# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from .base_embedding_metadata import BaseEmbeddingMetadata


class VideoEmbeddingMetadata(BaseEmbeddingMetadata):
    """
    An object containing metadata associated with the embedding.
    """

    video_clip_length: typing.Optional[float] = pydantic.Field(default=None)
    """
    The duration for each clip in seconds, as specified by the `video_clip_length` parameter of the [`POST`](/v1.3/api-reference/video-embeddings/create-video-embedding-task) method of the `/embed/task` endpoint. Note that the platform automatically truncates video segments shorter than 2 seconds. For a 31-second video divided into 6-second segments, the final 1-second segment will be truncated. This truncation only applies to the last segment if it does not meet the minimum length requirement of 2 seconds.
    """

    video_embedding_scope: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The scope you've specified in the request. It can take one of the following values: ['clip'] or ['clip', 'video'].
    """

    duration: typing.Optional[float] = pydantic.Field(default=None)
    """
    The total duration of the video in seconds.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
