# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .video_embedding_task_video_embedding import VideoEmbeddingTaskVideoEmbedding


class VideoEmbeddingTask(UniversalBaseModel):
    """
    A video embedding task that describes the status of the task and the metadata about the video.
    """

    id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="_id")] = pydantic.Field(default=None)
    """
    The unique identifier of the video embedding task.
    """

    model_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the video understanding model the platform used to create the embedding.
    """

    status: typing.Optional[str] = pydantic.Field(default=None)
    """
    A string indicating the status of the video indexing task. It can take one of the following values: `processing`, `ready` or `failed`.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), that the video embedding task was created.
    """

    video_embedding: typing.Optional[VideoEmbeddingTaskVideoEmbedding] = pydantic.Field(default=None)
    """
    An object containing the metadata associated with the embedding.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
