# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class VideoItem(UniversalBaseModel):
    """
    An object that contains information about a video file.
    """

    video_id: str = pydantic.Field()
    """
    The unique identifier of the video.
    """

    filename: str = pydantic.Field()
    """
    The name of the video file.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    The date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), when the video was added to the import process.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
