# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class VideoItemFailed(UniversalBaseModel):
    """
    An object that contains information about a video file that failed to import.
    """

    filename: str = pydantic.Field()
    """
    The name of the video file.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    The date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), when the video was added to the import process.
    """

    error_message: str = pydantic.Field()
    """
    The error message explaining why the video failed to import.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
