# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.search_response import SearchResponse
from .raw_client import AsyncRawSearchClient, RawSearchClient
from .types.search_content_request_id import SearchContentRequestId

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SearchClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSearchClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSearchClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSearchClient
        """
        return self._raw_client

    def content(
        self,
        id: SearchContentRequestId,
        *,
        query: str,
        n: typing.Optional[int] = None,
        next_token: typing.Optional[str] = None,
        verbosity: typing.Optional[int] = None,
        filter: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        relevance: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchResponse:
        """
        Search documents on GroundX for the most relevant information to a given query.
        The result of this query is typically used in one of two ways; `result.search.text` can be used to provide context to a language model, facilitating RAG, or `result.search.results` can be used to observe chunks of text which are relevant to the query, facilitating citation.

        Parameters
        ----------
        id : SearchContentRequestId
            The bucketId, groupId, or documentId to be searched. The document or documents within the specified container will be compared to the query, and relevant information will be extracted.

        query : str
            The search query to be used to find relevant documentation.

        n : typing.Optional[int]
            The maximum number of returned search results. Accepts 1-100 with a default of 20.

        next_token : typing.Optional[str]
            A token for pagination. If the number of search results for a given query is larger than n, the response will include a "nextToken" value. That token can be included in this field to retrieve the next batch of n search results.

        verbosity : typing.Optional[int]
            The amount of data returned with each search result. 0 == no search results, only the recommended context. 1 == search results but no searchData. 2 == search results and searchData.

        filter : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            A dictionary of key-value pairs that can be used to pre-filter documents prior to a search.

        relevance : typing.Optional[float]
            The minimum search relevance score required to include the result. By default, this is 10.0.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchResponse
            Search query success

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.search.content(
            id=1,
            n=1,
            next_token="eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9",
            verbosity=1,
            query="my search query",
        )
        """
        _response = self._raw_client.content(
            id,
            query=query,
            n=n,
            next_token=next_token,
            verbosity=verbosity,
            filter=filter,
            relevance=relevance,
            request_options=request_options,
        )
        return _response.data

    def documents(
        self,
        *,
        query: str,
        document_ids: typing.Sequence[str],
        n: typing.Optional[int] = None,
        next_token: typing.Optional[str] = None,
        verbosity: typing.Optional[int] = None,
        filter: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        relevance: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchResponse:
        """
        Search documents on GroundX for the most relevant information to a given query by documentId(s).
        The result of this query is typically used in one of two ways; `result.search.text` can be used to provide context to a language model, facilitating RAG, or `result.search.results` can be used to observe chunks of text which are relevant to the query, facilitating citation.

        Parameters
        ----------
        query : str
            The search query to be used to find relevant documentation.

        document_ids : typing.Sequence[str]
            An array of unique documentIds to be searched.

        n : typing.Optional[int]
            The maximum number of returned search results. Accepts 1-100 with a default of 20.

        next_token : typing.Optional[str]
            A token for pagination. If the number of search results for a given query is larger than n, the response will include a "nextToken" value. That token can be included in this field to retrieve the next batch of n search results.

        verbosity : typing.Optional[int]
            The amount of data returned with each search result. 0 == no search results, only the recommended context. 1 == search results but no searchData. 2 == search results and searchData.

        filter : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            A dictionary of key-value pairs that can be used to pre-filter documents prior to a search.

        relevance : typing.Optional[float]
            The minimum search relevance score required to include the result. By default, this is 10.0.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchResponse
            Search query success

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.search.documents(
            n=1,
            next_token="eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9",
            verbosity=1,
            query="my search query",
            document_ids=["docUUID1", "docUUID2"],
        )
        """
        _response = self._raw_client.documents(
            query=query,
            document_ids=document_ids,
            n=n,
            next_token=next_token,
            verbosity=verbosity,
            filter=filter,
            relevance=relevance,
            request_options=request_options,
        )
        return _response.data


class AsyncSearchClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSearchClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSearchClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSearchClient
        """
        return self._raw_client

    async def content(
        self,
        id: SearchContentRequestId,
        *,
        query: str,
        n: typing.Optional[int] = None,
        next_token: typing.Optional[str] = None,
        verbosity: typing.Optional[int] = None,
        filter: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        relevance: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchResponse:
        """
        Search documents on GroundX for the most relevant information to a given query.
        The result of this query is typically used in one of two ways; `result.search.text` can be used to provide context to a language model, facilitating RAG, or `result.search.results` can be used to observe chunks of text which are relevant to the query, facilitating citation.

        Parameters
        ----------
        id : SearchContentRequestId
            The bucketId, groupId, or documentId to be searched. The document or documents within the specified container will be compared to the query, and relevant information will be extracted.

        query : str
            The search query to be used to find relevant documentation.

        n : typing.Optional[int]
            The maximum number of returned search results. Accepts 1-100 with a default of 20.

        next_token : typing.Optional[str]
            A token for pagination. If the number of search results for a given query is larger than n, the response will include a "nextToken" value. That token can be included in this field to retrieve the next batch of n search results.

        verbosity : typing.Optional[int]
            The amount of data returned with each search result. 0 == no search results, only the recommended context. 1 == search results but no searchData. 2 == search results and searchData.

        filter : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            A dictionary of key-value pairs that can be used to pre-filter documents prior to a search.

        relevance : typing.Optional[float]
            The minimum search relevance score required to include the result. By default, this is 10.0.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchResponse
            Search query success

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.search.content(
                id=1,
                n=1,
                next_token="eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9",
                verbosity=1,
                query="my search query",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.content(
            id,
            query=query,
            n=n,
            next_token=next_token,
            verbosity=verbosity,
            filter=filter,
            relevance=relevance,
            request_options=request_options,
        )
        return _response.data

    async def documents(
        self,
        *,
        query: str,
        document_ids: typing.Sequence[str],
        n: typing.Optional[int] = None,
        next_token: typing.Optional[str] = None,
        verbosity: typing.Optional[int] = None,
        filter: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        relevance: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchResponse:
        """
        Search documents on GroundX for the most relevant information to a given query by documentId(s).
        The result of this query is typically used in one of two ways; `result.search.text` can be used to provide context to a language model, facilitating RAG, or `result.search.results` can be used to observe chunks of text which are relevant to the query, facilitating citation.

        Parameters
        ----------
        query : str
            The search query to be used to find relevant documentation.

        document_ids : typing.Sequence[str]
            An array of unique documentIds to be searched.

        n : typing.Optional[int]
            The maximum number of returned search results. Accepts 1-100 with a default of 20.

        next_token : typing.Optional[str]
            A token for pagination. If the number of search results for a given query is larger than n, the response will include a "nextToken" value. That token can be included in this field to retrieve the next batch of n search results.

        verbosity : typing.Optional[int]
            The amount of data returned with each search result. 0 == no search results, only the recommended context. 1 == search results but no searchData. 2 == search results and searchData.

        filter : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            A dictionary of key-value pairs that can be used to pre-filter documents prior to a search.

        relevance : typing.Optional[float]
            The minimum search relevance score required to include the result. By default, this is 10.0.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchResponse
            Search query success

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.search.documents(
                n=1,
                next_token="eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9",
                verbosity=1,
                query="my search query",
                document_ids=["docUUID1", "docUUID2"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.documents(
            query=query,
            document_ids=document_ids,
            n=n,
            next_token=next_token,
            verbosity=verbosity,
            filter=filter,
            relevance=relevance,
            request_options=request_options,
        )
        return _response.data
