# # Numbers represented as words
# NUMBER_WORDS = {
#     'one': 1, 
#     'two': 2,
#     'three': 3, 
#     'four': 4, 
#     'five': 5,
#     'six': 6, 
#     'seven': 7, 
#     'eight': 8, 
#     'nine': 9, 
#     'ten': 10,
#     'eleven': 11,
#     'twelve': 12,
#     'dozen': 12,  # 12
#     'dozens': 12,  # 12
#     'baker\'s dozen': 13,  # 13
#     'bakers dozen': 13,  # 13
#     'thirteen': 13,
#     'fourteen': 14,
#     'fifteen': 15,
#     'sixteen': 16,
#     'seventeen': 17,
#     'eighteen': 18,
#     'nineteen': 19,
#     'twenty': 20,
#     'thirty': 30,
#     'forty': 40,
#     'fifty': 50,
#     'sixty': 60,
#     'seventy': 70,
#     'eighty': 80,
#     'ninety': 90,
#     'hundred': 100,
#     'hundreds': 100,
#     'thousand': 1000
# }

# NUMBER_PREFIX_WORDS = {
#     'twenty': 20,
#     'thirty': 30,
#     'forty': 40,
#     'fifty': 50,
#     'sixty': 60,
#     'seventy': 70,
#     'eighty': 80,
#     'ninety': 90,
#     'hundred': 100,
#     'hundreds': 100,
#     'thousand': 1000
# }

# # Fractions represented as multiple words (or numbers) and words
# MULTI_FRACTION_WORDS = {
#     # amount with fraction words
#     "one half": "1/2",
#     "1 half": "1/2",
#     "two halves": "1",

#     "one quarter": "1/4",
#     "1 quarter": "1/4",
#     "two quarters": "1/2",
#     "three quarters": "3/4",
#     "3 quarters": "3/4",
#     "three quarter": "3/4",
#     "3 quarter": "3/4",

#     "one fourth": "1/4",
#     "1 fourth": "1/4",
#     "two fourths": "1/2",
#     "three fourths": "3/4",
#     "3 fourths": "3/4",

#     "one third": "1/3",
#     "1 third": "1/3",
#     "two thirds": "2/3",
#     "two thirds": "2/3",
#     "2 thirds": "2/3",
#     "2 third": "2/3",

#     "one fifth": "1/5",
#     "1 fifth": "1/5",
#     "two fifths": "2/5",
#     "2 fifths": "2/5",
#     "three fifths": "3/5",
#     "3 fifths": "3/5",
#     "four fifths": "4/5",
#     "4 fifths": "4/5",

#     "one sixth": "1/6",
#     "1 sixth": "1/6",
#     "two sixths": "1/3",
#     "three sixths": "1/2",
#     "4 sixths": "2/3",
#     "four sixths": "2/3",
#     "five sixths": "5/6",
#     "5 sixths": "5/6",

#     "one seventh": "1/7",
#     "1 seventh": "1/7",
#     "two sevenths": "2/7",
#     "2 sevenths": "2/7",
#     "three sevenths": "3/7",
#     "3 sevenths": "3/7",
#     "four sevenths": "4/7",
#     "4 sevenths": "4/7",
#     "five sevenths": "5/7",
#     "5 sevenths": "5/7",
#     "six sevenths": "6/7",
#     "6 sevenths": "6/7",

#     "one eighth": "1/8",
#     "1 eighth": "1/8",
#     "two eighths": "1/4",
#     "2 eighths": "1/4",
#     "three eighths": "3/8",
#     "3 eighths": "3/8",
#     "four eighths": "1/2",
#     "five eighths": "5/8",
#     "six eighths": "3/4",
#     "seven eighths": "7/8",

#     "one ninth": "1/9",
#     "two ninths": "2/9",
#     "one tenth": "1/10",
#     "two tenths": "1/5",

#     "one eleventh": "1/11",
#     "two elevenths": "2/11",

#     "one twelfth": "1/12",
#     "two twelfths": "1/6",
#     "eleven twelfths": "11/12",


#     "two thirds": "2/3",
#     "two fourths": "1/2",
#     "two fifths": "2/5",
#     "two sixths": "1/3",
#     "two sevenths": "2/7",
#     "two eighths": "1/4",
#     "two ninths": "2/9",
#     "two tenths": "1/5",
#     "two elevenths": "2/11",
#     "two twelfths": "1/6",

#     "three fourths": "3/4",
#     "three fifths": "3/5",
#     "three sixths": "1/2",
#     "three sevenths": "3/7",
#     "three eighths": "3/8",
#     "three ninths": "1/3",
#     "three tenths": "3/10",
#     "three elevenths": "3/11",
#     "three twelfths": "1/4",
#     "four fifths": "4/5",
#     "four sixths": "2/3",
#     "four sevenths": "4/7",
#     "four eighths": "1/2",
#     "four ninths": "4/9",
#     "four tenths": "2/5",
#     "four elevenths": "4/11",
#     "four twelfths": "1/3",
#     "five sixths": "5/6",
#     "five sevenths": "5/7",
#     "five eighths": "5/8",
#     "five ninths": "5/9",
#     "five tenths": "1/2",
#     "five elevenths": "5/11",
#     "five twelfths": "5/12",
#     "six sevenths": "6/7",
#     "six eighths": "3/4",
#     "six ninths": "2/3",
#     "six tenths": "3/5",
#     "six elevenths": "6/11",
#     "six twelfths": "1/2",
#     "seven eighths": "7/8",
#     "seven ninths": "7/9",
#     "seven tenths": "7/10",
#     "seven elevenths": "7/11",
#     "seven twelfths": "7/12",
#     "eight ninths": "8/9",
#     "eight tenths": "4/5",
#     "eight elevenths": "8/11",
#     "eight twelfths": "2/3",
#     "nine tenths": "9/10",
#     "nine elevenths": "9/11",
#     "nine twelfths": "3/4",
#     "ten elevenths": "10/11",
#     "ten twelfths": "5/6",
#     "eleven twelfths": "11/12"
# }

# # Fractions words representing a single fraction (i.e. a quarter is equal to 1/4)
# FRACTION_WORDS = {
#     # singular versions
#     "half": ("1/2", "0.5"),
#     "quarter": ("1/4", "0.25"),
#     "third": ("1/3", "0.333"),
#     "fourth": ("1/4", "0.25"),
#     "fifth": ("1/5", "0.2"),
#     "sixth": ("1/6", "0.166"),
#     "seventh": ("1/7", "0.142"),
#     "eighth": ("1/8", "0.125"),
#     "ninth": ("1/9", "0.111"),
#     "tenth": ("1/10", "0.1"),
#     "eleventh": ("1/11", "0.0909"),
#     "twelfth": ("1/12", "0.0833"),
    
#     # plural versions
#     "halves": ("1/2", "0.5"),
#     "quarters": ("1/4", "0.25"),
#     "thirds": ("1/3", "0.333"),
#     "fourths": ("1/4", "0.25"),
#     "fifths": ("1/5", "0.2"),
#     "sixths": ("1/6", "0.166"),
#     "sevenths": ("1/7", "0.142"),
#     "eighths": ("1/8", "0.125"),
#     "ninths": ("1/9", "0.111"),
#     "tenths": ("1/10", "0.1"),
#     "elevenths": ("1/11", "0.0909"),
#     "twelfths": ("1/12", "0.0833")

#     # "half": "1/2", 
#     # "quarter": "1/4",
#     # "third": "1/3",
#     # "fourth": "1/4",
#     # "fifth": "1/5",
#     # "sixth": "1/6",
#     # "seventh": "1/7",
#     # "eighth": "1/8",
#     # "ninth": "1/9",
#     # "tenth": "1/10",
#     # "eleventh": "1/11",
#     # "twelfth": "1/12",

#     # # plural versions
#     # "halves": "1/2",
#     # "quarters": "1/4",
#     # "thirds": "1/3",
#     # "fourths": "1/4",
#     # "fifths": "1/5",
#     # "sixths": "1/6",
#     # "sevenths": "1/7",
#     # "eighths": "1/8",
#     # "ninths": "1/9",
#     # "tenths": "1/10",
#     # "elevenths": "1/11",
#     # "twelfths": "1/12"
# }


# # Fractions words representing the denominator of a fraction
# DENOMINATOR_WORDS = {
#     "half": "/2",
#     "halves": "/2",

#     "quarter": "/4",
#     "quarters": "/4",
#     "fourth": "/4",
#     "fourths": "/4",

#     "third": "/3",
#     "thirds": "/3",

#     "fifth": "/5",
#     "fifths": "/5",

#     "sixth": "/6",
#     "sixths": "/6",

#     "seventh": "/7",
#     "sevenths": "/7",

#     "eighth": "/8",
#     "eighths": "/8",

#     "ninth": "/9",
#     "ninths": "/9",

#     "tenth": "/10",
#     "tenths": "/10",

#     "eleventh": "/11",
#     "elevenths": "/11",

#     "twelfth": "/12",
#     "twelfths": "/12"
# }

# UNICODE_FRACTIONS = {
#     '¼': "1/4",
#     '½': "1/2",
#     '¾': "3/4",
#     '⅐': "1/7",
#     '⅑': "1/9",
#     '⅒': "1/10",
#     '⅓': "1/3",
#     '⅔': "2/3",
#     '⅕': "1/5",
#     '⅖': "2/5",
#     '⅗': "3/5",
#     '⅘': "4/5",
#     '⅙': "1/6",
#     '⅚': "5/6",
#     '⅛': "1/8",
#     '⅜': "3/8",
#     '⅝': "5/8",
#     '⅞': "7/8",
#     '⅟': "1",
#     # "⁄": "/"
#     '-¼': "-1/4",
#     '-½': "-1/2",
#     '-¾': "-3/4",
#     '-⅐': "-1/7",
#     '-⅑': "-1/9",
#     '-⅒': "-1/10",
#     '-⅓': "-1/3",
#     '-⅔': "-2/3",
#     '-⅕': "-1/5",
#     '-⅖': "-2/5",
#     '-⅗': "-3/5",
#     '-⅘': "-4/5",
#     '-⅙': "-1/6",
#     '-⅚': "-5/6",
#     '-⅛': "-1/8",
#     '-⅜': "-3/8",
#     '-⅝': "-5/8",
#     '-⅞': "-7/8",
#     '-⅟': "-1"
# }

# TEMPERATURE_UNITS = {
#     "celsius": ("celsius", "degree celsius", "degrees celsius", "°C"),
#     "fahrenheit": ("fahrenheit", "degree fahrenheit", "degrees fahrenheit", "°F")
# }

# UNITS = {
#     "a taste" : ("a taste"),
#     'bag': ('bag', 'bags'), 
#     'bagful': ('bagful', 'bagfuls'), 
#     'bottle': ('bottle', 'bottles'), 
#     'bottleful': ('bottleful', 'bottlefuls'), 
#     'bowl': ('bowl', 'bowls'), 
#     'bowlful': ('bowlful', 'bowlfuls'),
#     'box': ('box', 'boxes'), 
#     'boxful': ('boxful', 'boxfuls'), 
#     'breast': ('breast', 'breasts'), 
#     'bulb': ('bulb', 'bulbs'), 
#     'bun': ('bun', 'buns'), 
#     'bunch': ('bunch', 'bunches'), 
#     'can': ('can', 'cans'), 
#     'canful': ('canful', 'canfuls'), 
#     # 'centimeter': ('centimeter', 'centimeters', 'cm', 'cms'),  # TODO: address dimensions
#     'container': ('container', 'containers'), 
#     'cube': ('cube', 'cubes'), 
#     'cup': ('cup', 'cups', "C", "c"),
#     'cupful': ('cupful', 'cupfuls'), 
#     # "dallop" : ("dallop", "dallops", "dollop", "dollops", "a dallop", "a dollop"),
#     # "dash" : ("dash", "dashes", "a dash"),
#     # "drop" : ("drop", "drops", "a drop"),
#     # "droplet" : ("droplet", "droplets", "a droplet"),
#     "dallop" : ("dallop", "dallops", "dollop", "dollops"),
#     'dash': ('dash', 'dashes'), 
#     "drop" : ("drop", "drops"),

#     "droplet" : ("droplet", "droplets"),
#     'drumstick': ('drumstick', 'drumsticks'), 
#     "dusting" : ("dusting", "dustings"),
#     'ear': ('ear', 'ears'), 
#     'envelope': ('envelope', 'envelopes'), 
#     'filet': ('filet', 'filets'), 
#     'fillet': ('fillet', 'fillets'), 
#     'fluid ounce': ('fluid ounce', 'fluid ounces', 'fl oz', 'fl ozs', 'fluid oz', 'fluid ozs', 'fluid oz', 'fluid ozs'),
#     'floret': ('floret', 'florets'),
#     # 'foot': ('foot', 'feet', 'ft', 'fts'), # TODO: address dimensions
#     'gallon': ('gallon', 'gallons', 'gals', 'gal'), 
#     'glass': ('glass', 'glasses'), 
#     'gram': ('gram', 'grams', 'g'), 

#     "handful" : ("handful", "handfuls", "handfull", "handfulls"),
#     # "handful" : ("handful", "handfuls", "handfull", "handfulls", "a handful"),
#     'head': ('head', 'heads'), 
#     # 'inch': ('inch', 'inches', 'ins'), # TODO: Removing unit "in" for now, unit "in" needs to be dealt with separately somehow, 
#     #                                    # TODO: "in" is used for both the unit "inch" and the standard usage of the word "in" (i.e. "I am in a house")
#     # 'inch': ('inch', 'inches', 'in', 'ins'), # Inches unit including the abbreviation "in"
#     'jar': ('jar', 'jars'), 
#     'jarful': ('jarful', 'jarfuls'), 
#     'kilogram': ('kilogram', 'kilograms', 'kg', 'kgs'), 
#     'leg': ('leg', 'legs'), 
#     'link': ('link', 'links'), 
#     'liter': ('liter', 'liters', 'l'), 
#     'loaf': ('loaf', 'loaves'), 
#     # 'meter': ('meter', 'meters', 'm', 'ms'), # TODO: address dimensions
#     'milligram': ('milligram', 'milligrams', 'mg', 'mgs'), 
#     'milliliter': ('milliliter', 'milliliters', 'ml', 'mls'), 
#     # 'millimeter': ('millimeter', 'millimeters', 'mm', 'mms'), # TODO: address dimensions
#     'ounce': ('ounce', 'ounces', 'oz', 'ozs', 'oz.', 'ozs.'), 
#     'package': ('package', 'packages', 'pkg', 'pkgs'), 
#     'packageful': ('packageful', 'packagefuls'), 
#     'packet': ('packet', 'packets'), 
#     'patty': ('patty', 'patties'), 
#     'piece': ('piece', 'pieces'), 
#     "pinch" : ("pinch", "pinches", "pinchful", "pinchfuls", "pinchfull", "pinchfulls"),
#     # 'pinch': ('pinch', 'pinches'), 
#     'pint': ('pint', 'pints', 'pt', 'pts'), 
#     'plate': ('plate', 'plates'), 
#     'portion': ('portion', 'portions'), 
#     'pound': ('pound', 'pounds', 'lbs', 'lb', 'lb.', 'lbs.'),
#     'quart': ('quart', 'quarts', 'qt', 'qts'), 
#     'rim': ('rim', 'rims'), 
#     'roll': ('roll', 'rolls'), 
#     'scoop': ('scoop', 'scoops'), 
#     'sheet': ('sheet', 'sheets'), 
#     'slice': ('slice', 'slices'), 
#     "smidgen" : ("smidgen", "smidgens"),
#     "sprinkle" : ("sprinkle", "sprinkles", "springkling", "sprinklings"),
#     # "smidgen" : ("smidgen", "smidgens", "a smidgen"),
#     # "sprinkle" : ("sprinkle", "sprinkles", "springkling", "sprinklings", "a sprinkle", "a sprinkling"),
#     'sprig': ('sprig', 'sprigs'), 
#     'stalk': ('stalk', 'stalks'), 
#     'stick': ('stick', 'sticks'), 
#     'strip': ('strip', 'strips'), 

#     'tablespoon': ('tablespoon', 'tablespoons', 'tbsp', 'tbsps', "tbsp", "tbsps", "tbsp.", "tbsps.", "tbl", "tbls", "tbl.", "tbls.", "T", "tbs", "tbs."), # 'tablespoon': ('tablespoon', 'tablespoons', 'tbsp', 'tbsps', 'tbsp', 'tbsps'), 
#     'tablespoonful': ('tablespoonful', 'tablespoonfuls'), 
#     "tad" : ("tad", "tads"),
#     # "tad" : ("tad", "tads", "a tad"),
#     'teaspoon': ('teaspoon', 'teaspoons', 'tsp', 'tsps', "tsp", "tspn", "tspns", "tspn.", "tspns.", "ts", "t", "t."), # 'teaspoon': ('teaspoon', 'teaspoons', 'tsp', 'tsps', "tsp", "t"),
#     'teaspoonful': ('teaspoonful', 'teaspoonfuls'), 
#     'thigh': ('thigh', 'thighs'),
#     "to taste" : ("to taste"), 
#     "touch" : ("touch", "touches"),
#     # "touch" : ("touch", "touches", "a touch"),
#     'tube': ('tube', 'tubes'), 
#     'wheel': ('wheel', 'wheels'), 
#     'wing': ('wing', 'wings')
# }

# UNITS_SET = set()

# # add all of the keys and values to a Hash set to contain all of the volume units words
# for key, pattern in UNITS.items():
#     UNITS_SET.add(key)
#     for val in pattern:
#         UNITS_SET.add(val)

# # create a hash map that maps every variation of a unit to the standard unit name
# UNIT_TO_STANDARD_UNIT = {}

# for key, pattern in UNITS.items():
#     # print(f"key: {key}, pattern: {pattern}")
#     for val in pattern:
#         UNIT_TO_STANDARD_UNIT[val] = key

# # Only the core basic imperial and metric units (Excludes the more specific units like "stalk", "fillet", "slices", etc.)
# BASIC_UNITS = {
#     # Imperial volume units
#     'teaspoon': ('teaspoon', 'teaspoons', 'tsp', 'tsps', "tsp", "tspn", "tspns", "tspn." "tspns." , "ts", "t", "t."), # 'teaspoon': ('teaspoon', 'teaspoons', 'tsp', 'tsps', "tsp", "t"),
#     'tablespoon': ('tablespoon', 'tablespoons', 'tbsp', 'tbsps', "tbsp", "tbsps", "tbsp.", "tbsps.", "tbl", "tbls", "tbl.", "tbls.", "T", "tbs", "tbs."),
#     'tablespoonful': ('tablespoonful', 'tablespoonfuls'),
#     'teaspoonful': ('teaspoonful', 'teaspoonfuls'),
#     'cup': ('cup', 'cups', "C", "c"),
#     'pint': ('pint', 'pints', "pt", "pts"),
#     'quart': ('quart', 'quarts', "qt", "qts"),
#     'gallon': ('gallon', 'gallons', "gals", "gal"),
#     'fluid ounce': ('fluid ounce', 'fluid ounces', 'fl oz', 'fl ozs',
#                     "fluid oz", "fluid ozs", "fluid oz", "fluid ozs"),

#     # Metric volume units
#     'milliliter': ('milliliter', 'milliliters', 'ml', 'mls'),
#     'liter': ('liter', 'liters', 'l'),

#     # Imperial weight units
#     'ounce': ('ounce', 'ounces', 'oz', 'ozs', 'oz.', 'ozs.'), 
#     'pound': ('pound', 'pounds', 'lbs', 'lb', 'lb.', 'lbs.'),

#     # Metric weight units
#     'milligram': ('milligram', 'milligrams', 'mg', 'mgs'),
#     'gram': ('gram', 'grams', 'g'),
#     'kilogram': ('kilogram', 'kilograms', 'kg', 'kgs'),
# }

# BASIC_UNITS_SET = set()

# # add all of the keys and values to a Hash set to contain all of the basic units words
# for key, pattern in BASIC_UNITS.items():
#     BASIC_UNITS_SET.add(key)
#     for val in pattern:
#         BASIC_UNITS_SET.add(val)

# # create a non basic units set by subtracting the basic units set from the units set
# NON_BASIC_UNITS_SET = UNITS_SET - BASIC_UNITS_SET

# # volume units dictionary, things like "cup", "fluid ounce", "gallon", etc.
# VOLUME_UNITS = {
#     'cup': ('cup', 'cups', "C", "c"),
#     'fluid ounce': ('fluid ounce', 'fluid ounces', 'fl oz', 'fl ozs', "fluid oz", "fluid ozs", "fluid oz", "fluid ozs"),
#     'gallon': ('gallon', 'gallons', "gals", "gal"),
#     'liter': ('liter', 'liters', 'l'),
#     'milliliter': ('milliliter', 'milliliters', 'ml', 'mls'),
#     'ounce': ('ounce', 'ounces', 'oz', 'ozs', "oz", "ozs"),
#     'pint': ('pint', 'pints', "pt", "pts"),
#     'quart': ('quart', 'quarts', "qt", "qts"),
#     'tablespoon': ('tablespoon', 'tablespoons', 'tbsp', 'tbsps', "tbsp", "tbsps", "tbsp.", "tbsps.", "tbl", "tbls", "tbl.", "tbls.", "T", "tbs", "tbs."),
#     'teaspoon': ('teaspoon', 'teaspoons', 'tsp', 'tsps', "tsp.")
# }

# VOLUME_UNITS_SET = set()

# # add all of the keys and values to a Hash set to contain all of the volume units words
# for key, pattern in VOLUME_UNITS.items():
#     VOLUME_UNITS_SET.add(key)
#     for val in pattern:
#         VOLUME_UNITS_SET.add(val)

# # dry weight units dictionary, things like "ounce", "pound", "gram", etc.
# WEIGHT_UNITS = {
#     'ounce': ('ounce', 'ounces', 'oz', 'ozs', 'oz.', 'ozs.'), 
#     'pound': ('pound', 'pounds', 'lbs', 'lb', 'lb.', 'lbs.'),
#     'gram': ('gram', 'grams', 'g'),
#     'kilogram': ('kilogram', 'kilograms', 'kg', 'kgs'),
#     'milligram': ('milligram', 'milligrams', 'mg', 'mgs')
# }

# WEIGHT_UNITS_SET = set()

# # add all of the keys and values to a Hash set to contain all of the weight units words
# for key, pattern in WEIGHT_UNITS.items():
#     WEIGHT_UNITS_SET.add(key)
#     for val in pattern:
#         WEIGHT_UNITS_SET.add(val)

# # dimensions dictioanry, things like "feet", "inches", "centimeters", etc.
# DIMENSION_UNITS = {
#     'centimeter': ('centimeter', 'centimeters', 'cm', 'cms'),
#     'foot': ('foot', 'feet', 'ft', 'fts'),
#     'inch': ('inch', 'inches', 'in', 'ins'),
#     # 'inch': ('inch', 'inches', 'ins'), # TODO: Removing unit "in" for now, unit "in" needs to be dealt with separately somehow, "in" is used for both the unit "inch" and the standard usage of the word "in" (i.e. "I am in a house")
#     'meter': ('meter', 'meters', 'm', 'ms'),
#     'millimeter': ('millimeter', 'millimeters', 'mm', 'mms')
# }

# DIMENSION_UNITS_SET = set()
# for key, pattern in DIMENSION_UNITS.items():
#     DIMENSION_UNITS_SET.add(key)
#     for val in pattern:
#         DIMENSION_UNITS_SET.add(val)

# # terms used to describe vague quantities
# CASUAL_QUANTITIES = {
#     # 'a' : 1,
#     # 'an': 1,
#     'couple': 2,
#     'few': 3,
#     'a couple': 2,
#     'a few': 3,
# }

# CASUAL_QUANTITIES_SET = set()
# for key, pattern in CASUAL_QUANTITIES.items():
#     CASUAL_QUANTITIES_SET.add(key)


# # # terms used to describe vague quantities
# # CASUAL_QUANTITIES = {
# #     # 'a' : 1,
# #     # 'an': 1,
# #     'couple': 2,
# #     'few': 3,
# #     'bit': 1,
# #     'tiny bit': 1,
# #     'handful': 5,
# #     'pinch': 1,
# #     'dash': 1,
# #     'dallop': 1,
# #     'drop': 1,
# #     "tad": 1,
# #     "smidgen": 1,
# #     "touch": 1,
# #     "to taste": 1,
# # }

# # terms that are sometimes used as units (i.e. "a pinch of salt")
# CASUAL_UNITS = {
#     "a taste" : ("a taste"),
#     "dash" : ("dash", "dashes"),
#     "dallop" : ("dallop", "dallops", "dollop", "dollops"),
#     "dusting" : ("dusting", "dustings"),
#     "drop" : ("drop", "drops"),
#     "droplet" : ("droplet", "droplets"),
#     "handful" : ("handful", "handfuls", "handfull", "handfulls"),
#     "pinch" : ("pinch", "pinches", "pinchful", "pinchfuls", "pinchfull", "pinchfulls"),
#     "tad" : ("tad", "tads"),
#     "smidgen" : ("smidgen", "smidgens"),
#     "sprinkle" : ("sprinkle", "sprinkles", "springkling", "sprinklings"),
#     "to taste" : ("to taste"),
#     "touch" : ("touch", "touches"),
#     # # NOTE: going back on forth on using units prefixed with "a " or not, for now I'm NOT using them
#     # "a taste" : ("a taste"),
#     # "bit" : ("bit", "bits"),
#     # "dash" : ("dash", "dashes", "a dash"),
#     # "dallop" : ("dallop", "dallops", "dollop", "dollops", "a dallop", "a dollop"),
#     # "dusting" : ("dusting", "dustings"),
#     # "drop" : ("drop", "drops", "a drop"),
#     # "droplet" : ("droplet", "droplets", "a droplet"),
#     # "handful" : ("handful", "handfuls", "handfull", "handfulls", "a handful"),
#     # "pinch" : ("pinch", "pinches", "pinchful", "pinchfuls", "pinchfull", "pinchfulls", "a pinch"),
#     # "tad" : ("tad", "tads", "a tad"),
#     # "smidgen" : ("smidgen", "smidgens", "a smidgen"),
#     # "sprinkle" : ("sprinkle", "sprinkles", "springkling", "sprinklings", "a sprinkle", "a sprinkling"),
#     # "touch" : ("touch", "touches", "a touch")
# }

# CASUAL_UNITS_SET = set()
# for key, pattern in CASUAL_UNITS.items():
#     CASUAL_UNITS_SET.add(key)
#     for val in pattern:
#         CASUAL_UNITS_SET.add(val)

# # Units that if they appear in a string and there are no "real" units, then these strings might be units
# # (i.e. "2 small carrots" -> "quantity: 2, unit: small, ingredient: carrots")
# # (i.e. "medium carrot" -> "quantity: 1, unit: medium, ingredient: carrot")
# SIZE_MODIFIERS_SET = set((
#     "extra small",
#     "extra-small",
#     "small",
#     "smallish",
#     "small-ish",
#     "medium",
#     "mediumish",
#     "medium-ish",
#     "large",
#     "largeish",
#     "large-ish",
#     # "sm",
#     # "med",
#     # "lrg",
#     "extra large",
#     "extra-large",
#     "big", 
#     "bigish",
#     "big-ish",
#     "tiny",
#     "modest",
#     "huge",
#     "giant",
#     "gigantic"
#     ))

# PREP_WORDS = {
#     'baked',
#     'beaten',
#     'beating',
#     'beat',
#     'blended',
#     'blending',
#     'blend',
#     'blanch',
#     'blanched',
#     'blistered',
#     'boil',
#     'boiled',
#     'broil',
#     'broiled',
#     'chopped',
#     'chopping',
#     'cored',
#     'cracked',
#     'cracking',
#     'cooked',
#     'crumbled',
#     'crushed',
#     'cubed',
#     'cut',
#     'cutting',
#     'crisped',
#     'diced',
#     'divided',
#     'drained',
#     'drenched',
#     'dressed',
#     'emulsified',
#     "even",
#     "firm",
#     "firmly",
#     'flaked',
#     'fried',
#     'generous',
#     'grated',
#     'grilled',
#     'ground',
#     'grounded',
#     'halved',
#     'hardened',
#     "heaping",
#     "heaped",
#     "heavy",
#     "heavily",
#     "hefty",
#     'julienned',
#     'juiced',
#     "level",
#     "leveled",
#     "light",
#     "lightly",
#     "lightly packed",
#     'mashed',
#     'melted',
#     'minced',
#     'packed',
#     'peeled',
#     'pitted',
#     'poached',
#     # 'pounded',
#     'pressed',
#     'pureed',
#     'quartered',
#     'rinsed',
#     'roasted',
#     "roughly",
#     "round",
#     "rounded",
#     "room temp",
#     "room temperature",
#     "scant",
#     'scramble',
#     'scrambled',
#     'scrambling',
#     'scrambles',
#     'seeded',
#     'shredded',
#     'sifted',
#     'sliced',
#     'slivered',
#     "smooth",
#     "smoothed",
#     'smoothly',
#     'softened',
#     'squeezed',
#     'squeeze',
#     'squished',
#     'steamed',
#     'stewed',
#     'stirred',
#     'stirring',
#     'stir',
#     'tenderized',
#     'thickened',
#     "tightly",
#     'toasted',
#     'trimmed',
#     "unsifted",
#     'zested'
# }

# # specific words that are used to describe something about a unit (i.e. "packed cup", "level tablespoon")
# # TODO: Probably something to remove at some point, I've split/consilidated values in this set into PREP_WORDS and SIZE_MODIFIERS_SET
# UNIT_MODIFIERS = set((
#     "round",
#     "rounded",
#     "level",
#     "leveled",
#     "heaping",
#     "heaped",
#     "scant",
#     "even",
#     "generous",
#     "packed",
#     "sifted",
#     "unsifted",
#     "light",
#     "lightly",
#     "lightly packed",
#     "heavy",
#     "heavily",
#     "firm",
#     "firmly",
#     "tightly",
#     "smooth",
#     "hefty",
#     "roughly",
    
#     "small",
#     "medium",
#     "large",
#     "extra large",
#     "extra-large",
#     "big", 
#     "tiny",
#     "modest",
#     "huge",
#     "giant",
#     "gigantic"
# ))

# # specific words that are used to describe something about a unit (i.e. "packed cup", "level tablespoon")
# APPROXIMATE_STRINGS = set((
#     "about",
#     "bout",
#     "around",
#     "approximately",
#     "approx",
#     "approx.",
#     "appx",
#     "appx.",
#     "nearly",
#     "almost",
#     "roughly",
#     "estimated",
#     "estimate",
#     "est.",
#     "est",
#     "estim", 
#     "estim."
# ))

# # phrases that are used to specify the amount of quantity per unit (i.e. "4 lbs each", "about 2 ounces each")
# QUANTITY_PER_UNIT_STRINGS = set((
#     "each",
#     "per",
#     "apiece",
#     "a piece",
#     "per each"
# ))

# # sets of all dashes and hyphens, and sets of dashes that should be removed
# DASH_SYMBOLS = set(("-", "‐" "−", "–", "—"))
# REMOVABLE_DASH_SYMBOLS = set(("‐" "−", "–", "—"))

# # generic list of stop words that are not useful for parsing and should be removed from the string
# STOP_WORDS = set((
#     "0o", "0s", "3a", "3b", "3d", "6b", "6o",
#     "a", "a1", "a2", "a3", "a4", "ab", "able", "about", "above", "abst", 
#     "ac", "accordance", "according", "accordingly", "across", "act", "actually", "ad", "added", "adj", "ae", "af", 
#     "affected", "affecting", "affects", "after", "afterwards", "ag", "again", "against", "ah", "ain", "ain't", "aj", 
#     "al", "all", "allow", "allows", "almost", "alone", "along", "already", "also", "although", "always", "am", "among", 
#     "amongst", "amoungst", "amount", "an", "and", "announce", "another", "any", "anybody", "anyhow", "anymore", 
#     "anyone", "anything", "anyway", "anyways", "anywhere", "ao", "ap", "apart", "apparently", "appear", "appreciate", 
#     "appropriate", "approximately", "ar", "are", "aren", "arent", "aren't", "arise", "around", "as", "a's", "aside", 
#     "ask", "asking", "associated", "at", "au", "auth", "av", "available", "aw", "away", "awfully", "ax", "ay", "az", 
    
#     "b", "b1", "b2", "b3", "ba", "back", "bc", "bd", "be", "became", "because", "become", "becomes", "becoming", 
#     "been", "before", "beforehand", "begin", "beginning", "beginnings", "begins", "behind", "being", "believe", 
#     "below", "beside", "besides", "best", "better", "between", "beyond", "bi", "bill", "biol", "bj", "bk", "bl", 
#     "bn", "both", "bottom", "bp", "br", "brief", "briefly", "bs", "bt", "bu", "but", "bx", "by", 
#     "bitesized", "bitesize", "bite-sized", "bite-size",
#     # "c",  "cm",
#     "c1", "c2", 
#     "c3", "ca", "call", "came", "can", "cannot", "cant", "can't", "cause", "causes", "cc", "cd", "ce", "certain", 
#     "certainly", "cf", "cg", "ch", "changes", "ci", "cit", "cj", "cl", "clearly",
#     "c'mon", "cn", "co", "com", "come", "comes", "con", "concerning", "consequently", "consider", "considering", "contain", "containing", 
#     "contains", "corresponding", "could", "couldn", "couldnt", "couldn't", "course", "cp", "cq", "cr", "cry", "cs", 
#     "c's", "ct", "cu", "currently", "cv", "cx", "cy", "cz", "d", "d2", "da", "date", "dc", "dd", "de", "definitely", 
#     "describe", "described", "despite", "detail", "df", "di", "did", "didn", "didn't", "different", "dj", "dk", "dl", 
#     "do", "does", "doesn", "doesn't", "doing", "don", "done", "don't", "down", "downwards", "dp", "dr", "ds", "dt", 
#     "du", "due", "during", "dx", "dy", 
#     "e", "e2", "e3", "ea", "each", "ec", "ed", "edu", "ee", "ef", "effect", "eg", "ei", "eight", "eighty", "either", 
#     "ej", "el", "eleven", "else", "elsewhere", "em", "empty", "en", "end", "ending", "enough", "entirely", "eo", 
#     "ep", "eq", "er", "es", "especially", "est", "et", "et-al", "etc", "eu", "ev", "even", "ever", "every", 
#     "everybody", "everyone", "everything", "everywhere", "ex", "exactly", "example", "except", "ey", "f", "f2", 
#     "fa", "far", "fc", "few", "ff", "fi", "fifteen", "fifth", "fify", "fill", "find", "fire", "first", "five", 
#     "fix", "fj", "fl", "fn", "fo", "followed", "following", "follows", "for", "former", "formerly", "forth", 
#     "forty", "found", "four", "fr", "from", "front", "frozen", "further", "furthermore", 
#     "fs", "ft", "fu", "full", "further", "furthermore", "fy", 
#     # "g",
#     "ga", "gave", "ge", "get", "gets", "getting", "gi", "give", "given", "gives", "giving", "gj", "gl", 
#     "go", "goes", "going", "gone", "got", "gotten", "gr", "greetings", "gs", "gy",
#     "h", "h2", "h3", "had", 
#     "hadn", "hadn't", "happens", "hardly", "has", "hasn", "hasnt", "hasn't", "have", "haven", "haven't", "having", 
#     "he", "hed", "he'd", "he'll", "hello", "help", "hence", "her", "here", "hereafter", "hereby", "herein", "heres", 
#     "here's", "hereupon", "hers", "herself", "hes", "he's", "hh", "hi", "hid", "him", "himself", "his", "hither", 
#     "hj", "ho", "home", "hopefully", "how", "howbeit", "however", "how's", "hr", "hs", "http", "hu", "hundred", "hy",

#     "i", "i2", "i3", "i4", "i6", "i7", "i8", "ia", "ib", "ibid", "ic", "id", "i'd", "ie", "if", "ig", "ignored", 
#     "ih", "ii", "ij", "il", "i'll", "im", "i'm", "immediate", "immediately", "importance", "important", "in", 
#     "inasmuch", "inc", "indeed", "index", "indicate", "indicated", "indicates", "information", "inner", "insofar", 
#     "instead", "interest", "into", "invention", "inward", "io", "ip", "iq", "ir", "is", "isn", "isn't", "it", "itd", 
#     "it'd", "it'll", "its", "it's", "itself", "iv", "i've", "ix", "iy", "iz", "j", "jj", "jr", "js", "jt", "ju", 
#     "just", "k", "ke", "keep", "keeps", "kept", "kg", "kj", "km", "know", "known", "knows", "ko", 
    
#     # "l",
#     "l2", "la", "largely", "last", "lately", "later", "latter", "latterly", 
#     # "lb", 
#     "lc", "le", "least", "les", "less", "lest", 
#     "let", "lets", "let's", "lf", "like", "liked", "likely", "line", "little", "lj", "ll", "ln", "lo", "lol", "look", 
#     "looking", "looks", "los", "lr", "ls", "love", "loved", "loving", "lovingly",
#     # "lt", # "ltd", 
#     "m2", "ma", "made", "mainly", "make", "makes", "many", "may", "maybe", "me", "mean", "means", "meantime", 
#     "meanwhile", "merely", "mg", "might", "mightn", "mightn't", 
#     "mill", "million", "mine", "miss", 
#     "mn", "mo", "more", "moreover", "most", "mostly", "move", "mr", "mrs", 
#     "mt", "mu", "much", 
#     # "m", "ml",  "ms","mug", 
#     "must", "mustn", "mustn't", "my", "myself", 
#     "n", "n2", "na", "name", "namely", "nay", "nc", "nd", "ne", "near", "nearly", "necessarily", "necessary",
#     "need", "needn", "needn't", "needs", "neither", "never", "nevertheless", "new", "next", "ng", "ni", "nine", "ninety",
#     "nj", "nl", "nn", "no", "nobody", "non", "none", "nonetheless", "noone",  "nor", "normally",
#     "nos", "not", "noted", "nothing", "novel", "now", "nowhere", "nr", "ns", "nt", "ny", 
#     "o", "oa", "ob", "obtain", "obtained", "obviously", "oc", "od", "of", "off", "often", "og", "oh", "oi", "oj", "ok", 
#     "okay", "ol", "old", "om", "omitted", "on", "once", "one", "ones", "only", "onto", "oo", "op", "oq", "or", "ord", 
#     "os", "ot", "other", "others", "otherwise", "ou", "ought", "our", "ours", "ourselves", "out", "outside", "over", 
#     "overall", "ow", "owing", "own", "ox", "oz", 
#     "p1", "p2", "p3", "page", "pagecount", "pages", "par", "part", 
#     "particular", "particularly", "pas", "past", "pc", "pd", "pe", "per", "perhaps", "pf", "ph", "pi", "pj", "pk", 
#     "pl", "placed", "please", "plus", "pm", "pn", "po", "poorly", "possible", "possibly", "potentially", "pp", "pq", 
#     "pr", "predominantly", "present", "presumably", "previously", "primarily", "probably", "promptly", "proud", 
#     "provides", "ps", "pt", "pu", "put", "purpose", "purposes", "py",
#     "q", "qj", "qu", "que", "quickly", "quite", "qv", "r", "r2", "ra", 
#     "ran", "rather", "rc", "rd", "re", "readily", "really", "reasonably", "recent", "recently", "ref", "refs", 
#     "regarding", "regardless", "regards", "related", "relatively", "research", "research-articl", "respectively", 
#     "resulted", "resulting", "results", "rf", "rh", "ri", "right", "rj", "rl", "rm", "rn", "ro", "rq", "rr", "rs", 
#     "rt", "ru", "run", "rv", "ry", 
#     "s", 
#     "s2", "sa", "said", "same", "saw", "say", "saying", "says", "sc", "sd", 
#     "se", "sec", "second", "secondly", "section", "see", "seeing", "seem", "seemed", "seeming", "seems", "seen", 
#     "self", "selves", "sensible", "sent", "serious", "seriously", "served", "serving", "servings", "serves", "serve", "seven", "several", "sf", "shall", "shan", 
#     "shan't", "she", "shed", "she'd", "she'll", "shes", "she's", "should", "shouldn", "shouldn't", "should've", 
#     "show", "showed", "shown", "showns", "shows", "si", "side", "significant", "significantly", "similar", "similarly", 
#     "since", "sincere", "six", "sixty", "sj", "sl", "slightly", "sm", "sn", "so", "some", "somebody", "somehow", 
#     "someone", "somethan", "something", "sometime", "sometimes", "somewhat", "somewhere", "soon", "sorry", "sp", 
#     "specifically", "specified", "specify", "specifying", "sq", "sr", "ss", "st", "still", "stop", "strongly", 
#     "sub", "substantially", "successfully", "such", "sufficiently", "suggest", "sup", "sum", "summary", 
#     "sure", "sy", "system", "sz",

#     # "t", 
#     "t1", "t2", "t3", "take", "taken", "taking", "tb", "tc", "td", "te", "tell", "ten", "tends", "tf", "th", 
#     "than", "thank", "thanks", "thanx", "that", "that'll", "thats", "that's", "that've", "thaw", "thawed", 
#     "the", "their", "theirs", 
#     "them", "themselves", "then", "thence", "there", "thereafter", "thereby", "thered", "therefore", "therein", 
#     "there'll", "thereof", "therere", "theres", "there's", "thereto", "thereupon", "there've", "these", "they", 
#     "theyd", "they'd", "they'll", "theyre", "they're", "they've", "thickv", "thin", "think", "third", "this", 
#     "thorough", "thoroughly", "those", "thou", "though", "thoughh", "thousand", "three", "throug", "through", 
#     "throughout", "thru", "thus", "ti", "til", "tip", "tj", "tl", "tm", "tn", "to", "together", "too", "took", 
#     "top", "topping", "toward", "towards", "tp", "tq", "tr", "tried", "tries", "truly", "try", "trying", 
#     # "ts",
#     "t's", "tt", "tv", "twelve", "twenty", "twice", "two", "tx", 
#     "u", "u201d", "ue", "ui", "uj", "uk", "um", "un", "under", "unfortunately", "unless", 
#     "unlike", "unlikely", "until", "unto", "uo", "up", "upon", "ups", "ur", "us", "use", 
#     "used", "useful", "usefully", "usefulness", "uses", "using", "usually", "ut", 
#     # "v", 
#     "va", "value", "various", "vd", "very", "via", "viz", "vj", "vo", "vol", "vols", "volumtype", "vq", "vs", "vt", "vu", 
#     # "w", 
#     "wa", "want", "wants", "was", "wasn", "wasnt", "wasn't", "way", "we", "wed", "we'd", "welcome", "well", "we'll", 
#     "well-b", "went", "were", "we're", "weren", "werent", "weren't", "we've", "what", "whatever", "what'll", 
#     "whats", "what's", "when", "whence", "whenever", "when's", "where", "whereafter", "whereas", "whereby", 
#     "wherein", "wheres", "where's", "whereupon", "wherever", "whether", "which", "while", "whim", "whither", "who", 
#     "whod", "whoever", "whole", "who'll", "whom", "whomever", "whos", "who's", "whose", "why", "why's", "wi", 
#     "widely", "will", "willing", "wish", "with", "within", "without", "wo", 
#     "won", 
#     "wonder", "wont", "won't", 
#     "words", "world", "would", "wouldn", "wouldnt", "wouldn't", "www", 
#     "x", "x1", "x2", "x3", "xf", "xi", "xj", 
#     "xk", "xl", "xn", "xo", "xox", "xoxo", "xs", "xt", "xv", "xx",
#     "y", "y2", "yall", "ya'll", "y'all", "yes", "yet", "yj", "yl", "you", "youd", "you'd", 
#     "you'll", "your", "youre", "you're", "yours", "yourself", "yourselves", "you've", "yr", "ys", "yt", 
#     "z", "zero", "zi", "zz", "zip", "zips", "zipped", "zipping", "zipper"
# ))

# FOOD_CATALOG = {
#             # VEGETABLES
#             "potato": ("vegetable", "root"),
#             "potatoes": ("vegetable", "root"),
#             "potatoe": ("vegetable", "root"),
#             "potatos": ("vegetable", "root"),
#             "russet potato": ("vegetable", "root"),
#             "russet potatoes": ("vegetable", "root"),
#             "russet potatos": ("vegetable", "root"),
#             "yukon gold potato": ("vegetable", "root"),
#             "yukon gold potatoes": ("vegetable", "root"),
#             "yukon gold potatos": ("vegetable", "root"),
#             "fingerling potato": ("vegetable", "root"),
#             "fingerling potatoes": ("vegetable", "root"),
#             "fingerling potatos": ("vegetable", "root"),
#             "sweet potato": ("vegetable", "root"),
#             "sweet potatoes": ("vegetable", "root"),
#             "sweet potatos": ("vegetable", "root"),
#             "beet": ("vegetable", "root"),
#             "beets": ("vegetable", "root"),
#             "carrot": ("vegetable", "root"),
#             "carrots": ("vegetable", "root"),
#             "onion": ("vegetable", "bulb"),
#             "onions": ("vegetable", "bulb"),
#             "shallot": ("vegetable", "bulb"),
#             "shallots": ("vegetable", "bulb"),
#             "green onion": ("vegetable", "bulb"),
#             "green onions": ("vegetable", "bulb"),
#             "red onion": ("vegetable", "bulb"),
#             "red onions": ("vegetable", "bulb"),
#             "yellow onion": ("vegetable", "bulb"),
#             "yellow onions": ("vegetable", "bulb"),
#             "white onion": ("vegetable", "bulb"),
#             "white onions": ("vegetable", "bulb"),
#             "sweet onion": ("vegetable", "bulb"),
#             "sweet onions": ("vegetable", "bulb"),
#             "pearl onion": ("vegetable", "bulb"),
#             "pearl onions": ("vegetable", "bulb"),
#             "cipollini onion": ("vegetable", "bulb"),
#             "cipollini onions": ("vegetable", "bulb"),
#             "leek": ("vegetable", "bulb"),
#             "leeks": ("vegetable", "bulb"),
#             "scallion": ("vegetable", "bulb"),
#             "scallions": ("vegetable", "bulb"),
#             "garlic": ("vegetable", "bulb"),
#             "celery": ("vegetable", "stem"),
#             "tomato": ("vegetable", "fruit"),
#             "tomatoes": ("vegetable", "fruit"),
#             "tomato paste": ("vegetable", "fruit"),
#             "cherry tomato": ("vegetable", "fruit"),
#             "cherry tomatoes": ("vegetable", "fruit"),
#             "asparagus": ("vegetable", "stem"),
#             "kale": ("vegetable", "leafy"),
#             "spinach": ("vegetable", "leafy"),
#             "broccoli": ("vegetable", "cruciferous"),
#             "broccolini": ("vegetable", "cruciferous"),
#             "broccolis": ("vegetable", "cruciferous"),
#             "broccolinis": ("vegetable", "cruciferous"),
#             "broccoli rabe": ("vegetable", "cruciferous"),
#             "broccoli raab": ("vegetable", "cruciferous"),
#             "cauliflower": ("vegetable", "cruciferous"),
#             "cauliflower rice": ("vegetable", "cruciferous"),
#             "brussel sprout": ("vegetable", "cruciferous"),
#             "brussel sprouts": ("vegetable", "cruciferous"),
#             "zucchini": ("fruit", "squash"),
#             "zucchinis": ("fruit", "squash"),
#             "lettuce": ("vegetable", "leafy"),
#             "romaine lettuce": ("vegetable", "leafy"),
#             "iceberg lettuce": ("vegetable", "leafy"),
#             "butter lettuce": ("vegetable", "leafy"),
#             "boston lettuce": ("vegetable", "leafy"),
#             "bibb lettuce": ("vegetable", "leafy"),
#             "butter head lettuce": ("vegetable", "leafy"),
#             "mixed greens": ("vegetable", "leafy"),
#             "arugula": ("vegetable", "leafy"),
#             "endive": ("vegetable", "leafy"),
#             "endives": ("vegetable", "leafy"),
#             "radicchio": ("vegetable", "leafy"),
#             "radish": ("vegetable", "root"),
#             "radishes": ("vegetable", "root"),
#             "turnip": ("vegetable", "root"),
#             "turnips": ("vegetable", "root"),
#             "artichoke": ("vegetable", "flower"),
#             "artichokes": ("vegetable", "flower"),
#             "cabbage": ("vegetable", "cruciferous"),
#             "bell pepper": ("vegetable", "fruit"),
#             "bell peppers": ("vegetable", "fruit"),
#             "yellow bell pepper": ("vegetable", "fruit"),
#             "yellow bell peppers": ("vegetable", "fruit"),
#             "red bell pepper": ("vegetable", "fruit"),
#             "red bell peppers": ("vegetable", "fruit"),
#             "green bell pepper": ("vegetable", "fruit"),
#             "green bell peppers": ("vegetable", "fruit"),
#             "jalapeno": ("vegetable", "fruit"),
#             "jalapenos": ("vegetable", "fruit"),
#             "poblano": ("vegetable", "fruit"),
#             "poblanos": ("vegetable", "fruit"),
#             "habanero": ("vegetable", "fruit"),
#             "habaneros": ("vegetable", "fruit"),
#             "serrano": ("vegetable", "fruit"),
#             "serranos": ("vegetable", "fruit"),
#             "cucumber": ("vegetable", "fruit"),
#             "cucumbers": ("vegetable", "fruit"),
#             "ghost pepper": ("vegetable", "fruit"),
#             "ghost peppers": ("vegetable", "fruit"),
#             "carolina reaper": ("vegetable", "fruit"),
#             "carolina reapers": ("vegetable", "fruit"),
#             "mushroom": ("vegetable", "fungi"),
#             "mushrooms": ("vegetable", "fungi"),
#             "cremini mushroom": ("vegetable", "fungi"),
#             "cremini mushrooms": ("vegetable", "fungi"),
#             "portobello mushroom": ("vegetable", "fungi"),
#             "portobello mushrooms": ("vegetable", "fungi"),
#             "shiitake mushroom": ("vegetable", "fungi"),
#             "shiitake mushrooms": ("vegetable", "fungi"),

#             # LEGUMES
#             "bean": ("legume", "bean"),
#             "beans": ("legume", "bean"),
#             "black bean": ("legume", "bean"),
#             "black beans": ("legume", "bean"),
#             "kidney bean": ("legume", "bean"),
#             "kidney beans": ("legume", "bean"),
#             "pinto bean": ("legume", "bean"),
#             "pinto beans": ("legume", "bean"),
#             "cannellini bean": ("legume", "bean"),
#             "cannellini beans": ("legume", "bean"),
#             "refried bean": ("legume", "bean"),
#             "refried beans": ("legume", "bean"),
#             "white bean": ("legume", "bean"),
#             "white beans": ("legume", "bean"),
#             "fava bean": ("legume", "bean"),
#             "fava beans": ("legume", "bean"),
#             "navy bean": ("legume", "bean"),
#             "navy beans": ("legume", "bean"),
#             "lima bean": ("legume", "bean"),
#             "lima beans": ("legume", "bean"),
#             "soybean": ("legume", "bean"),
#             "soybeans": ("legume", "bean"),
#             "edamame": ("legume", "bean"),
#             "edamames": ("legume", "bean"),

#             "lentil": ("legume", "lentil"),
#             "lentils": ("legume", "lentil"),
#             "red lentil": ("legume", "lentil"),
#             "red lentils": ("legume", "lentil"),
#             "green lentil": ("legume", "lentil"),
#             "green lentils": ("legume", "lentil"),
#             "brown lentil": ("legume", "lentil"),
#             "brown lentils": ("legume", "lentil"),
#             "yellow lentil": ("legume", "lentil"),
#             "yellow lentils": ("legume", "lentil"),
#             "black lentil": ("legume", "lentil"),
#             "black lentils": ("legume", "lentil"),
#             "french lentil": ("legume", "lentil"),
#             "french lentils": ("legume", "other"),
#             "puy lentil": ("legume", "lentil"),
#             "puy lentils": ("legume", "lentil"),
#             "canned lentil": ("legume", "lentil"),
#             "canned lentils": ("legume", "lentil"),

#             "peas": ("legume", "peas"),
#             "green pea": ("legume", "pea"),
#             "green peas": ("legume", "pea"),
#             "split pea": ("legume", "pea"),
#             "split peas": ("legume", "pea"),
#             "black-eyed pea": ("legume", "pea"),
#             "black-eyed peas": ("legume", "pea"),
#             "black eyed pea": ("legume", "pea"),
#             "black eyed peas": ("legume", "pea"),
#             "blackeyed peas": ("legume", "pea"),
#             "blackeyed pea": ("legume", "pea"),

#             "chickpea": ("legume", "pea"),
#             "chickpeas": ("legume", "pea"),
#             "garbanzo": ("legume", "bean"),
#             "garbanzos": ("legume", "bean"),
#             "garbanzo bean": ("legume", "pea"),
#             "garbanzo beans": ("legume", "pea"), 
#             "can of chickpea": ("legume", "pea"),
#             "can of chickpeas": ("legume", "pea"),
#             "canned chickpea": ("legume", "pea"),
#             "canned chickpeas": ("legume", "pea"),
#             "canned garbanzo": ("legume", "pea"),
#             "canned garbanzos": ("legume", "pea"),
#             "can of garbanzo": ("legume", "pea"),
#             "can of garbanzos": ("legume", "pea"),
#             "can of garbanzo bean": ("legume", "pea"),
#             "can of garbanzo beans": ("legume", "pea"),
#             "canned garbanzo bean": ("legume", "pea"),
#             "canned garbanzo beans": ("legume", "pea"),
#             "snow pea": ("legume", "pea"),
#             "snow peas": ("legume", "pea"),
#             "snowpea": ("legume", "pea"),
#             "snowpeas": ("legume", "pea"),
#             "sugar snap pea": ("legume", "pea"),
#             "sugar snap peas": ("legume", "pea"),
#             "snap pea": ("legume", "pea"),
#             "snap peas": ("legume", "pea"),
#             "field pea": ("legume", "pea"),
#             "field peas": ("legume", "pea"),
#             "cowpea": ("legume", "pea"),
#             "cowpeas": ("legume", "pea"),
#             "yellow pea": ("legume", "pea"),
#             "yellow peas": ("legume", "pea"),
#             "garden pea": ("legume", "pea"),
#             "garden peas": ("legume", "pea"),
#             "pea shoot": ("legume", "pea"),
#             "pea shoots": ("legume", "pea"),

#             # MEATS
#             "egg": ("meat", "egg"),
#             "eggs": ("meat", "egg"),
#             "egg yolk": ("meat", "egg"),
#             "egg yolks": ("meat", "egg"),
#             "egg white": ("meat", "egg"),
#             "egg whites": ("meat", "egg"),
#             "chicken egg": ("meat", "egg"),
#             "chicken eggs": ("meat", "egg"),
#             "duck egg": ("meat", "egg"),
#             "duck eggs": ("meat", "egg"),
#             "quail egg": ("meat", "egg"),
#             "quail eggs": ("meat", "egg"),

#             "chicken": ("meat", "poultry"),
#             "chicken breast": ("meat", "poultry"),
#             "chicken breasts": ("meat", "poultry"),
#             "chicken thigh": ("meat", "poultry"),
#             "chicken thighs": ("meat", "poultry"),
#             "chicken leg": ("meat", "poultry"),
#             "chicken legs": ("meat", "poultry"),
#             "chicken wing": ("meat", "poultry"),
#             "chicken wings": ("meat", "poultry"),
#             "turkey": ("meat", "poultry"),
#             "turkey breast": ("meat", "poultry"),
#             "turkey breasts": ("meat", "poultry"),
#             "turkey thigh": ("meat", "poultry"),
#             "turkey thighs": ("meat", "poultry"),
#             "turkey leg": ("meat", "poultry"),
#             "turkey legs": ("meat", "poultry"),
#             "turkey wing": ("meat", "poultry"),
#             "turkey wings": ("meat", "poultry"),
#             "turkey bacon": ("meat", "poultry"),
#             "turkey sausage": ("meat", "poultry"),
#             "duck": ("meat", "poultry"),
#             "duck breast": ("meat", "poultry"),
#             "duck breasts": ("meat", "poultry"),
#             "duck thigh": ("meat", "poultry"),
#             "duck thighs": ("meat", "poultry"),
#             "duck leg": ("meat", "poultry"),
#             "duck legs": ("meat", "poultry"),
#             "duck wing": ("meat", "poultry"),
#             "duck wings": ("meat", "poultry"),
#             "duck bacon": ("meat", "poultry"),
#             "duck sausage": ("meat", "poultry"),
#             "quail": ("meat", "poultry"),
#             "quail breast": ("meat", "poultry"),
#             "quail breasts": ("meat", "poultry"),
#             "quail thigh": ("meat", "poultry"),
#             "quail thighs": ("meat", "poultry"),
#             "quail leg": ("meat", "poultry"),
#             "quail legs": ("meat", "poultry"),
#             "quail wing": ("meat", "poultry"),
#             "quail wings": ("meat", "poultry"),

#             "beef": ("meat", "beef"),
#             "grass-fed beef": ("meat", "beef"),
#             "grassfed beef": ("meat", "beef"),
#             "grass fed beef": ("meat", "beef"),
#             "ground beef": ("meat", "beef"),
#             "grass-fed ground beef": ("meat", "beef"),
#             "grassfed ground beef": ("meat", "beef"),
#             "grass fed ground beef": ("meat", "beef"),
#             "hamburger": ("meat", "beef"),
#             "hamburgers": ("meat", "beef"),
#             "hamburger patty": ("meat", "beef"),
#             "hamburger patties": ("meat", "beef"),
#             "steak": ("meat", "beef"),
#             "steaks": ("meat", "beef"),
#             "beef chuck": ("meat", "beef"),
#             "beef brisket": ("meat", "beef"),
#             "beef shank": ("meat", "beef"),
#             "beef sirloin": ("meat", "beef"),
#             "beef tenderloin": ("meat", "beef"),
#             "beef loin": ("meat", "beef"),
#             "beef short loin": ("meat", "beef"),
#             "beef ribeye": ("meat", "beef"),
#             "beef ribeyes": ("meat", "beef"),
#             "beef liver": ("meat", "beef"),
#             "beef tongue": ("meat", "beef"),
#             "beef round": ("meat", "beef"),
#             "beef rib": ("meat", "beef"),
#             "beef ribs": ("meat", "beef"),
#             "beef cheek": ("meat", "beef"),
#             "beef cheeks": ("meat", "beef"),
#             "t-bone steak": ("meat", "beef"),
#             "T-bone steaks": ("meat", "beef"),
#             "filet mignon": ("meat", "beef"),
#             "filet mignons": ("meat", "beef"),
#             "new york strip": ("meat", "beef"),
#             "new york strips": ("meat", "beef"),
#             "ribeye steak": ("meat", "beef"),
#             "ribeye steaks": ("meat", "beef"),
#             "sirloin steak": ("meat", "beef"),
#             "sirloin steaks": ("meat", "beef"),
#             "flank steak": ("meat", "beef"),
#             "flank steaks": ("meat", "beef"),
#             "skirt steak": ("meat", "beef"),
#             "skirt steaks": ("meat", "beef"),
#             "hanger steak": ("meat", "beef"),
#             "hanger steaks": ("meat", "beef"),
#             "porterhouse steak": ("meat", "beef"),
#             "porterhouse steaks": ("meat", "beef"),
#             "chuck steak": ("meat", "beef"),
#             "chuck steaks": ("meat", "beef"),
#             "brisket": ("meat", "beef"),

#             "bacon": ("meat", "pork"),
#             "bacon strips": ("meat", "pork"),
#             "bacon slice": ("meat", "pork"),
#             "bacon bits": ("meat", "pork"),
#             "pork": ("meat", "pork"),
#             "pork chop": ("meat", "pork"),
#             "pork chops": ("meat", "pork"),
#             "pork tenderloin": ("meat", "pork"),
#             "pork tenderloins": ("meat", "pork"),
#             "pork loin": ("meat", "pork"),
#             "pork loins": ("meat", "pork"),
#             "pork shoulder": ("meat", "pork"),
#             "pork shoulders": ("meat", "pork"),
#             "pork belly": ("meat", "pork"),
#             "pork bellies": ("meat", "pork"),
#             "pork butt": ("meat", "pork"),
#             "pork butts": ("meat", "pork"),
#             "pork rib": ("meat", "pork"),
#             "pork ribs": ("meat", "pork"),
#             "pork sausage": ("meat", "pork"),
#             "pork sausages": ("meat", "pork"),
            
#             "lamb": ("meat", "lamb"),
#             "lamb chop": ("meat", "lamb"),
#             "lamb chops": ("meat", "lamb"),
#             "lamb shank": ("meat", "lamb"),
#             "lamb shanks": ("meat", "lamb"),
#             "lamb cutlet": ("meat", "lamb"),
#             "lamb cutlets": ("meat", "lamb"),
#             "lamb leg": ("meat", "lamb"),
#             "lamb legs": ("meat", "lamb"),

#             "venison": ("meat", "venison"),
#             "venison chop": ("meat", "venison"),
#             "venison chops": ("meat", "venison"),
#             "venison shank": ("meat", "venison"),
#             "venison shanks": ("meat", "venison"),
#             "venison loin": ("meat", "venison"),
#             "venison loins": ("meat", "venison"),
#             "venison tenderloin": ("meat", "venison"),
#             "venison tenderloins": ("meat", "venison"),
#             "venison shoulder": ("meat", "venison"),
#             "venison shoulders": ("meat", "venison"),

#             "tofu": ("meat", "meat substitute"),
#             "tofus": ("meat", "meat substitute"),
#             "tofu block": ("meat", "meat substitute"),
#             "tofu blocks": ("meat", "meat substitute"),
#             "tofu burger": ("meat", "meat substitute"),
#             "tofu burgers": ("meat", "meat substitute"),
#             "tofu bacon": ("meat", "meat substitute"),
#             "tempeh": ("meat", "meat substitute"),
#             "seitan": ("meat", "meat substitute"),
#             "soy protein": ("meat", "meat substitute"),
#             "soy protein powder": ("meat", "meat substitute"),
#             "soy protein isolate": ("meat", "meat substitute"),
#             "pea protein": ("meat", "meat substitute"),
#             "tofurkey": ("meat", "meat substitute"),
#             "tofurkey sausage": ("meat", "meat substitute"),
#             "tofurkey sausages": ("meat", "meat substitute"),
#             "impossible burger": ("meat", "meat substitute"),
#             "impossible burgers": ("meat", "meat substitute"),
#             "impossible meat": ("meat", "meat substitute"),
#             "impossible meats": ("meat", "meat substitute"),
#             "impossible sausage": ("meat", "meat substitute"),
#             "impossible sausages": ("meat", "meat substitute"),
#             "beyond burger": ("meat", "meat substitute"),
#             "beyond burgers": ("meat", "meat substitute"),

#             # SEAFOOD
#             "salmon": ("meat", "fish"),
#             "swordfish": ("meat", "fish"),
#             "sea bass": ("meat", "fish"),
#             "catfish": ("meat", "fish"),
#             "halibut": ("meat", "fish"),
#             "cod": ("meat", "fish"),
#             "tuna": ("meat", "fish"),
#             "trout": ("meat", "fish"),
#             "snapper": ("meat", "fish"),
#             "mahi mahi": ("meat", "fish"),
#             "mackerel": ("meat", "fish"),
#             "sardine": ("meat", "fish"),
#             "sardines": ("meat", "fish"),
#             "anchovy": ("meat", "fish"),
#             "anchovies": ("meat", "fish"),
#             "herring": ("meat", "fish"),
#             "carp": ("meat", "fish"),
#             "tilapia": ("meat", "fish"),
#             "can of tuna": ("meat", "fish"),
#             "canned tuna": ("meat", "fish"),
#             "can of salmon": ("meat", "fish"),
#             "canned salmon": ("meat", "fish"),
#             "clam": ("meat", "shellfish"),
#             "clams": ("meat", "shellfish"),
#             "mussels": ("meat", "shellfish"),
#             "shrimp": ("meat", "shellfish"),
#             "lobster": ("meat", "shellfish"),
#             "lobsters": ("meat", "shellfish"),
#             "crab": ("meat", "shellfish"),
#             "crabs": ("meat", "shellfish"),
#             "imitation crab": ("meat", "shellfish"),
#             "oyster": ("meat", "shellfish"),
#             "oysters": ("meat", "shellfish"),
#             "scallop": ("meat", "shellfish"),
#             "scallops": ("meat", "shellfish"),
            
#             # DAIRY
#             "milk": ("dairy", "milk"),
#             "whole milk": ("dairy", "milk"),
#             "skim milk": ("dairy", "milk"),
#             "nonfat milk": ("dairy", "milk"),
#             "butter": ("dairy", "butter"),
#             "clarified butter": ("dairy", "butter"),
#             "unsalted butter": ("dairy", "butter"),
#             "salted butter": ("dairy", "butter"),
#             "heavy whipping cream": ("dairy", "cream"),
#             "half and half": ("dairy", "cream"),
#             "half & half": ("dairy", "cream"),
#             "whipped cream": ("dairy", "cream"),
#             "light whipped cream": ("dairy", "cream"),
#             "lowfat whipped cream": ("dairy", "cream"),
#             "margarine": ("dairy", "butter"),
#             "cheese": ("dairy", "cheese"),
#             "crumbled cheese": ("dairy", "cheese"),
#             "shredded cheese": ("dairy", "cheese"),
#             "bleu cheese": ("dairy", "cheese"),
#             "parmesan cheese": ("dairy", "cheese"),
#             "shredded parmesan cheese": ("dairy", "cheese"),
#             "cheddar cheese": ("dairy", "cheese"),
#             "shredded cheddar cheese": ("dairy", "cheese"),
#             "mozzarella cheese": ("dairy", "cheese"),
#             "shredded mozzarella cheese": ("dairy", "cheese"),
#             "feta cheese": ("dairy", "cheese"),
#             "goat cheese": ("dairy", "cheese"),
#             "gorgonzola cheese": ("dairy", "cheese"),
#             "provolone cheese": ("dairy", "cheese"),
#             "swiss cheese": ("dairy", "cheese"),
#             "american cheese": ("dairy", "cheese"),
#             "pepper jack cheese": ("dairy", "cheese"),
#             "monterey jack cheese": ("dairy", "cheese"),
#             "colby cheese": ("dairy", "cheese"),
#             "muenster cheese": ("dairy", "cheese"),
#             "havarti cheese": ("dairy", "cheese"),
#             "brie cheese": ("dairy", "cheese"),
#             "camembert cheese": ("dairy", "cheese"),
#             "cream cheese": ("dairy", "cheese"),
#             "light cream cheese": ("dairy", "cheese"),
#             "lowfat cream cheese": ("dairy", "cheese"),
#             "cottage cheese": ("dairy", "cheese"),
#             "lowfat cottage cheese": ("dairy", "cheese"),
#             "yogurt": ("dairy", "yogurt"),
#             "nonfat yogurt": ("dairy", "yogurt"),
#             "lowfat yogurt": ("dairy", "yogurt"),
#             "greek yogurt": ("dairy", "yogurt"),
#             "nonfat greek yogurt": ("dairy", "yogurt"),
#             "lowfat greek yogurt": ("dairy", "yogurt"),
#             "sour cream": ("dairy", "other"),
#             "light sour cream": ("dairy", "other"),
#             "heavy cream": ("dairy", "other"),

#             # DAIRY ALTERNATIVES
#             "almond milk": ("dairy", "milk substitute"),
#             "unsweetened almond milk": ("dairy", "milk substitute"),
#             "sweetened almond milk": ("dairy", "milk substitute"),
#             "unsweetened vanilla almond milk": ("dairy", "milk substitute"),
#             "sweetened vanilla almond milk": ("dairy", "milk substitute"),
#             "cashew milk": ("dairy", "milk substitute"),
#             "unsweetened cashew milk": ("dairy", "milk substitute"),
#             "sweetened cashew milk": ("dairy", "milk substitute"),
#             "unsweetened vanilla cashew milk": ("dairy", "milk substitute"),
#             "sweetened vanilla cashew milk": ("dairy", "milk substitute"),
#             "rice milk": ("dairy", "milk substitute"),
#             "soy milk": ("dairy", "milk substitute"),
#             "coconut milk": ("dairy", "milk substitute"),
#             "oat milk": ("dairy", "milk substitute"),

#             # GRAINS
#             "rice": ("grain", "rice"),
#             "white rice": ("grain", "rice"),
#             "brown rice": ("grain", "rice"),
#             "basmati rice": ("grain", "rice"),
#             "long grain rice": ("grain", "rice"),
#             "short grain rice": ("grain", "rice"),
#             "jasmine rice": ("grain", "rice"),
#             "wild rice": ("grain", "rice"),
#             "wild rice blend": ("grain", "rice"),
#             "fried rice": ("grain", "rice"),

#             "pasta": ("grain", "pasta"),
#             "pastas": ("grain", "pasta"),
#             "whole wheat pasta": ("grain", "pasta"),
#             "whole wheat pastas": ("grain", "pasta"),
#             "whole grain pasta": ("grain", "pasta"),
#             "whole grain pastas": ("grain", "pasta"),
#             "gluten free pasta": ("grain", "pasta"),
#             "gluten free pastas": ("grain", "pasta"),
#             "gluten-free pasta": ("grain", "pasta"),
#             "angel hair pasta": ("grain", "pasta"),
#             "fettuccine pasta": ("grain", "pasta"),
#             "penne pasta": ("grain", "pasta"),
#             "spaghetti pasta": ("grain", "pasta"),
#             "linguine pasta": ("grain", "pasta"),
#             "rotini pasta": ("grain", "pasta"),
#             "macaroni pasta": ("grain", "pasta"),
#             "elbow pasta": ("grain", "pasta"),
#             "penne" : ("grain", "pasta"),
#             "spaghetti" : ("grain", "pasta"),
#             "linguine" : ("grain", "pasta"),
#             "rotini" : ("grain", "pasta"),
#             "macaroni" : ("grain", "pasta"),
#             "elbow" : ("grain", "pasta"),
#             "lasagna noodle": ("grain", "pasta"),
#             "lasagna noodles": ("grain", "pasta"),
#             "lasagna sheet": ("grain", "pasta"),
#             "lasagna sheets": ("grain", "pasta"),
#             "lasagna": ("grain", "pasta"),
#             "bread": ("grain", "bread"),
#             "baguette": ("grain", "bread"),
#             "french bread": ("grain", "bread"),
#             "french baguette": ("grain", "bread"),
#             "french roll": ("grain", "bread"),
#             "french rolls": ("grain", "bread"),
#             "sourdough": ("grain", "bread"),
#             "sourdough bread": ("grain", "bread"),
#             "whole wheat bread": ("grain", "bread"),
#             "white bread": ("grain", "bread"),
#             "multigrain bread": ("grain", "bread"),
#             "rye bread": ("grain", "bread"),
#             "oat bread": ("grain", "bread"),
#             "egg bread": ("grain", "bread"),
#             "potato bread": ("grain", "bread"),
#             "cornbread": ("grain", "bread"),
#             "corn bread": ("grain", "bread"),
#             "croissant": ("grain", "bread"),
#             "croissants": ("grain", "bread"),
#             "biscuit": ("grain", "bread"),
#             "biscuits": ("grain", "bread"),
#             "english muffin": ("grain", "bread"),
#             "english muffins": ("grain", "bread"),
#             "bagel": ("grain", "bread"),
#             "bagels": ("grain", "bread"),
#             "tortilla": ("grain", "bread"),
#             "tortillas": ("grain", "bread"),
#             "corn tortilla": ("grain", "bread"),
#             "corn tortillas": ("grain", "bread"),
#             "flour tortilla": ("grain", "bread"),
#             "flour tortillas": ("grain", "bread"),
#             "flatbread": ("grain", "bread"),
#             "flatbreads": ("grain", "bread"),
#             "pita": ("grain", "bread"),
#             "pitas": ("grain", "bread"),
#             "naan": ("grain", "bread"),
#             "naans": ("grain", "bread"),
#             "whole wheat naan": ("grain", "bread"),
#             "hamburger bun": ("grain", "bread"),
#             "hamburger buns": ("grain", "bread"),
#             "hot dog bun": ("grain", "bread"),
#             "hot dog buns": ("grain", "bread"),
#             "hawaiian roll": ("grain", "bread"),
#             "hawaiian rolls": ("grain", "bread"),
#             "english roll": ("grain", "bread"),
#             "english rolls": ("grain", "bread"),
#             "foccacia": ("grain", "bread"),
#             "foccacia bread": ("grain", "bread"),
#             "foccacia roll": ("grain", "bread"),
#             "foccacia rolls": ("grain", "bread"),

#             "egg noodle": ("grain", "pasta"),
#             "egg noodles": ("grain", "pasta"),
#             "glass noodle": ("grain", "pasta"),
#             "glass noodles": ("grain", "pasta"),
#             "ramen noodle": ("grain", "pasta"),
#             "ramen noodles": ("grain", "pasta"),
#             "rice noodle": ("grain", "pasta"),
#             "rice noodles": ("grain", "pasta"),
#             "soba noodle": ("grain", "pasta"),
#             "soba noodles": ("grain", "pasta"),
#             "udon noodle": ("grain", "pasta"),
#             "udon noodles": ("grain", "pasta"),
#             "oatmeal": ("grain", "oat"),
#             "rolled oats": ("grain", "oat"),
#             "steel cut oats": ("grain", "oat"),
#             "rolled oatmeal": ("grain", "oat"),
#             "steel cut oatmeal": ("grain", "oat"),
#             "corn": ("grain", "corn"),
#             "quinoa": ("grain", "other"),
#             "barley": ("grain", "other"),
#             "rye": ("grain", "other"),
#             "couscous": ("grain", "other"),
#             "popcorn": ("grain", "other"),
#             "millet": ("grain", "other"),
#             "flour": ("grain", "flour"),
#             "all-purpose flour": ("grain", "flour"),
#             "whole wheat flour": ("grain", "flour"),
#             "whole grain flour": ("grain", "flour"),
#             "bread flour": ("grain", "flour"),
#             "semolina flour": ("grain", "flour"),
#             "semolina": ("grain", "flour"),
#             "cake flour": ("grain", "flour"),
#             "self-rising flour": ("grain", "flour"),
#             "cornstarch": ("grain", "flour"),
#             "corn starch": ("grain", "flour"),
#             "cornmeal": ("grain", "flour"),
#             "corn meal": ("grain", "flour"),

#             # NUTS
#             "almond": ("nut", "other"),
#             "almonds": ("nut", "other"),
#             "roasted almond": ("nut", "other"),
#             "roasted almonds": ("nut", "other"),
#             "peanut": ("nut", "other"),
#             "peanuts": ("nut", "other"),
#             "roasted peanut": ("nut", "other"),
#             "roasted peanuts": ("nut", "other"),
#             "unsalted peanut": ("nut", "other"),
#             "unsalted peanuts": ("nut", "other"),
#             "salted peanut": ("nut", "other"),
#             "salted peanuts": ("nut", "other"),
#             "cashew": ("nut", "other"),
#             "cashews": ("nut", "other"),
#             "pisatchio": ("nut", "other"),
#             "pistachios": ("nut", "other"),
#             "macadamia": ("nut", "other"),
#             "macadamia nut": ("nut", "other"),
#             "macadamia nuts": ("nut", "other"),
#             "hazelnut": ("nut", "other"),
#             "hazelnuts": ("nut", "other"),
#             "chestnut": ("nut", "other"),
#             "chestnuts": ("nut", "other"),
#             "pine nut": ("nut", "other"),
#             "pine nuts": ("nut", "other"),
#             "brazil nut": ("nut", "other"),
#             "brazil nuts": ("nut", "other"),
#             "walnut": ("nut", "other"),
#             "walnuts": ("nut", "other"),
#             "pecan": ("nut", "other"),
#             "pecans": ("nut", "other"),
#             "peanut butter": ("nut", "nut butter"),
#             "almond butter": ("nut", "nut butter"),
#             "cashew butter": ("nut", "nut butter"),
#             "pumpkin seed": ("nut", "seed"),
#             "pumpkin seeds": ("nut", "seed"),
#             "sunflower seed": ("nut", "seed"),
#             "sunflower seeds": ("nut", "seed"),
#             "sesame seed": ("nut", "seed"),
#             "sesame seeds": ("nut", "seed"),
#             "almond flour": ("nut", "flour"),

#             # OILS
#             "vegetable oil": ("oil", "vegetable-based"),
#             "sesame oil": ("oil", "seed-based"),
#             "sunflower oil": ("oil", "seed-based"),
#             "canola oil": ("oil", "seed-based"),
#             "olive oil": ("oil", "vegetable-based"),
#             "coconut oil": ("oil", "vegetable-based"),
#             "avocado oil": ("oil", "vegetable-based"),
#             "extra virgin olive oil": ("oil", "vegetable-based"),
#             "peanut oil": ("oil", "seed-based"),
#             "truffle oil": ("oil", "vegetable-based"),
#             "chili oil": ("oil", "vegetable-based"),
#             "salmon oil": ("oil", "animal-based"),
#             "wild alaskan salmon oil": ("oil", "animal-based"),
#             "cod liver oil": ("oil", "animal-based"),
#             "omega-3 oil": ("oil", "animal-based"),
#             "fish oil": ("oil", "animal-based"),
#             "lard": ("oil", "animal-based"),
#             "duck fat": ("oil", "animal-based"),
#             "goose fat": ("oil", "animal-based"),
#             "tallow": ("oil", "animal-based"),
#             "beef tallow": ("oil", "animal-based"),
#             "chicken fat": ("oil", "animal-based"),
#             "ghee": ("oil", "animal-based"),
#             "suet": ("oil", "animal-based"),
#             "grass-fed ghee": ("oil", "animal-based"),
#             "grassfed ghee": ("oil", "animal-based"),
#             "grass fed ghee": ("oil", "animal-based"),

#             # SPICES
#             "salt": ("spice", "salt"),
#             "Kosher salt": ("spice", "salt"),
#             "kosher salt": ("spice", "salt"),
#             "table salt": ("spice", "salt"),
#             "sea salt": ("spice", "salt"),
#             "iodized salt": ("spice", "salt"),
#             "black salt": ("spice", "salt"),
#             "himilayan salt": ("spice", "salt"),
#             "pink salt": ("spice", "salt"),
#             "garlic salt": ("spice", "salt"),
#             "onion salt": ("spice", "salt"),
#             "cinnamon": ("spice", "bark"),
#             "cumin": ("spice", "other"),
#             "coriander": ("spice", "other"),
#             "paprika": ("spice", "other"),
#             "cayenne": ("spice", "other"),
#             "chili powder": ("spice", "other"),
#             "curry powder": ("spice", "other"),
#             "turmeric": ("spice", "other"),
#             "ginger": ("spice", "root"),
#             "nutmeg": ("spice", "other"),
#             "cloves": ("spice", "other"),
#             "allspice": ("spice", "other"),
#             "cardamom": ("spice", "other"),
#             "oregano": ("spice", "herb"),
#             "thyme": ("spice", "herb"),
#             "rosemary": ("spice", "herb"),
#             "sage": ("spice", "herb"),
#             "basil": ("spice", "herb"),
#             "mint": ("spice", "herb"),
#             "parsley": ("spice", "herb"),
#             "cilantro": ("spice", "herb"),
#             "dill": ("spice", "herb"),
#             "tarragon": ("spice", "herb"),
#             "garlic powder": ("spice", "other"),
#             "onion powder": ("spice", "other"),
#             "cayenne pepper": ("spice", "pepper"),
#             "lemon pepper": ("spice", "pepper"),
#             "fresh tarragon": ("spice", "herb"),
#             "pepper": ("spice", "pepper"),
#             "ground pepper": ("spice", "pepper"),
#             "black pepper": ("spice", "pepper"),
#             "ground black pepper": ("spice", "pepper"),
#             "peppercorns": ("spice", "seed"),

#             # FRUITS
#             "grapefruit": ("fruit", "citrus"),
#             "grapefruits": ("fruit", "citrus"),
#             "lime": ("fruit", "citrus"),
#             "limes": ("fruit", "citrus"),
#             "lemon": ("fruit", "citrus"),
#             "lemons": ("fruit", "citrus"),
#             "strawberry": ("fruit", "berry"),
#             "strawberries": ("fruit", "berry"),
#             "blueberry": ("fruit", "berry"),
#             "blueberries": ("fruit", "berry"),
#             "blackberry": ("fruit", "berry"),
#             "blackberries": ("fruit", "berry"),
#             "raspberry": ("fruit", "berry"),
#             "raspberries": ("fruit", "berry"),
#             "banana": ("fruit", "tropical"),
#             "bananas": ("fruit", "tropical"),
#             "apple": ("fruit", "pome"),
#             "apples": ("fruit", "pome"),
#             "granny smith apple": ("fruit", "pome"),
#             "granny smith apples": ("fruit", "pome"),
#             "fuji apple": ("fruit", "pome"),
#             "fuji apples": ("fruit", "pome"),
#             "red delicious apple": ("fruit", "pome"),
#             "red delicious apples": ("fruit", "pome"),
#             "golden delicious apple": ("fruit", "pome"),
#             "golden delicious apples": ("fruit", "pome"),
#             "honeycrisp apple": ("fruit", "pome"),
#             "honeycrisp apples": ("fruit", "pome"),
#             "macintosh apple": ("fruit", "pome"),
#             "macintosh apples": ("fruit", "pome"),
#             "orange": ("fruit", "citrus"),
#             "oranges": ("fruit", "citrus"),
#             "pear": ("fruit", "pome"),
#             "pears": ("fruit", "pome"),
#             "grape": ("fruit", "berry"),
#             "grapes": ("fruit", "berry"),
#             "watermelon": ("fruit", "melon"),
#             "watermelons": ("fruit", "melon"),
#             "cantaloupe": ("fruit", "melon"),
#             "cantaloupes": ("fruit", "melon"),
#             "honeydew": ("fruit", "melon"),
#             "honeydews": ("fruit", "melon"),
#             "kiwi": ("fruit", "tropical"),
#             "kiwis": ("fruit", "tropical"),
#             "mango": ("fruit", "tropical"),
#             "mangos": ("fruit", "tropical"),
#             "pineapple": ("fruit", "tropical"),
#             "pineapples": ("fruit", "tropical"),
#             "peach": ("fruit", "stone"),
#             "peaches": ("fruit", "stone"),
#             "plum": ("fruit", "stone"),
#             "plums": ("fruit", "stone"),
#             "apricot": ("fruit", "stone"),
#             "apricots": ("fruit", "stone"),
#             "cherry": ("fruit", "stone"),
#             "cherries": ("fruit", "stone"),
#             "fig": ("fruit", "other"),
#             "figs": ("fruit", "other"),
#             "date": ("fruit", "other"),
#             "dates": ("fruit", "other"),
#             "pomegranate": ("fruit", "other"),
#             "pomegranates": ("fruit", "other"),
#             "coconut": ("fruit", "other"),
#             "coconuts": ("fruit", "other"),
#             "passion fruit": ("fruit", "other"),
#             "passion fruits": ("fruit", "other"),
#             "dragon fruit": ("fruit", "other"),
#             "dragon fruits": ("fruit", "other"),
#             "guava": ("fruit", "other"),
#             "guavas": ("fruit", "other"),
#             "star fruit": ("fruit", "other"),
#             "star fruits": ("fruit", "other"),
#             "lychee": ("fruit", "other"),
#             "lychees": ("fruit", "other"),
#             "persimmon": ("fruit", "other"),
#             "persimmons": ("fruit", "other"),
#             "papaya": ("fruit", "tropical"),
#             "papayas": ("fruit", "tropical"),
#             "cranberry": ("fruit", "berry"),
#             "cranberries": ("fruit", "berry"),
#             "raisin": ("fruit", "other"),
#             "raisins": ("fruit", "other"),
#             "prune": ("fruit", "other"),
#             "prunes": ("fruit", "other"),
#             "currant": ("fruit", "berry"),
#             "currants": ("fruit", "berry"),
#             "elderberry": ("fruit", "berry"),
#             "elderberries": ("fruit", "berry"),
#             "goji berry": ("fruit", "berry"),
#             "goji berries": ("fruit", "berry"),
#             "acai": ("fruit", "berry"),
#             "acai berry": ("fruit", "berry"),
#             "acai berries": ("fruit", "berry"),
#             "boysenberry": ("fruit", "berry"),
#             "boysenberries": ("fruit", "berry"),

#             # BEVERAGES
#             "water": ("beverage", "water"),
#             "coffee": ("beverage", "coffee"),
#             "decaf coffee": ("beverage", "coffee"),
#             "espresso": ("beverage", "coffee"),
#             "tea": ("beverage", "tea"),
#             "soda": ("beverage", "soda"),
#             "orange juice": ("beverage", "juice"),
#             "apple juice": ("beverage", "juice"),
#             "grape juice": ("beverage", "juice"),
#             "mango juice": ("beverage", "juice"),
#             "pineapple juice": ("beverage", "juice"),
#             "lime juice": ("beverage", "juice"),
#             "lemon juice": ("beverage", "juice"),
#             "lemonade": ("beverage", "juice"),
#             "limeade": ("beverage", "juice"),
#             "chicken broth": ("beverage", "soup"),
#             "beef broth": ("beverage", "soup"),
#             "vegetable broth": ("beverage", "soup"),
#             "broth": ("beverage", "soup"),
#             "stock": ("beverage", "soup"),
#             "beer": ("beverage", "beer"),
#             "ale": ("beverage", "beer"),
#             "lager": ("beverage", "beer"),
#             "stout": ("beverage", "beer"),
#             "pilsner": ("beverage", "beer"),
#             "porter": ("beverage", "beer"),
#             "IPA": ("beverage", "beer"),
#             "india pale ale": ("beverage", "beer"),
#             "ipa": ("beverage", "beer"),
#             "wine": ("beverage", "wine"),
#             "white wine": ("beverage", "wine"),
#             "red wine": ("beverage", "wine"),
#             "pinot noir": ("beverage", "wine"),
#             "chardonnay": ("beverage", "wine"),
#             "sauvignon blanc": ("beverage", "wine"),
#             "merlot": ("beverage", "wine"),
#             "cabernet sauvignon": ("beverage", "wine"),
#             "rosé": ("beverage", "wine"),
#             "rose": ("beverage", "wine"),
#             "rose wine" : ("beverage", "wine"),
#             "champagne": ("beverage", "wine"),
#             "sparkling wine": ("beverage", "wine"),
#             "dessert wine": ("beverage", "wine"),
#             "cooking wine": ("beverage", "wine"),

#             # CONDIMENTS/SAUCES
#             "vinegar": ("condiment/sauce", "vinegar"),
#             "white wine vinegar": ("condiment/sauce", "vinegar"),
#             "balsamic vinegar": ("condiment/sauce", "vinegar"),
#             "red wine vinegar": ("condiment/sauce", "vinegar"),
#             "apple cider vinegar": ("condiment/sauce", "vinegar"),
#             "distilled vinegar": ("condiment/sauce", "vinegar"),
#             "rice vinegar": ("condiment/sauce", "vinegar"),
#             "white vinegar": ("condiment/sauce", "vinegar"),
#             "fish sauce": ("condiment/sauce", "other"),
#             "ketchup": ("condiment/sauce", "other"),
#             "reduced-sugar ketchup": ("condiment/sauce", "other"),
#             "reduced sugar ketchup": ("condiment/sauce", "other"),
#             "low-sugar ketchup": ("condiment/sauce", "other"),
#             "low sugar ketchup": ("condiment/sauce", "other"),
#             "sugar-free ketchup": ("condiment/sauce", "other"),
#             "sugar free ketchup": ("condiment/sauce", "other"),
#             "low-sodium ketchup": ("condiment/sauce", "other"),
#             "low sodium ketchup": ("condiment/sauce", "other"),
#             "sodium-free ketchup": ("condiment/sauce", "other"),
#             "sodium free ketchup": ("condiment/sauce", "other"),
#             "relish": ("condiment/sauce", "other"),
#             "mustard": ("condiment/sauce", "other"),
#             "dijon mustard": ("condiment/sauce", "other"),
#             "yellow mustard": ("condiment/sauce", "other"),
#             "honey mustard": ("condiment/sauce", "other"),
#             "mayonnaise": ("condiment/sauce", "other"),
#             "light mayonnaise": ("condiment/sauce", "other"),
#             "lowfat mayonnaise": ("condiment/sauce", "other"),
#             "low-fat mayonnaise": ("condiment/sauce", "other"),
#             "low fat mayonnaise": ("condiment/sauce", "other"),
#             "fat-free mayonnaise": ("condiment/sauce", "other"),
#             "fat free mayonnaise": ("condiment/sauce", "other"),
#             "mayo": ("condiment/sauce", "other"),
#             "light mayo": ("condiment/sauce", "other"),
#             "lowfat mayo": ("condiment/sauce", "other"),
#             "low-fat mayo": ("condiment/sauce", "other"),
#             "low fat mayo": ("condiment/sauce", "other"),
#             "fat-free mayo": ("condiment/sauce", "other"),
#             "fat free mayo": ("condiment/sauce", "other"),
#             "miracle whip": ("condiment/sauce", "other"),
#             "miracle whip light": ("condiment/sauce", "other"),
#             "miracle whip fat-free": ("condiment/sauce", "other"),
#             "miracle whip lowfat": ("condiment/sauce", "other"),
            
#             "ranch": ("condiment/sauce", "other"),
#             "ranch dressing": ("condiment/sauce", "salad dressing"),
#             "caesar dressing": ("condiment/sauce", "salad dressing"),
#             "thousand island dressing": ("condiment/sauce", "salad dressing"),
#             "blue cheese dressing": ("condiment/sauce", "salad dressing"),
#             "italian dressing": ("condiment/sauce", "salad dressing"),
#             "vinaigrette": ("condiment/sauce", "salad dressing"),
#             "vinaigrette dressing": ("condiment/sauce", "salad dressing"),
#             "sesame dressing": ("condiment/sauce", "salad dressing"),
#             "honey mustard dressing": ("condiment/sauce", "salad dressing"),
#             "balsamic dressing": ("condiment/sauce", "salad dressing"),
#             "balsamic vinaigrette": ("condiment/sauce", "salad dressing"),
#             "soy sauce": ("condiment/sauce", "other"),
#             "BBQ sauce": ("condiment/sauce", "other"),
#             "bbq sauce": ("condiment/sauce", "other"),
#             "barbecue sauce": ("condiment/sauce", "other"),
#             "hot sauce": ("condiment/sauce", "other"),
#             "sriracha": ("condiment/sauce", "other"),
#             "salsa": ("condiment/sauce", "other"),

#             # SWEETENERS
#             "sugar": ("sweetener", "sugar"),
#             "brown sugar": ("sweetener", "sugar"),
#             "powdered sugar": ("sweetener", "sugar"),
#             "cane sugar": ("sweetener", "sugar"),
#             "granulated sugar": ("sweetener", "sugar"),
#             "confectioners' sugar": ("sweetener", "sugar"),
#             "confectioners sugar": ("sweetener", "sugar"),
#             "confectioner's sugar": ("sweetener", "sugar"),
#             "coconut palm sugar": ("sweetener", "sugar"),
#             "coconut sugar": ("sweetener", "sugar"),
#             "date sugar": ("sweetener", "sugar"),
#             "corn syrup": ("sweetener", "syrup"),
#             "high fructose corn syrup": ("sweetener", "syrup"),
#             "honey": ("sweetener", "honey"),
#             "organic honey": ("sweetener", "honey"),
#             "maple syrup": ("sweetener", "syrup"),
#             "maple sugar": ("sweetener", "sugar"),
#             "agave": ("sweetener", "nectar"),
#             "agave nectar": ("sweetener", "nectar"),
#             "stevia": ("sweetener", "sugar substitute"),
#             "Sweet'n Low": ("sweetener", "sugar substitute"),
#             "sweet'n low": ("sweetener", "sugar substitute"),
#             "splenda": ("sweetener", "sugar substitute"),
#             "Splenda": ("sweetener", "sugar substitute"),
#             "truvia": ("sweetener", "sugar substitute"),
#             "Xylitol": ("sweetener", "sugar alcohol"),
#             "Erythritol": ("sweetener", "sugar alcohol"),
#             "Sorbitol": ("sweetener", "sugar alcohol"),
#             "Maltitol": ("sweetener", "sugar alcohol"),
#             "xylitol": ("sweetener", "sugar alcohol"),
#             "erythritol": ("sweetener", "sugar alcohol"),
#             "sorbitol": ("sweetener", "sugar alcohol"),
#             "maltitol": ("sweetener", "sugar alcohol"),
#             "chocolate chips": ("sweetener", "other"),

#             # OTHER
#             "pizza": ("other", "other"),
#             "chocolate": ("other", "other"),
#             "ice cream": ("other", "other"),
#             "cake": ("other", "other"),
#             "cooking spray": ("other", "other"),
#             "baking sheets": ("other", "baking"),
#             "baking powder": ("other", "baking"),
#             "baking soda": ("other", "baking"),
#             "yeast": ("other", "baking"),
#             "baking yeast": ("other", "baking"),
#             "active dry yeast": ("other", "baking"),
#             "instant yeast": ("other", "baking"),
#             "baking chocolate": ("other", "baking")
#             }

# FOOD_CATEGORIES = {}

# # go through all of the foods and get all of the major and minor categories from the dictionary value lists
# for key, val in FOOD_CATALOG.items():
#     major_category, minor_category = val
    
#     current_set = FOOD_CATEGORIES.get(major_category, set())
#     current_set.add(minor_category)

#     # Update the major category key with the new updated set of minory categories
#     FOOD_CATEGORIES[major_category] = current_set

# # Convert each set to a list
# for key, val in FOOD_CATEGORIES.items():
#     # This is hacky, but to keep "other" at the end of the list if "other" is a category
#     if "other" not in val:
#         FOOD_CATEGORIES[key] = list(val)
#     else:
#         FOOD_CATEGORIES[key].remove("other")
#         FOOD_CATEGORIES[key] = list(val)
#         FOOD_CATEGORIES[key].append("other")

# # then convert the lists to tuples 
# for key in FOOD_CATEGORIES:
#     FOOD_CATEGORIES[key] = tuple(FOOD_CATEGORIES[key])

# class IngredientConstants:

#     # Primary unit maps
#     UNITS = UNITS
#     BASIC_UNITS = BASIC_UNITS

#     # other (specific) unit maps
#     WEIGHT_UNITS = WEIGHT_UNITS
#     DIMENSION_UNITS = DIMENSION_UNITS
#     CASUAL_UNITS = CASUAL_UNITS
#     CASUAL_QUANTITIES = CASUAL_QUANTITIES

#     # primary unit sets
#     UNITS_SET = UNITS_SET
#     BASIC_UNITS_SET = BASIC_UNITS_SET
#     NON_BASIC_UNITS_SET = NON_BASIC_UNITS_SET
    
#     # other (specific) units sets
#     WEIGHT_UNITS_SET = WEIGHT_UNITS_SET
#     DIMENSION_UNITS_SET = DIMENSION_UNITS_SET
#     CASUAL_UNITS_SET = CASUAL_UNITS_SET
#     CASUAL_QUANTITIES_SET = CASUAL_QUANTITIES_SET
#     SIZE_MODIFIERS_SET = SIZE_MODIFIERS_SET

#     # Misc. Sets
#     PREP_WORDS = PREP_WORDS
#     APPROXIMATE_STRINGS = APPROXIMATE_STRINGS
#     UNIT_MODIFIERS = UNIT_MODIFIERS
    
#     # generic stop words for parsing 
#     STOP_WORDS = STOP_WORDS

#     # food catalog and food categories
#     FOOD_CATALOG = FOOD_CATALOG
#     FOOD_CATEGORIES = FOOD_CATEGORIES
