# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['KeyTransactionArgs', 'KeyTransaction']

@pulumi.input_type
class KeyTransactionArgs:
    def __init__(__self__, *,
                 apdex_index: pulumi.Input[_builtins.float],
                 application_guid: pulumi.Input[_builtins.str],
                 browser_apdex_target: pulumi.Input[_builtins.float],
                 metric_name: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a KeyTransaction resource.
        :param pulumi.Input[_builtins.float] apdex_index: A decimal value, measuring user satisfaction with response times, ranging from 0 (frustrated) to 1 (satisfied).
        :param pulumi.Input[_builtins.str] application_guid: The GUID of the APM Application comprising transactions, of which one would be made a key transaction.
        :param pulumi.Input[_builtins.float] browser_apdex_target: A decimal value representing the response time threshold for satisfactory experience (e.g., 0.5 seconds).
               
               > **NOTE:** It may be noted that the `metric_name` and `application_guid` of a Key Transaction _cannot_ be updated in a key transaction that has already been created; since this is not supported. As a consequence, altering the values of `application_guid` and/or `metric_name` of a `KeyTransaction` resource created (to try updating these values) would result in `pulumi preview` prompting a forced destruction and re-creation of the resource.
        :param pulumi.Input[_builtins.str] metric_name: The name of the underlying metric monitored by the key transaction to be created.
        :param pulumi.Input[_builtins.str] name: The name of the key transaction.
        """
        pulumi.set(__self__, "apdex_index", apdex_index)
        pulumi.set(__self__, "application_guid", application_guid)
        pulumi.set(__self__, "browser_apdex_target", browser_apdex_target)
        pulumi.set(__self__, "metric_name", metric_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="apdexIndex")
    def apdex_index(self) -> pulumi.Input[_builtins.float]:
        """
        A decimal value, measuring user satisfaction with response times, ranging from 0 (frustrated) to 1 (satisfied).
        """
        return pulumi.get(self, "apdex_index")

    @apdex_index.setter
    def apdex_index(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "apdex_index", value)

    @_builtins.property
    @pulumi.getter(name="applicationGuid")
    def application_guid(self) -> pulumi.Input[_builtins.str]:
        """
        The GUID of the APM Application comprising transactions, of which one would be made a key transaction.
        """
        return pulumi.get(self, "application_guid")

    @application_guid.setter
    def application_guid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_guid", value)

    @_builtins.property
    @pulumi.getter(name="browserApdexTarget")
    def browser_apdex_target(self) -> pulumi.Input[_builtins.float]:
        """
        A decimal value representing the response time threshold for satisfactory experience (e.g., 0.5 seconds).

        > **NOTE:** It may be noted that the `metric_name` and `application_guid` of a Key Transaction _cannot_ be updated in a key transaction that has already been created; since this is not supported. As a consequence, altering the values of `application_guid` and/or `metric_name` of a `KeyTransaction` resource created (to try updating these values) would result in `pulumi preview` prompting a forced destruction and re-creation of the resource.
        """
        return pulumi.get(self, "browser_apdex_target")

    @browser_apdex_target.setter
    def browser_apdex_target(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "browser_apdex_target", value)

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the underlying metric monitored by the key transaction to be created.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "metric_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the key transaction.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _KeyTransactionState:
    def __init__(__self__, *,
                 apdex_index: Optional[pulumi.Input[_builtins.float]] = None,
                 application_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 browser_apdex_target: Optional[pulumi.Input[_builtins.float]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KeyTransaction resources.
        :param pulumi.Input[_builtins.float] apdex_index: A decimal value, measuring user satisfaction with response times, ranging from 0 (frustrated) to 1 (satisfied).
        :param pulumi.Input[_builtins.str] application_guid: The GUID of the APM Application comprising transactions, of which one would be made a key transaction.
        :param pulumi.Input[_builtins.float] browser_apdex_target: A decimal value representing the response time threshold for satisfactory experience (e.g., 0.5 seconds).
               
               > **NOTE:** It may be noted that the `metric_name` and `application_guid` of a Key Transaction _cannot_ be updated in a key transaction that has already been created; since this is not supported. As a consequence, altering the values of `application_guid` and/or `metric_name` of a `KeyTransaction` resource created (to try updating these values) would result in `pulumi preview` prompting a forced destruction and re-creation of the resource.
        :param pulumi.Input[_builtins.str] domain: The domain of the entity monitored by the key transaction.
        :param pulumi.Input[_builtins.str] metric_name: The name of the underlying metric monitored by the key transaction to be created.
        :param pulumi.Input[_builtins.str] name: The name of the key transaction.
        :param pulumi.Input[_builtins.str] type: The type of the entity monitored by the key transaction.
        """
        if apdex_index is not None:
            pulumi.set(__self__, "apdex_index", apdex_index)
        if application_guid is not None:
            pulumi.set(__self__, "application_guid", application_guid)
        if browser_apdex_target is not None:
            pulumi.set(__self__, "browser_apdex_target", browser_apdex_target)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="apdexIndex")
    def apdex_index(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        A decimal value, measuring user satisfaction with response times, ranging from 0 (frustrated) to 1 (satisfied).
        """
        return pulumi.get(self, "apdex_index")

    @apdex_index.setter
    def apdex_index(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "apdex_index", value)

    @_builtins.property
    @pulumi.getter(name="applicationGuid")
    def application_guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GUID of the APM Application comprising transactions, of which one would be made a key transaction.
        """
        return pulumi.get(self, "application_guid")

    @application_guid.setter
    def application_guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_guid", value)

    @_builtins.property
    @pulumi.getter(name="browserApdexTarget")
    def browser_apdex_target(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        A decimal value representing the response time threshold for satisfactory experience (e.g., 0.5 seconds).

        > **NOTE:** It may be noted that the `metric_name` and `application_guid` of a Key Transaction _cannot_ be updated in a key transaction that has already been created; since this is not supported. As a consequence, altering the values of `application_guid` and/or `metric_name` of a `KeyTransaction` resource created (to try updating these values) would result in `pulumi preview` prompting a forced destruction and re-creation of the resource.
        """
        return pulumi.get(self, "browser_apdex_target")

    @browser_apdex_target.setter
    def browser_apdex_target(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "browser_apdex_target", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain of the entity monitored by the key transaction.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the underlying metric monitored by the key transaction to be created.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the key transaction.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the entity monitored by the key transaction.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("newrelic:index/keyTransaction:KeyTransaction")
class KeyTransaction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apdex_index: Optional[pulumi.Input[_builtins.float]] = None,
                 application_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 browser_apdex_target: Optional[pulumi.Input[_builtins.float]] = None,
                 metric_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Use this resource to create a new Key Transaction in New Relic.

        > **NOTE:** For more information on Key Transactions, head over to [this page](https://docs.newrelic.com/docs/apm/transactions/key-transactions/introduction-key-transactions/) in New Relic's docs.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.KeyTransaction("foo",
            application_guid="MzgfNjUyNnxBUE19QVBQTElDQVHJT068NTUfNDT4MjUy",
            apdex_index=0.5,
            browser_apdex_target=0.5,
            metric_name="WebTransaction/Function/__main__:foo_bar",
            name="Sample Key Transaction")
        ```

        ## Import

        A Key Transaction in New Relic may be imported into Terraform using its GUID specified in the `<id>` field, in the following command.

        bash

        ```sh
        $ pulumi import newrelic:index/keyTransaction:KeyTransaction foo <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.float] apdex_index: A decimal value, measuring user satisfaction with response times, ranging from 0 (frustrated) to 1 (satisfied).
        :param pulumi.Input[_builtins.str] application_guid: The GUID of the APM Application comprising transactions, of which one would be made a key transaction.
        :param pulumi.Input[_builtins.float] browser_apdex_target: A decimal value representing the response time threshold for satisfactory experience (e.g., 0.5 seconds).
               
               > **NOTE:** It may be noted that the `metric_name` and `application_guid` of a Key Transaction _cannot_ be updated in a key transaction that has already been created; since this is not supported. As a consequence, altering the values of `application_guid` and/or `metric_name` of a `KeyTransaction` resource created (to try updating these values) would result in `pulumi preview` prompting a forced destruction and re-creation of the resource.
        :param pulumi.Input[_builtins.str] metric_name: The name of the underlying metric monitored by the key transaction to be created.
        :param pulumi.Input[_builtins.str] name: The name of the key transaction.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeyTransactionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to create a new Key Transaction in New Relic.

        > **NOTE:** For more information on Key Transactions, head over to [this page](https://docs.newrelic.com/docs/apm/transactions/key-transactions/introduction-key-transactions/) in New Relic's docs.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.KeyTransaction("foo",
            application_guid="MzgfNjUyNnxBUE19QVBQTElDQVHJT068NTUfNDT4MjUy",
            apdex_index=0.5,
            browser_apdex_target=0.5,
            metric_name="WebTransaction/Function/__main__:foo_bar",
            name="Sample Key Transaction")
        ```

        ## Import

        A Key Transaction in New Relic may be imported into Terraform using its GUID specified in the `<id>` field, in the following command.

        bash

        ```sh
        $ pulumi import newrelic:index/keyTransaction:KeyTransaction foo <id>
        ```

        :param str resource_name: The name of the resource.
        :param KeyTransactionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyTransactionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apdex_index: Optional[pulumi.Input[_builtins.float]] = None,
                 application_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 browser_apdex_target: Optional[pulumi.Input[_builtins.float]] = None,
                 metric_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyTransactionArgs.__new__(KeyTransactionArgs)

            if apdex_index is None and not opts.urn:
                raise TypeError("Missing required property 'apdex_index'")
            __props__.__dict__["apdex_index"] = apdex_index
            if application_guid is None and not opts.urn:
                raise TypeError("Missing required property 'application_guid'")
            __props__.__dict__["application_guid"] = application_guid
            if browser_apdex_target is None and not opts.urn:
                raise TypeError("Missing required property 'browser_apdex_target'")
            __props__.__dict__["browser_apdex_target"] = browser_apdex_target
            if metric_name is None and not opts.urn:
                raise TypeError("Missing required property 'metric_name'")
            __props__.__dict__["metric_name"] = metric_name
            __props__.__dict__["name"] = name
            __props__.__dict__["domain"] = None
            __props__.__dict__["type"] = None
        super(KeyTransaction, __self__).__init__(
            'newrelic:index/keyTransaction:KeyTransaction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apdex_index: Optional[pulumi.Input[_builtins.float]] = None,
            application_guid: Optional[pulumi.Input[_builtins.str]] = None,
            browser_apdex_target: Optional[pulumi.Input[_builtins.float]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            metric_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'KeyTransaction':
        """
        Get an existing KeyTransaction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.float] apdex_index: A decimal value, measuring user satisfaction with response times, ranging from 0 (frustrated) to 1 (satisfied).
        :param pulumi.Input[_builtins.str] application_guid: The GUID of the APM Application comprising transactions, of which one would be made a key transaction.
        :param pulumi.Input[_builtins.float] browser_apdex_target: A decimal value representing the response time threshold for satisfactory experience (e.g., 0.5 seconds).
               
               > **NOTE:** It may be noted that the `metric_name` and `application_guid` of a Key Transaction _cannot_ be updated in a key transaction that has already been created; since this is not supported. As a consequence, altering the values of `application_guid` and/or `metric_name` of a `KeyTransaction` resource created (to try updating these values) would result in `pulumi preview` prompting a forced destruction and re-creation of the resource.
        :param pulumi.Input[_builtins.str] domain: The domain of the entity monitored by the key transaction.
        :param pulumi.Input[_builtins.str] metric_name: The name of the underlying metric monitored by the key transaction to be created.
        :param pulumi.Input[_builtins.str] name: The name of the key transaction.
        :param pulumi.Input[_builtins.str] type: The type of the entity monitored by the key transaction.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyTransactionState.__new__(_KeyTransactionState)

        __props__.__dict__["apdex_index"] = apdex_index
        __props__.__dict__["application_guid"] = application_guid
        __props__.__dict__["browser_apdex_target"] = browser_apdex_target
        __props__.__dict__["domain"] = domain
        __props__.__dict__["metric_name"] = metric_name
        __props__.__dict__["name"] = name
        __props__.__dict__["type"] = type
        return KeyTransaction(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apdexIndex")
    def apdex_index(self) -> pulumi.Output[_builtins.float]:
        """
        A decimal value, measuring user satisfaction with response times, ranging from 0 (frustrated) to 1 (satisfied).
        """
        return pulumi.get(self, "apdex_index")

    @_builtins.property
    @pulumi.getter(name="applicationGuid")
    def application_guid(self) -> pulumi.Output[_builtins.str]:
        """
        The GUID of the APM Application comprising transactions, of which one would be made a key transaction.
        """
        return pulumi.get(self, "application_guid")

    @_builtins.property
    @pulumi.getter(name="browserApdexTarget")
    def browser_apdex_target(self) -> pulumi.Output[_builtins.float]:
        """
        A decimal value representing the response time threshold for satisfactory experience (e.g., 0.5 seconds).

        > **NOTE:** It may be noted that the `metric_name` and `application_guid` of a Key Transaction _cannot_ be updated in a key transaction that has already been created; since this is not supported. As a consequence, altering the values of `application_guid` and/or `metric_name` of a `KeyTransaction` resource created (to try updating these values) would result in `pulumi preview` prompting a forced destruction and re-creation of the resource.
        """
        return pulumi.get(self, "browser_apdex_target")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        The domain of the entity monitored by the key transaction.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the underlying metric monitored by the key transaction to be created.
        """
        return pulumi.get(self, "metric_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the key transaction.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the entity monitored by the key transaction.
        """
        return pulumi.get(self, "type")

