# 🧠 Synapse SDK

![lint workflow](https://github.com/datamaker-kr/synapse-sdk/actions/workflows/lint.yml/badge.svg)
![test workflow](https://github.com/datamaker-kr/synapse-sdk/actions/workflows/test.yml/badge.svg)

A Python SDK for building and managing ML plugins, data annotation workflows, and AI agents.

## ✨ Features

- **🔌 Plugin System**: Create and manage ML plugins with categories like neural networks, data validation, and export tools
- **🤖 Agent Management**: Backend and Ray-based agent clients for distributed AI workflows  
- **🔄 Data Converters**: Convert between formats (COCO, Pascal VOC, YOLO) and annotation schemas
- **🛠️ Development Tools**: Interactive web dashboard for monitoring and debugging
- **⚡ CLI Interface**: Command-line tool for configuration, plugin management, and development

## 🚀 Quick Start

```bash
pip install synapse-sdk
synapse --help
```

## 📚 Documentation

*Docs [https://docs.synapse.sh](https://docs.synapse.sh)*
