---
id: introduction
title: Introduction
sidebar_position: 1
---

# Synapse SDK

Build ML and data processing plugins.

## Overview

Synapse SDK is..

### Key Features

- **🚀 Plugin Development and Testing**: Develop modular, reusable components organized by categories for Synapse
- **⚡ Distributed Computing**: Built on Ray for scalable, distributed execution
- **🔧 Multiple Execution Modes**: Support for Jobs, Tasks, and REST APIs
- **📦 Isolated Runtime Environments**: Each plugin runs in its own environment with dependency management
- **📊 Progress Tracking**: Built-in progress monitoring and metrics reporting

### Plugin Categories

The SDK organizes plugins into specific categories:

1. **Neural Network** (`NEURAL_NET`): ML model training, inference, and deployment
2. **Export** (`EXPORT`): Data export and transformation operations
3. **Upload** (`UPLOAD`): File and data upload functionality
4. **Smart Tools** (`SMART_TOOL`): Intelligent automation tools
5. **Post-Annotation** (`POST_ANNOTATION`): Post-processing after data annotation
6. **Pre-Annotation** (`PRE_ANNOTATION`): Pre-processing before data annotation
7. **Data Validation** (`DATA_VALIDATION`): Data quality and validation checks

## Getting Started

To get started with the Synapse SDK:

1. [Install the SDK](./installation.md)
2. [Follow the Quickstart Guide](./quickstart.md)
3. [Explore the API Reference](./api/index.md)
4. [Check out Examples](./examples/index.md)

## Next Steps

- Learn about [Core Concepts](./concepts/index.md)
- Configure [Backend Connection](./configuration.md)
