import type {SidebarsConfig} from '@docusaurus/plugin-content-docs';

// This runs in Node.js - Don't use client-side code here (browser APIs, JSX...)

/**
 * Creating a sidebar enables you to:
 - create an ordered group of docs
 - render a sidebar for each doc of that group
 - provide next/previous navigation

 The sidebars can be generated from the filesystem, or explicitly defined here.

 Create as many sidebars as you want.
 */
const sidebars: SidebarsConfig = {
  tutorialSidebar: [
    'introduction',
    'installation', 
    'quickstart',
    {
      type: 'category',
      label: 'Features',
      items: [
        'features/features',
        'features/converters/converters',
      ],
    },
    {
      type: 'category',
      label: 'API Reference',
      items: [
        'api/index',
        'api/clients/backend',
      ],
    },
    'configuration',
    'troubleshooting',
    'faq',
    'changelog',
    'contributing',
  ],
};

export default sidebars;
