# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.create_new_sheet_tab_response import CreateNewSheetTabResponse
from ...types.get_table_response import GetTableResponse
from ...types.sheet_operation_response import SheetOperationResponse
from .types.insert_table_row_request_row_data_item_value import InsertTableRowRequestRowDataItemValue

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawSheetsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def update_cell(
        self,
        *,
        asset_id: str,
        column: int,
        row: int,
        value: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SheetOperationResponse]:
        """
        Update a single cell in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        column : int
            1-based column index (e.g., 1 = column A)

        row : int
            1-based row index (e.g., 1 = first row)

        value : str
            Value to set in the cell

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/cell/update",
            method="POST",
            json={
                "asset_id": asset_id,
                "column": column,
                "row": row,
                "sheet_id": sheet_id,
                "value": value,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_cells(
        self,
        *,
        asset_id: str,
        end_column_index: int,
        end_row_index: int,
        start_column_index: int,
        start_row_index: int,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SheetOperationResponse]:
        """
        Delete cells from an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column_index : int
            1-based ending column index

        end_row_index : int
            1-based ending row index

        start_column_index : int
            1-based starting column index

        start_row_index : int
            1-based starting row index

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/cells/delete",
            method="POST",
            json={
                "asset_id": asset_id,
                "end_column_index": end_column_index,
                "end_row_index": end_row_index,
                "sheet_id": sheet_id,
                "start_column_index": start_column_index,
                "start_row_index": start_row_index,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_column(
        self,
        *,
        asset_id: str,
        column_indexes: typing.Sequence[int],
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SheetOperationResponse]:
        """
        Delete columns from an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        column_indexes : typing.Sequence[int]
            List of 1-based column indexes to delete

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/column/delete",
            method="POST",
            json={
                "asset_id": asset_id,
                "column_indexes": column_indexes,
                "sheet_id": sheet_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def insert_column(
        self,
        *,
        asset_id: str,
        reference_column_index: int,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SheetOperationResponse]:
        """
        Insert a column in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        reference_column_index : int
            1-based reference column index where to insert

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/column/insert",
            method="POST",
            json={
                "asset_id": asset_id,
                "reference_column_index": reference_column_index,
                "sheet_id": sheet_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def clear_formatting(
        self,
        *,
        asset_id: str,
        end_column_index: int,
        end_row_index: int,
        start_column_index: int,
        start_row_index: int,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SheetOperationResponse]:
        """
        Clear formatting from cells in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column_index : int
            1-based ending column index

        end_row_index : int
            1-based ending row index

        start_column_index : int
            1-based starting column index

        start_row_index : int
            1-based starting row index

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/formatting/clear",
            method="POST",
            json={
                "asset_id": asset_id,
                "end_column_index": end_column_index,
                "end_row_index": end_row_index,
                "sheet_id": sheet_id,
                "start_column_index": start_column_index,
                "start_row_index": start_row_index,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def clear_range(
        self,
        *,
        asset_id: str,
        num_columns: int,
        num_rows: int,
        start_column: int,
        start_row: int,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SheetOperationResponse]:
        """
        Clear a range of cells in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        num_columns : int
            Number of columns to clear

        num_rows : int
            Number of rows to clear

        start_column : int
            1-based starting column index

        start_row : int
            1-based starting row index

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/range/clear",
            method="POST",
            json={
                "asset_id": asset_id,
                "num_columns": num_columns,
                "num_rows": num_rows,
                "sheet_id": sheet_id,
                "start_column": start_column,
                "start_row": start_row,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def format_range(
        self,
        *,
        asset_id: str,
        end_column: int,
        end_row: int,
        start_column: int,
        start_row: int,
        type: str,
        value_json: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SheetOperationResponse]:
        """
        Apply formatting to a range of cells in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column : int
            1-based ending column index

        end_row : int
            1-based ending row index

        start_column : int
            1-based starting column index

        start_row : int
            1-based starting row index

        type : str
            Formatting type (e.g. backgroundColor, textFormat, borders, etc.)

        value_json : str
            JSON string for value param (e.g. '"#FF0000"' or '{"fontSize":12}')

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/range/format",
            method="POST",
            json={
                "asset_id": asset_id,
                "end_column": end_column,
                "end_row": end_row,
                "sheet_id": sheet_id,
                "start_column": start_column,
                "start_row": start_row,
                "type": type,
                "value_json": value_json,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_range(
        self,
        *,
        asset_id: str,
        start_column: int,
        start_row: int,
        values: typing.Sequence[str],
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SheetOperationResponse]:
        """
        Update a range of cells in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        start_column : int
            1-based starting column index

        start_row : int
            1-based starting row index

        values : typing.Sequence[str]
            List of pipe-separated strings representing rows (e.g. ['A1|B1|C1', 'A2|B2|C2'])

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/range/update",
            method="POST",
            json={
                "asset_id": asset_id,
                "sheet_id": sheet_id,
                "start_column": start_column,
                "start_row": start_row,
                "values": values,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def insert_row(
        self,
        *,
        asset_id: str,
        reference_row_index: int,
        num_rows: typing.Optional[int] = OMIT,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SheetOperationResponse]:
        """
        Insert a row in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        reference_row_index : int
            1-based reference row index where to insert

        num_rows : typing.Optional[int]
            Number of rows to insert

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/row/insert",
            method="POST",
            json={
                "asset_id": asset_id,
                "num_rows": num_rows,
                "reference_row_index": reference_row_index,
                "sheet_id": sheet_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def duplicate_sheet(
        self,
        *,
        asset_id: str,
        new_sheet_id: typing.Optional[int] = OMIT,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SheetOperationResponse]:
        """
        Duplicate an existing sheet in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        new_sheet_id : typing.Optional[int]
            New sheet ID for the duplicated sheet (auto-generated if not provided)

        sheet_id : typing.Optional[int]
            Sheet ID to duplicate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/sheet/duplicate",
            method="POST",
            json={
                "asset_id": asset_id,
                "new_sheet_id": new_sheet_id,
                "sheet_id": sheet_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_tab(
        self,
        *,
        asset_id: str,
        sheet_id: int,
        title: str,
        active_sheet_id: typing.Optional[int] = OMIT,
        tab_color: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CreateNewSheetTabResponse]:
        """
        Create a new tab in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        sheet_id : int
            Sheet ID of the new tab

        title : str
            Title of the new tab

        active_sheet_id : typing.Optional[int]
            Currently active sheet ID

        tab_color : typing.Optional[str]
            Optional color of the new tab

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateNewSheetTabResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/tab/create",
            method="POST",
            json={
                "active_sheet_id": active_sheet_id,
                "asset_id": asset_id,
                "sheet_id": sheet_id,
                "tab_color": tab_color,
                "title": title,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateNewSheetTabResponse,
                    parse_obj_as(
                        type_=CreateNewSheetTabResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_table_column(
        self,
        *,
        asset_id: str,
        dimension_index: int,
        table_id: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SheetOperationResponse]:
        """
        Delete a column from a table within an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        dimension_index : int
            0-based dimension index within the table

        table_id : str
            Table ID where to delete column

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/table/column/delete",
            method="POST",
            json={
                "asset_id": asset_id,
                "dimension_index": dimension_index,
                "sheet_id": sheet_id,
                "table_id": table_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def insert_table_column(
        self,
        *,
        asset_id: str,
        dimension_index: int,
        direction: str,
        table_id: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SheetOperationResponse]:
        """
        Insert a column in a table within an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        dimension_index : int
            0-based dimension index within the table

        direction : str
            Direction of insertion (left or right)

        table_id : str
            Table ID where to insert column

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/table/column/insert",
            method="POST",
            json={
                "asset_id": asset_id,
                "dimension_index": dimension_index,
                "direction": direction,
                "sheet_id": sheet_id,
                "table_id": table_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_table(
        self,
        *,
        asset_id: str,
        end_column_index: int,
        end_row_index: int,
        start_column_index: int,
        start_row_index: int,
        table_id: str,
        table_name: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SheetOperationResponse]:
        """
        Create a table in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column_index : int
            1-based ending column index

        end_row_index : int
            1-based ending row index

        start_column_index : int
            1-based starting column index

        start_row_index : int
            1-based starting row index

        table_id : str
            Unique table ID

        table_name : str
            Name of the table

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/table/create",
            method="POST",
            json={
                "asset_id": asset_id,
                "end_column_index": end_column_index,
                "end_row_index": end_row_index,
                "sheet_id": sheet_id,
                "start_column_index": start_column_index,
                "start_row_index": start_row_index,
                "table_id": table_id,
                "table_name": table_name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_table(
        self,
        *,
        asset_id: str,
        table_name: str,
        table_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetTableResponse]:
        """
        Retrieve table data from an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        table_name : str
            Table name to retrieve

        table_id : typing.Optional[str]
            Table ID to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetTableResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/table/get",
            method="POST",
            json={
                "asset_id": asset_id,
                "table_id": table_id,
                "table_name": table_name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTableResponse,
                    parse_obj_as(
                        type_=GetTableResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def insert_table_row(
        self,
        *,
        asset_id: str,
        row_data: typing.Sequence[typing.Dict[str, typing.Optional[InsertTableRowRequestRowDataItemValue]]],
        table_name: str,
        table_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SheetOperationResponse]:
        """
        Insert rows into a table in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        row_data : typing.Sequence[typing.Dict[str, typing.Optional[InsertTableRowRequestRowDataItemValue]]]
            Array of row objects where keys are column names and values are cell values

        table_name : str
            Table name to insert row into

        table_id : typing.Optional[str]
            Table ID to insert row into

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/table/insert-row",
            method="POST",
            json={
                "asset_id": asset_id,
                "row_data": convert_and_respect_annotation_metadata(
                    object_=row_data,
                    annotation=typing.Sequence[
                        typing.Dict[str, typing.Optional[InsertTableRowRequestRowDataItemValue]]
                    ],
                    direction="write",
                ),
                "table_id": table_id,
                "table_name": table_name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_table(
        self,
        *,
        asset_id: str,
        end_column_index: int,
        end_row_index: int,
        start_column_index: int,
        start_row_index: int,
        table_id: str,
        table_name: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SheetOperationResponse]:
        """
        Update an existing table in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column_index : int
            1-based ending column index

        end_row_index : int
            1-based ending row index

        start_column_index : int
            1-based starting column index

        start_row_index : int
            1-based starting row index

        table_id : str
            Table ID to update

        table_name : str
            Name of the table

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/table/update",
            method="POST",
            json={
                "asset_id": asset_id,
                "end_column_index": end_column_index,
                "end_row_index": end_row_index,
                "sheet_id": sheet_id,
                "start_column_index": start_column_index,
                "start_row_index": start_row_index,
                "table_id": table_id,
                "table_name": table_name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawSheetsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def update_cell(
        self,
        *,
        asset_id: str,
        column: int,
        row: int,
        value: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SheetOperationResponse]:
        """
        Update a single cell in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        column : int
            1-based column index (e.g., 1 = column A)

        row : int
            1-based row index (e.g., 1 = first row)

        value : str
            Value to set in the cell

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/cell/update",
            method="POST",
            json={
                "asset_id": asset_id,
                "column": column,
                "row": row,
                "sheet_id": sheet_id,
                "value": value,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_cells(
        self,
        *,
        asset_id: str,
        end_column_index: int,
        end_row_index: int,
        start_column_index: int,
        start_row_index: int,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SheetOperationResponse]:
        """
        Delete cells from an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column_index : int
            1-based ending column index

        end_row_index : int
            1-based ending row index

        start_column_index : int
            1-based starting column index

        start_row_index : int
            1-based starting row index

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/cells/delete",
            method="POST",
            json={
                "asset_id": asset_id,
                "end_column_index": end_column_index,
                "end_row_index": end_row_index,
                "sheet_id": sheet_id,
                "start_column_index": start_column_index,
                "start_row_index": start_row_index,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_column(
        self,
        *,
        asset_id: str,
        column_indexes: typing.Sequence[int],
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SheetOperationResponse]:
        """
        Delete columns from an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        column_indexes : typing.Sequence[int]
            List of 1-based column indexes to delete

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/column/delete",
            method="POST",
            json={
                "asset_id": asset_id,
                "column_indexes": column_indexes,
                "sheet_id": sheet_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def insert_column(
        self,
        *,
        asset_id: str,
        reference_column_index: int,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SheetOperationResponse]:
        """
        Insert a column in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        reference_column_index : int
            1-based reference column index where to insert

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/column/insert",
            method="POST",
            json={
                "asset_id": asset_id,
                "reference_column_index": reference_column_index,
                "sheet_id": sheet_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def clear_formatting(
        self,
        *,
        asset_id: str,
        end_column_index: int,
        end_row_index: int,
        start_column_index: int,
        start_row_index: int,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SheetOperationResponse]:
        """
        Clear formatting from cells in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column_index : int
            1-based ending column index

        end_row_index : int
            1-based ending row index

        start_column_index : int
            1-based starting column index

        start_row_index : int
            1-based starting row index

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/formatting/clear",
            method="POST",
            json={
                "asset_id": asset_id,
                "end_column_index": end_column_index,
                "end_row_index": end_row_index,
                "sheet_id": sheet_id,
                "start_column_index": start_column_index,
                "start_row_index": start_row_index,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def clear_range(
        self,
        *,
        asset_id: str,
        num_columns: int,
        num_rows: int,
        start_column: int,
        start_row: int,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SheetOperationResponse]:
        """
        Clear a range of cells in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        num_columns : int
            Number of columns to clear

        num_rows : int
            Number of rows to clear

        start_column : int
            1-based starting column index

        start_row : int
            1-based starting row index

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/range/clear",
            method="POST",
            json={
                "asset_id": asset_id,
                "num_columns": num_columns,
                "num_rows": num_rows,
                "sheet_id": sheet_id,
                "start_column": start_column,
                "start_row": start_row,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def format_range(
        self,
        *,
        asset_id: str,
        end_column: int,
        end_row: int,
        start_column: int,
        start_row: int,
        type: str,
        value_json: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SheetOperationResponse]:
        """
        Apply formatting to a range of cells in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column : int
            1-based ending column index

        end_row : int
            1-based ending row index

        start_column : int
            1-based starting column index

        start_row : int
            1-based starting row index

        type : str
            Formatting type (e.g. backgroundColor, textFormat, borders, etc.)

        value_json : str
            JSON string for value param (e.g. '"#FF0000"' or '{"fontSize":12}')

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/range/format",
            method="POST",
            json={
                "asset_id": asset_id,
                "end_column": end_column,
                "end_row": end_row,
                "sheet_id": sheet_id,
                "start_column": start_column,
                "start_row": start_row,
                "type": type,
                "value_json": value_json,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_range(
        self,
        *,
        asset_id: str,
        start_column: int,
        start_row: int,
        values: typing.Sequence[str],
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SheetOperationResponse]:
        """
        Update a range of cells in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        start_column : int
            1-based starting column index

        start_row : int
            1-based starting row index

        values : typing.Sequence[str]
            List of pipe-separated strings representing rows (e.g. ['A1|B1|C1', 'A2|B2|C2'])

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/range/update",
            method="POST",
            json={
                "asset_id": asset_id,
                "sheet_id": sheet_id,
                "start_column": start_column,
                "start_row": start_row,
                "values": values,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def insert_row(
        self,
        *,
        asset_id: str,
        reference_row_index: int,
        num_rows: typing.Optional[int] = OMIT,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SheetOperationResponse]:
        """
        Insert a row in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        reference_row_index : int
            1-based reference row index where to insert

        num_rows : typing.Optional[int]
            Number of rows to insert

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/row/insert",
            method="POST",
            json={
                "asset_id": asset_id,
                "num_rows": num_rows,
                "reference_row_index": reference_row_index,
                "sheet_id": sheet_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def duplicate_sheet(
        self,
        *,
        asset_id: str,
        new_sheet_id: typing.Optional[int] = OMIT,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SheetOperationResponse]:
        """
        Duplicate an existing sheet in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        new_sheet_id : typing.Optional[int]
            New sheet ID for the duplicated sheet (auto-generated if not provided)

        sheet_id : typing.Optional[int]
            Sheet ID to duplicate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/sheet/duplicate",
            method="POST",
            json={
                "asset_id": asset_id,
                "new_sheet_id": new_sheet_id,
                "sheet_id": sheet_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_tab(
        self,
        *,
        asset_id: str,
        sheet_id: int,
        title: str,
        active_sheet_id: typing.Optional[int] = OMIT,
        tab_color: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CreateNewSheetTabResponse]:
        """
        Create a new tab in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        sheet_id : int
            Sheet ID of the new tab

        title : str
            Title of the new tab

        active_sheet_id : typing.Optional[int]
            Currently active sheet ID

        tab_color : typing.Optional[str]
            Optional color of the new tab

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateNewSheetTabResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/tab/create",
            method="POST",
            json={
                "active_sheet_id": active_sheet_id,
                "asset_id": asset_id,
                "sheet_id": sheet_id,
                "tab_color": tab_color,
                "title": title,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateNewSheetTabResponse,
                    parse_obj_as(
                        type_=CreateNewSheetTabResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_table_column(
        self,
        *,
        asset_id: str,
        dimension_index: int,
        table_id: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SheetOperationResponse]:
        """
        Delete a column from a table within an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        dimension_index : int
            0-based dimension index within the table

        table_id : str
            Table ID where to delete column

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/table/column/delete",
            method="POST",
            json={
                "asset_id": asset_id,
                "dimension_index": dimension_index,
                "sheet_id": sheet_id,
                "table_id": table_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def insert_table_column(
        self,
        *,
        asset_id: str,
        dimension_index: int,
        direction: str,
        table_id: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SheetOperationResponse]:
        """
        Insert a column in a table within an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        dimension_index : int
            0-based dimension index within the table

        direction : str
            Direction of insertion (left or right)

        table_id : str
            Table ID where to insert column

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/table/column/insert",
            method="POST",
            json={
                "asset_id": asset_id,
                "dimension_index": dimension_index,
                "direction": direction,
                "sheet_id": sheet_id,
                "table_id": table_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_table(
        self,
        *,
        asset_id: str,
        end_column_index: int,
        end_row_index: int,
        start_column_index: int,
        start_row_index: int,
        table_id: str,
        table_name: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SheetOperationResponse]:
        """
        Create a table in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column_index : int
            1-based ending column index

        end_row_index : int
            1-based ending row index

        start_column_index : int
            1-based starting column index

        start_row_index : int
            1-based starting row index

        table_id : str
            Unique table ID

        table_name : str
            Name of the table

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/table/create",
            method="POST",
            json={
                "asset_id": asset_id,
                "end_column_index": end_column_index,
                "end_row_index": end_row_index,
                "sheet_id": sheet_id,
                "start_column_index": start_column_index,
                "start_row_index": start_row_index,
                "table_id": table_id,
                "table_name": table_name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_table(
        self,
        *,
        asset_id: str,
        table_name: str,
        table_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetTableResponse]:
        """
        Retrieve table data from an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        table_name : str
            Table name to retrieve

        table_id : typing.Optional[str]
            Table ID to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetTableResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/table/get",
            method="POST",
            json={
                "asset_id": asset_id,
                "table_id": table_id,
                "table_name": table_name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTableResponse,
                    parse_obj_as(
                        type_=GetTableResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def insert_table_row(
        self,
        *,
        asset_id: str,
        row_data: typing.Sequence[typing.Dict[str, typing.Optional[InsertTableRowRequestRowDataItemValue]]],
        table_name: str,
        table_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SheetOperationResponse]:
        """
        Insert rows into a table in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        row_data : typing.Sequence[typing.Dict[str, typing.Optional[InsertTableRowRequestRowDataItemValue]]]
            Array of row objects where keys are column names and values are cell values

        table_name : str
            Table name to insert row into

        table_id : typing.Optional[str]
            Table ID to insert row into

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/table/insert-row",
            method="POST",
            json={
                "asset_id": asset_id,
                "row_data": convert_and_respect_annotation_metadata(
                    object_=row_data,
                    annotation=typing.Sequence[
                        typing.Dict[str, typing.Optional[InsertTableRowRequestRowDataItemValue]]
                    ],
                    direction="write",
                ),
                "table_id": table_id,
                "table_name": table_name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_table(
        self,
        *,
        asset_id: str,
        end_column_index: int,
        end_row_index: int,
        start_column_index: int,
        start_row_index: int,
        table_id: str,
        table_name: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SheetOperationResponse]:
        """
        Update an existing table in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column_index : int
            1-based ending column index

        end_row_index : int
            1-based ending row index

        start_column_index : int
            1-based starting column index

        start_row_index : int
            1-based starting row index

        table_id : str
            Table ID to update

        table_name : str
            Name of the table

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SheetOperationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v0/tools/sheets/table/update",
            method="POST",
            json={
                "asset_id": asset_id,
                "end_column_index": end_column_index,
                "end_row_index": end_row_index,
                "sheet_id": sheet_id,
                "start_column_index": start_column_index,
                "start_row_index": start_row_index,
                "table_id": table_id,
                "table_name": table_name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SheetOperationResponse,
                    parse_obj_as(
                        type_=SheetOperationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
