# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class AopExecuteResponseOut(UniversalBaseModel):
    """
    Response model for AOP execution.
    """

    aop_asset_id: str = pydantic.Field()
    """
    ID of the AOP asset that was executed
    """

    aop_config: typing.Dict[str, typing.Optional[typing.Any]] = pydantic.Field()
    """
    Full configuration of the AOP asset
    """

    aop_title: str = pydantic.Field()
    """
    Title of the AOP asset
    """

    base_prompt: str = pydantic.Field()
    """
    Base prompt of the AOP before user inputs were added
    """

    enabled_tools: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of tools that were enabled for this execution
    """

    final_prompt: str = pydantic.Field()
    """
    Final prompt used for execution including user inputs
    """

    response: typing.Dict[str, typing.Optional[typing.Any]] = pydantic.Field()
    """
    The execution response from the AOP
    """

    status: str = pydantic.Field()
    """
    Status of the execution (e.g., 'submitted')
    """

    sync_server: str = pydantic.Field()
    """
    Sync server URL used for execution
    """

    thread_id: str = pydantic.Field()
    """
    Unique thread ID for tracking the execution
    """

    trigger_type: str = pydantic.Field()
    """
    Type of trigger that initiated the execution
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
