# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'ComputeClusterHostImageArgs',
    'ComputeClusterHostImageComponentArgs',
    'ComputeClusterVsanDiskGroupArgs',
    'ComputeClusterVsanFaultDomainArgs',
    'ComputeClusterVsanFaultDomainFaultDomainArgs',
    'ComputeClusterVsanStretchedClusterArgs',
    'ContentLibraryPublicationArgs',
    'ContentLibrarySubscriptionArgs',
    'DistributedPortGroupVlanRangeArgs',
    'DistributedVirtualSwitchHostArgs',
    'DistributedVirtualSwitchPvlanMappingArgs',
    'DistributedVirtualSwitchVlanRangeArgs',
    'EntityPermissionsPermissionArgs',
    'GuestOsCustomizationSpecArgs',
    'GuestOsCustomizationSpecLinuxOptionsArgs',
    'GuestOsCustomizationSpecNetworkInterfaceArgs',
    'GuestOsCustomizationSpecWindowsOptionsArgs',
    'HostPortGroupPortArgs',
    'OfflineSoftwareDepotComponentArgs',
    'SupervisorEgressCidrArgs',
    'SupervisorIngressCidrArgs',
    'SupervisorManagementNetworkArgs',
    'SupervisorNamespaceArgs',
    'SupervisorPodCidrArgs',
    'SupervisorServiceCidrArgs',
    'VirtualMachineCdromArgs',
    'VirtualMachineCloneArgs',
    'VirtualMachineCloneCustomizationSpecArgs',
    'VirtualMachineCloneCustomizeArgs',
    'VirtualMachineCloneCustomizeLinuxOptionsArgs',
    'VirtualMachineCloneCustomizeNetworkInterfaceArgs',
    'VirtualMachineCloneCustomizeWindowsOptionsArgs',
    'VirtualMachineDiskArgs',
    'VirtualMachineNetworkInterfaceArgs',
    'VirtualMachineOvfDeployArgs',
    'VirtualMachineVappArgs',
    'VmStoragePolicyTagRuleArgs',
    'VnicIpv4Args',
    'VnicIpv6Args',
    'GetVirtualMachineVappArgs',
]

@pulumi.input_type
class ComputeClusterHostImageArgs:
    def __init__(__self__, *,
                 components: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeClusterHostImageComponentArgs']]]] = None,
                 esx_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ComputeClusterHostImageComponentArgs']]] components: List of custom components.
        :param pulumi.Input[str] esx_version: The ESXi version which the image is based on.
        """
        if components is not None:
            pulumi.set(__self__, "components", components)
        if esx_version is not None:
            pulumi.set(__self__, "esx_version", esx_version)

    @property
    @pulumi.getter
    def components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeClusterHostImageComponentArgs']]]]:
        """
        List of custom components.
        """
        return pulumi.get(self, "components")

    @components.setter
    def components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeClusterHostImageComponentArgs']]]]):
        pulumi.set(self, "components", value)

    @property
    @pulumi.getter(name="esxVersion")
    def esx_version(self) -> Optional[pulumi.Input[str]]:
        """
        The ESXi version which the image is based on.
        """
        return pulumi.get(self, "esx_version")

    @esx_version.setter
    def esx_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "esx_version", value)


@pulumi.input_type
class ComputeClusterHostImageComponentArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: The identifier for the component.
        :param pulumi.Input[str] version: The version to use.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the component.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version to use.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ComputeClusterVsanDiskGroupArgs:
    def __init__(__self__, *,
                 cache: Optional[pulumi.Input[str]] = None,
                 storages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] cache: Cache disk.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] storages: List of storage disks.
        """
        if cache is not None:
            pulumi.set(__self__, "cache", cache)
        if storages is not None:
            pulumi.set(__self__, "storages", storages)

    @property
    @pulumi.getter
    def cache(self) -> Optional[pulumi.Input[str]]:
        """
        Cache disk.
        """
        return pulumi.get(self, "cache")

    @cache.setter
    def cache(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache", value)

    @property
    @pulumi.getter
    def storages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of storage disks.
        """
        return pulumi.get(self, "storages")

    @storages.setter
    def storages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "storages", value)


@pulumi.input_type
class ComputeClusterVsanFaultDomainArgs:
    def __init__(__self__, *,
                 fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanFaultDomainFaultDomainArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanFaultDomainFaultDomainArgs']]] fault_domains: The configuration for single fault domain.
        """
        if fault_domains is not None:
            pulumi.set(__self__, "fault_domains", fault_domains)

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanFaultDomainFaultDomainArgs']]]]:
        """
        The configuration for single fault domain.
        """
        return pulumi.get(self, "fault_domains")

    @fault_domains.setter
    def fault_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanFaultDomainFaultDomainArgs']]]]):
        pulumi.set(self, "fault_domains", value)


@pulumi.input_type
class ComputeClusterVsanFaultDomainFaultDomainArgs:
    def __init__(__self__, *,
                 host_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 name: pulumi.Input[str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_ids: The managed object IDs of the hosts to put in the fault domain.
        :param pulumi.Input[str] name: The name of the cluster.
        """
        pulumi.set(__self__, "host_ids", host_ids)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="hostIds")
    def host_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The managed object IDs of the hosts to put in the fault domain.
        """
        return pulumi.get(self, "host_ids")

    @host_ids.setter
    def host_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "host_ids", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ComputeClusterVsanStretchedClusterArgs:
    def __init__(__self__, *,
                 preferred_fault_domain_host_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 secondary_fault_domain_host_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 witness_node: pulumi.Input[str],
                 preferred_fault_domain_name: Optional[pulumi.Input[str]] = None,
                 secondary_fault_domain_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] preferred_fault_domain_host_ids: The managed object IDs of the hosts to put in the first fault domain.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secondary_fault_domain_host_ids: The managed object IDs of the hosts to put in the second fault domain.
        :param pulumi.Input[str] witness_node: The managed object IDs of the host selected as witness node when enable stretched cluster.
        :param pulumi.Input[str] preferred_fault_domain_name: The name of prepferred fault domain.
        :param pulumi.Input[str] secondary_fault_domain_name: The name of secondary fault domain.
        """
        pulumi.set(__self__, "preferred_fault_domain_host_ids", preferred_fault_domain_host_ids)
        pulumi.set(__self__, "secondary_fault_domain_host_ids", secondary_fault_domain_host_ids)
        pulumi.set(__self__, "witness_node", witness_node)
        if preferred_fault_domain_name is not None:
            pulumi.set(__self__, "preferred_fault_domain_name", preferred_fault_domain_name)
        if secondary_fault_domain_name is not None:
            pulumi.set(__self__, "secondary_fault_domain_name", secondary_fault_domain_name)

    @property
    @pulumi.getter(name="preferredFaultDomainHostIds")
    def preferred_fault_domain_host_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The managed object IDs of the hosts to put in the first fault domain.
        """
        return pulumi.get(self, "preferred_fault_domain_host_ids")

    @preferred_fault_domain_host_ids.setter
    def preferred_fault_domain_host_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "preferred_fault_domain_host_ids", value)

    @property
    @pulumi.getter(name="secondaryFaultDomainHostIds")
    def secondary_fault_domain_host_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The managed object IDs of the hosts to put in the second fault domain.
        """
        return pulumi.get(self, "secondary_fault_domain_host_ids")

    @secondary_fault_domain_host_ids.setter
    def secondary_fault_domain_host_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "secondary_fault_domain_host_ids", value)

    @property
    @pulumi.getter(name="witnessNode")
    def witness_node(self) -> pulumi.Input[str]:
        """
        The managed object IDs of the host selected as witness node when enable stretched cluster.
        """
        return pulumi.get(self, "witness_node")

    @witness_node.setter
    def witness_node(self, value: pulumi.Input[str]):
        pulumi.set(self, "witness_node", value)

    @property
    @pulumi.getter(name="preferredFaultDomainName")
    def preferred_fault_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of prepferred fault domain.
        """
        return pulumi.get(self, "preferred_fault_domain_name")

    @preferred_fault_domain_name.setter
    def preferred_fault_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_fault_domain_name", value)

    @property
    @pulumi.getter(name="secondaryFaultDomainName")
    def secondary_fault_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of secondary fault domain.
        """
        return pulumi.get(self, "secondary_fault_domain_name")

    @secondary_fault_domain_name.setter
    def secondary_fault_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_fault_domain_name", value)


@pulumi.input_type
class ContentLibraryPublicationArgs:
    def __init__(__self__, *,
                 authentication_method: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 publish_url: Optional[pulumi.Input[str]] = None,
                 published: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] authentication_method: Method to authenticate users. Must be `NONE` or `BASIC`.
        :param pulumi.Input[str] password: Password used by subscribers to authenticate.
        :param pulumi.Input[str] publish_url: The URL of the published content library.
        :param pulumi.Input[bool] published: Publish the content library. Default `false`.
        :param pulumi.Input[str] username: Username used by subscribers to authenticate. Currently can only be `vcsp`.
        """
        if authentication_method is not None:
            pulumi.set(__self__, "authentication_method", authentication_method)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if publish_url is not None:
            pulumi.set(__self__, "publish_url", publish_url)
        if published is not None:
            pulumi.set(__self__, "published", published)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> Optional[pulumi.Input[str]]:
        """
        Method to authenticate users. Must be `NONE` or `BASIC`.
        """
        return pulumi.get(self, "authentication_method")

    @authentication_method.setter
    def authentication_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_method", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password used by subscribers to authenticate.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="publishUrl")
    def publish_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the published content library.
        """
        return pulumi.get(self, "publish_url")

    @publish_url.setter
    def publish_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publish_url", value)

    @property
    @pulumi.getter
    def published(self) -> Optional[pulumi.Input[bool]]:
        """
        Publish the content library. Default `false`.
        """
        return pulumi.get(self, "published")

    @published.setter
    def published(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "published", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username used by subscribers to authenticate. Currently can only be `vcsp`.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ContentLibrarySubscriptionArgs:
    def __init__(__self__, *,
                 authentication_method: Optional[pulumi.Input[str]] = None,
                 automatic_sync: Optional[pulumi.Input[bool]] = None,
                 on_demand: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 subscription_url: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] authentication_method: Authentication method to connect ro a published content library. Must be `NONE` or `BASIC`.
        :param pulumi.Input[bool] automatic_sync: Enable automatic synchronization with the published library. Default `false`.
        :param pulumi.Input[bool] on_demand: Download the library from a content only when needed. Default `true`.
        :param pulumi.Input[str] password: Password used for authentication.
        :param pulumi.Input[str] subscription_url: URL of the published content library.
        :param pulumi.Input[str] username: Username used for authentication.
        """
        if authentication_method is not None:
            pulumi.set(__self__, "authentication_method", authentication_method)
        if automatic_sync is not None:
            pulumi.set(__self__, "automatic_sync", automatic_sync)
        if on_demand is not None:
            pulumi.set(__self__, "on_demand", on_demand)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if subscription_url is not None:
            pulumi.set(__self__, "subscription_url", subscription_url)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> Optional[pulumi.Input[str]]:
        """
        Authentication method to connect ro a published content library. Must be `NONE` or `BASIC`.
        """
        return pulumi.get(self, "authentication_method")

    @authentication_method.setter
    def authentication_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_method", value)

    @property
    @pulumi.getter(name="automaticSync")
    def automatic_sync(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable automatic synchronization with the published library. Default `false`.
        """
        return pulumi.get(self, "automatic_sync")

    @automatic_sync.setter
    def automatic_sync(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automatic_sync", value)

    @property
    @pulumi.getter(name="onDemand")
    def on_demand(self) -> Optional[pulumi.Input[bool]]:
        """
        Download the library from a content only when needed. Default `true`.
        """
        return pulumi.get(self, "on_demand")

    @on_demand.setter
    def on_demand(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_demand", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password used for authentication.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="subscriptionUrl")
    def subscription_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the published content library.
        """
        return pulumi.get(self, "subscription_url")

    @subscription_url.setter
    def subscription_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_url", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username used for authentication.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class DistributedPortGroupVlanRangeArgs:
    def __init__(__self__, *,
                 max_vlan: pulumi.Input[int],
                 min_vlan: pulumi.Input[int]):
        """
        :param pulumi.Input[int] max_vlan: The minimum VLAN to use in the range.
        :param pulumi.Input[int] min_vlan: The minimum VLAN to use in the range.
        """
        pulumi.set(__self__, "max_vlan", max_vlan)
        pulumi.set(__self__, "min_vlan", min_vlan)

    @property
    @pulumi.getter(name="maxVlan")
    def max_vlan(self) -> pulumi.Input[int]:
        """
        The minimum VLAN to use in the range.
        """
        return pulumi.get(self, "max_vlan")

    @max_vlan.setter
    def max_vlan(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_vlan", value)

    @property
    @pulumi.getter(name="minVlan")
    def min_vlan(self) -> pulumi.Input[int]:
        """
        The minimum VLAN to use in the range.
        """
        return pulumi.get(self, "min_vlan")

    @min_vlan.setter
    def min_vlan(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_vlan", value)


@pulumi.input_type
class DistributedVirtualSwitchHostArgs:
    def __init__(__self__, *,
                 host_system_id: pulumi.Input[str],
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] host_system_id: The managed object ID of the host this specification applies to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] devices: Name of the physical NIC to be added to the proxy switch.
        """
        pulumi.set(__self__, "host_system_id", host_system_id)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)

    @property
    @pulumi.getter(name="hostSystemId")
    def host_system_id(self) -> pulumi.Input[str]:
        """
        The managed object ID of the host this specification applies to.
        """
        return pulumi.get(self, "host_system_id")

    @host_system_id.setter
    def host_system_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "host_system_id", value)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Name of the physical NIC to be added to the proxy switch.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "devices", value)


@pulumi.input_type
class DistributedVirtualSwitchPvlanMappingArgs:
    def __init__(__self__, *,
                 primary_vlan_id: pulumi.Input[int],
                 pvlan_type: pulumi.Input[str],
                 secondary_vlan_id: pulumi.Input[int]):
        """
        :param pulumi.Input[int] primary_vlan_id: The primary VLAN ID. The VLAN IDs of 0 and 4095 are reserved and cannot be used in this property.
        :param pulumi.Input[str] pvlan_type: The private VLAN type. Valid values are promiscuous, community and isolated.
        :param pulumi.Input[int] secondary_vlan_id: The secondary VLAN ID. The VLAN IDs of 0 and 4095 are reserved and cannot be used in this property.
        """
        pulumi.set(__self__, "primary_vlan_id", primary_vlan_id)
        pulumi.set(__self__, "pvlan_type", pvlan_type)
        pulumi.set(__self__, "secondary_vlan_id", secondary_vlan_id)

    @property
    @pulumi.getter(name="primaryVlanId")
    def primary_vlan_id(self) -> pulumi.Input[int]:
        """
        The primary VLAN ID. The VLAN IDs of 0 and 4095 are reserved and cannot be used in this property.
        """
        return pulumi.get(self, "primary_vlan_id")

    @primary_vlan_id.setter
    def primary_vlan_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "primary_vlan_id", value)

    @property
    @pulumi.getter(name="pvlanType")
    def pvlan_type(self) -> pulumi.Input[str]:
        """
        The private VLAN type. Valid values are promiscuous, community and isolated.
        """
        return pulumi.get(self, "pvlan_type")

    @pvlan_type.setter
    def pvlan_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "pvlan_type", value)

    @property
    @pulumi.getter(name="secondaryVlanId")
    def secondary_vlan_id(self) -> pulumi.Input[int]:
        """
        The secondary VLAN ID. The VLAN IDs of 0 and 4095 are reserved and cannot be used in this property.
        """
        return pulumi.get(self, "secondary_vlan_id")

    @secondary_vlan_id.setter
    def secondary_vlan_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "secondary_vlan_id", value)


@pulumi.input_type
class DistributedVirtualSwitchVlanRangeArgs:
    def __init__(__self__, *,
                 max_vlan: pulumi.Input[int],
                 min_vlan: pulumi.Input[int]):
        """
        :param pulumi.Input[int] max_vlan: The minimum VLAN to use in the range.
        :param pulumi.Input[int] min_vlan: The minimum VLAN to use in the range.
        """
        pulumi.set(__self__, "max_vlan", max_vlan)
        pulumi.set(__self__, "min_vlan", min_vlan)

    @property
    @pulumi.getter(name="maxVlan")
    def max_vlan(self) -> pulumi.Input[int]:
        """
        The minimum VLAN to use in the range.
        """
        return pulumi.get(self, "max_vlan")

    @max_vlan.setter
    def max_vlan(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_vlan", value)

    @property
    @pulumi.getter(name="minVlan")
    def min_vlan(self) -> pulumi.Input[int]:
        """
        The minimum VLAN to use in the range.
        """
        return pulumi.get(self, "min_vlan")

    @min_vlan.setter
    def min_vlan(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_vlan", value)


@pulumi.input_type
class EntityPermissionsPermissionArgs:
    def __init__(__self__, *,
                 is_group: pulumi.Input[bool],
                 propagate: pulumi.Input[bool],
                 role_id: pulumi.Input[str],
                 user_or_group: pulumi.Input[str]):
        """
        :param pulumi.Input[bool] is_group: Whether user_or_group field refers to a user or a group. True for a group and false for a user.
        :param pulumi.Input[bool] propagate: Whether or not this permission propagates down the hierarchy to sub-entities.
        :param pulumi.Input[str] role_id: The role id of the role to be given to the user on the specified entity.
        :param pulumi.Input[str] user_or_group: The user/group getting the permission.
        """
        pulumi.set(__self__, "is_group", is_group)
        pulumi.set(__self__, "propagate", propagate)
        pulumi.set(__self__, "role_id", role_id)
        pulumi.set(__self__, "user_or_group", user_or_group)

    @property
    @pulumi.getter(name="isGroup")
    def is_group(self) -> pulumi.Input[bool]:
        """
        Whether user_or_group field refers to a user or a group. True for a group and false for a user.
        """
        return pulumi.get(self, "is_group")

    @is_group.setter
    def is_group(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_group", value)

    @property
    @pulumi.getter
    def propagate(self) -> pulumi.Input[bool]:
        """
        Whether or not this permission propagates down the hierarchy to sub-entities.
        """
        return pulumi.get(self, "propagate")

    @propagate.setter
    def propagate(self, value: pulumi.Input[bool]):
        pulumi.set(self, "propagate", value)

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Input[str]:
        """
        The role id of the role to be given to the user on the specified entity.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_id", value)

    @property
    @pulumi.getter(name="userOrGroup")
    def user_or_group(self) -> pulumi.Input[str]:
        """
        The user/group getting the permission.
        """
        return pulumi.get(self, "user_or_group")

    @user_or_group.setter
    def user_or_group(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_or_group", value)


@pulumi.input_type
class GuestOsCustomizationSpecArgs:
    def __init__(__self__, *,
                 dns_server_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_suffix_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv4_gateway: Optional[pulumi.Input[str]] = None,
                 ipv6_gateway: Optional[pulumi.Input[str]] = None,
                 linux_options: Optional[pulumi.Input['GuestOsCustomizationSpecLinuxOptionsArgs']] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['GuestOsCustomizationSpecNetworkInterfaceArgs']]]] = None,
                 windows_options: Optional[pulumi.Input['GuestOsCustomizationSpecWindowsOptionsArgs']] = None,
                 windows_sysprep_text: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_server_lists: The list of DNS servers for a virtual network adapter with a static IP address.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_suffix_lists: A list of DNS search domains to add to the DNS configuration on the virtual machine.
        :param pulumi.Input[str] ipv4_gateway: The IPv4 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
        :param pulumi.Input[str] ipv6_gateway: The IPv6 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
        :param pulumi.Input['GuestOsCustomizationSpecLinuxOptionsArgs'] linux_options: A list of configuration options specific to Linux virtual machines.
        :param pulumi.Input[Sequence[pulumi.Input['GuestOsCustomizationSpecNetworkInterfaceArgs']]] network_interfaces: A specification of network interface configuration options.
        :param pulumi.Input['GuestOsCustomizationSpecWindowsOptionsArgs'] windows_options: A list of configuration options specific to Windows virtual machines.
        :param pulumi.Input[str] windows_sysprep_text: Use this option to specify a windows sysprep file directly.
        """
        if dns_server_lists is not None:
            pulumi.set(__self__, "dns_server_lists", dns_server_lists)
        if dns_suffix_lists is not None:
            pulumi.set(__self__, "dns_suffix_lists", dns_suffix_lists)
        if ipv4_gateway is not None:
            pulumi.set(__self__, "ipv4_gateway", ipv4_gateway)
        if ipv6_gateway is not None:
            pulumi.set(__self__, "ipv6_gateway", ipv6_gateway)
        if linux_options is not None:
            pulumi.set(__self__, "linux_options", linux_options)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if windows_options is not None:
            pulumi.set(__self__, "windows_options", windows_options)
        if windows_sysprep_text is not None:
            pulumi.set(__self__, "windows_sysprep_text", windows_sysprep_text)

    @property
    @pulumi.getter(name="dnsServerLists")
    def dns_server_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of DNS servers for a virtual network adapter with a static IP address.
        """
        return pulumi.get(self, "dns_server_lists")

    @dns_server_lists.setter
    def dns_server_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_server_lists", value)

    @property
    @pulumi.getter(name="dnsSuffixLists")
    def dns_suffix_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of DNS search domains to add to the DNS configuration on the virtual machine.
        """
        return pulumi.get(self, "dns_suffix_lists")

    @dns_suffix_lists.setter
    def dns_suffix_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_suffix_lists", value)

    @property
    @pulumi.getter(name="ipv4Gateway")
    def ipv4_gateway(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
        """
        return pulumi.get(self, "ipv4_gateway")

    @ipv4_gateway.setter
    def ipv4_gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_gateway", value)

    @property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
        """
        return pulumi.get(self, "ipv6_gateway")

    @ipv6_gateway.setter
    def ipv6_gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_gateway", value)

    @property
    @pulumi.getter(name="linuxOptions")
    def linux_options(self) -> Optional[pulumi.Input['GuestOsCustomizationSpecLinuxOptionsArgs']]:
        """
        A list of configuration options specific to Linux virtual machines.
        """
        return pulumi.get(self, "linux_options")

    @linux_options.setter
    def linux_options(self, value: Optional[pulumi.Input['GuestOsCustomizationSpecLinuxOptionsArgs']]):
        pulumi.set(self, "linux_options", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GuestOsCustomizationSpecNetworkInterfaceArgs']]]]:
        """
        A specification of network interface configuration options.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GuestOsCustomizationSpecNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="windowsOptions")
    def windows_options(self) -> Optional[pulumi.Input['GuestOsCustomizationSpecWindowsOptionsArgs']]:
        """
        A list of configuration options specific to Windows virtual machines.
        """
        return pulumi.get(self, "windows_options")

    @windows_options.setter
    def windows_options(self, value: Optional[pulumi.Input['GuestOsCustomizationSpecWindowsOptionsArgs']]):
        pulumi.set(self, "windows_options", value)

    @property
    @pulumi.getter(name="windowsSysprepText")
    def windows_sysprep_text(self) -> Optional[pulumi.Input[str]]:
        """
        Use this option to specify a windows sysprep file directly.
        """
        return pulumi.get(self, "windows_sysprep_text")

    @windows_sysprep_text.setter
    def windows_sysprep_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "windows_sysprep_text", value)


@pulumi.input_type
class GuestOsCustomizationSpecLinuxOptionsArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[str],
                 host_name: pulumi.Input[str],
                 hw_clock_utc: Optional[pulumi.Input[bool]] = None,
                 script_text: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] domain: The domain name for this virtual machine.
        :param pulumi.Input[str] host_name: The hostname for this virtual machine.
        :param pulumi.Input[bool] hw_clock_utc: Specifies whether or not the hardware clock should be in UTC or not.
        :param pulumi.Input[str] script_text: The customization script to run before and or after guest customization
        :param pulumi.Input[str] time_zone: Customize the time zone on the VM. This should be a time zone-style entry, like America/Los_Angeles.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "host_name", host_name)
        if hw_clock_utc is not None:
            pulumi.set(__self__, "hw_clock_utc", hw_clock_utc)
        if script_text is not None:
            pulumi.set(__self__, "script_text", script_text)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[str]:
        """
        The domain name for this virtual machine.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Input[str]:
        """
        The hostname for this virtual machine.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="hwClockUtc")
    def hw_clock_utc(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether or not the hardware clock should be in UTC or not.
        """
        return pulumi.get(self, "hw_clock_utc")

    @hw_clock_utc.setter
    def hw_clock_utc(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hw_clock_utc", value)

    @property
    @pulumi.getter(name="scriptText")
    def script_text(self) -> Optional[pulumi.Input[str]]:
        """
        The customization script to run before and or after guest customization
        """
        return pulumi.get(self, "script_text")

    @script_text.setter
    def script_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_text", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Customize the time zone on the VM. This should be a time zone-style entry, like America/Los_Angeles.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class GuestOsCustomizationSpecNetworkInterfaceArgs:
    def __init__(__self__, *,
                 dns_domain: Optional[pulumi.Input[str]] = None,
                 dns_server_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv4_address: Optional[pulumi.Input[str]] = None,
                 ipv4_netmask: Optional[pulumi.Input[int]] = None,
                 ipv6_address: Optional[pulumi.Input[str]] = None,
                 ipv6_netmask: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] dns_domain: A DNS search domain to add to the DNS configuration on the virtual machine.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_server_lists: Network-interface specific DNS settings for Windows operating systems. Ignored on Linux.
        :param pulumi.Input[str] ipv4_address: The IPv4 address assigned to this network adapter. If left blank, DHCP is used.
        :param pulumi.Input[int] ipv4_netmask: The IPv4 CIDR netmask for the supplied IP address. Ignored if DHCP is selected.
        :param pulumi.Input[str] ipv6_address: The IPv6 address assigned to this network adapter. If left blank, default auto-configuration is used.
        :param pulumi.Input[int] ipv6_netmask: The IPv6 CIDR netmask for the supplied IP address. Ignored if auto-configuration is selected.
        """
        if dns_domain is not None:
            pulumi.set(__self__, "dns_domain", dns_domain)
        if dns_server_lists is not None:
            pulumi.set(__self__, "dns_server_lists", dns_server_lists)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_netmask is not None:
            pulumi.set(__self__, "ipv4_netmask", ipv4_netmask)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if ipv6_netmask is not None:
            pulumi.set(__self__, "ipv6_netmask", ipv6_netmask)

    @property
    @pulumi.getter(name="dnsDomain")
    def dns_domain(self) -> Optional[pulumi.Input[str]]:
        """
        A DNS search domain to add to the DNS configuration on the virtual machine.
        """
        return pulumi.get(self, "dns_domain")

    @dns_domain.setter
    def dns_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_domain", value)

    @property
    @pulumi.getter(name="dnsServerLists")
    def dns_server_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Network-interface specific DNS settings for Windows operating systems. Ignored on Linux.
        """
        return pulumi.get(self, "dns_server_lists")

    @dns_server_lists.setter
    def dns_server_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_server_lists", value)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address assigned to this network adapter. If left blank, DHCP is used.
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_address", value)

    @property
    @pulumi.getter(name="ipv4Netmask")
    def ipv4_netmask(self) -> Optional[pulumi.Input[int]]:
        """
        The IPv4 CIDR netmask for the supplied IP address. Ignored if DHCP is selected.
        """
        return pulumi.get(self, "ipv4_netmask")

    @ipv4_netmask.setter
    def ipv4_netmask(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_netmask", value)

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 address assigned to this network adapter. If left blank, default auto-configuration is used.
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_address", value)

    @property
    @pulumi.getter(name="ipv6Netmask")
    def ipv6_netmask(self) -> Optional[pulumi.Input[int]]:
        """
        The IPv6 CIDR netmask for the supplied IP address. Ignored if auto-configuration is selected.
        """
        return pulumi.get(self, "ipv6_netmask")

    @ipv6_netmask.setter
    def ipv6_netmask(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_netmask", value)


@pulumi.input_type
class GuestOsCustomizationSpecWindowsOptionsArgs:
    def __init__(__self__, *,
                 computer_name: pulumi.Input[str],
                 admin_password: Optional[pulumi.Input[str]] = None,
                 auto_logon: Optional[pulumi.Input[bool]] = None,
                 auto_logon_count: Optional[pulumi.Input[int]] = None,
                 domain_admin_password: Optional[pulumi.Input[str]] = None,
                 domain_admin_user: Optional[pulumi.Input[str]] = None,
                 domain_ou: Optional[pulumi.Input[str]] = None,
                 full_name: Optional[pulumi.Input[str]] = None,
                 join_domain: Optional[pulumi.Input[str]] = None,
                 organization_name: Optional[pulumi.Input[str]] = None,
                 product_key: Optional[pulumi.Input[str]] = None,
                 run_once_command_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 time_zone: Optional[pulumi.Input[int]] = None,
                 workgroup: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] computer_name: The host name for this virtual machine.
        :param pulumi.Input[str] admin_password: The new administrator password for this virtual machine.
        :param pulumi.Input[bool] auto_logon: Specifies whether or not the VM automatically logs on as Administrator.
        :param pulumi.Input[int] auto_logon_count: Specifies how many times the VM should auto-logon the Administrator account when auto_logon is true.
        :param pulumi.Input[str] domain_admin_password: The password of the domain administrator used to join this virtual machine to the domain.
        :param pulumi.Input[str] domain_admin_user: The user account of the domain administrator used to join this virtual machine to the domain.
        :param pulumi.Input[str] domain_ou: The MachineObjectOU which specifies the full LDAP path name of the OU to which the virtual machine belongs.
        :param pulumi.Input[str] full_name: The full name of the user of this virtual machine.
        :param pulumi.Input[str] join_domain: The domain that the virtual machine should join.
        :param pulumi.Input[str] organization_name: The organization name this virtual machine is being installed for.
        :param pulumi.Input[str] product_key: The product key for this virtual machine.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] run_once_command_lists: A list of commands to run at first user logon, after guest customization.
        :param pulumi.Input[int] time_zone: The new time zone for the virtual machine. This is a sysprep-dictated timezone code.
        :param pulumi.Input[str] workgroup: The workgroup for this virtual machine if not joining a domain.
        """
        pulumi.set(__self__, "computer_name", computer_name)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if auto_logon is not None:
            pulumi.set(__self__, "auto_logon", auto_logon)
        if auto_logon_count is not None:
            pulumi.set(__self__, "auto_logon_count", auto_logon_count)
        if domain_admin_password is not None:
            pulumi.set(__self__, "domain_admin_password", domain_admin_password)
        if domain_admin_user is not None:
            pulumi.set(__self__, "domain_admin_user", domain_admin_user)
        if domain_ou is not None:
            pulumi.set(__self__, "domain_ou", domain_ou)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if join_domain is not None:
            pulumi.set(__self__, "join_domain", join_domain)
        if organization_name is not None:
            pulumi.set(__self__, "organization_name", organization_name)
        if product_key is not None:
            pulumi.set(__self__, "product_key", product_key)
        if run_once_command_lists is not None:
            pulumi.set(__self__, "run_once_command_lists", run_once_command_lists)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if workgroup is not None:
            pulumi.set(__self__, "workgroup", workgroup)

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> pulumi.Input[str]:
        """
        The host name for this virtual machine.
        """
        return pulumi.get(self, "computer_name")

    @computer_name.setter
    def computer_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "computer_name", value)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        The new administrator password for this virtual machine.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="autoLogon")
    def auto_logon(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether or not the VM automatically logs on as Administrator.
        """
        return pulumi.get(self, "auto_logon")

    @auto_logon.setter
    def auto_logon(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_logon", value)

    @property
    @pulumi.getter(name="autoLogonCount")
    def auto_logon_count(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies how many times the VM should auto-logon the Administrator account when auto_logon is true.
        """
        return pulumi.get(self, "auto_logon_count")

    @auto_logon_count.setter
    def auto_logon_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_logon_count", value)

    @property
    @pulumi.getter(name="domainAdminPassword")
    def domain_admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the domain administrator used to join this virtual machine to the domain.
        """
        return pulumi.get(self, "domain_admin_password")

    @domain_admin_password.setter
    def domain_admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_admin_password", value)

    @property
    @pulumi.getter(name="domainAdminUser")
    def domain_admin_user(self) -> Optional[pulumi.Input[str]]:
        """
        The user account of the domain administrator used to join this virtual machine to the domain.
        """
        return pulumi.get(self, "domain_admin_user")

    @domain_admin_user.setter
    def domain_admin_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_admin_user", value)

    @property
    @pulumi.getter(name="domainOu")
    def domain_ou(self) -> Optional[pulumi.Input[str]]:
        """
        The MachineObjectOU which specifies the full LDAP path name of the OU to which the virtual machine belongs.
        """
        return pulumi.get(self, "domain_ou")

    @domain_ou.setter
    def domain_ou(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_ou", value)

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the user of this virtual machine.
        """
        return pulumi.get(self, "full_name")

    @full_name.setter
    def full_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_name", value)

    @property
    @pulumi.getter(name="joinDomain")
    def join_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain that the virtual machine should join.
        """
        return pulumi.get(self, "join_domain")

    @join_domain.setter
    def join_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "join_domain", value)

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[pulumi.Input[str]]:
        """
        The organization name this virtual machine is being installed for.
        """
        return pulumi.get(self, "organization_name")

    @organization_name.setter
    def organization_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_name", value)

    @property
    @pulumi.getter(name="productKey")
    def product_key(self) -> Optional[pulumi.Input[str]]:
        """
        The product key for this virtual machine.
        """
        return pulumi.get(self, "product_key")

    @product_key.setter
    def product_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_key", value)

    @property
    @pulumi.getter(name="runOnceCommandLists")
    def run_once_command_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of commands to run at first user logon, after guest customization.
        """
        return pulumi.get(self, "run_once_command_lists")

    @run_once_command_lists.setter
    def run_once_command_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "run_once_command_lists", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[int]]:
        """
        The new time zone for the virtual machine. This is a sysprep-dictated timezone code.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter
    def workgroup(self) -> Optional[pulumi.Input[str]]:
        """
        The workgroup for this virtual machine if not joining a domain.
        """
        return pulumi.get(self, "workgroup")

    @workgroup.setter
    def workgroup(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workgroup", value)


@pulumi.input_type
class HostPortGroupPortArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: The key for this port group as returned from the vSphere API.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mac_addresses: The MAC addresses of the network service of the virtual machine connected on this port.
        :param pulumi.Input[str] type: Type type of the entity connected on this port. Possible values are host (VMKkernel), systemManagement (service console), virtualMachine, or unknown.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if mac_addresses is not None:
            pulumi.set(__self__, "mac_addresses", mac_addresses)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The key for this port group as returned from the vSphere API.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="macAddresses")
    def mac_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The MAC addresses of the network service of the virtual machine connected on this port.
        """
        return pulumi.get(self, "mac_addresses")

    @mac_addresses.setter
    def mac_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "mac_addresses", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type type of the entity connected on this port. Possible values are host (VMKkernel), systemManagement (service console), virtualMachine, or unknown.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class OfflineSoftwareDepotComponentArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] display_name: The name of the component. Useful for easier identification.
        :param pulumi.Input[str] key: The identifier of the component.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] versions: The list of available versions of the component.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the component. Useful for easier identification.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the component.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of available versions of the component.
        """
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "versions", value)


@pulumi.input_type
class SupervisorEgressCidrArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 prefix: pulumi.Input[int]):
        """
        :param pulumi.Input[str] address: Network address.
        :param pulumi.Input[int] prefix: Subnet prefix.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        Network address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Input[int]:
        """
        Subnet prefix.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: pulumi.Input[int]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class SupervisorIngressCidrArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 prefix: pulumi.Input[int]):
        """
        :param pulumi.Input[str] address: Network address.
        :param pulumi.Input[int] prefix: Subnet prefix.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        Network address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Input[int]:
        """
        Subnet prefix.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: pulumi.Input[int]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class SupervisorManagementNetworkArgs:
    def __init__(__self__, *,
                 address_count: pulumi.Input[int],
                 gateway: pulumi.Input[str],
                 network: pulumi.Input[str],
                 starting_address: pulumi.Input[str],
                 subnet_mask: pulumi.Input[str]):
        """
        :param pulumi.Input[int] address_count: Number of addresses to allocate. Starts from 'starting_address'
        :param pulumi.Input[str] gateway: Gateway IP address.
        :param pulumi.Input[str] network: ID of the network. (e.g. a distributed port group).
        :param pulumi.Input[str] starting_address: Starting address of the management network range.
        :param pulumi.Input[str] subnet_mask: Subnet mask.
        """
        pulumi.set(__self__, "address_count", address_count)
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "starting_address", starting_address)
        pulumi.set(__self__, "subnet_mask", subnet_mask)

    @property
    @pulumi.getter(name="addressCount")
    def address_count(self) -> pulumi.Input[int]:
        """
        Number of addresses to allocate. Starts from 'starting_address'
        """
        return pulumi.get(self, "address_count")

    @address_count.setter
    def address_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "address_count", value)

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Input[str]:
        """
        Gateway IP address.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: pulumi.Input[str]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[str]:
        """
        ID of the network. (e.g. a distributed port group).
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="startingAddress")
    def starting_address(self) -> pulumi.Input[str]:
        """
        Starting address of the management network range.
        """
        return pulumi.get(self, "starting_address")

    @starting_address.setter
    def starting_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "starting_address", value)

    @property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> pulumi.Input[str]:
        """
        Subnet mask.
        """
        return pulumi.get(self, "subnet_mask")

    @subnet_mask.setter
    def subnet_mask(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_mask", value)


@pulumi.input_type
class SupervisorNamespaceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 content_libraries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vm_classes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] name: The name of the namespace.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] content_libraries: A list of content libraries.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vm_classes: A list of virtual machine classes.
        """
        pulumi.set(__self__, "name", name)
        if content_libraries is not None:
            pulumi.set(__self__, "content_libraries", content_libraries)
        if vm_classes is not None:
            pulumi.set(__self__, "vm_classes", vm_classes)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the namespace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="contentLibraries")
    def content_libraries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of content libraries.
        """
        return pulumi.get(self, "content_libraries")

    @content_libraries.setter
    def content_libraries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "content_libraries", value)

    @property
    @pulumi.getter(name="vmClasses")
    def vm_classes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of virtual machine classes.
        """
        return pulumi.get(self, "vm_classes")

    @vm_classes.setter
    def vm_classes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vm_classes", value)


@pulumi.input_type
class SupervisorPodCidrArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 prefix: pulumi.Input[int]):
        """
        :param pulumi.Input[str] address: Network address.
        :param pulumi.Input[int] prefix: Subnet prefix.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        Network address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Input[int]:
        """
        Subnet prefix.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: pulumi.Input[int]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class SupervisorServiceCidrArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 prefix: pulumi.Input[int]):
        """
        :param pulumi.Input[str] address: Network address.
        :param pulumi.Input[int] prefix: Subnet prefix.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        Network address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Input[int]:
        """
        Subnet prefix.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: pulumi.Input[int]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class VirtualMachineCdromArgs:
    def __init__(__self__, *,
                 client_device: Optional[pulumi.Input[bool]] = None,
                 datastore_id: Optional[pulumi.Input[str]] = None,
                 device_address: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[int]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] client_device: Indicates whether the device should be mapped to a remote client device
        :param pulumi.Input[str] datastore_id: The datastore ID the ISO is located on.
        :param pulumi.Input[str] device_address: The internally-computed address of this device, such as scsi:0:1, denoting scsi bus #0 and device unit 1.
        :param pulumi.Input[int] key: The ID of the device within the virtual machine.
        :param pulumi.Input[str] path: The path to the ISO file on the datastore.
        """
        if client_device is not None:
            pulumi.set(__self__, "client_device", client_device)
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if device_address is not None:
            pulumi.set(__self__, "device_address", device_address)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="clientDevice")
    def client_device(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the device should be mapped to a remote client device
        """
        return pulumi.get(self, "client_device")

    @client_device.setter
    def client_device(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "client_device", value)

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[pulumi.Input[str]]:
        """
        The datastore ID the ISO is located on.
        """
        return pulumi.get(self, "datastore_id")

    @datastore_id.setter
    def datastore_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datastore_id", value)

    @property
    @pulumi.getter(name="deviceAddress")
    def device_address(self) -> Optional[pulumi.Input[str]]:
        """
        The internally-computed address of this device, such as scsi:0:1, denoting scsi bus #0 and device unit 1.
        """
        return pulumi.get(self, "device_address")

    @device_address.setter
    def device_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_address", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the device within the virtual machine.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the ISO file on the datastore.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class VirtualMachineCloneArgs:
    def __init__(__self__, *,
                 template_uuid: pulumi.Input[str],
                 customization_spec: Optional[pulumi.Input['VirtualMachineCloneCustomizationSpecArgs']] = None,
                 customize: Optional[pulumi.Input['VirtualMachineCloneCustomizeArgs']] = None,
                 linked_clone: Optional[pulumi.Input[bool]] = None,
                 ovf_network_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ovf_storage_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] template_uuid: The UUID of the source virtual machine or template.
        :param pulumi.Input['VirtualMachineCloneCustomizationSpecArgs'] customization_spec: The customization specification for the virtual machine post-clone.
        :param pulumi.Input['VirtualMachineCloneCustomizeArgs'] customize: The customization specification for the virtual machine post-clone.
        :param pulumi.Input[bool] linked_clone: Whether or not to create a linked clone when cloning. When this option is used, the source VM must have a single snapshot associated with it.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] ovf_network_map: Mapping of ovf networks to the networks to use in vSphere.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] ovf_storage_map: Mapping of ovf storage to the datastores to use in vSphere.
        :param pulumi.Input[int] timeout: The timeout, in minutes, to wait for the virtual machine clone to complete.
        """
        pulumi.set(__self__, "template_uuid", template_uuid)
        if customization_spec is not None:
            pulumi.set(__self__, "customization_spec", customization_spec)
        if customize is not None:
            pulumi.set(__self__, "customize", customize)
        if linked_clone is not None:
            pulumi.set(__self__, "linked_clone", linked_clone)
        if ovf_network_map is not None:
            pulumi.set(__self__, "ovf_network_map", ovf_network_map)
        if ovf_storage_map is not None:
            pulumi.set(__self__, "ovf_storage_map", ovf_storage_map)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="templateUuid")
    def template_uuid(self) -> pulumi.Input[str]:
        """
        The UUID of the source virtual machine or template.
        """
        return pulumi.get(self, "template_uuid")

    @template_uuid.setter
    def template_uuid(self, value: pulumi.Input[str]):
        pulumi.set(self, "template_uuid", value)

    @property
    @pulumi.getter(name="customizationSpec")
    def customization_spec(self) -> Optional[pulumi.Input['VirtualMachineCloneCustomizationSpecArgs']]:
        """
        The customization specification for the virtual machine post-clone.
        """
        return pulumi.get(self, "customization_spec")

    @customization_spec.setter
    def customization_spec(self, value: Optional[pulumi.Input['VirtualMachineCloneCustomizationSpecArgs']]):
        pulumi.set(self, "customization_spec", value)

    @property
    @pulumi.getter
    def customize(self) -> Optional[pulumi.Input['VirtualMachineCloneCustomizeArgs']]:
        """
        The customization specification for the virtual machine post-clone.
        """
        return pulumi.get(self, "customize")

    @customize.setter
    def customize(self, value: Optional[pulumi.Input['VirtualMachineCloneCustomizeArgs']]):
        pulumi.set(self, "customize", value)

    @property
    @pulumi.getter(name="linkedClone")
    def linked_clone(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to create a linked clone when cloning. When this option is used, the source VM must have a single snapshot associated with it.
        """
        return pulumi.get(self, "linked_clone")

    @linked_clone.setter
    def linked_clone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "linked_clone", value)

    @property
    @pulumi.getter(name="ovfNetworkMap")
    def ovf_network_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Mapping of ovf networks to the networks to use in vSphere.
        """
        return pulumi.get(self, "ovf_network_map")

    @ovf_network_map.setter
    def ovf_network_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "ovf_network_map", value)

    @property
    @pulumi.getter(name="ovfStorageMap")
    def ovf_storage_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Mapping of ovf storage to the datastores to use in vSphere.
        """
        return pulumi.get(self, "ovf_storage_map")

    @ovf_storage_map.setter
    def ovf_storage_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "ovf_storage_map", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout, in minutes, to wait for the virtual machine clone to complete.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class VirtualMachineCloneCustomizationSpecArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 timeout: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] id: The UUID of the virtual machine.
        :param pulumi.Input[int] timeout: The amount of time, in minutes, to wait for guest OS customization to complete before returning with an error. Setting this value to 0 or a negative value skips the waiter. Default: 10.
        """
        pulumi.set(__self__, "id", id)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The UUID of the virtual machine.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time, in minutes, to wait for guest OS customization to complete before returning with an error. Setting this value to 0 or a negative value skips the waiter. Default: 10.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class VirtualMachineCloneCustomizeArgs:
    def __init__(__self__, *,
                 dns_server_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_suffix_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv4_gateway: Optional[pulumi.Input[str]] = None,
                 ipv6_gateway: Optional[pulumi.Input[str]] = None,
                 linux_options: Optional[pulumi.Input['VirtualMachineCloneCustomizeLinuxOptionsArgs']] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineCloneCustomizeNetworkInterfaceArgs']]]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 windows_options: Optional[pulumi.Input['VirtualMachineCloneCustomizeWindowsOptionsArgs']] = None,
                 windows_sysprep_text: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_server_lists: The list of DNS servers for a virtual network adapter with a static IP address.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_suffix_lists: A list of DNS search domains to add to the DNS configuration on the virtual machine.
        :param pulumi.Input[str] ipv4_gateway: The IPv4 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
        :param pulumi.Input[str] ipv6_gateway: The IPv6 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
        :param pulumi.Input['VirtualMachineCloneCustomizeLinuxOptionsArgs'] linux_options: A list of configuration options specific to Linux virtual machines.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineCloneCustomizeNetworkInterfaceArgs']]] network_interfaces: A specification of network interface configuration options.
        :param pulumi.Input[int] timeout: The amount of time, in minutes, to wait for guest OS customization to complete before returning with an error. Setting this value to 0 or a negative value skips the waiter. Default: 10.
        :param pulumi.Input['VirtualMachineCloneCustomizeWindowsOptionsArgs'] windows_options: A list of configuration options specific to Windows virtual machines.
        :param pulumi.Input[str] windows_sysprep_text: Use this option to specify a windows sysprep file directly.
        """
        if dns_server_lists is not None:
            pulumi.set(__self__, "dns_server_lists", dns_server_lists)
        if dns_suffix_lists is not None:
            pulumi.set(__self__, "dns_suffix_lists", dns_suffix_lists)
        if ipv4_gateway is not None:
            pulumi.set(__self__, "ipv4_gateway", ipv4_gateway)
        if ipv6_gateway is not None:
            pulumi.set(__self__, "ipv6_gateway", ipv6_gateway)
        if linux_options is not None:
            pulumi.set(__self__, "linux_options", linux_options)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if windows_options is not None:
            pulumi.set(__self__, "windows_options", windows_options)
        if windows_sysprep_text is not None:
            pulumi.set(__self__, "windows_sysprep_text", windows_sysprep_text)

    @property
    @pulumi.getter(name="dnsServerLists")
    def dns_server_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of DNS servers for a virtual network adapter with a static IP address.
        """
        return pulumi.get(self, "dns_server_lists")

    @dns_server_lists.setter
    def dns_server_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_server_lists", value)

    @property
    @pulumi.getter(name="dnsSuffixLists")
    def dns_suffix_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of DNS search domains to add to the DNS configuration on the virtual machine.
        """
        return pulumi.get(self, "dns_suffix_lists")

    @dns_suffix_lists.setter
    def dns_suffix_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_suffix_lists", value)

    @property
    @pulumi.getter(name="ipv4Gateway")
    def ipv4_gateway(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
        """
        return pulumi.get(self, "ipv4_gateway")

    @ipv4_gateway.setter
    def ipv4_gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_gateway", value)

    @property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
        """
        return pulumi.get(self, "ipv6_gateway")

    @ipv6_gateway.setter
    def ipv6_gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_gateway", value)

    @property
    @pulumi.getter(name="linuxOptions")
    def linux_options(self) -> Optional[pulumi.Input['VirtualMachineCloneCustomizeLinuxOptionsArgs']]:
        """
        A list of configuration options specific to Linux virtual machines.
        """
        return pulumi.get(self, "linux_options")

    @linux_options.setter
    def linux_options(self, value: Optional[pulumi.Input['VirtualMachineCloneCustomizeLinuxOptionsArgs']]):
        pulumi.set(self, "linux_options", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineCloneCustomizeNetworkInterfaceArgs']]]]:
        """
        A specification of network interface configuration options.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineCloneCustomizeNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time, in minutes, to wait for guest OS customization to complete before returning with an error. Setting this value to 0 or a negative value skips the waiter. Default: 10.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="windowsOptions")
    def windows_options(self) -> Optional[pulumi.Input['VirtualMachineCloneCustomizeWindowsOptionsArgs']]:
        """
        A list of configuration options specific to Windows virtual machines.
        """
        return pulumi.get(self, "windows_options")

    @windows_options.setter
    def windows_options(self, value: Optional[pulumi.Input['VirtualMachineCloneCustomizeWindowsOptionsArgs']]):
        pulumi.set(self, "windows_options", value)

    @property
    @pulumi.getter(name="windowsSysprepText")
    def windows_sysprep_text(self) -> Optional[pulumi.Input[str]]:
        """
        Use this option to specify a windows sysprep file directly.
        """
        return pulumi.get(self, "windows_sysprep_text")

    @windows_sysprep_text.setter
    def windows_sysprep_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "windows_sysprep_text", value)


@pulumi.input_type
class VirtualMachineCloneCustomizeLinuxOptionsArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[str],
                 host_name: pulumi.Input[str],
                 hw_clock_utc: Optional[pulumi.Input[bool]] = None,
                 script_text: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] domain: The domain name for this virtual machine.
        :param pulumi.Input[str] host_name: The hostname for this virtual machine.
        :param pulumi.Input[bool] hw_clock_utc: Specifies whether or not the hardware clock should be in UTC or not.
        :param pulumi.Input[str] script_text: The customization script to run before and or after guest customization
        :param pulumi.Input[str] time_zone: Customize the time zone on the VM. This should be a time zone-style entry, like America/Los_Angeles.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "host_name", host_name)
        if hw_clock_utc is not None:
            pulumi.set(__self__, "hw_clock_utc", hw_clock_utc)
        if script_text is not None:
            pulumi.set(__self__, "script_text", script_text)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[str]:
        """
        The domain name for this virtual machine.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Input[str]:
        """
        The hostname for this virtual machine.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="hwClockUtc")
    def hw_clock_utc(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether or not the hardware clock should be in UTC or not.
        """
        return pulumi.get(self, "hw_clock_utc")

    @hw_clock_utc.setter
    def hw_clock_utc(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hw_clock_utc", value)

    @property
    @pulumi.getter(name="scriptText")
    def script_text(self) -> Optional[pulumi.Input[str]]:
        """
        The customization script to run before and or after guest customization
        """
        return pulumi.get(self, "script_text")

    @script_text.setter
    def script_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_text", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Customize the time zone on the VM. This should be a time zone-style entry, like America/Los_Angeles.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class VirtualMachineCloneCustomizeNetworkInterfaceArgs:
    def __init__(__self__, *,
                 dns_domain: Optional[pulumi.Input[str]] = None,
                 dns_server_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv4_address: Optional[pulumi.Input[str]] = None,
                 ipv4_netmask: Optional[pulumi.Input[int]] = None,
                 ipv6_address: Optional[pulumi.Input[str]] = None,
                 ipv6_netmask: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] dns_domain: A DNS search domain to add to the DNS configuration on the virtual machine.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_server_lists: Network-interface specific DNS settings for Windows operating systems. Ignored on Linux.
        :param pulumi.Input[str] ipv4_address: The IPv4 address assigned to this network adapter. If left blank, DHCP is used.
        :param pulumi.Input[int] ipv4_netmask: The IPv4 CIDR netmask for the supplied IP address. Ignored if DHCP is selected.
        :param pulumi.Input[str] ipv6_address: The IPv6 address assigned to this network adapter. If left blank, default auto-configuration is used.
        :param pulumi.Input[int] ipv6_netmask: The IPv6 CIDR netmask for the supplied IP address. Ignored if auto-configuration is selected.
        """
        if dns_domain is not None:
            pulumi.set(__self__, "dns_domain", dns_domain)
        if dns_server_lists is not None:
            pulumi.set(__self__, "dns_server_lists", dns_server_lists)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_netmask is not None:
            pulumi.set(__self__, "ipv4_netmask", ipv4_netmask)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if ipv6_netmask is not None:
            pulumi.set(__self__, "ipv6_netmask", ipv6_netmask)

    @property
    @pulumi.getter(name="dnsDomain")
    def dns_domain(self) -> Optional[pulumi.Input[str]]:
        """
        A DNS search domain to add to the DNS configuration on the virtual machine.
        """
        return pulumi.get(self, "dns_domain")

    @dns_domain.setter
    def dns_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_domain", value)

    @property
    @pulumi.getter(name="dnsServerLists")
    def dns_server_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Network-interface specific DNS settings for Windows operating systems. Ignored on Linux.
        """
        return pulumi.get(self, "dns_server_lists")

    @dns_server_lists.setter
    def dns_server_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_server_lists", value)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address assigned to this network adapter. If left blank, DHCP is used.
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_address", value)

    @property
    @pulumi.getter(name="ipv4Netmask")
    def ipv4_netmask(self) -> Optional[pulumi.Input[int]]:
        """
        The IPv4 CIDR netmask for the supplied IP address. Ignored if DHCP is selected.
        """
        return pulumi.get(self, "ipv4_netmask")

    @ipv4_netmask.setter
    def ipv4_netmask(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_netmask", value)

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 address assigned to this network adapter. If left blank, default auto-configuration is used.
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_address", value)

    @property
    @pulumi.getter(name="ipv6Netmask")
    def ipv6_netmask(self) -> Optional[pulumi.Input[int]]:
        """
        The IPv6 CIDR netmask for the supplied IP address. Ignored if auto-configuration is selected.
        """
        return pulumi.get(self, "ipv6_netmask")

    @ipv6_netmask.setter
    def ipv6_netmask(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_netmask", value)


@pulumi.input_type
class VirtualMachineCloneCustomizeWindowsOptionsArgs:
    def __init__(__self__, *,
                 computer_name: pulumi.Input[str],
                 admin_password: Optional[pulumi.Input[str]] = None,
                 auto_logon: Optional[pulumi.Input[bool]] = None,
                 auto_logon_count: Optional[pulumi.Input[int]] = None,
                 domain_admin_password: Optional[pulumi.Input[str]] = None,
                 domain_admin_user: Optional[pulumi.Input[str]] = None,
                 domain_ou: Optional[pulumi.Input[str]] = None,
                 full_name: Optional[pulumi.Input[str]] = None,
                 join_domain: Optional[pulumi.Input[str]] = None,
                 organization_name: Optional[pulumi.Input[str]] = None,
                 product_key: Optional[pulumi.Input[str]] = None,
                 run_once_command_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 time_zone: Optional[pulumi.Input[int]] = None,
                 workgroup: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] computer_name: The host name for this virtual machine.
        :param pulumi.Input[str] admin_password: The new administrator password for this virtual machine.
        :param pulumi.Input[bool] auto_logon: Specifies whether or not the VM automatically logs on as Administrator.
        :param pulumi.Input[int] auto_logon_count: Specifies how many times the VM should auto-logon the Administrator account when auto_logon is true.
        :param pulumi.Input[str] domain_admin_password: The password of the domain administrator used to join this virtual machine to the domain.
        :param pulumi.Input[str] domain_admin_user: The user account of the domain administrator used to join this virtual machine to the domain.
        :param pulumi.Input[str] domain_ou: The MachineObjectOU which specifies the full LDAP path name of the OU to which the virtual machine belongs.
        :param pulumi.Input[str] full_name: The full name of the user of this virtual machine.
        :param pulumi.Input[str] join_domain: The domain that the virtual machine should join.
        :param pulumi.Input[str] organization_name: The organization name this virtual machine is being installed for.
        :param pulumi.Input[str] product_key: The product key for this virtual machine.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] run_once_command_lists: A list of commands to run at first user logon, after guest customization.
        :param pulumi.Input[int] time_zone: The new time zone for the virtual machine. This is a sysprep-dictated timezone code.
        :param pulumi.Input[str] workgroup: The workgroup for this virtual machine if not joining a domain.
        """
        pulumi.set(__self__, "computer_name", computer_name)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if auto_logon is not None:
            pulumi.set(__self__, "auto_logon", auto_logon)
        if auto_logon_count is not None:
            pulumi.set(__self__, "auto_logon_count", auto_logon_count)
        if domain_admin_password is not None:
            pulumi.set(__self__, "domain_admin_password", domain_admin_password)
        if domain_admin_user is not None:
            pulumi.set(__self__, "domain_admin_user", domain_admin_user)
        if domain_ou is not None:
            pulumi.set(__self__, "domain_ou", domain_ou)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if join_domain is not None:
            pulumi.set(__self__, "join_domain", join_domain)
        if organization_name is not None:
            pulumi.set(__self__, "organization_name", organization_name)
        if product_key is not None:
            pulumi.set(__self__, "product_key", product_key)
        if run_once_command_lists is not None:
            pulumi.set(__self__, "run_once_command_lists", run_once_command_lists)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if workgroup is not None:
            pulumi.set(__self__, "workgroup", workgroup)

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> pulumi.Input[str]:
        """
        The host name for this virtual machine.
        """
        return pulumi.get(self, "computer_name")

    @computer_name.setter
    def computer_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "computer_name", value)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        The new administrator password for this virtual machine.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="autoLogon")
    def auto_logon(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether or not the VM automatically logs on as Administrator.
        """
        return pulumi.get(self, "auto_logon")

    @auto_logon.setter
    def auto_logon(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_logon", value)

    @property
    @pulumi.getter(name="autoLogonCount")
    def auto_logon_count(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies how many times the VM should auto-logon the Administrator account when auto_logon is true.
        """
        return pulumi.get(self, "auto_logon_count")

    @auto_logon_count.setter
    def auto_logon_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_logon_count", value)

    @property
    @pulumi.getter(name="domainAdminPassword")
    def domain_admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the domain administrator used to join this virtual machine to the domain.
        """
        return pulumi.get(self, "domain_admin_password")

    @domain_admin_password.setter
    def domain_admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_admin_password", value)

    @property
    @pulumi.getter(name="domainAdminUser")
    def domain_admin_user(self) -> Optional[pulumi.Input[str]]:
        """
        The user account of the domain administrator used to join this virtual machine to the domain.
        """
        return pulumi.get(self, "domain_admin_user")

    @domain_admin_user.setter
    def domain_admin_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_admin_user", value)

    @property
    @pulumi.getter(name="domainOu")
    def domain_ou(self) -> Optional[pulumi.Input[str]]:
        """
        The MachineObjectOU which specifies the full LDAP path name of the OU to which the virtual machine belongs.
        """
        return pulumi.get(self, "domain_ou")

    @domain_ou.setter
    def domain_ou(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_ou", value)

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the user of this virtual machine.
        """
        return pulumi.get(self, "full_name")

    @full_name.setter
    def full_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_name", value)

    @property
    @pulumi.getter(name="joinDomain")
    def join_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain that the virtual machine should join.
        """
        return pulumi.get(self, "join_domain")

    @join_domain.setter
    def join_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "join_domain", value)

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[pulumi.Input[str]]:
        """
        The organization name this virtual machine is being installed for.
        """
        return pulumi.get(self, "organization_name")

    @organization_name.setter
    def organization_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_name", value)

    @property
    @pulumi.getter(name="productKey")
    def product_key(self) -> Optional[pulumi.Input[str]]:
        """
        The product key for this virtual machine.
        """
        return pulumi.get(self, "product_key")

    @product_key.setter
    def product_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_key", value)

    @property
    @pulumi.getter(name="runOnceCommandLists")
    def run_once_command_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of commands to run at first user logon, after guest customization.
        """
        return pulumi.get(self, "run_once_command_lists")

    @run_once_command_lists.setter
    def run_once_command_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "run_once_command_lists", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[int]]:
        """
        The new time zone for the virtual machine. This is a sysprep-dictated timezone code.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter
    def workgroup(self) -> Optional[pulumi.Input[str]]:
        """
        The workgroup for this virtual machine if not joining a domain.
        """
        return pulumi.get(self, "workgroup")

    @workgroup.setter
    def workgroup(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workgroup", value)


@pulumi.input_type
class VirtualMachineDiskArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 attach: Optional[pulumi.Input[bool]] = None,
                 controller_type: Optional[pulumi.Input[str]] = None,
                 datastore_id: Optional[pulumi.Input[str]] = None,
                 device_address: Optional[pulumi.Input[str]] = None,
                 disk_mode: Optional[pulumi.Input[str]] = None,
                 disk_sharing: Optional[pulumi.Input[str]] = None,
                 eagerly_scrub: Optional[pulumi.Input[bool]] = None,
                 io_limit: Optional[pulumi.Input[int]] = None,
                 io_reservation: Optional[pulumi.Input[int]] = None,
                 io_share_count: Optional[pulumi.Input[int]] = None,
                 io_share_level: Optional[pulumi.Input[str]] = None,
                 keep_on_remove: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[int]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 storage_policy_id: Optional[pulumi.Input[str]] = None,
                 thin_provisioned: Optional[pulumi.Input[bool]] = None,
                 unit_number: Optional[pulumi.Input[int]] = None,
                 uuid: Optional[pulumi.Input[str]] = None,
                 write_through: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] label: A unique label for this disk.
        :param pulumi.Input[bool] attach: If this is true, the disk is attached instead of created. Implies keep_on_remove.
        :param pulumi.Input[str] controller_type: The type of controller the disk should be connected to. Must be 'scsi', 'sata', or 'ide'.
        :param pulumi.Input[str] datastore_id: The datastore ID for this virtual disk, if different than the virtual machine.
        :param pulumi.Input[str] device_address: The internally-computed address of this device, such as scsi:0:1, denoting scsi bus #0 and device unit 1.
        :param pulumi.Input[str] disk_mode: The mode of this this virtual disk for purposes of writes and snapshotting. Can be one of append, independent_nonpersistent, independent_persistent, nonpersistent, persistent, or undoable.
        :param pulumi.Input[str] disk_sharing: The sharing mode of this virtual disk. Can be one of sharingMultiWriter or sharingNone.
        :param pulumi.Input[bool] eagerly_scrub: The virtual disk file zeroing policy when thin_provision is not true. The default is false, which lazily-zeros the disk, speeding up thick-provisioned disk creation time.
        :param pulumi.Input[int] io_limit: The upper limit of IOPS that this disk can use.
        :param pulumi.Input[int] io_reservation: The I/O guarantee that this disk has, in IOPS.
        :param pulumi.Input[int] io_share_count: The share count for this disk when the share level is custom.
        :param pulumi.Input[str] io_share_level: The share allocation level for this disk. Can be one of low, normal, high, or custom.
        :param pulumi.Input[bool] keep_on_remove: Set to true to keep the underlying VMDK file when removing this virtual disk from configuration.
        :param pulumi.Input[int] key: The ID of the device within the virtual machine.
        :param pulumi.Input[str] path: The full path of the virtual disk. This can only be provided if attach is set to true, otherwise it is a read-only value.
        :param pulumi.Input[int] size: The size of the disk, in GB.
        :param pulumi.Input[str] storage_policy_id: The ID of the storage policy to assign to the virtual disk in VM.
        :param pulumi.Input[bool] thin_provisioned: If true, this disk is thin provisioned, with space for the file being allocated on an as-needed basis.
        :param pulumi.Input[int] unit_number: The unique device number for this disk. This number determines where on the SCSI bus this device will be attached.
        :param pulumi.Input[str] uuid: The UUID of the virtual machine. Also exposed as the `id` of the resource.
        :param pulumi.Input[bool] write_through: If true, writes for this disk are sent directly to the filesystem immediately instead of being buffered.
        """
        pulumi.set(__self__, "label", label)
        if attach is not None:
            pulumi.set(__self__, "attach", attach)
        if controller_type is not None:
            pulumi.set(__self__, "controller_type", controller_type)
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if device_address is not None:
            pulumi.set(__self__, "device_address", device_address)
        if disk_mode is not None:
            pulumi.set(__self__, "disk_mode", disk_mode)
        if disk_sharing is not None:
            pulumi.set(__self__, "disk_sharing", disk_sharing)
        if eagerly_scrub is not None:
            pulumi.set(__self__, "eagerly_scrub", eagerly_scrub)
        if io_limit is not None:
            pulumi.set(__self__, "io_limit", io_limit)
        if io_reservation is not None:
            pulumi.set(__self__, "io_reservation", io_reservation)
        if io_share_count is not None:
            pulumi.set(__self__, "io_share_count", io_share_count)
        if io_share_level is not None:
            pulumi.set(__self__, "io_share_level", io_share_level)
        if keep_on_remove is not None:
            pulumi.set(__self__, "keep_on_remove", keep_on_remove)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if storage_policy_id is not None:
            pulumi.set(__self__, "storage_policy_id", storage_policy_id)
        if thin_provisioned is not None:
            pulumi.set(__self__, "thin_provisioned", thin_provisioned)
        if unit_number is not None:
            pulumi.set(__self__, "unit_number", unit_number)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if write_through is not None:
            pulumi.set(__self__, "write_through", write_through)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        A unique label for this disk.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def attach(self) -> Optional[pulumi.Input[bool]]:
        """
        If this is true, the disk is attached instead of created. Implies keep_on_remove.
        """
        return pulumi.get(self, "attach")

    @attach.setter
    def attach(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "attach", value)

    @property
    @pulumi.getter(name="controllerType")
    def controller_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of controller the disk should be connected to. Must be 'scsi', 'sata', or 'ide'.
        """
        return pulumi.get(self, "controller_type")

    @controller_type.setter
    def controller_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller_type", value)

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[pulumi.Input[str]]:
        """
        The datastore ID for this virtual disk, if different than the virtual machine.
        """
        return pulumi.get(self, "datastore_id")

    @datastore_id.setter
    def datastore_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datastore_id", value)

    @property
    @pulumi.getter(name="deviceAddress")
    def device_address(self) -> Optional[pulumi.Input[str]]:
        """
        The internally-computed address of this device, such as scsi:0:1, denoting scsi bus #0 and device unit 1.
        """
        return pulumi.get(self, "device_address")

    @device_address.setter
    def device_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_address", value)

    @property
    @pulumi.getter(name="diskMode")
    def disk_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The mode of this this virtual disk for purposes of writes and snapshotting. Can be one of append, independent_nonpersistent, independent_persistent, nonpersistent, persistent, or undoable.
        """
        return pulumi.get(self, "disk_mode")

    @disk_mode.setter
    def disk_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_mode", value)

    @property
    @pulumi.getter(name="diskSharing")
    def disk_sharing(self) -> Optional[pulumi.Input[str]]:
        """
        The sharing mode of this virtual disk. Can be one of sharingMultiWriter or sharingNone.
        """
        return pulumi.get(self, "disk_sharing")

    @disk_sharing.setter
    def disk_sharing(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_sharing", value)

    @property
    @pulumi.getter(name="eagerlyScrub")
    def eagerly_scrub(self) -> Optional[pulumi.Input[bool]]:
        """
        The virtual disk file zeroing policy when thin_provision is not true. The default is false, which lazily-zeros the disk, speeding up thick-provisioned disk creation time.
        """
        return pulumi.get(self, "eagerly_scrub")

    @eagerly_scrub.setter
    def eagerly_scrub(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "eagerly_scrub", value)

    @property
    @pulumi.getter(name="ioLimit")
    def io_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The upper limit of IOPS that this disk can use.
        """
        return pulumi.get(self, "io_limit")

    @io_limit.setter
    def io_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "io_limit", value)

    @property
    @pulumi.getter(name="ioReservation")
    def io_reservation(self) -> Optional[pulumi.Input[int]]:
        """
        The I/O guarantee that this disk has, in IOPS.
        """
        return pulumi.get(self, "io_reservation")

    @io_reservation.setter
    def io_reservation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "io_reservation", value)

    @property
    @pulumi.getter(name="ioShareCount")
    def io_share_count(self) -> Optional[pulumi.Input[int]]:
        """
        The share count for this disk when the share level is custom.
        """
        return pulumi.get(self, "io_share_count")

    @io_share_count.setter
    def io_share_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "io_share_count", value)

    @property
    @pulumi.getter(name="ioShareLevel")
    def io_share_level(self) -> Optional[pulumi.Input[str]]:
        """
        The share allocation level for this disk. Can be one of low, normal, high, or custom.
        """
        return pulumi.get(self, "io_share_level")

    @io_share_level.setter
    def io_share_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "io_share_level", value)

    @property
    @pulumi.getter(name="keepOnRemove")
    def keep_on_remove(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true to keep the underlying VMDK file when removing this virtual disk from configuration.
        """
        return pulumi.get(self, "keep_on_remove")

    @keep_on_remove.setter
    def keep_on_remove(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_on_remove", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the device within the virtual machine.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The full path of the virtual disk. This can only be provided if attach is set to true, otherwise it is a read-only value.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the disk, in GB.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="storagePolicyId")
    def storage_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the storage policy to assign to the virtual disk in VM.
        """
        return pulumi.get(self, "storage_policy_id")

    @storage_policy_id.setter
    def storage_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_policy_id", value)

    @property
    @pulumi.getter(name="thinProvisioned")
    def thin_provisioned(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, this disk is thin provisioned, with space for the file being allocated on an as-needed basis.
        """
        return pulumi.get(self, "thin_provisioned")

    @thin_provisioned.setter
    def thin_provisioned(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "thin_provisioned", value)

    @property
    @pulumi.getter(name="unitNumber")
    def unit_number(self) -> Optional[pulumi.Input[int]]:
        """
        The unique device number for this disk. This number determines where on the SCSI bus this device will be attached.
        """
        return pulumi.get(self, "unit_number")

    @unit_number.setter
    def unit_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "unit_number", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID of the virtual machine. Also exposed as the `id` of the resource.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)

    @property
    @pulumi.getter(name="writeThrough")
    def write_through(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, writes for this disk are sent directly to the filesystem immediately instead of being buffered.
        """
        return pulumi.get(self, "write_through")

    @write_through.setter
    def write_through(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "write_through", value)


@pulumi.input_type
class VirtualMachineNetworkInterfaceArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 adapter_type: Optional[pulumi.Input[str]] = None,
                 bandwidth_limit: Optional[pulumi.Input[int]] = None,
                 bandwidth_reservation: Optional[pulumi.Input[int]] = None,
                 bandwidth_share_count: Optional[pulumi.Input[int]] = None,
                 bandwidth_share_level: Optional[pulumi.Input[str]] = None,
                 device_address: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[int]] = None,
                 mac_address: Optional[pulumi.Input[str]] = None,
                 ovf_mapping: Optional[pulumi.Input[str]] = None,
                 physical_function: Optional[pulumi.Input[str]] = None,
                 use_static_mac: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] network_id: The ID of the network to connect this network interface to.
        :param pulumi.Input[str] adapter_type: The controller type. Can be one of e1000, e1000e, sriov, vmxnet3, or vrdma.
        :param pulumi.Input[int] bandwidth_limit: The upper bandwidth limit of this network interface, in Mbits/sec.
        :param pulumi.Input[int] bandwidth_reservation: The bandwidth reservation of this network interface, in Mbits/sec.
        :param pulumi.Input[int] bandwidth_share_count: The share count for this network interface when the share level is custom.
        :param pulumi.Input[str] bandwidth_share_level: The bandwidth share allocation level for this interface. Can be one of low, normal, high, or custom.
        :param pulumi.Input[str] device_address: The internally-computed address of this device, such as scsi:0:1, denoting scsi bus #0 and device unit 1.
        :param pulumi.Input[int] key: The ID of the device within the virtual machine.
        :param pulumi.Input[str] mac_address: The MAC address of this network interface. Can only be manually set if use_static_mac is true.
        :param pulumi.Input[str] ovf_mapping: Mapping of network interface to OVF network.
        :param pulumi.Input[str] physical_function: The ID of the Physical SR-IOV NIC to attach to, e.g. '0000:d8:00.0'
        :param pulumi.Input[bool] use_static_mac: If true, the mac_address field is treated as a static MAC address and set accordingly.
        """
        pulumi.set(__self__, "network_id", network_id)
        if adapter_type is not None:
            pulumi.set(__self__, "adapter_type", adapter_type)
        if bandwidth_limit is not None:
            pulumi.set(__self__, "bandwidth_limit", bandwidth_limit)
        if bandwidth_reservation is not None:
            pulumi.set(__self__, "bandwidth_reservation", bandwidth_reservation)
        if bandwidth_share_count is not None:
            pulumi.set(__self__, "bandwidth_share_count", bandwidth_share_count)
        if bandwidth_share_level is not None:
            pulumi.set(__self__, "bandwidth_share_level", bandwidth_share_level)
        if device_address is not None:
            pulumi.set(__self__, "device_address", device_address)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if ovf_mapping is not None:
            pulumi.set(__self__, "ovf_mapping", ovf_mapping)
        if physical_function is not None:
            pulumi.set(__self__, "physical_function", physical_function)
        if use_static_mac is not None:
            pulumi.set(__self__, "use_static_mac", use_static_mac)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        The ID of the network to connect this network interface to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="adapterType")
    def adapter_type(self) -> Optional[pulumi.Input[str]]:
        """
        The controller type. Can be one of e1000, e1000e, sriov, vmxnet3, or vrdma.
        """
        return pulumi.get(self, "adapter_type")

    @adapter_type.setter
    def adapter_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "adapter_type", value)

    @property
    @pulumi.getter(name="bandwidthLimit")
    def bandwidth_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The upper bandwidth limit of this network interface, in Mbits/sec.
        """
        return pulumi.get(self, "bandwidth_limit")

    @bandwidth_limit.setter
    def bandwidth_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth_limit", value)

    @property
    @pulumi.getter(name="bandwidthReservation")
    def bandwidth_reservation(self) -> Optional[pulumi.Input[int]]:
        """
        The bandwidth reservation of this network interface, in Mbits/sec.
        """
        return pulumi.get(self, "bandwidth_reservation")

    @bandwidth_reservation.setter
    def bandwidth_reservation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth_reservation", value)

    @property
    @pulumi.getter(name="bandwidthShareCount")
    def bandwidth_share_count(self) -> Optional[pulumi.Input[int]]:
        """
        The share count for this network interface when the share level is custom.
        """
        return pulumi.get(self, "bandwidth_share_count")

    @bandwidth_share_count.setter
    def bandwidth_share_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth_share_count", value)

    @property
    @pulumi.getter(name="bandwidthShareLevel")
    def bandwidth_share_level(self) -> Optional[pulumi.Input[str]]:
        """
        The bandwidth share allocation level for this interface. Can be one of low, normal, high, or custom.
        """
        return pulumi.get(self, "bandwidth_share_level")

    @bandwidth_share_level.setter
    def bandwidth_share_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth_share_level", value)

    @property
    @pulumi.getter(name="deviceAddress")
    def device_address(self) -> Optional[pulumi.Input[str]]:
        """
        The internally-computed address of this device, such as scsi:0:1, denoting scsi bus #0 and device unit 1.
        """
        return pulumi.get(self, "device_address")

    @device_address.setter
    def device_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_address", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the device within the virtual machine.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[str]]:
        """
        The MAC address of this network interface. Can only be manually set if use_static_mac is true.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac_address", value)

    @property
    @pulumi.getter(name="ovfMapping")
    def ovf_mapping(self) -> Optional[pulumi.Input[str]]:
        """
        Mapping of network interface to OVF network.
        """
        return pulumi.get(self, "ovf_mapping")

    @ovf_mapping.setter
    def ovf_mapping(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ovf_mapping", value)

    @property
    @pulumi.getter(name="physicalFunction")
    def physical_function(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Physical SR-IOV NIC to attach to, e.g. '0000:d8:00.0'
        """
        return pulumi.get(self, "physical_function")

    @physical_function.setter
    def physical_function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "physical_function", value)

    @property
    @pulumi.getter(name="useStaticMac")
    def use_static_mac(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the mac_address field is treated as a static MAC address and set accordingly.
        """
        return pulumi.get(self, "use_static_mac")

    @use_static_mac.setter
    def use_static_mac(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_static_mac", value)


@pulumi.input_type
class VirtualMachineOvfDeployArgs:
    def __init__(__self__, *,
                 allow_unverified_ssl_cert: Optional[pulumi.Input[bool]] = None,
                 deployment_option: Optional[pulumi.Input[str]] = None,
                 disk_provisioning: Optional[pulumi.Input[str]] = None,
                 enable_hidden_properties: Optional[pulumi.Input[bool]] = None,
                 ip_allocation_policy: Optional[pulumi.Input[str]] = None,
                 ip_protocol: Optional[pulumi.Input[str]] = None,
                 local_ovf_path: Optional[pulumi.Input[str]] = None,
                 ovf_network_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 remote_ovf_url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] allow_unverified_ssl_cert: Allow unverified ssl certificates while deploying ovf/ova from url.
        :param pulumi.Input[str] deployment_option: The Deployment option to be chosen. If empty, the default option is used.
        :param pulumi.Input[str] disk_provisioning: An optional disk provisioning. If set, all the disks in the deployed ovf will have the same specified disk type (e.g., thin provisioned).
        :param pulumi.Input[bool] enable_hidden_properties: Allow properties with ovf:userConfigurable=false to be set.
        :param pulumi.Input[str] ip_allocation_policy: The IP allocation policy.
        :param pulumi.Input[str] ip_protocol: The IP protocol.
        :param pulumi.Input[str] local_ovf_path: The absolute path to the ovf/ova file in the local system.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] ovf_network_map: The mapping of name of network identifiers from the ovf descriptor to network UUID in the VI infrastructure.
        :param pulumi.Input[str] remote_ovf_url: URL to the remote ovf/ova file to be deployed.
        """
        if allow_unverified_ssl_cert is not None:
            pulumi.set(__self__, "allow_unverified_ssl_cert", allow_unverified_ssl_cert)
        if deployment_option is not None:
            pulumi.set(__self__, "deployment_option", deployment_option)
        if disk_provisioning is not None:
            pulumi.set(__self__, "disk_provisioning", disk_provisioning)
        if enable_hidden_properties is not None:
            pulumi.set(__self__, "enable_hidden_properties", enable_hidden_properties)
        if ip_allocation_policy is not None:
            pulumi.set(__self__, "ip_allocation_policy", ip_allocation_policy)
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if local_ovf_path is not None:
            pulumi.set(__self__, "local_ovf_path", local_ovf_path)
        if ovf_network_map is not None:
            pulumi.set(__self__, "ovf_network_map", ovf_network_map)
        if remote_ovf_url is not None:
            pulumi.set(__self__, "remote_ovf_url", remote_ovf_url)

    @property
    @pulumi.getter(name="allowUnverifiedSslCert")
    def allow_unverified_ssl_cert(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow unverified ssl certificates while deploying ovf/ova from url.
        """
        return pulumi.get(self, "allow_unverified_ssl_cert")

    @allow_unverified_ssl_cert.setter
    def allow_unverified_ssl_cert(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_unverified_ssl_cert", value)

    @property
    @pulumi.getter(name="deploymentOption")
    def deployment_option(self) -> Optional[pulumi.Input[str]]:
        """
        The Deployment option to be chosen. If empty, the default option is used.
        """
        return pulumi.get(self, "deployment_option")

    @deployment_option.setter
    def deployment_option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_option", value)

    @property
    @pulumi.getter(name="diskProvisioning")
    def disk_provisioning(self) -> Optional[pulumi.Input[str]]:
        """
        An optional disk provisioning. If set, all the disks in the deployed ovf will have the same specified disk type (e.g., thin provisioned).
        """
        return pulumi.get(self, "disk_provisioning")

    @disk_provisioning.setter
    def disk_provisioning(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_provisioning", value)

    @property
    @pulumi.getter(name="enableHiddenProperties")
    def enable_hidden_properties(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow properties with ovf:userConfigurable=false to be set.
        """
        return pulumi.get(self, "enable_hidden_properties")

    @enable_hidden_properties.setter
    def enable_hidden_properties(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_hidden_properties", value)

    @property
    @pulumi.getter(name="ipAllocationPolicy")
    def ip_allocation_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The IP allocation policy.
        """
        return pulumi.get(self, "ip_allocation_policy")

    @ip_allocation_policy.setter
    def ip_allocation_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_allocation_policy", value)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The IP protocol.
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter(name="localOvfPath")
    def local_ovf_path(self) -> Optional[pulumi.Input[str]]:
        """
        The absolute path to the ovf/ova file in the local system.
        """
        return pulumi.get(self, "local_ovf_path")

    @local_ovf_path.setter
    def local_ovf_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_ovf_path", value)

    @property
    @pulumi.getter(name="ovfNetworkMap")
    def ovf_network_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The mapping of name of network identifiers from the ovf descriptor to network UUID in the VI infrastructure.
        """
        return pulumi.get(self, "ovf_network_map")

    @ovf_network_map.setter
    def ovf_network_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "ovf_network_map", value)

    @property
    @pulumi.getter(name="remoteOvfUrl")
    def remote_ovf_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL to the remote ovf/ova file to be deployed.
        """
        return pulumi.get(self, "remote_ovf_url")

    @remote_ovf_url.setter
    def remote_ovf_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_ovf_url", value)


@pulumi.input_type
class VirtualMachineVappArgs:
    def __init__(__self__, *,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: A map of customizable vApp properties and their values. Allows customization of VMs cloned from OVF templates which have customizable vApp properties.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of customizable vApp properties and their values. Allows customization of VMs cloned from OVF templates which have customizable vApp properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class VmStoragePolicyTagRuleArgs:
    def __init__(__self__, *,
                 tag_category: pulumi.Input[str],
                 tags: pulumi.Input[Sequence[pulumi.Input[str]]],
                 include_datastores_with_tags: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] tag_category: Name of the tag category.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: List of Name of tags to select from the given category.
        :param pulumi.Input[bool] include_datastores_with_tags: Include datastores with the given tags or exclude. Default `true`.
        """
        pulumi.set(__self__, "tag_category", tag_category)
        pulumi.set(__self__, "tags", tags)
        if include_datastores_with_tags is not None:
            pulumi.set(__self__, "include_datastores_with_tags", include_datastores_with_tags)

    @property
    @pulumi.getter(name="tagCategory")
    def tag_category(self) -> pulumi.Input[str]:
        """
        Name of the tag category.
        """
        return pulumi.get(self, "tag_category")

    @tag_category.setter
    def tag_category(self, value: pulumi.Input[str]):
        pulumi.set(self, "tag_category", value)

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of Name of tags to select from the given category.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="includeDatastoresWithTags")
    def include_datastores_with_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        Include datastores with the given tags or exclude. Default `true`.
        """
        return pulumi.get(self, "include_datastores_with_tags")

    @include_datastores_with_tags.setter
    def include_datastores_with_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_datastores_with_tags", value)


@pulumi.input_type
class VnicIpv4Args:
    def __init__(__self__, *,
                 dhcp: Optional[pulumi.Input[bool]] = None,
                 gw: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 netmask: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] dhcp: Use DHCP to configure the interface's IPv4 stack.
        :param pulumi.Input[str] gw: IP address of the default gateway, if DHCP is not set.
        :param pulumi.Input[str] ip: address of the interface, if DHCP is not set.
        :param pulumi.Input[str] netmask: netmask of the interface, if DHCP is not set.
        """
        if dhcp is not None:
            pulumi.set(__self__, "dhcp", dhcp)
        if gw is not None:
            pulumi.set(__self__, "gw", gw)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if netmask is not None:
            pulumi.set(__self__, "netmask", netmask)

    @property
    @pulumi.getter
    def dhcp(self) -> Optional[pulumi.Input[bool]]:
        """
        Use DHCP to configure the interface's IPv4 stack.
        """
        return pulumi.get(self, "dhcp")

    @dhcp.setter
    def dhcp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dhcp", value)

    @property
    @pulumi.getter
    def gw(self) -> Optional[pulumi.Input[str]]:
        """
        IP address of the default gateway, if DHCP is not set.
        """
        return pulumi.get(self, "gw")

    @gw.setter
    def gw(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        address of the interface, if DHCP is not set.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def netmask(self) -> Optional[pulumi.Input[str]]:
        """
        netmask of the interface, if DHCP is not set.
        """
        return pulumi.get(self, "netmask")

    @netmask.setter
    def netmask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "netmask", value)


@pulumi.input_type
class VnicIpv6Args:
    def __init__(__self__, *,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 autoconfig: Optional[pulumi.Input[bool]] = None,
                 dhcp: Optional[pulumi.Input[bool]] = None,
                 gw: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] addresses: List of IPv6 addresses
        :param pulumi.Input[bool] autoconfig: Use IPv6 Autoconfiguration (RFC2462).
        :param pulumi.Input[bool] dhcp: Use DHCP to configure the interface's IPv4 stack.
        :param pulumi.Input[str] gw: IP address of the default gateway, if DHCP or autoconfig is not set.
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if autoconfig is not None:
            pulumi.set(__self__, "autoconfig", autoconfig)
        if dhcp is not None:
            pulumi.set(__self__, "dhcp", dhcp)
        if gw is not None:
            pulumi.set(__self__, "gw", gw)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of IPv6 addresses
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter
    def autoconfig(self) -> Optional[pulumi.Input[bool]]:
        """
        Use IPv6 Autoconfiguration (RFC2462).
        """
        return pulumi.get(self, "autoconfig")

    @autoconfig.setter
    def autoconfig(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autoconfig", value)

    @property
    @pulumi.getter
    def dhcp(self) -> Optional[pulumi.Input[bool]]:
        """
        Use DHCP to configure the interface's IPv4 stack.
        """
        return pulumi.get(self, "dhcp")

    @dhcp.setter
    def dhcp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dhcp", value)

    @property
    @pulumi.getter
    def gw(self) -> Optional[pulumi.Input[str]]:
        """
        IP address of the default gateway, if DHCP or autoconfig is not set.
        """
        return pulumi.get(self, "gw")

    @gw.setter
    def gw(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw", value)


@pulumi.input_type
class GetVirtualMachineVappArgs:
    def __init__(__self__, *,
                 properties: Optional[Mapping[str, str]] = None):
        """
        :param Mapping[str, str] properties: A map of customizable vApp properties and their values. Allows customization of VMs cloned from OVF templates which have customizable vApp properties.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        A map of customizable vApp properties and their values. Allows customization of VMs cloned from OVF templates which have customizable vApp properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[Mapping[str, str]]):
        pulumi.set(self, "properties", value)


