# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ComputeClusterArgs', 'ComputeCluster']

@pulumi.input_type
class ComputeClusterArgs:
    def __init__(__self__, *,
                 datacenter_id: pulumi.Input[str],
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 dpm_automation_level: Optional[pulumi.Input[str]] = None,
                 dpm_enabled: Optional[pulumi.Input[bool]] = None,
                 dpm_threshold: Optional[pulumi.Input[int]] = None,
                 drs_advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 drs_automation_level: Optional[pulumi.Input[str]] = None,
                 drs_enable_predictive_drs: Optional[pulumi.Input[bool]] = None,
                 drs_enable_vm_overrides: Optional[pulumi.Input[bool]] = None,
                 drs_enabled: Optional[pulumi.Input[bool]] = None,
                 drs_migration_threshold: Optional[pulumi.Input[int]] = None,
                 drs_scale_descendants_shares: Optional[pulumi.Input[str]] = None,
                 folder: Optional[pulumi.Input[str]] = None,
                 force_evacuate_on_destroy: Optional[pulumi.Input[bool]] = None,
                 ha_admission_control_failover_host_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ha_admission_control_host_failure_tolerance: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_performance_tolerance: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_policy: Optional[pulumi.Input[str]] = None,
                 ha_admission_control_resource_percentage_auto_compute: Optional[pulumi.Input[bool]] = None,
                 ha_admission_control_resource_percentage_cpu: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_resource_percentage_memory: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_slot_policy_explicit_cpu: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_slot_policy_explicit_memory: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_slot_policy_use_explicit_size: Optional[pulumi.Input[bool]] = None,
                 ha_advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ha_datastore_apd_recovery_action: Optional[pulumi.Input[str]] = None,
                 ha_datastore_apd_response: Optional[pulumi.Input[str]] = None,
                 ha_datastore_apd_response_delay: Optional[pulumi.Input[int]] = None,
                 ha_datastore_pdl_response: Optional[pulumi.Input[str]] = None,
                 ha_enabled: Optional[pulumi.Input[bool]] = None,
                 ha_heartbeat_datastore_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ha_heartbeat_datastore_policy: Optional[pulumi.Input[str]] = None,
                 ha_host_isolation_response: Optional[pulumi.Input[str]] = None,
                 ha_host_monitoring: Optional[pulumi.Input[str]] = None,
                 ha_vm_component_protection: Optional[pulumi.Input[str]] = None,
                 ha_vm_dependency_restart_condition: Optional[pulumi.Input[str]] = None,
                 ha_vm_failure_interval: Optional[pulumi.Input[int]] = None,
                 ha_vm_maximum_failure_window: Optional[pulumi.Input[int]] = None,
                 ha_vm_maximum_resets: Optional[pulumi.Input[int]] = None,
                 ha_vm_minimum_uptime: Optional[pulumi.Input[int]] = None,
                 ha_vm_monitoring: Optional[pulumi.Input[str]] = None,
                 ha_vm_restart_additional_delay: Optional[pulumi.Input[int]] = None,
                 ha_vm_restart_priority: Optional[pulumi.Input[str]] = None,
                 ha_vm_restart_timeout: Optional[pulumi.Input[int]] = None,
                 host_cluster_exit_timeout: Optional[pulumi.Input[int]] = None,
                 host_image: Optional[pulumi.Input['ComputeClusterHostImageArgs']] = None,
                 host_managed: Optional[pulumi.Input[bool]] = None,
                 host_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 proactive_ha_automation_level: Optional[pulumi.Input[str]] = None,
                 proactive_ha_enabled: Optional[pulumi.Input[bool]] = None,
                 proactive_ha_moderate_remediation: Optional[pulumi.Input[str]] = None,
                 proactive_ha_provider_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 proactive_ha_severe_remediation: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vsan_compression_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_dedup_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_disk_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanDiskGroupArgs']]]] = None,
                 vsan_dit_encryption_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_dit_rekey_interval: Optional[pulumi.Input[int]] = None,
                 vsan_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_esa_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanFaultDomainArgs']]]] = None,
                 vsan_network_diagnostic_mode_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_performance_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_remote_datastore_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vsan_stretched_cluster: Optional[pulumi.Input['ComputeClusterVsanStretchedClusterArgs']] = None,
                 vsan_unmap_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_verbose_mode_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a ComputeCluster resource.
        :param pulumi.Input[str] datacenter_id: The managed object ID of
               the datacenter to create the cluster in. Forces a new resource if changed.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_attributes: A map of custom attribute ids to attribute
               value strings to set for the datastore cluster.
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter Server.
        :param pulumi.Input[str] dpm_automation_level: The automation level for host power operations in this cluster. Can be one of manual or automated.
        :param pulumi.Input[bool] dpm_enabled: Enable DPM support for DRS. This allows you to dynamically control the power of hosts depending on the needs of virtual
               machines in the cluster. Requires that DRS be enabled.
        :param pulumi.Input[int] dpm_threshold: A value between 1 and 5 indicating the threshold of load within the cluster that influences host power operations. This
               affects both power on and power off operations - a lower setting will tolerate more of a surplus/deficit than a higher
               setting.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] drs_advanced_options: Advanced configuration options for DRS and DPM.
        :param pulumi.Input[str] drs_automation_level: The default automation level for all virtual machines in this cluster. Can be one of manual, partiallyAutomated, or
               fullyAutomated.
        :param pulumi.Input[bool] drs_enable_predictive_drs: When true, enables DRS to use data from vRealize Operations Manager to make proactive DRS recommendations.
        :param pulumi.Input[bool] drs_enable_vm_overrides: When true, allows individual VM overrides within this cluster to be set.
        :param pulumi.Input[bool] drs_enabled: Enable DRS for this cluster.
        :param pulumi.Input[int] drs_migration_threshold: A value between 1 and 5 indicating the threshold of imbalance tolerated between hosts. A lower setting will tolerate
               more imbalance while a higher setting will tolerate less.
        :param pulumi.Input[str] drs_scale_descendants_shares: Enable scalable shares for all descendants of this cluster.
        :param pulumi.Input[str] folder: The relative path to a folder to put this cluster in.
               This is a path relative to the datacenter you are deploying the cluster to.
               Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
               The provider will place a cluster named `compute-cluster-test` in a
               host folder located at `/dc1/host/foo/bar`, with the final inventory path
               being `/dc1/host/foo/bar/datastore-cluster-test`.
        :param pulumi.Input[bool] force_evacuate_on_destroy: Force removal of all hosts in the cluster during destroy and make them standalone hosts. Use of this flag mainly exists
               for testing and is not recommended in normal use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ha_admission_control_failover_host_system_ids: When ha_admission_control_policy is failoverHosts, this defines the managed object IDs of hosts to use as dedicated
               failover hosts. These hosts are kept as available as possible - admission control will block access to the host, and DRS
               will ignore the host when making recommendations.
        :param pulumi.Input[int] ha_admission_control_host_failure_tolerance: The maximum number of failed hosts that admission control tolerates when making decisions on whether to permit virtual
               machine operations. The maximum is one less than the number of hosts in the cluster.
        :param pulumi.Input[int] ha_admission_control_performance_tolerance: The percentage of resource reduction that a cluster of VMs can tolerate in case of a failover. A value of 0 produces
               warnings only, whereas a value of 100 disables the setting.
        :param pulumi.Input[str] ha_admission_control_policy: The type of admission control policy to use with vSphere HA, which controls whether or not specific VM operations are
               permitted in the cluster in order to protect the reliability of the cluster. Can be one of resourcePercentage,
               slotPolicy, failoverHosts, or disabled. Note that disabling admission control is not recommended and can lead to service
               issues.
        :param pulumi.Input[bool] ha_admission_control_resource_percentage_auto_compute: When ha_admission_control_policy is resourcePercentage, automatically determine available resource percentages by
               subtracting the average number of host resources represented by the ha_admission_control_host_failure_tolerance setting
               from the total amount of resources in the cluster. Disable to supply user-defined values.
        :param pulumi.Input[int] ha_admission_control_resource_percentage_cpu: When ha_admission_control_policy is resourcePercentage, this controls the user-defined percentage of CPU resources in
               the cluster to reserve for failover.
        :param pulumi.Input[int] ha_admission_control_resource_percentage_memory: When ha_admission_control_policy is resourcePercentage, this controls the user-defined percentage of memory resources in
               the cluster to reserve for failover.
        :param pulumi.Input[int] ha_admission_control_slot_policy_explicit_cpu: When ha_admission_control_policy is slotPolicy, this controls the user-defined CPU slot size, in MHz.
        :param pulumi.Input[int] ha_admission_control_slot_policy_explicit_memory: When ha_admission_control_policy is slotPolicy, this controls the user-defined memory slot size, in MB.
        :param pulumi.Input[bool] ha_admission_control_slot_policy_use_explicit_size: When ha_admission_control_policy is slotPolicy, this setting controls whether or not you wish to supply explicit values
               to CPU and memory slot sizes. The default is to gather a automatic average based on all powered-on virtual machines
               currently in the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] ha_advanced_options: Advanced configuration options for vSphere HA.
        :param pulumi.Input[str] ha_datastore_apd_recovery_action: When ha_vm_component_protection is enabled, controls the action to take on virtual machines if an APD status on an
               affected datastore clears in the middle of an APD event. Can be one of none or reset.
        :param pulumi.Input[str] ha_datastore_apd_response: When ha_vm_component_protection is enabled, controls the action to take on virtual machines when the cluster has
               detected loss to all paths to a relevant datastore. Can be one of disabled, warning, restartConservative, or
               restartAggressive.
        :param pulumi.Input[int] ha_datastore_apd_response_delay: When ha_vm_component_protection is enabled, controls the delay in seconds to wait after an APD timeout event to execute
               the response action defined in ha_datastore_apd_response.
        :param pulumi.Input[str] ha_datastore_pdl_response: When ha_vm_component_protection is enabled, controls the action to take on virtual machines when the cluster has
               detected a permanent device loss to a relevant datastore. Can be one of disabled, warning, or restartAggressive.
        :param pulumi.Input[bool] ha_enabled: Enable vSphere HA for this cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ha_heartbeat_datastore_ids: The list of managed object IDs for preferred datastores to use for HA heartbeating. This setting is only useful when
               ha_heartbeat_datastore_policy is set to either userSelectedDs or allFeasibleDsWithUserPreference.
        :param pulumi.Input[str] ha_heartbeat_datastore_policy: The selection policy for HA heartbeat datastores. Can be one of allFeasibleDs, userSelectedDs, or
               allFeasibleDsWithUserPreference.
        :param pulumi.Input[str] ha_host_isolation_response: The action to take on virtual machines when a host has detected that it has been isolated from the rest of the cluster.
               Can be one of none, powerOff, or shutdown.
        :param pulumi.Input[str] ha_host_monitoring: Global setting that controls whether vSphere HA remediates VMs on host failure. Can be one of enabled or disabled.
        :param pulumi.Input[str] ha_vm_component_protection: Controls vSphere VM component protection for virtual machines in this cluster. This allows vSphere HA to react to
               failures between hosts and specific virtual machine components, such as datastores. Can be one of enabled or disabled.
        :param pulumi.Input[str] ha_vm_dependency_restart_condition: The condition used to determine whether or not VMs in a certain restart priority class are online, allowing HA to move
               on to restarting VMs on the next priority. Can be one of none, poweredOn, guestHbStatusGreen, or appHbStatusGreen.
        :param pulumi.Input[int] ha_vm_failure_interval: If a heartbeat from a virtual machine is not received within this configured interval, the virtual machine is marked as
               failed. The value is in seconds.
        :param pulumi.Input[int] ha_vm_maximum_failure_window: The length of the reset window in which ha_vm_maximum_resets can operate. When this window expires, no more resets are
               attempted regardless of the setting configured in ha_vm_maximum_resets. -1 means no window, meaning an unlimited reset
               time is allotted.
        :param pulumi.Input[int] ha_vm_maximum_resets: The maximum number of resets that HA will perform to a virtual machine when responding to a failure event.
        :param pulumi.Input[int] ha_vm_minimum_uptime: The time, in seconds, that HA waits after powering on a virtual machine before monitoring for heartbeats.
        :param pulumi.Input[str] ha_vm_monitoring: The type of virtual machine monitoring to use when HA is enabled in the cluster. Can be one of vmMonitoringDisabled,
               vmMonitoringOnly, or vmAndAppMonitoring.
        :param pulumi.Input[int] ha_vm_restart_additional_delay: Additional delay in seconds after ready condition is met. A VM is considered ready at this point.
        :param pulumi.Input[str] ha_vm_restart_priority: The default restart priority for affected VMs when vSphere detects a host failure. Can be one of lowest, low, medium,
               high, or highest.
        :param pulumi.Input[int] ha_vm_restart_timeout: The maximum time, in seconds, that vSphere HA will wait for virtual machines in one priority to be ready before
               proceeding with the next priority.
        :param pulumi.Input[int] host_cluster_exit_timeout: The timeout for each host maintenance mode operation when removing hosts from a cluster.
        :param pulumi.Input['ComputeClusterHostImageArgs'] host_image: Details about the host image which should be applied to the cluster.
        :param pulumi.Input[bool] host_managed: Must be set if cluster enrollment is managed from host resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_system_ids: The managed object IDs of the hosts to put in the cluster.
        :param pulumi.Input[str] name: The name of the cluster.
        :param pulumi.Input[str] proactive_ha_automation_level: The DRS behavior for proactive HA recommendations. Can be one of Automated or Manual.
        :param pulumi.Input[bool] proactive_ha_enabled: Enables proactive HA, allowing for vSphere to get HA data from external providers and use DRS to perform remediation.
        :param pulumi.Input[str] proactive_ha_moderate_remediation: The configured remediation for moderately degraded hosts. Can be one of MaintenanceMode or QuarantineMode. Note that
               this cannot be set to MaintenanceMode when proactive_ha_severe_remediation is set to QuarantineMode.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] proactive_ha_provider_ids: The list of IDs for health update providers configured for this cluster.
        :param pulumi.Input[str] proactive_ha_severe_remediation: The configured remediation for severely degraded hosts. Can be one of MaintenanceMode or QuarantineMode. Note that this
               cannot be set to QuarantineMode when proactive_ha_moderate_remediation is set to MaintenanceMode.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The IDs of any tags to attach to this resource.
        :param pulumi.Input[bool] vsan_compression_enabled: Whether the vSAN compression service is enabled for the cluster.
        :param pulumi.Input[bool] vsan_dedup_enabled: Whether the vSAN deduplication service is enabled for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanDiskGroupArgs']]] vsan_disk_groups: A list of disk UUIDs to add to the vSAN cluster.
        :param pulumi.Input[bool] vsan_dit_encryption_enabled: Whether the vSAN data-in-transit encryption is enabled for the cluster.
        :param pulumi.Input[int] vsan_dit_rekey_interval: When vsan_dit_encryption_enabled is enabled, sets the rekey interval of data-in-transit encryption (in minutes).
        :param pulumi.Input[bool] vsan_enabled: Whether the vSAN service is enabled for the cluster.
        :param pulumi.Input[bool] vsan_esa_enabled: Whether the vSAN ESA service is enabled for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanFaultDomainArgs']]] vsan_fault_domains: The configuration for vSAN fault domains.
        :param pulumi.Input[bool] vsan_network_diagnostic_mode_enabled: Whether the vSAN network diagnostic mode is enabled for the cluster.
        :param pulumi.Input[bool] vsan_performance_enabled: Whether the vSAN performance service is enabled for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vsan_remote_datastore_ids: The managed object IDs of the vSAN datastore to be mounted on the cluster.
        :param pulumi.Input['ComputeClusterVsanStretchedClusterArgs'] vsan_stretched_cluster: The configuration for stretched cluster.
        :param pulumi.Input[bool] vsan_unmap_enabled: Whether the vSAN unmap service is enabled for the cluster.
        :param pulumi.Input[bool] vsan_verbose_mode_enabled: Whether the vSAN verbose mode is enabled for the cluster.
        """
        pulumi.set(__self__, "datacenter_id", datacenter_id)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if dpm_automation_level is not None:
            pulumi.set(__self__, "dpm_automation_level", dpm_automation_level)
        if dpm_enabled is not None:
            pulumi.set(__self__, "dpm_enabled", dpm_enabled)
        if dpm_threshold is not None:
            pulumi.set(__self__, "dpm_threshold", dpm_threshold)
        if drs_advanced_options is not None:
            pulumi.set(__self__, "drs_advanced_options", drs_advanced_options)
        if drs_automation_level is not None:
            pulumi.set(__self__, "drs_automation_level", drs_automation_level)
        if drs_enable_predictive_drs is not None:
            pulumi.set(__self__, "drs_enable_predictive_drs", drs_enable_predictive_drs)
        if drs_enable_vm_overrides is not None:
            pulumi.set(__self__, "drs_enable_vm_overrides", drs_enable_vm_overrides)
        if drs_enabled is not None:
            pulumi.set(__self__, "drs_enabled", drs_enabled)
        if drs_migration_threshold is not None:
            pulumi.set(__self__, "drs_migration_threshold", drs_migration_threshold)
        if drs_scale_descendants_shares is not None:
            pulumi.set(__self__, "drs_scale_descendants_shares", drs_scale_descendants_shares)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if force_evacuate_on_destroy is not None:
            pulumi.set(__self__, "force_evacuate_on_destroy", force_evacuate_on_destroy)
        if ha_admission_control_failover_host_system_ids is not None:
            pulumi.set(__self__, "ha_admission_control_failover_host_system_ids", ha_admission_control_failover_host_system_ids)
        if ha_admission_control_host_failure_tolerance is not None:
            pulumi.set(__self__, "ha_admission_control_host_failure_tolerance", ha_admission_control_host_failure_tolerance)
        if ha_admission_control_performance_tolerance is not None:
            pulumi.set(__self__, "ha_admission_control_performance_tolerance", ha_admission_control_performance_tolerance)
        if ha_admission_control_policy is not None:
            pulumi.set(__self__, "ha_admission_control_policy", ha_admission_control_policy)
        if ha_admission_control_resource_percentage_auto_compute is not None:
            pulumi.set(__self__, "ha_admission_control_resource_percentage_auto_compute", ha_admission_control_resource_percentage_auto_compute)
        if ha_admission_control_resource_percentage_cpu is not None:
            pulumi.set(__self__, "ha_admission_control_resource_percentage_cpu", ha_admission_control_resource_percentage_cpu)
        if ha_admission_control_resource_percentage_memory is not None:
            pulumi.set(__self__, "ha_admission_control_resource_percentage_memory", ha_admission_control_resource_percentage_memory)
        if ha_admission_control_slot_policy_explicit_cpu is not None:
            pulumi.set(__self__, "ha_admission_control_slot_policy_explicit_cpu", ha_admission_control_slot_policy_explicit_cpu)
        if ha_admission_control_slot_policy_explicit_memory is not None:
            pulumi.set(__self__, "ha_admission_control_slot_policy_explicit_memory", ha_admission_control_slot_policy_explicit_memory)
        if ha_admission_control_slot_policy_use_explicit_size is not None:
            pulumi.set(__self__, "ha_admission_control_slot_policy_use_explicit_size", ha_admission_control_slot_policy_use_explicit_size)
        if ha_advanced_options is not None:
            pulumi.set(__self__, "ha_advanced_options", ha_advanced_options)
        if ha_datastore_apd_recovery_action is not None:
            pulumi.set(__self__, "ha_datastore_apd_recovery_action", ha_datastore_apd_recovery_action)
        if ha_datastore_apd_response is not None:
            pulumi.set(__self__, "ha_datastore_apd_response", ha_datastore_apd_response)
        if ha_datastore_apd_response_delay is not None:
            pulumi.set(__self__, "ha_datastore_apd_response_delay", ha_datastore_apd_response_delay)
        if ha_datastore_pdl_response is not None:
            pulumi.set(__self__, "ha_datastore_pdl_response", ha_datastore_pdl_response)
        if ha_enabled is not None:
            pulumi.set(__self__, "ha_enabled", ha_enabled)
        if ha_heartbeat_datastore_ids is not None:
            pulumi.set(__self__, "ha_heartbeat_datastore_ids", ha_heartbeat_datastore_ids)
        if ha_heartbeat_datastore_policy is not None:
            pulumi.set(__self__, "ha_heartbeat_datastore_policy", ha_heartbeat_datastore_policy)
        if ha_host_isolation_response is not None:
            pulumi.set(__self__, "ha_host_isolation_response", ha_host_isolation_response)
        if ha_host_monitoring is not None:
            pulumi.set(__self__, "ha_host_monitoring", ha_host_monitoring)
        if ha_vm_component_protection is not None:
            pulumi.set(__self__, "ha_vm_component_protection", ha_vm_component_protection)
        if ha_vm_dependency_restart_condition is not None:
            pulumi.set(__self__, "ha_vm_dependency_restart_condition", ha_vm_dependency_restart_condition)
        if ha_vm_failure_interval is not None:
            pulumi.set(__self__, "ha_vm_failure_interval", ha_vm_failure_interval)
        if ha_vm_maximum_failure_window is not None:
            pulumi.set(__self__, "ha_vm_maximum_failure_window", ha_vm_maximum_failure_window)
        if ha_vm_maximum_resets is not None:
            pulumi.set(__self__, "ha_vm_maximum_resets", ha_vm_maximum_resets)
        if ha_vm_minimum_uptime is not None:
            pulumi.set(__self__, "ha_vm_minimum_uptime", ha_vm_minimum_uptime)
        if ha_vm_monitoring is not None:
            pulumi.set(__self__, "ha_vm_monitoring", ha_vm_monitoring)
        if ha_vm_restart_additional_delay is not None:
            pulumi.set(__self__, "ha_vm_restart_additional_delay", ha_vm_restart_additional_delay)
        if ha_vm_restart_priority is not None:
            pulumi.set(__self__, "ha_vm_restart_priority", ha_vm_restart_priority)
        if ha_vm_restart_timeout is not None:
            pulumi.set(__self__, "ha_vm_restart_timeout", ha_vm_restart_timeout)
        if host_cluster_exit_timeout is not None:
            pulumi.set(__self__, "host_cluster_exit_timeout", host_cluster_exit_timeout)
        if host_image is not None:
            pulumi.set(__self__, "host_image", host_image)
        if host_managed is not None:
            pulumi.set(__self__, "host_managed", host_managed)
        if host_system_ids is not None:
            pulumi.set(__self__, "host_system_ids", host_system_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if proactive_ha_automation_level is not None:
            pulumi.set(__self__, "proactive_ha_automation_level", proactive_ha_automation_level)
        if proactive_ha_enabled is not None:
            pulumi.set(__self__, "proactive_ha_enabled", proactive_ha_enabled)
        if proactive_ha_moderate_remediation is not None:
            pulumi.set(__self__, "proactive_ha_moderate_remediation", proactive_ha_moderate_remediation)
        if proactive_ha_provider_ids is not None:
            pulumi.set(__self__, "proactive_ha_provider_ids", proactive_ha_provider_ids)
        if proactive_ha_severe_remediation is not None:
            pulumi.set(__self__, "proactive_ha_severe_remediation", proactive_ha_severe_remediation)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vsan_compression_enabled is not None:
            pulumi.set(__self__, "vsan_compression_enabled", vsan_compression_enabled)
        if vsan_dedup_enabled is not None:
            pulumi.set(__self__, "vsan_dedup_enabled", vsan_dedup_enabled)
        if vsan_disk_groups is not None:
            pulumi.set(__self__, "vsan_disk_groups", vsan_disk_groups)
        if vsan_dit_encryption_enabled is not None:
            pulumi.set(__self__, "vsan_dit_encryption_enabled", vsan_dit_encryption_enabled)
        if vsan_dit_rekey_interval is not None:
            pulumi.set(__self__, "vsan_dit_rekey_interval", vsan_dit_rekey_interval)
        if vsan_enabled is not None:
            pulumi.set(__self__, "vsan_enabled", vsan_enabled)
        if vsan_esa_enabled is not None:
            pulumi.set(__self__, "vsan_esa_enabled", vsan_esa_enabled)
        if vsan_fault_domains is not None:
            pulumi.set(__self__, "vsan_fault_domains", vsan_fault_domains)
        if vsan_network_diagnostic_mode_enabled is not None:
            pulumi.set(__self__, "vsan_network_diagnostic_mode_enabled", vsan_network_diagnostic_mode_enabled)
        if vsan_performance_enabled is not None:
            pulumi.set(__self__, "vsan_performance_enabled", vsan_performance_enabled)
        if vsan_remote_datastore_ids is not None:
            pulumi.set(__self__, "vsan_remote_datastore_ids", vsan_remote_datastore_ids)
        if vsan_stretched_cluster is not None:
            pulumi.set(__self__, "vsan_stretched_cluster", vsan_stretched_cluster)
        if vsan_unmap_enabled is not None:
            pulumi.set(__self__, "vsan_unmap_enabled", vsan_unmap_enabled)
        if vsan_verbose_mode_enabled is not None:
            pulumi.set(__self__, "vsan_verbose_mode_enabled", vsan_verbose_mode_enabled)

    @property
    @pulumi.getter(name="datacenterId")
    def datacenter_id(self) -> pulumi.Input[str]:
        """
        The managed object ID of
        the datacenter to create the cluster in. Forces a new resource if changed.
        """
        return pulumi.get(self, "datacenter_id")

    @datacenter_id.setter
    def datacenter_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "datacenter_id", value)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of custom attribute ids to attribute
        value strings to set for the datastore cluster.

        > **NOTE:** Custom attributes are unsupported on direct ESXi connections
        and require vCenter Server.
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "custom_attributes", value)

    @property
    @pulumi.getter(name="dpmAutomationLevel")
    def dpm_automation_level(self) -> Optional[pulumi.Input[str]]:
        """
        The automation level for host power operations in this cluster. Can be one of manual or automated.
        """
        return pulumi.get(self, "dpm_automation_level")

    @dpm_automation_level.setter
    def dpm_automation_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dpm_automation_level", value)

    @property
    @pulumi.getter(name="dpmEnabled")
    def dpm_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable DPM support for DRS. This allows you to dynamically control the power of hosts depending on the needs of virtual
        machines in the cluster. Requires that DRS be enabled.
        """
        return pulumi.get(self, "dpm_enabled")

    @dpm_enabled.setter
    def dpm_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dpm_enabled", value)

    @property
    @pulumi.getter(name="dpmThreshold")
    def dpm_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        A value between 1 and 5 indicating the threshold of load within the cluster that influences host power operations. This
        affects both power on and power off operations - a lower setting will tolerate more of a surplus/deficit than a higher
        setting.
        """
        return pulumi.get(self, "dpm_threshold")

    @dpm_threshold.setter
    def dpm_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "dpm_threshold", value)

    @property
    @pulumi.getter(name="drsAdvancedOptions")
    def drs_advanced_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Advanced configuration options for DRS and DPM.
        """
        return pulumi.get(self, "drs_advanced_options")

    @drs_advanced_options.setter
    def drs_advanced_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "drs_advanced_options", value)

    @property
    @pulumi.getter(name="drsAutomationLevel")
    def drs_automation_level(self) -> Optional[pulumi.Input[str]]:
        """
        The default automation level for all virtual machines in this cluster. Can be one of manual, partiallyAutomated, or
        fullyAutomated.
        """
        return pulumi.get(self, "drs_automation_level")

    @drs_automation_level.setter
    def drs_automation_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "drs_automation_level", value)

    @property
    @pulumi.getter(name="drsEnablePredictiveDrs")
    def drs_enable_predictive_drs(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, enables DRS to use data from vRealize Operations Manager to make proactive DRS recommendations.
        """
        return pulumi.get(self, "drs_enable_predictive_drs")

    @drs_enable_predictive_drs.setter
    def drs_enable_predictive_drs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drs_enable_predictive_drs", value)

    @property
    @pulumi.getter(name="drsEnableVmOverrides")
    def drs_enable_vm_overrides(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, allows individual VM overrides within this cluster to be set.
        """
        return pulumi.get(self, "drs_enable_vm_overrides")

    @drs_enable_vm_overrides.setter
    def drs_enable_vm_overrides(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drs_enable_vm_overrides", value)

    @property
    @pulumi.getter(name="drsEnabled")
    def drs_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable DRS for this cluster.
        """
        return pulumi.get(self, "drs_enabled")

    @drs_enabled.setter
    def drs_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drs_enabled", value)

    @property
    @pulumi.getter(name="drsMigrationThreshold")
    def drs_migration_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        A value between 1 and 5 indicating the threshold of imbalance tolerated between hosts. A lower setting will tolerate
        more imbalance while a higher setting will tolerate less.
        """
        return pulumi.get(self, "drs_migration_threshold")

    @drs_migration_threshold.setter
    def drs_migration_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "drs_migration_threshold", value)

    @property
    @pulumi.getter(name="drsScaleDescendantsShares")
    def drs_scale_descendants_shares(self) -> Optional[pulumi.Input[str]]:
        """
        Enable scalable shares for all descendants of this cluster.
        """
        return pulumi.get(self, "drs_scale_descendants_shares")

    @drs_scale_descendants_shares.setter
    def drs_scale_descendants_shares(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "drs_scale_descendants_shares", value)

    @property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[str]]:
        """
        The relative path to a folder to put this cluster in.
        This is a path relative to the datacenter you are deploying the cluster to.
        Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
        The provider will place a cluster named `compute-cluster-test` in a
        host folder located at `/dc1/host/foo/bar`, with the final inventory path
        being `/dc1/host/foo/bar/datastore-cluster-test`.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter(name="forceEvacuateOnDestroy")
    def force_evacuate_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Force removal of all hosts in the cluster during destroy and make them standalone hosts. Use of this flag mainly exists
        for testing and is not recommended in normal use.
        """
        return pulumi.get(self, "force_evacuate_on_destroy")

    @force_evacuate_on_destroy.setter
    def force_evacuate_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_evacuate_on_destroy", value)

    @property
    @pulumi.getter(name="haAdmissionControlFailoverHostSystemIds")
    def ha_admission_control_failover_host_system_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        When ha_admission_control_policy is failoverHosts, this defines the managed object IDs of hosts to use as dedicated
        failover hosts. These hosts are kept as available as possible - admission control will block access to the host, and DRS
        will ignore the host when making recommendations.
        """
        return pulumi.get(self, "ha_admission_control_failover_host_system_ids")

    @ha_admission_control_failover_host_system_ids.setter
    def ha_admission_control_failover_host_system_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ha_admission_control_failover_host_system_ids", value)

    @property
    @pulumi.getter(name="haAdmissionControlHostFailureTolerance")
    def ha_admission_control_host_failure_tolerance(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of failed hosts that admission control tolerates when making decisions on whether to permit virtual
        machine operations. The maximum is one less than the number of hosts in the cluster.
        """
        return pulumi.get(self, "ha_admission_control_host_failure_tolerance")

    @ha_admission_control_host_failure_tolerance.setter
    def ha_admission_control_host_failure_tolerance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_admission_control_host_failure_tolerance", value)

    @property
    @pulumi.getter(name="haAdmissionControlPerformanceTolerance")
    def ha_admission_control_performance_tolerance(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage of resource reduction that a cluster of VMs can tolerate in case of a failover. A value of 0 produces
        warnings only, whereas a value of 100 disables the setting.
        """
        return pulumi.get(self, "ha_admission_control_performance_tolerance")

    @ha_admission_control_performance_tolerance.setter
    def ha_admission_control_performance_tolerance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_admission_control_performance_tolerance", value)

    @property
    @pulumi.getter(name="haAdmissionControlPolicy")
    def ha_admission_control_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The type of admission control policy to use with vSphere HA, which controls whether or not specific VM operations are
        permitted in the cluster in order to protect the reliability of the cluster. Can be one of resourcePercentage,
        slotPolicy, failoverHosts, or disabled. Note that disabling admission control is not recommended and can lead to service
        issues.
        """
        return pulumi.get(self, "ha_admission_control_policy")

    @ha_admission_control_policy.setter
    def ha_admission_control_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_admission_control_policy", value)

    @property
    @pulumi.getter(name="haAdmissionControlResourcePercentageAutoCompute")
    def ha_admission_control_resource_percentage_auto_compute(self) -> Optional[pulumi.Input[bool]]:
        """
        When ha_admission_control_policy is resourcePercentage, automatically determine available resource percentages by
        subtracting the average number of host resources represented by the ha_admission_control_host_failure_tolerance setting
        from the total amount of resources in the cluster. Disable to supply user-defined values.
        """
        return pulumi.get(self, "ha_admission_control_resource_percentage_auto_compute")

    @ha_admission_control_resource_percentage_auto_compute.setter
    def ha_admission_control_resource_percentage_auto_compute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ha_admission_control_resource_percentage_auto_compute", value)

    @property
    @pulumi.getter(name="haAdmissionControlResourcePercentageCpu")
    def ha_admission_control_resource_percentage_cpu(self) -> Optional[pulumi.Input[int]]:
        """
        When ha_admission_control_policy is resourcePercentage, this controls the user-defined percentage of CPU resources in
        the cluster to reserve for failover.
        """
        return pulumi.get(self, "ha_admission_control_resource_percentage_cpu")

    @ha_admission_control_resource_percentage_cpu.setter
    def ha_admission_control_resource_percentage_cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_admission_control_resource_percentage_cpu", value)

    @property
    @pulumi.getter(name="haAdmissionControlResourcePercentageMemory")
    def ha_admission_control_resource_percentage_memory(self) -> Optional[pulumi.Input[int]]:
        """
        When ha_admission_control_policy is resourcePercentage, this controls the user-defined percentage of memory resources in
        the cluster to reserve for failover.
        """
        return pulumi.get(self, "ha_admission_control_resource_percentage_memory")

    @ha_admission_control_resource_percentage_memory.setter
    def ha_admission_control_resource_percentage_memory(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_admission_control_resource_percentage_memory", value)

    @property
    @pulumi.getter(name="haAdmissionControlSlotPolicyExplicitCpu")
    def ha_admission_control_slot_policy_explicit_cpu(self) -> Optional[pulumi.Input[int]]:
        """
        When ha_admission_control_policy is slotPolicy, this controls the user-defined CPU slot size, in MHz.
        """
        return pulumi.get(self, "ha_admission_control_slot_policy_explicit_cpu")

    @ha_admission_control_slot_policy_explicit_cpu.setter
    def ha_admission_control_slot_policy_explicit_cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_admission_control_slot_policy_explicit_cpu", value)

    @property
    @pulumi.getter(name="haAdmissionControlSlotPolicyExplicitMemory")
    def ha_admission_control_slot_policy_explicit_memory(self) -> Optional[pulumi.Input[int]]:
        """
        When ha_admission_control_policy is slotPolicy, this controls the user-defined memory slot size, in MB.
        """
        return pulumi.get(self, "ha_admission_control_slot_policy_explicit_memory")

    @ha_admission_control_slot_policy_explicit_memory.setter
    def ha_admission_control_slot_policy_explicit_memory(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_admission_control_slot_policy_explicit_memory", value)

    @property
    @pulumi.getter(name="haAdmissionControlSlotPolicyUseExplicitSize")
    def ha_admission_control_slot_policy_use_explicit_size(self) -> Optional[pulumi.Input[bool]]:
        """
        When ha_admission_control_policy is slotPolicy, this setting controls whether or not you wish to supply explicit values
        to CPU and memory slot sizes. The default is to gather a automatic average based on all powered-on virtual machines
        currently in the cluster.
        """
        return pulumi.get(self, "ha_admission_control_slot_policy_use_explicit_size")

    @ha_admission_control_slot_policy_use_explicit_size.setter
    def ha_admission_control_slot_policy_use_explicit_size(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ha_admission_control_slot_policy_use_explicit_size", value)

    @property
    @pulumi.getter(name="haAdvancedOptions")
    def ha_advanced_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Advanced configuration options for vSphere HA.
        """
        return pulumi.get(self, "ha_advanced_options")

    @ha_advanced_options.setter
    def ha_advanced_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "ha_advanced_options", value)

    @property
    @pulumi.getter(name="haDatastoreApdRecoveryAction")
    def ha_datastore_apd_recovery_action(self) -> Optional[pulumi.Input[str]]:
        """
        When ha_vm_component_protection is enabled, controls the action to take on virtual machines if an APD status on an
        affected datastore clears in the middle of an APD event. Can be one of none or reset.
        """
        return pulumi.get(self, "ha_datastore_apd_recovery_action")

    @ha_datastore_apd_recovery_action.setter
    def ha_datastore_apd_recovery_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_datastore_apd_recovery_action", value)

    @property
    @pulumi.getter(name="haDatastoreApdResponse")
    def ha_datastore_apd_response(self) -> Optional[pulumi.Input[str]]:
        """
        When ha_vm_component_protection is enabled, controls the action to take on virtual machines when the cluster has
        detected loss to all paths to a relevant datastore. Can be one of disabled, warning, restartConservative, or
        restartAggressive.
        """
        return pulumi.get(self, "ha_datastore_apd_response")

    @ha_datastore_apd_response.setter
    def ha_datastore_apd_response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_datastore_apd_response", value)

    @property
    @pulumi.getter(name="haDatastoreApdResponseDelay")
    def ha_datastore_apd_response_delay(self) -> Optional[pulumi.Input[int]]:
        """
        When ha_vm_component_protection is enabled, controls the delay in seconds to wait after an APD timeout event to execute
        the response action defined in ha_datastore_apd_response.
        """
        return pulumi.get(self, "ha_datastore_apd_response_delay")

    @ha_datastore_apd_response_delay.setter
    def ha_datastore_apd_response_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_datastore_apd_response_delay", value)

    @property
    @pulumi.getter(name="haDatastorePdlResponse")
    def ha_datastore_pdl_response(self) -> Optional[pulumi.Input[str]]:
        """
        When ha_vm_component_protection is enabled, controls the action to take on virtual machines when the cluster has
        detected a permanent device loss to a relevant datastore. Can be one of disabled, warning, or restartAggressive.
        """
        return pulumi.get(self, "ha_datastore_pdl_response")

    @ha_datastore_pdl_response.setter
    def ha_datastore_pdl_response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_datastore_pdl_response", value)

    @property
    @pulumi.getter(name="haEnabled")
    def ha_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable vSphere HA for this cluster.
        """
        return pulumi.get(self, "ha_enabled")

    @ha_enabled.setter
    def ha_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ha_enabled", value)

    @property
    @pulumi.getter(name="haHeartbeatDatastoreIds")
    def ha_heartbeat_datastore_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of managed object IDs for preferred datastores to use for HA heartbeating. This setting is only useful when
        ha_heartbeat_datastore_policy is set to either userSelectedDs or allFeasibleDsWithUserPreference.
        """
        return pulumi.get(self, "ha_heartbeat_datastore_ids")

    @ha_heartbeat_datastore_ids.setter
    def ha_heartbeat_datastore_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ha_heartbeat_datastore_ids", value)

    @property
    @pulumi.getter(name="haHeartbeatDatastorePolicy")
    def ha_heartbeat_datastore_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The selection policy for HA heartbeat datastores. Can be one of allFeasibleDs, userSelectedDs, or
        allFeasibleDsWithUserPreference.
        """
        return pulumi.get(self, "ha_heartbeat_datastore_policy")

    @ha_heartbeat_datastore_policy.setter
    def ha_heartbeat_datastore_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_heartbeat_datastore_policy", value)

    @property
    @pulumi.getter(name="haHostIsolationResponse")
    def ha_host_isolation_response(self) -> Optional[pulumi.Input[str]]:
        """
        The action to take on virtual machines when a host has detected that it has been isolated from the rest of the cluster.
        Can be one of none, powerOff, or shutdown.
        """
        return pulumi.get(self, "ha_host_isolation_response")

    @ha_host_isolation_response.setter
    def ha_host_isolation_response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_host_isolation_response", value)

    @property
    @pulumi.getter(name="haHostMonitoring")
    def ha_host_monitoring(self) -> Optional[pulumi.Input[str]]:
        """
        Global setting that controls whether vSphere HA remediates VMs on host failure. Can be one of enabled or disabled.
        """
        return pulumi.get(self, "ha_host_monitoring")

    @ha_host_monitoring.setter
    def ha_host_monitoring(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_host_monitoring", value)

    @property
    @pulumi.getter(name="haVmComponentProtection")
    def ha_vm_component_protection(self) -> Optional[pulumi.Input[str]]:
        """
        Controls vSphere VM component protection for virtual machines in this cluster. This allows vSphere HA to react to
        failures between hosts and specific virtual machine components, such as datastores. Can be one of enabled or disabled.
        """
        return pulumi.get(self, "ha_vm_component_protection")

    @ha_vm_component_protection.setter
    def ha_vm_component_protection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_vm_component_protection", value)

    @property
    @pulumi.getter(name="haVmDependencyRestartCondition")
    def ha_vm_dependency_restart_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The condition used to determine whether or not VMs in a certain restart priority class are online, allowing HA to move
        on to restarting VMs on the next priority. Can be one of none, poweredOn, guestHbStatusGreen, or appHbStatusGreen.
        """
        return pulumi.get(self, "ha_vm_dependency_restart_condition")

    @ha_vm_dependency_restart_condition.setter
    def ha_vm_dependency_restart_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_vm_dependency_restart_condition", value)

    @property
    @pulumi.getter(name="haVmFailureInterval")
    def ha_vm_failure_interval(self) -> Optional[pulumi.Input[int]]:
        """
        If a heartbeat from a virtual machine is not received within this configured interval, the virtual machine is marked as
        failed. The value is in seconds.
        """
        return pulumi.get(self, "ha_vm_failure_interval")

    @ha_vm_failure_interval.setter
    def ha_vm_failure_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_vm_failure_interval", value)

    @property
    @pulumi.getter(name="haVmMaximumFailureWindow")
    def ha_vm_maximum_failure_window(self) -> Optional[pulumi.Input[int]]:
        """
        The length of the reset window in which ha_vm_maximum_resets can operate. When this window expires, no more resets are
        attempted regardless of the setting configured in ha_vm_maximum_resets. -1 means no window, meaning an unlimited reset
        time is allotted.
        """
        return pulumi.get(self, "ha_vm_maximum_failure_window")

    @ha_vm_maximum_failure_window.setter
    def ha_vm_maximum_failure_window(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_vm_maximum_failure_window", value)

    @property
    @pulumi.getter(name="haVmMaximumResets")
    def ha_vm_maximum_resets(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of resets that HA will perform to a virtual machine when responding to a failure event.
        """
        return pulumi.get(self, "ha_vm_maximum_resets")

    @ha_vm_maximum_resets.setter
    def ha_vm_maximum_resets(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_vm_maximum_resets", value)

    @property
    @pulumi.getter(name="haVmMinimumUptime")
    def ha_vm_minimum_uptime(self) -> Optional[pulumi.Input[int]]:
        """
        The time, in seconds, that HA waits after powering on a virtual machine before monitoring for heartbeats.
        """
        return pulumi.get(self, "ha_vm_minimum_uptime")

    @ha_vm_minimum_uptime.setter
    def ha_vm_minimum_uptime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_vm_minimum_uptime", value)

    @property
    @pulumi.getter(name="haVmMonitoring")
    def ha_vm_monitoring(self) -> Optional[pulumi.Input[str]]:
        """
        The type of virtual machine monitoring to use when HA is enabled in the cluster. Can be one of vmMonitoringDisabled,
        vmMonitoringOnly, or vmAndAppMonitoring.
        """
        return pulumi.get(self, "ha_vm_monitoring")

    @ha_vm_monitoring.setter
    def ha_vm_monitoring(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_vm_monitoring", value)

    @property
    @pulumi.getter(name="haVmRestartAdditionalDelay")
    def ha_vm_restart_additional_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Additional delay in seconds after ready condition is met. A VM is considered ready at this point.
        """
        return pulumi.get(self, "ha_vm_restart_additional_delay")

    @ha_vm_restart_additional_delay.setter
    def ha_vm_restart_additional_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_vm_restart_additional_delay", value)

    @property
    @pulumi.getter(name="haVmRestartPriority")
    def ha_vm_restart_priority(self) -> Optional[pulumi.Input[str]]:
        """
        The default restart priority for affected VMs when vSphere detects a host failure. Can be one of lowest, low, medium,
        high, or highest.
        """
        return pulumi.get(self, "ha_vm_restart_priority")

    @ha_vm_restart_priority.setter
    def ha_vm_restart_priority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_vm_restart_priority", value)

    @property
    @pulumi.getter(name="haVmRestartTimeout")
    def ha_vm_restart_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum time, in seconds, that vSphere HA will wait for virtual machines in one priority to be ready before
        proceeding with the next priority.
        """
        return pulumi.get(self, "ha_vm_restart_timeout")

    @ha_vm_restart_timeout.setter
    def ha_vm_restart_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_vm_restart_timeout", value)

    @property
    @pulumi.getter(name="hostClusterExitTimeout")
    def host_cluster_exit_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout for each host maintenance mode operation when removing hosts from a cluster.
        """
        return pulumi.get(self, "host_cluster_exit_timeout")

    @host_cluster_exit_timeout.setter
    def host_cluster_exit_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "host_cluster_exit_timeout", value)

    @property
    @pulumi.getter(name="hostImage")
    def host_image(self) -> Optional[pulumi.Input['ComputeClusterHostImageArgs']]:
        """
        Details about the host image which should be applied to the cluster.
        """
        return pulumi.get(self, "host_image")

    @host_image.setter
    def host_image(self, value: Optional[pulumi.Input['ComputeClusterHostImageArgs']]):
        pulumi.set(self, "host_image", value)

    @property
    @pulumi.getter(name="hostManaged")
    def host_managed(self) -> Optional[pulumi.Input[bool]]:
        """
        Must be set if cluster enrollment is managed from host resource.
        """
        return pulumi.get(self, "host_managed")

    @host_managed.setter
    def host_managed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "host_managed", value)

    @property
    @pulumi.getter(name="hostSystemIds")
    def host_system_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The managed object IDs of the hosts to put in the cluster.
        """
        return pulumi.get(self, "host_system_ids")

    @host_system_ids.setter
    def host_system_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "host_system_ids", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="proactiveHaAutomationLevel")
    def proactive_ha_automation_level(self) -> Optional[pulumi.Input[str]]:
        """
        The DRS behavior for proactive HA recommendations. Can be one of Automated or Manual.
        """
        return pulumi.get(self, "proactive_ha_automation_level")

    @proactive_ha_automation_level.setter
    def proactive_ha_automation_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proactive_ha_automation_level", value)

    @property
    @pulumi.getter(name="proactiveHaEnabled")
    def proactive_ha_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables proactive HA, allowing for vSphere to get HA data from external providers and use DRS to perform remediation.
        """
        return pulumi.get(self, "proactive_ha_enabled")

    @proactive_ha_enabled.setter
    def proactive_ha_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "proactive_ha_enabled", value)

    @property
    @pulumi.getter(name="proactiveHaModerateRemediation")
    def proactive_ha_moderate_remediation(self) -> Optional[pulumi.Input[str]]:
        """
        The configured remediation for moderately degraded hosts. Can be one of MaintenanceMode or QuarantineMode. Note that
        this cannot be set to MaintenanceMode when proactive_ha_severe_remediation is set to QuarantineMode.
        """
        return pulumi.get(self, "proactive_ha_moderate_remediation")

    @proactive_ha_moderate_remediation.setter
    def proactive_ha_moderate_remediation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proactive_ha_moderate_remediation", value)

    @property
    @pulumi.getter(name="proactiveHaProviderIds")
    def proactive_ha_provider_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of IDs for health update providers configured for this cluster.
        """
        return pulumi.get(self, "proactive_ha_provider_ids")

    @proactive_ha_provider_ids.setter
    def proactive_ha_provider_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "proactive_ha_provider_ids", value)

    @property
    @pulumi.getter(name="proactiveHaSevereRemediation")
    def proactive_ha_severe_remediation(self) -> Optional[pulumi.Input[str]]:
        """
        The configured remediation for severely degraded hosts. Can be one of MaintenanceMode or QuarantineMode. Note that this
        cannot be set to QuarantineMode when proactive_ha_moderate_remediation is set to MaintenanceMode.
        """
        return pulumi.get(self, "proactive_ha_severe_remediation")

    @proactive_ha_severe_remediation.setter
    def proactive_ha_severe_remediation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proactive_ha_severe_remediation", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IDs of any tags to attach to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vsanCompressionEnabled")
    def vsan_compression_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the vSAN compression service is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_compression_enabled")

    @vsan_compression_enabled.setter
    def vsan_compression_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vsan_compression_enabled", value)

    @property
    @pulumi.getter(name="vsanDedupEnabled")
    def vsan_dedup_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the vSAN deduplication service is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_dedup_enabled")

    @vsan_dedup_enabled.setter
    def vsan_dedup_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vsan_dedup_enabled", value)

    @property
    @pulumi.getter(name="vsanDiskGroups")
    def vsan_disk_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanDiskGroupArgs']]]]:
        """
        A list of disk UUIDs to add to the vSAN cluster.
        """
        return pulumi.get(self, "vsan_disk_groups")

    @vsan_disk_groups.setter
    def vsan_disk_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanDiskGroupArgs']]]]):
        pulumi.set(self, "vsan_disk_groups", value)

    @property
    @pulumi.getter(name="vsanDitEncryptionEnabled")
    def vsan_dit_encryption_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the vSAN data-in-transit encryption is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_dit_encryption_enabled")

    @vsan_dit_encryption_enabled.setter
    def vsan_dit_encryption_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vsan_dit_encryption_enabled", value)

    @property
    @pulumi.getter(name="vsanDitRekeyInterval")
    def vsan_dit_rekey_interval(self) -> Optional[pulumi.Input[int]]:
        """
        When vsan_dit_encryption_enabled is enabled, sets the rekey interval of data-in-transit encryption (in minutes).
        """
        return pulumi.get(self, "vsan_dit_rekey_interval")

    @vsan_dit_rekey_interval.setter
    def vsan_dit_rekey_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vsan_dit_rekey_interval", value)

    @property
    @pulumi.getter(name="vsanEnabled")
    def vsan_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the vSAN service is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_enabled")

    @vsan_enabled.setter
    def vsan_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vsan_enabled", value)

    @property
    @pulumi.getter(name="vsanEsaEnabled")
    def vsan_esa_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the vSAN ESA service is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_esa_enabled")

    @vsan_esa_enabled.setter
    def vsan_esa_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vsan_esa_enabled", value)

    @property
    @pulumi.getter(name="vsanFaultDomains")
    def vsan_fault_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanFaultDomainArgs']]]]:
        """
        The configuration for vSAN fault domains.
        """
        return pulumi.get(self, "vsan_fault_domains")

    @vsan_fault_domains.setter
    def vsan_fault_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanFaultDomainArgs']]]]):
        pulumi.set(self, "vsan_fault_domains", value)

    @property
    @pulumi.getter(name="vsanNetworkDiagnosticModeEnabled")
    def vsan_network_diagnostic_mode_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the vSAN network diagnostic mode is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_network_diagnostic_mode_enabled")

    @vsan_network_diagnostic_mode_enabled.setter
    def vsan_network_diagnostic_mode_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vsan_network_diagnostic_mode_enabled", value)

    @property
    @pulumi.getter(name="vsanPerformanceEnabled")
    def vsan_performance_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the vSAN performance service is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_performance_enabled")

    @vsan_performance_enabled.setter
    def vsan_performance_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vsan_performance_enabled", value)

    @property
    @pulumi.getter(name="vsanRemoteDatastoreIds")
    def vsan_remote_datastore_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The managed object IDs of the vSAN datastore to be mounted on the cluster.
        """
        return pulumi.get(self, "vsan_remote_datastore_ids")

    @vsan_remote_datastore_ids.setter
    def vsan_remote_datastore_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vsan_remote_datastore_ids", value)

    @property
    @pulumi.getter(name="vsanStretchedCluster")
    def vsan_stretched_cluster(self) -> Optional[pulumi.Input['ComputeClusterVsanStretchedClusterArgs']]:
        """
        The configuration for stretched cluster.
        """
        return pulumi.get(self, "vsan_stretched_cluster")

    @vsan_stretched_cluster.setter
    def vsan_stretched_cluster(self, value: Optional[pulumi.Input['ComputeClusterVsanStretchedClusterArgs']]):
        pulumi.set(self, "vsan_stretched_cluster", value)

    @property
    @pulumi.getter(name="vsanUnmapEnabled")
    def vsan_unmap_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the vSAN unmap service is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_unmap_enabled")

    @vsan_unmap_enabled.setter
    def vsan_unmap_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vsan_unmap_enabled", value)

    @property
    @pulumi.getter(name="vsanVerboseModeEnabled")
    def vsan_verbose_mode_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the vSAN verbose mode is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_verbose_mode_enabled")

    @vsan_verbose_mode_enabled.setter
    def vsan_verbose_mode_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vsan_verbose_mode_enabled", value)


@pulumi.input_type
class _ComputeClusterState:
    def __init__(__self__, *,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 datacenter_id: Optional[pulumi.Input[str]] = None,
                 dpm_automation_level: Optional[pulumi.Input[str]] = None,
                 dpm_enabled: Optional[pulumi.Input[bool]] = None,
                 dpm_threshold: Optional[pulumi.Input[int]] = None,
                 drs_advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 drs_automation_level: Optional[pulumi.Input[str]] = None,
                 drs_enable_predictive_drs: Optional[pulumi.Input[bool]] = None,
                 drs_enable_vm_overrides: Optional[pulumi.Input[bool]] = None,
                 drs_enabled: Optional[pulumi.Input[bool]] = None,
                 drs_migration_threshold: Optional[pulumi.Input[int]] = None,
                 drs_scale_descendants_shares: Optional[pulumi.Input[str]] = None,
                 folder: Optional[pulumi.Input[str]] = None,
                 force_evacuate_on_destroy: Optional[pulumi.Input[bool]] = None,
                 ha_admission_control_failover_host_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ha_admission_control_host_failure_tolerance: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_performance_tolerance: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_policy: Optional[pulumi.Input[str]] = None,
                 ha_admission_control_resource_percentage_auto_compute: Optional[pulumi.Input[bool]] = None,
                 ha_admission_control_resource_percentage_cpu: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_resource_percentage_memory: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_slot_policy_explicit_cpu: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_slot_policy_explicit_memory: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_slot_policy_use_explicit_size: Optional[pulumi.Input[bool]] = None,
                 ha_advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ha_datastore_apd_recovery_action: Optional[pulumi.Input[str]] = None,
                 ha_datastore_apd_response: Optional[pulumi.Input[str]] = None,
                 ha_datastore_apd_response_delay: Optional[pulumi.Input[int]] = None,
                 ha_datastore_pdl_response: Optional[pulumi.Input[str]] = None,
                 ha_enabled: Optional[pulumi.Input[bool]] = None,
                 ha_heartbeat_datastore_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ha_heartbeat_datastore_policy: Optional[pulumi.Input[str]] = None,
                 ha_host_isolation_response: Optional[pulumi.Input[str]] = None,
                 ha_host_monitoring: Optional[pulumi.Input[str]] = None,
                 ha_vm_component_protection: Optional[pulumi.Input[str]] = None,
                 ha_vm_dependency_restart_condition: Optional[pulumi.Input[str]] = None,
                 ha_vm_failure_interval: Optional[pulumi.Input[int]] = None,
                 ha_vm_maximum_failure_window: Optional[pulumi.Input[int]] = None,
                 ha_vm_maximum_resets: Optional[pulumi.Input[int]] = None,
                 ha_vm_minimum_uptime: Optional[pulumi.Input[int]] = None,
                 ha_vm_monitoring: Optional[pulumi.Input[str]] = None,
                 ha_vm_restart_additional_delay: Optional[pulumi.Input[int]] = None,
                 ha_vm_restart_priority: Optional[pulumi.Input[str]] = None,
                 ha_vm_restart_timeout: Optional[pulumi.Input[int]] = None,
                 host_cluster_exit_timeout: Optional[pulumi.Input[int]] = None,
                 host_image: Optional[pulumi.Input['ComputeClusterHostImageArgs']] = None,
                 host_managed: Optional[pulumi.Input[bool]] = None,
                 host_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 proactive_ha_automation_level: Optional[pulumi.Input[str]] = None,
                 proactive_ha_enabled: Optional[pulumi.Input[bool]] = None,
                 proactive_ha_moderate_remediation: Optional[pulumi.Input[str]] = None,
                 proactive_ha_provider_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 proactive_ha_severe_remediation: Optional[pulumi.Input[str]] = None,
                 resource_pool_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vsan_compression_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_dedup_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_disk_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanDiskGroupArgs']]]] = None,
                 vsan_dit_encryption_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_dit_rekey_interval: Optional[pulumi.Input[int]] = None,
                 vsan_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_esa_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanFaultDomainArgs']]]] = None,
                 vsan_network_diagnostic_mode_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_performance_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_remote_datastore_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vsan_stretched_cluster: Optional[pulumi.Input['ComputeClusterVsanStretchedClusterArgs']] = None,
                 vsan_unmap_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_verbose_mode_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering ComputeCluster resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_attributes: A map of custom attribute ids to attribute
               value strings to set for the datastore cluster.
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter Server.
        :param pulumi.Input[str] datacenter_id: The managed object ID of
               the datacenter to create the cluster in. Forces a new resource if changed.
        :param pulumi.Input[str] dpm_automation_level: The automation level for host power operations in this cluster. Can be one of manual or automated.
        :param pulumi.Input[bool] dpm_enabled: Enable DPM support for DRS. This allows you to dynamically control the power of hosts depending on the needs of virtual
               machines in the cluster. Requires that DRS be enabled.
        :param pulumi.Input[int] dpm_threshold: A value between 1 and 5 indicating the threshold of load within the cluster that influences host power operations. This
               affects both power on and power off operations - a lower setting will tolerate more of a surplus/deficit than a higher
               setting.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] drs_advanced_options: Advanced configuration options for DRS and DPM.
        :param pulumi.Input[str] drs_automation_level: The default automation level for all virtual machines in this cluster. Can be one of manual, partiallyAutomated, or
               fullyAutomated.
        :param pulumi.Input[bool] drs_enable_predictive_drs: When true, enables DRS to use data from vRealize Operations Manager to make proactive DRS recommendations.
        :param pulumi.Input[bool] drs_enable_vm_overrides: When true, allows individual VM overrides within this cluster to be set.
        :param pulumi.Input[bool] drs_enabled: Enable DRS for this cluster.
        :param pulumi.Input[int] drs_migration_threshold: A value between 1 and 5 indicating the threshold of imbalance tolerated between hosts. A lower setting will tolerate
               more imbalance while a higher setting will tolerate less.
        :param pulumi.Input[str] drs_scale_descendants_shares: Enable scalable shares for all descendants of this cluster.
        :param pulumi.Input[str] folder: The relative path to a folder to put this cluster in.
               This is a path relative to the datacenter you are deploying the cluster to.
               Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
               The provider will place a cluster named `compute-cluster-test` in a
               host folder located at `/dc1/host/foo/bar`, with the final inventory path
               being `/dc1/host/foo/bar/datastore-cluster-test`.
        :param pulumi.Input[bool] force_evacuate_on_destroy: Force removal of all hosts in the cluster during destroy and make them standalone hosts. Use of this flag mainly exists
               for testing and is not recommended in normal use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ha_admission_control_failover_host_system_ids: When ha_admission_control_policy is failoverHosts, this defines the managed object IDs of hosts to use as dedicated
               failover hosts. These hosts are kept as available as possible - admission control will block access to the host, and DRS
               will ignore the host when making recommendations.
        :param pulumi.Input[int] ha_admission_control_host_failure_tolerance: The maximum number of failed hosts that admission control tolerates when making decisions on whether to permit virtual
               machine operations. The maximum is one less than the number of hosts in the cluster.
        :param pulumi.Input[int] ha_admission_control_performance_tolerance: The percentage of resource reduction that a cluster of VMs can tolerate in case of a failover. A value of 0 produces
               warnings only, whereas a value of 100 disables the setting.
        :param pulumi.Input[str] ha_admission_control_policy: The type of admission control policy to use with vSphere HA, which controls whether or not specific VM operations are
               permitted in the cluster in order to protect the reliability of the cluster. Can be one of resourcePercentage,
               slotPolicy, failoverHosts, or disabled. Note that disabling admission control is not recommended and can lead to service
               issues.
        :param pulumi.Input[bool] ha_admission_control_resource_percentage_auto_compute: When ha_admission_control_policy is resourcePercentage, automatically determine available resource percentages by
               subtracting the average number of host resources represented by the ha_admission_control_host_failure_tolerance setting
               from the total amount of resources in the cluster. Disable to supply user-defined values.
        :param pulumi.Input[int] ha_admission_control_resource_percentage_cpu: When ha_admission_control_policy is resourcePercentage, this controls the user-defined percentage of CPU resources in
               the cluster to reserve for failover.
        :param pulumi.Input[int] ha_admission_control_resource_percentage_memory: When ha_admission_control_policy is resourcePercentage, this controls the user-defined percentage of memory resources in
               the cluster to reserve for failover.
        :param pulumi.Input[int] ha_admission_control_slot_policy_explicit_cpu: When ha_admission_control_policy is slotPolicy, this controls the user-defined CPU slot size, in MHz.
        :param pulumi.Input[int] ha_admission_control_slot_policy_explicit_memory: When ha_admission_control_policy is slotPolicy, this controls the user-defined memory slot size, in MB.
        :param pulumi.Input[bool] ha_admission_control_slot_policy_use_explicit_size: When ha_admission_control_policy is slotPolicy, this setting controls whether or not you wish to supply explicit values
               to CPU and memory slot sizes. The default is to gather a automatic average based on all powered-on virtual machines
               currently in the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] ha_advanced_options: Advanced configuration options for vSphere HA.
        :param pulumi.Input[str] ha_datastore_apd_recovery_action: When ha_vm_component_protection is enabled, controls the action to take on virtual machines if an APD status on an
               affected datastore clears in the middle of an APD event. Can be one of none or reset.
        :param pulumi.Input[str] ha_datastore_apd_response: When ha_vm_component_protection is enabled, controls the action to take on virtual machines when the cluster has
               detected loss to all paths to a relevant datastore. Can be one of disabled, warning, restartConservative, or
               restartAggressive.
        :param pulumi.Input[int] ha_datastore_apd_response_delay: When ha_vm_component_protection is enabled, controls the delay in seconds to wait after an APD timeout event to execute
               the response action defined in ha_datastore_apd_response.
        :param pulumi.Input[str] ha_datastore_pdl_response: When ha_vm_component_protection is enabled, controls the action to take on virtual machines when the cluster has
               detected a permanent device loss to a relevant datastore. Can be one of disabled, warning, or restartAggressive.
        :param pulumi.Input[bool] ha_enabled: Enable vSphere HA for this cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ha_heartbeat_datastore_ids: The list of managed object IDs for preferred datastores to use for HA heartbeating. This setting is only useful when
               ha_heartbeat_datastore_policy is set to either userSelectedDs or allFeasibleDsWithUserPreference.
        :param pulumi.Input[str] ha_heartbeat_datastore_policy: The selection policy for HA heartbeat datastores. Can be one of allFeasibleDs, userSelectedDs, or
               allFeasibleDsWithUserPreference.
        :param pulumi.Input[str] ha_host_isolation_response: The action to take on virtual machines when a host has detected that it has been isolated from the rest of the cluster.
               Can be one of none, powerOff, or shutdown.
        :param pulumi.Input[str] ha_host_monitoring: Global setting that controls whether vSphere HA remediates VMs on host failure. Can be one of enabled or disabled.
        :param pulumi.Input[str] ha_vm_component_protection: Controls vSphere VM component protection for virtual machines in this cluster. This allows vSphere HA to react to
               failures between hosts and specific virtual machine components, such as datastores. Can be one of enabled or disabled.
        :param pulumi.Input[str] ha_vm_dependency_restart_condition: The condition used to determine whether or not VMs in a certain restart priority class are online, allowing HA to move
               on to restarting VMs on the next priority. Can be one of none, poweredOn, guestHbStatusGreen, or appHbStatusGreen.
        :param pulumi.Input[int] ha_vm_failure_interval: If a heartbeat from a virtual machine is not received within this configured interval, the virtual machine is marked as
               failed. The value is in seconds.
        :param pulumi.Input[int] ha_vm_maximum_failure_window: The length of the reset window in which ha_vm_maximum_resets can operate. When this window expires, no more resets are
               attempted regardless of the setting configured in ha_vm_maximum_resets. -1 means no window, meaning an unlimited reset
               time is allotted.
        :param pulumi.Input[int] ha_vm_maximum_resets: The maximum number of resets that HA will perform to a virtual machine when responding to a failure event.
        :param pulumi.Input[int] ha_vm_minimum_uptime: The time, in seconds, that HA waits after powering on a virtual machine before monitoring for heartbeats.
        :param pulumi.Input[str] ha_vm_monitoring: The type of virtual machine monitoring to use when HA is enabled in the cluster. Can be one of vmMonitoringDisabled,
               vmMonitoringOnly, or vmAndAppMonitoring.
        :param pulumi.Input[int] ha_vm_restart_additional_delay: Additional delay in seconds after ready condition is met. A VM is considered ready at this point.
        :param pulumi.Input[str] ha_vm_restart_priority: The default restart priority for affected VMs when vSphere detects a host failure. Can be one of lowest, low, medium,
               high, or highest.
        :param pulumi.Input[int] ha_vm_restart_timeout: The maximum time, in seconds, that vSphere HA will wait for virtual machines in one priority to be ready before
               proceeding with the next priority.
        :param pulumi.Input[int] host_cluster_exit_timeout: The timeout for each host maintenance mode operation when removing hosts from a cluster.
        :param pulumi.Input['ComputeClusterHostImageArgs'] host_image: Details about the host image which should be applied to the cluster.
        :param pulumi.Input[bool] host_managed: Must be set if cluster enrollment is managed from host resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_system_ids: The managed object IDs of the hosts to put in the cluster.
        :param pulumi.Input[str] name: The name of the cluster.
        :param pulumi.Input[str] proactive_ha_automation_level: The DRS behavior for proactive HA recommendations. Can be one of Automated or Manual.
        :param pulumi.Input[bool] proactive_ha_enabled: Enables proactive HA, allowing for vSphere to get HA data from external providers and use DRS to perform remediation.
        :param pulumi.Input[str] proactive_ha_moderate_remediation: The configured remediation for moderately degraded hosts. Can be one of MaintenanceMode or QuarantineMode. Note that
               this cannot be set to MaintenanceMode when proactive_ha_severe_remediation is set to QuarantineMode.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] proactive_ha_provider_ids: The list of IDs for health update providers configured for this cluster.
        :param pulumi.Input[str] proactive_ha_severe_remediation: The configured remediation for severely degraded hosts. Can be one of MaintenanceMode or QuarantineMode. Note that this
               cannot be set to QuarantineMode when proactive_ha_moderate_remediation is set to MaintenanceMode.
        :param pulumi.Input[str] resource_pool_id: The managed object ID of the primary
               resource pool for this cluster. This can be passed directly to the
               `resource_pool_id`
               attribute of the
               `VirtualMachine` resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The IDs of any tags to attach to this resource.
        :param pulumi.Input[bool] vsan_compression_enabled: Whether the vSAN compression service is enabled for the cluster.
        :param pulumi.Input[bool] vsan_dedup_enabled: Whether the vSAN deduplication service is enabled for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanDiskGroupArgs']]] vsan_disk_groups: A list of disk UUIDs to add to the vSAN cluster.
        :param pulumi.Input[bool] vsan_dit_encryption_enabled: Whether the vSAN data-in-transit encryption is enabled for the cluster.
        :param pulumi.Input[int] vsan_dit_rekey_interval: When vsan_dit_encryption_enabled is enabled, sets the rekey interval of data-in-transit encryption (in minutes).
        :param pulumi.Input[bool] vsan_enabled: Whether the vSAN service is enabled for the cluster.
        :param pulumi.Input[bool] vsan_esa_enabled: Whether the vSAN ESA service is enabled for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanFaultDomainArgs']]] vsan_fault_domains: The configuration for vSAN fault domains.
        :param pulumi.Input[bool] vsan_network_diagnostic_mode_enabled: Whether the vSAN network diagnostic mode is enabled for the cluster.
        :param pulumi.Input[bool] vsan_performance_enabled: Whether the vSAN performance service is enabled for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vsan_remote_datastore_ids: The managed object IDs of the vSAN datastore to be mounted on the cluster.
        :param pulumi.Input['ComputeClusterVsanStretchedClusterArgs'] vsan_stretched_cluster: The configuration for stretched cluster.
        :param pulumi.Input[bool] vsan_unmap_enabled: Whether the vSAN unmap service is enabled for the cluster.
        :param pulumi.Input[bool] vsan_verbose_mode_enabled: Whether the vSAN verbose mode is enabled for the cluster.
        """
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if datacenter_id is not None:
            pulumi.set(__self__, "datacenter_id", datacenter_id)
        if dpm_automation_level is not None:
            pulumi.set(__self__, "dpm_automation_level", dpm_automation_level)
        if dpm_enabled is not None:
            pulumi.set(__self__, "dpm_enabled", dpm_enabled)
        if dpm_threshold is not None:
            pulumi.set(__self__, "dpm_threshold", dpm_threshold)
        if drs_advanced_options is not None:
            pulumi.set(__self__, "drs_advanced_options", drs_advanced_options)
        if drs_automation_level is not None:
            pulumi.set(__self__, "drs_automation_level", drs_automation_level)
        if drs_enable_predictive_drs is not None:
            pulumi.set(__self__, "drs_enable_predictive_drs", drs_enable_predictive_drs)
        if drs_enable_vm_overrides is not None:
            pulumi.set(__self__, "drs_enable_vm_overrides", drs_enable_vm_overrides)
        if drs_enabled is not None:
            pulumi.set(__self__, "drs_enabled", drs_enabled)
        if drs_migration_threshold is not None:
            pulumi.set(__self__, "drs_migration_threshold", drs_migration_threshold)
        if drs_scale_descendants_shares is not None:
            pulumi.set(__self__, "drs_scale_descendants_shares", drs_scale_descendants_shares)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if force_evacuate_on_destroy is not None:
            pulumi.set(__self__, "force_evacuate_on_destroy", force_evacuate_on_destroy)
        if ha_admission_control_failover_host_system_ids is not None:
            pulumi.set(__self__, "ha_admission_control_failover_host_system_ids", ha_admission_control_failover_host_system_ids)
        if ha_admission_control_host_failure_tolerance is not None:
            pulumi.set(__self__, "ha_admission_control_host_failure_tolerance", ha_admission_control_host_failure_tolerance)
        if ha_admission_control_performance_tolerance is not None:
            pulumi.set(__self__, "ha_admission_control_performance_tolerance", ha_admission_control_performance_tolerance)
        if ha_admission_control_policy is not None:
            pulumi.set(__self__, "ha_admission_control_policy", ha_admission_control_policy)
        if ha_admission_control_resource_percentage_auto_compute is not None:
            pulumi.set(__self__, "ha_admission_control_resource_percentage_auto_compute", ha_admission_control_resource_percentage_auto_compute)
        if ha_admission_control_resource_percentage_cpu is not None:
            pulumi.set(__self__, "ha_admission_control_resource_percentage_cpu", ha_admission_control_resource_percentage_cpu)
        if ha_admission_control_resource_percentage_memory is not None:
            pulumi.set(__self__, "ha_admission_control_resource_percentage_memory", ha_admission_control_resource_percentage_memory)
        if ha_admission_control_slot_policy_explicit_cpu is not None:
            pulumi.set(__self__, "ha_admission_control_slot_policy_explicit_cpu", ha_admission_control_slot_policy_explicit_cpu)
        if ha_admission_control_slot_policy_explicit_memory is not None:
            pulumi.set(__self__, "ha_admission_control_slot_policy_explicit_memory", ha_admission_control_slot_policy_explicit_memory)
        if ha_admission_control_slot_policy_use_explicit_size is not None:
            pulumi.set(__self__, "ha_admission_control_slot_policy_use_explicit_size", ha_admission_control_slot_policy_use_explicit_size)
        if ha_advanced_options is not None:
            pulumi.set(__self__, "ha_advanced_options", ha_advanced_options)
        if ha_datastore_apd_recovery_action is not None:
            pulumi.set(__self__, "ha_datastore_apd_recovery_action", ha_datastore_apd_recovery_action)
        if ha_datastore_apd_response is not None:
            pulumi.set(__self__, "ha_datastore_apd_response", ha_datastore_apd_response)
        if ha_datastore_apd_response_delay is not None:
            pulumi.set(__self__, "ha_datastore_apd_response_delay", ha_datastore_apd_response_delay)
        if ha_datastore_pdl_response is not None:
            pulumi.set(__self__, "ha_datastore_pdl_response", ha_datastore_pdl_response)
        if ha_enabled is not None:
            pulumi.set(__self__, "ha_enabled", ha_enabled)
        if ha_heartbeat_datastore_ids is not None:
            pulumi.set(__self__, "ha_heartbeat_datastore_ids", ha_heartbeat_datastore_ids)
        if ha_heartbeat_datastore_policy is not None:
            pulumi.set(__self__, "ha_heartbeat_datastore_policy", ha_heartbeat_datastore_policy)
        if ha_host_isolation_response is not None:
            pulumi.set(__self__, "ha_host_isolation_response", ha_host_isolation_response)
        if ha_host_monitoring is not None:
            pulumi.set(__self__, "ha_host_monitoring", ha_host_monitoring)
        if ha_vm_component_protection is not None:
            pulumi.set(__self__, "ha_vm_component_protection", ha_vm_component_protection)
        if ha_vm_dependency_restart_condition is not None:
            pulumi.set(__self__, "ha_vm_dependency_restart_condition", ha_vm_dependency_restart_condition)
        if ha_vm_failure_interval is not None:
            pulumi.set(__self__, "ha_vm_failure_interval", ha_vm_failure_interval)
        if ha_vm_maximum_failure_window is not None:
            pulumi.set(__self__, "ha_vm_maximum_failure_window", ha_vm_maximum_failure_window)
        if ha_vm_maximum_resets is not None:
            pulumi.set(__self__, "ha_vm_maximum_resets", ha_vm_maximum_resets)
        if ha_vm_minimum_uptime is not None:
            pulumi.set(__self__, "ha_vm_minimum_uptime", ha_vm_minimum_uptime)
        if ha_vm_monitoring is not None:
            pulumi.set(__self__, "ha_vm_monitoring", ha_vm_monitoring)
        if ha_vm_restart_additional_delay is not None:
            pulumi.set(__self__, "ha_vm_restart_additional_delay", ha_vm_restart_additional_delay)
        if ha_vm_restart_priority is not None:
            pulumi.set(__self__, "ha_vm_restart_priority", ha_vm_restart_priority)
        if ha_vm_restart_timeout is not None:
            pulumi.set(__self__, "ha_vm_restart_timeout", ha_vm_restart_timeout)
        if host_cluster_exit_timeout is not None:
            pulumi.set(__self__, "host_cluster_exit_timeout", host_cluster_exit_timeout)
        if host_image is not None:
            pulumi.set(__self__, "host_image", host_image)
        if host_managed is not None:
            pulumi.set(__self__, "host_managed", host_managed)
        if host_system_ids is not None:
            pulumi.set(__self__, "host_system_ids", host_system_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if proactive_ha_automation_level is not None:
            pulumi.set(__self__, "proactive_ha_automation_level", proactive_ha_automation_level)
        if proactive_ha_enabled is not None:
            pulumi.set(__self__, "proactive_ha_enabled", proactive_ha_enabled)
        if proactive_ha_moderate_remediation is not None:
            pulumi.set(__self__, "proactive_ha_moderate_remediation", proactive_ha_moderate_remediation)
        if proactive_ha_provider_ids is not None:
            pulumi.set(__self__, "proactive_ha_provider_ids", proactive_ha_provider_ids)
        if proactive_ha_severe_remediation is not None:
            pulumi.set(__self__, "proactive_ha_severe_remediation", proactive_ha_severe_remediation)
        if resource_pool_id is not None:
            pulumi.set(__self__, "resource_pool_id", resource_pool_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vsan_compression_enabled is not None:
            pulumi.set(__self__, "vsan_compression_enabled", vsan_compression_enabled)
        if vsan_dedup_enabled is not None:
            pulumi.set(__self__, "vsan_dedup_enabled", vsan_dedup_enabled)
        if vsan_disk_groups is not None:
            pulumi.set(__self__, "vsan_disk_groups", vsan_disk_groups)
        if vsan_dit_encryption_enabled is not None:
            pulumi.set(__self__, "vsan_dit_encryption_enabled", vsan_dit_encryption_enabled)
        if vsan_dit_rekey_interval is not None:
            pulumi.set(__self__, "vsan_dit_rekey_interval", vsan_dit_rekey_interval)
        if vsan_enabled is not None:
            pulumi.set(__self__, "vsan_enabled", vsan_enabled)
        if vsan_esa_enabled is not None:
            pulumi.set(__self__, "vsan_esa_enabled", vsan_esa_enabled)
        if vsan_fault_domains is not None:
            pulumi.set(__self__, "vsan_fault_domains", vsan_fault_domains)
        if vsan_network_diagnostic_mode_enabled is not None:
            pulumi.set(__self__, "vsan_network_diagnostic_mode_enabled", vsan_network_diagnostic_mode_enabled)
        if vsan_performance_enabled is not None:
            pulumi.set(__self__, "vsan_performance_enabled", vsan_performance_enabled)
        if vsan_remote_datastore_ids is not None:
            pulumi.set(__self__, "vsan_remote_datastore_ids", vsan_remote_datastore_ids)
        if vsan_stretched_cluster is not None:
            pulumi.set(__self__, "vsan_stretched_cluster", vsan_stretched_cluster)
        if vsan_unmap_enabled is not None:
            pulumi.set(__self__, "vsan_unmap_enabled", vsan_unmap_enabled)
        if vsan_verbose_mode_enabled is not None:
            pulumi.set(__self__, "vsan_verbose_mode_enabled", vsan_verbose_mode_enabled)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of custom attribute ids to attribute
        value strings to set for the datastore cluster.

        > **NOTE:** Custom attributes are unsupported on direct ESXi connections
        and require vCenter Server.
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "custom_attributes", value)

    @property
    @pulumi.getter(name="datacenterId")
    def datacenter_id(self) -> Optional[pulumi.Input[str]]:
        """
        The managed object ID of
        the datacenter to create the cluster in. Forces a new resource if changed.
        """
        return pulumi.get(self, "datacenter_id")

    @datacenter_id.setter
    def datacenter_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datacenter_id", value)

    @property
    @pulumi.getter(name="dpmAutomationLevel")
    def dpm_automation_level(self) -> Optional[pulumi.Input[str]]:
        """
        The automation level for host power operations in this cluster. Can be one of manual or automated.
        """
        return pulumi.get(self, "dpm_automation_level")

    @dpm_automation_level.setter
    def dpm_automation_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dpm_automation_level", value)

    @property
    @pulumi.getter(name="dpmEnabled")
    def dpm_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable DPM support for DRS. This allows you to dynamically control the power of hosts depending on the needs of virtual
        machines in the cluster. Requires that DRS be enabled.
        """
        return pulumi.get(self, "dpm_enabled")

    @dpm_enabled.setter
    def dpm_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dpm_enabled", value)

    @property
    @pulumi.getter(name="dpmThreshold")
    def dpm_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        A value between 1 and 5 indicating the threshold of load within the cluster that influences host power operations. This
        affects both power on and power off operations - a lower setting will tolerate more of a surplus/deficit than a higher
        setting.
        """
        return pulumi.get(self, "dpm_threshold")

    @dpm_threshold.setter
    def dpm_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "dpm_threshold", value)

    @property
    @pulumi.getter(name="drsAdvancedOptions")
    def drs_advanced_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Advanced configuration options for DRS and DPM.
        """
        return pulumi.get(self, "drs_advanced_options")

    @drs_advanced_options.setter
    def drs_advanced_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "drs_advanced_options", value)

    @property
    @pulumi.getter(name="drsAutomationLevel")
    def drs_automation_level(self) -> Optional[pulumi.Input[str]]:
        """
        The default automation level for all virtual machines in this cluster. Can be one of manual, partiallyAutomated, or
        fullyAutomated.
        """
        return pulumi.get(self, "drs_automation_level")

    @drs_automation_level.setter
    def drs_automation_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "drs_automation_level", value)

    @property
    @pulumi.getter(name="drsEnablePredictiveDrs")
    def drs_enable_predictive_drs(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, enables DRS to use data from vRealize Operations Manager to make proactive DRS recommendations.
        """
        return pulumi.get(self, "drs_enable_predictive_drs")

    @drs_enable_predictive_drs.setter
    def drs_enable_predictive_drs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drs_enable_predictive_drs", value)

    @property
    @pulumi.getter(name="drsEnableVmOverrides")
    def drs_enable_vm_overrides(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, allows individual VM overrides within this cluster to be set.
        """
        return pulumi.get(self, "drs_enable_vm_overrides")

    @drs_enable_vm_overrides.setter
    def drs_enable_vm_overrides(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drs_enable_vm_overrides", value)

    @property
    @pulumi.getter(name="drsEnabled")
    def drs_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable DRS for this cluster.
        """
        return pulumi.get(self, "drs_enabled")

    @drs_enabled.setter
    def drs_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drs_enabled", value)

    @property
    @pulumi.getter(name="drsMigrationThreshold")
    def drs_migration_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        A value between 1 and 5 indicating the threshold of imbalance tolerated between hosts. A lower setting will tolerate
        more imbalance while a higher setting will tolerate less.
        """
        return pulumi.get(self, "drs_migration_threshold")

    @drs_migration_threshold.setter
    def drs_migration_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "drs_migration_threshold", value)

    @property
    @pulumi.getter(name="drsScaleDescendantsShares")
    def drs_scale_descendants_shares(self) -> Optional[pulumi.Input[str]]:
        """
        Enable scalable shares for all descendants of this cluster.
        """
        return pulumi.get(self, "drs_scale_descendants_shares")

    @drs_scale_descendants_shares.setter
    def drs_scale_descendants_shares(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "drs_scale_descendants_shares", value)

    @property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[str]]:
        """
        The relative path to a folder to put this cluster in.
        This is a path relative to the datacenter you are deploying the cluster to.
        Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
        The provider will place a cluster named `compute-cluster-test` in a
        host folder located at `/dc1/host/foo/bar`, with the final inventory path
        being `/dc1/host/foo/bar/datastore-cluster-test`.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter(name="forceEvacuateOnDestroy")
    def force_evacuate_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Force removal of all hosts in the cluster during destroy and make them standalone hosts. Use of this flag mainly exists
        for testing and is not recommended in normal use.
        """
        return pulumi.get(self, "force_evacuate_on_destroy")

    @force_evacuate_on_destroy.setter
    def force_evacuate_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_evacuate_on_destroy", value)

    @property
    @pulumi.getter(name="haAdmissionControlFailoverHostSystemIds")
    def ha_admission_control_failover_host_system_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        When ha_admission_control_policy is failoverHosts, this defines the managed object IDs of hosts to use as dedicated
        failover hosts. These hosts are kept as available as possible - admission control will block access to the host, and DRS
        will ignore the host when making recommendations.
        """
        return pulumi.get(self, "ha_admission_control_failover_host_system_ids")

    @ha_admission_control_failover_host_system_ids.setter
    def ha_admission_control_failover_host_system_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ha_admission_control_failover_host_system_ids", value)

    @property
    @pulumi.getter(name="haAdmissionControlHostFailureTolerance")
    def ha_admission_control_host_failure_tolerance(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of failed hosts that admission control tolerates when making decisions on whether to permit virtual
        machine operations. The maximum is one less than the number of hosts in the cluster.
        """
        return pulumi.get(self, "ha_admission_control_host_failure_tolerance")

    @ha_admission_control_host_failure_tolerance.setter
    def ha_admission_control_host_failure_tolerance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_admission_control_host_failure_tolerance", value)

    @property
    @pulumi.getter(name="haAdmissionControlPerformanceTolerance")
    def ha_admission_control_performance_tolerance(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage of resource reduction that a cluster of VMs can tolerate in case of a failover. A value of 0 produces
        warnings only, whereas a value of 100 disables the setting.
        """
        return pulumi.get(self, "ha_admission_control_performance_tolerance")

    @ha_admission_control_performance_tolerance.setter
    def ha_admission_control_performance_tolerance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_admission_control_performance_tolerance", value)

    @property
    @pulumi.getter(name="haAdmissionControlPolicy")
    def ha_admission_control_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The type of admission control policy to use with vSphere HA, which controls whether or not specific VM operations are
        permitted in the cluster in order to protect the reliability of the cluster. Can be one of resourcePercentage,
        slotPolicy, failoverHosts, or disabled. Note that disabling admission control is not recommended and can lead to service
        issues.
        """
        return pulumi.get(self, "ha_admission_control_policy")

    @ha_admission_control_policy.setter
    def ha_admission_control_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_admission_control_policy", value)

    @property
    @pulumi.getter(name="haAdmissionControlResourcePercentageAutoCompute")
    def ha_admission_control_resource_percentage_auto_compute(self) -> Optional[pulumi.Input[bool]]:
        """
        When ha_admission_control_policy is resourcePercentage, automatically determine available resource percentages by
        subtracting the average number of host resources represented by the ha_admission_control_host_failure_tolerance setting
        from the total amount of resources in the cluster. Disable to supply user-defined values.
        """
        return pulumi.get(self, "ha_admission_control_resource_percentage_auto_compute")

    @ha_admission_control_resource_percentage_auto_compute.setter
    def ha_admission_control_resource_percentage_auto_compute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ha_admission_control_resource_percentage_auto_compute", value)

    @property
    @pulumi.getter(name="haAdmissionControlResourcePercentageCpu")
    def ha_admission_control_resource_percentage_cpu(self) -> Optional[pulumi.Input[int]]:
        """
        When ha_admission_control_policy is resourcePercentage, this controls the user-defined percentage of CPU resources in
        the cluster to reserve for failover.
        """
        return pulumi.get(self, "ha_admission_control_resource_percentage_cpu")

    @ha_admission_control_resource_percentage_cpu.setter
    def ha_admission_control_resource_percentage_cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_admission_control_resource_percentage_cpu", value)

    @property
    @pulumi.getter(name="haAdmissionControlResourcePercentageMemory")
    def ha_admission_control_resource_percentage_memory(self) -> Optional[pulumi.Input[int]]:
        """
        When ha_admission_control_policy is resourcePercentage, this controls the user-defined percentage of memory resources in
        the cluster to reserve for failover.
        """
        return pulumi.get(self, "ha_admission_control_resource_percentage_memory")

    @ha_admission_control_resource_percentage_memory.setter
    def ha_admission_control_resource_percentage_memory(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_admission_control_resource_percentage_memory", value)

    @property
    @pulumi.getter(name="haAdmissionControlSlotPolicyExplicitCpu")
    def ha_admission_control_slot_policy_explicit_cpu(self) -> Optional[pulumi.Input[int]]:
        """
        When ha_admission_control_policy is slotPolicy, this controls the user-defined CPU slot size, in MHz.
        """
        return pulumi.get(self, "ha_admission_control_slot_policy_explicit_cpu")

    @ha_admission_control_slot_policy_explicit_cpu.setter
    def ha_admission_control_slot_policy_explicit_cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_admission_control_slot_policy_explicit_cpu", value)

    @property
    @pulumi.getter(name="haAdmissionControlSlotPolicyExplicitMemory")
    def ha_admission_control_slot_policy_explicit_memory(self) -> Optional[pulumi.Input[int]]:
        """
        When ha_admission_control_policy is slotPolicy, this controls the user-defined memory slot size, in MB.
        """
        return pulumi.get(self, "ha_admission_control_slot_policy_explicit_memory")

    @ha_admission_control_slot_policy_explicit_memory.setter
    def ha_admission_control_slot_policy_explicit_memory(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_admission_control_slot_policy_explicit_memory", value)

    @property
    @pulumi.getter(name="haAdmissionControlSlotPolicyUseExplicitSize")
    def ha_admission_control_slot_policy_use_explicit_size(self) -> Optional[pulumi.Input[bool]]:
        """
        When ha_admission_control_policy is slotPolicy, this setting controls whether or not you wish to supply explicit values
        to CPU and memory slot sizes. The default is to gather a automatic average based on all powered-on virtual machines
        currently in the cluster.
        """
        return pulumi.get(self, "ha_admission_control_slot_policy_use_explicit_size")

    @ha_admission_control_slot_policy_use_explicit_size.setter
    def ha_admission_control_slot_policy_use_explicit_size(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ha_admission_control_slot_policy_use_explicit_size", value)

    @property
    @pulumi.getter(name="haAdvancedOptions")
    def ha_advanced_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Advanced configuration options for vSphere HA.
        """
        return pulumi.get(self, "ha_advanced_options")

    @ha_advanced_options.setter
    def ha_advanced_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "ha_advanced_options", value)

    @property
    @pulumi.getter(name="haDatastoreApdRecoveryAction")
    def ha_datastore_apd_recovery_action(self) -> Optional[pulumi.Input[str]]:
        """
        When ha_vm_component_protection is enabled, controls the action to take on virtual machines if an APD status on an
        affected datastore clears in the middle of an APD event. Can be one of none or reset.
        """
        return pulumi.get(self, "ha_datastore_apd_recovery_action")

    @ha_datastore_apd_recovery_action.setter
    def ha_datastore_apd_recovery_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_datastore_apd_recovery_action", value)

    @property
    @pulumi.getter(name="haDatastoreApdResponse")
    def ha_datastore_apd_response(self) -> Optional[pulumi.Input[str]]:
        """
        When ha_vm_component_protection is enabled, controls the action to take on virtual machines when the cluster has
        detected loss to all paths to a relevant datastore. Can be one of disabled, warning, restartConservative, or
        restartAggressive.
        """
        return pulumi.get(self, "ha_datastore_apd_response")

    @ha_datastore_apd_response.setter
    def ha_datastore_apd_response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_datastore_apd_response", value)

    @property
    @pulumi.getter(name="haDatastoreApdResponseDelay")
    def ha_datastore_apd_response_delay(self) -> Optional[pulumi.Input[int]]:
        """
        When ha_vm_component_protection is enabled, controls the delay in seconds to wait after an APD timeout event to execute
        the response action defined in ha_datastore_apd_response.
        """
        return pulumi.get(self, "ha_datastore_apd_response_delay")

    @ha_datastore_apd_response_delay.setter
    def ha_datastore_apd_response_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_datastore_apd_response_delay", value)

    @property
    @pulumi.getter(name="haDatastorePdlResponse")
    def ha_datastore_pdl_response(self) -> Optional[pulumi.Input[str]]:
        """
        When ha_vm_component_protection is enabled, controls the action to take on virtual machines when the cluster has
        detected a permanent device loss to a relevant datastore. Can be one of disabled, warning, or restartAggressive.
        """
        return pulumi.get(self, "ha_datastore_pdl_response")

    @ha_datastore_pdl_response.setter
    def ha_datastore_pdl_response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_datastore_pdl_response", value)

    @property
    @pulumi.getter(name="haEnabled")
    def ha_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable vSphere HA for this cluster.
        """
        return pulumi.get(self, "ha_enabled")

    @ha_enabled.setter
    def ha_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ha_enabled", value)

    @property
    @pulumi.getter(name="haHeartbeatDatastoreIds")
    def ha_heartbeat_datastore_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of managed object IDs for preferred datastores to use for HA heartbeating. This setting is only useful when
        ha_heartbeat_datastore_policy is set to either userSelectedDs or allFeasibleDsWithUserPreference.
        """
        return pulumi.get(self, "ha_heartbeat_datastore_ids")

    @ha_heartbeat_datastore_ids.setter
    def ha_heartbeat_datastore_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ha_heartbeat_datastore_ids", value)

    @property
    @pulumi.getter(name="haHeartbeatDatastorePolicy")
    def ha_heartbeat_datastore_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The selection policy for HA heartbeat datastores. Can be one of allFeasibleDs, userSelectedDs, or
        allFeasibleDsWithUserPreference.
        """
        return pulumi.get(self, "ha_heartbeat_datastore_policy")

    @ha_heartbeat_datastore_policy.setter
    def ha_heartbeat_datastore_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_heartbeat_datastore_policy", value)

    @property
    @pulumi.getter(name="haHostIsolationResponse")
    def ha_host_isolation_response(self) -> Optional[pulumi.Input[str]]:
        """
        The action to take on virtual machines when a host has detected that it has been isolated from the rest of the cluster.
        Can be one of none, powerOff, or shutdown.
        """
        return pulumi.get(self, "ha_host_isolation_response")

    @ha_host_isolation_response.setter
    def ha_host_isolation_response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_host_isolation_response", value)

    @property
    @pulumi.getter(name="haHostMonitoring")
    def ha_host_monitoring(self) -> Optional[pulumi.Input[str]]:
        """
        Global setting that controls whether vSphere HA remediates VMs on host failure. Can be one of enabled or disabled.
        """
        return pulumi.get(self, "ha_host_monitoring")

    @ha_host_monitoring.setter
    def ha_host_monitoring(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_host_monitoring", value)

    @property
    @pulumi.getter(name="haVmComponentProtection")
    def ha_vm_component_protection(self) -> Optional[pulumi.Input[str]]:
        """
        Controls vSphere VM component protection for virtual machines in this cluster. This allows vSphere HA to react to
        failures between hosts and specific virtual machine components, such as datastores. Can be one of enabled or disabled.
        """
        return pulumi.get(self, "ha_vm_component_protection")

    @ha_vm_component_protection.setter
    def ha_vm_component_protection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_vm_component_protection", value)

    @property
    @pulumi.getter(name="haVmDependencyRestartCondition")
    def ha_vm_dependency_restart_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The condition used to determine whether or not VMs in a certain restart priority class are online, allowing HA to move
        on to restarting VMs on the next priority. Can be one of none, poweredOn, guestHbStatusGreen, or appHbStatusGreen.
        """
        return pulumi.get(self, "ha_vm_dependency_restart_condition")

    @ha_vm_dependency_restart_condition.setter
    def ha_vm_dependency_restart_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_vm_dependency_restart_condition", value)

    @property
    @pulumi.getter(name="haVmFailureInterval")
    def ha_vm_failure_interval(self) -> Optional[pulumi.Input[int]]:
        """
        If a heartbeat from a virtual machine is not received within this configured interval, the virtual machine is marked as
        failed. The value is in seconds.
        """
        return pulumi.get(self, "ha_vm_failure_interval")

    @ha_vm_failure_interval.setter
    def ha_vm_failure_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_vm_failure_interval", value)

    @property
    @pulumi.getter(name="haVmMaximumFailureWindow")
    def ha_vm_maximum_failure_window(self) -> Optional[pulumi.Input[int]]:
        """
        The length of the reset window in which ha_vm_maximum_resets can operate. When this window expires, no more resets are
        attempted regardless of the setting configured in ha_vm_maximum_resets. -1 means no window, meaning an unlimited reset
        time is allotted.
        """
        return pulumi.get(self, "ha_vm_maximum_failure_window")

    @ha_vm_maximum_failure_window.setter
    def ha_vm_maximum_failure_window(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_vm_maximum_failure_window", value)

    @property
    @pulumi.getter(name="haVmMaximumResets")
    def ha_vm_maximum_resets(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of resets that HA will perform to a virtual machine when responding to a failure event.
        """
        return pulumi.get(self, "ha_vm_maximum_resets")

    @ha_vm_maximum_resets.setter
    def ha_vm_maximum_resets(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_vm_maximum_resets", value)

    @property
    @pulumi.getter(name="haVmMinimumUptime")
    def ha_vm_minimum_uptime(self) -> Optional[pulumi.Input[int]]:
        """
        The time, in seconds, that HA waits after powering on a virtual machine before monitoring for heartbeats.
        """
        return pulumi.get(self, "ha_vm_minimum_uptime")

    @ha_vm_minimum_uptime.setter
    def ha_vm_minimum_uptime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_vm_minimum_uptime", value)

    @property
    @pulumi.getter(name="haVmMonitoring")
    def ha_vm_monitoring(self) -> Optional[pulumi.Input[str]]:
        """
        The type of virtual machine monitoring to use when HA is enabled in the cluster. Can be one of vmMonitoringDisabled,
        vmMonitoringOnly, or vmAndAppMonitoring.
        """
        return pulumi.get(self, "ha_vm_monitoring")

    @ha_vm_monitoring.setter
    def ha_vm_monitoring(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_vm_monitoring", value)

    @property
    @pulumi.getter(name="haVmRestartAdditionalDelay")
    def ha_vm_restart_additional_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Additional delay in seconds after ready condition is met. A VM is considered ready at this point.
        """
        return pulumi.get(self, "ha_vm_restart_additional_delay")

    @ha_vm_restart_additional_delay.setter
    def ha_vm_restart_additional_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_vm_restart_additional_delay", value)

    @property
    @pulumi.getter(name="haVmRestartPriority")
    def ha_vm_restart_priority(self) -> Optional[pulumi.Input[str]]:
        """
        The default restart priority for affected VMs when vSphere detects a host failure. Can be one of lowest, low, medium,
        high, or highest.
        """
        return pulumi.get(self, "ha_vm_restart_priority")

    @ha_vm_restart_priority.setter
    def ha_vm_restart_priority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_vm_restart_priority", value)

    @property
    @pulumi.getter(name="haVmRestartTimeout")
    def ha_vm_restart_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum time, in seconds, that vSphere HA will wait for virtual machines in one priority to be ready before
        proceeding with the next priority.
        """
        return pulumi.get(self, "ha_vm_restart_timeout")

    @ha_vm_restart_timeout.setter
    def ha_vm_restart_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_vm_restart_timeout", value)

    @property
    @pulumi.getter(name="hostClusterExitTimeout")
    def host_cluster_exit_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout for each host maintenance mode operation when removing hosts from a cluster.
        """
        return pulumi.get(self, "host_cluster_exit_timeout")

    @host_cluster_exit_timeout.setter
    def host_cluster_exit_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "host_cluster_exit_timeout", value)

    @property
    @pulumi.getter(name="hostImage")
    def host_image(self) -> Optional[pulumi.Input['ComputeClusterHostImageArgs']]:
        """
        Details about the host image which should be applied to the cluster.
        """
        return pulumi.get(self, "host_image")

    @host_image.setter
    def host_image(self, value: Optional[pulumi.Input['ComputeClusterHostImageArgs']]):
        pulumi.set(self, "host_image", value)

    @property
    @pulumi.getter(name="hostManaged")
    def host_managed(self) -> Optional[pulumi.Input[bool]]:
        """
        Must be set if cluster enrollment is managed from host resource.
        """
        return pulumi.get(self, "host_managed")

    @host_managed.setter
    def host_managed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "host_managed", value)

    @property
    @pulumi.getter(name="hostSystemIds")
    def host_system_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The managed object IDs of the hosts to put in the cluster.
        """
        return pulumi.get(self, "host_system_ids")

    @host_system_ids.setter
    def host_system_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "host_system_ids", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="proactiveHaAutomationLevel")
    def proactive_ha_automation_level(self) -> Optional[pulumi.Input[str]]:
        """
        The DRS behavior for proactive HA recommendations. Can be one of Automated or Manual.
        """
        return pulumi.get(self, "proactive_ha_automation_level")

    @proactive_ha_automation_level.setter
    def proactive_ha_automation_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proactive_ha_automation_level", value)

    @property
    @pulumi.getter(name="proactiveHaEnabled")
    def proactive_ha_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables proactive HA, allowing for vSphere to get HA data from external providers and use DRS to perform remediation.
        """
        return pulumi.get(self, "proactive_ha_enabled")

    @proactive_ha_enabled.setter
    def proactive_ha_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "proactive_ha_enabled", value)

    @property
    @pulumi.getter(name="proactiveHaModerateRemediation")
    def proactive_ha_moderate_remediation(self) -> Optional[pulumi.Input[str]]:
        """
        The configured remediation for moderately degraded hosts. Can be one of MaintenanceMode or QuarantineMode. Note that
        this cannot be set to MaintenanceMode when proactive_ha_severe_remediation is set to QuarantineMode.
        """
        return pulumi.get(self, "proactive_ha_moderate_remediation")

    @proactive_ha_moderate_remediation.setter
    def proactive_ha_moderate_remediation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proactive_ha_moderate_remediation", value)

    @property
    @pulumi.getter(name="proactiveHaProviderIds")
    def proactive_ha_provider_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of IDs for health update providers configured for this cluster.
        """
        return pulumi.get(self, "proactive_ha_provider_ids")

    @proactive_ha_provider_ids.setter
    def proactive_ha_provider_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "proactive_ha_provider_ids", value)

    @property
    @pulumi.getter(name="proactiveHaSevereRemediation")
    def proactive_ha_severe_remediation(self) -> Optional[pulumi.Input[str]]:
        """
        The configured remediation for severely degraded hosts. Can be one of MaintenanceMode or QuarantineMode. Note that this
        cannot be set to QuarantineMode when proactive_ha_moderate_remediation is set to MaintenanceMode.
        """
        return pulumi.get(self, "proactive_ha_severe_remediation")

    @proactive_ha_severe_remediation.setter
    def proactive_ha_severe_remediation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proactive_ha_severe_remediation", value)

    @property
    @pulumi.getter(name="resourcePoolId")
    def resource_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The managed object ID of the primary
        resource pool for this cluster. This can be passed directly to the
        `resource_pool_id`
        attribute of the
        `VirtualMachine` resource.
        """
        return pulumi.get(self, "resource_pool_id")

    @resource_pool_id.setter
    def resource_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_pool_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IDs of any tags to attach to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vsanCompressionEnabled")
    def vsan_compression_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the vSAN compression service is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_compression_enabled")

    @vsan_compression_enabled.setter
    def vsan_compression_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vsan_compression_enabled", value)

    @property
    @pulumi.getter(name="vsanDedupEnabled")
    def vsan_dedup_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the vSAN deduplication service is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_dedup_enabled")

    @vsan_dedup_enabled.setter
    def vsan_dedup_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vsan_dedup_enabled", value)

    @property
    @pulumi.getter(name="vsanDiskGroups")
    def vsan_disk_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanDiskGroupArgs']]]]:
        """
        A list of disk UUIDs to add to the vSAN cluster.
        """
        return pulumi.get(self, "vsan_disk_groups")

    @vsan_disk_groups.setter
    def vsan_disk_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanDiskGroupArgs']]]]):
        pulumi.set(self, "vsan_disk_groups", value)

    @property
    @pulumi.getter(name="vsanDitEncryptionEnabled")
    def vsan_dit_encryption_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the vSAN data-in-transit encryption is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_dit_encryption_enabled")

    @vsan_dit_encryption_enabled.setter
    def vsan_dit_encryption_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vsan_dit_encryption_enabled", value)

    @property
    @pulumi.getter(name="vsanDitRekeyInterval")
    def vsan_dit_rekey_interval(self) -> Optional[pulumi.Input[int]]:
        """
        When vsan_dit_encryption_enabled is enabled, sets the rekey interval of data-in-transit encryption (in minutes).
        """
        return pulumi.get(self, "vsan_dit_rekey_interval")

    @vsan_dit_rekey_interval.setter
    def vsan_dit_rekey_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vsan_dit_rekey_interval", value)

    @property
    @pulumi.getter(name="vsanEnabled")
    def vsan_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the vSAN service is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_enabled")

    @vsan_enabled.setter
    def vsan_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vsan_enabled", value)

    @property
    @pulumi.getter(name="vsanEsaEnabled")
    def vsan_esa_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the vSAN ESA service is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_esa_enabled")

    @vsan_esa_enabled.setter
    def vsan_esa_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vsan_esa_enabled", value)

    @property
    @pulumi.getter(name="vsanFaultDomains")
    def vsan_fault_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanFaultDomainArgs']]]]:
        """
        The configuration for vSAN fault domains.
        """
        return pulumi.get(self, "vsan_fault_domains")

    @vsan_fault_domains.setter
    def vsan_fault_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeClusterVsanFaultDomainArgs']]]]):
        pulumi.set(self, "vsan_fault_domains", value)

    @property
    @pulumi.getter(name="vsanNetworkDiagnosticModeEnabled")
    def vsan_network_diagnostic_mode_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the vSAN network diagnostic mode is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_network_diagnostic_mode_enabled")

    @vsan_network_diagnostic_mode_enabled.setter
    def vsan_network_diagnostic_mode_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vsan_network_diagnostic_mode_enabled", value)

    @property
    @pulumi.getter(name="vsanPerformanceEnabled")
    def vsan_performance_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the vSAN performance service is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_performance_enabled")

    @vsan_performance_enabled.setter
    def vsan_performance_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vsan_performance_enabled", value)

    @property
    @pulumi.getter(name="vsanRemoteDatastoreIds")
    def vsan_remote_datastore_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The managed object IDs of the vSAN datastore to be mounted on the cluster.
        """
        return pulumi.get(self, "vsan_remote_datastore_ids")

    @vsan_remote_datastore_ids.setter
    def vsan_remote_datastore_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vsan_remote_datastore_ids", value)

    @property
    @pulumi.getter(name="vsanStretchedCluster")
    def vsan_stretched_cluster(self) -> Optional[pulumi.Input['ComputeClusterVsanStretchedClusterArgs']]:
        """
        The configuration for stretched cluster.
        """
        return pulumi.get(self, "vsan_stretched_cluster")

    @vsan_stretched_cluster.setter
    def vsan_stretched_cluster(self, value: Optional[pulumi.Input['ComputeClusterVsanStretchedClusterArgs']]):
        pulumi.set(self, "vsan_stretched_cluster", value)

    @property
    @pulumi.getter(name="vsanUnmapEnabled")
    def vsan_unmap_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the vSAN unmap service is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_unmap_enabled")

    @vsan_unmap_enabled.setter
    def vsan_unmap_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vsan_unmap_enabled", value)

    @property
    @pulumi.getter(name="vsanVerboseModeEnabled")
    def vsan_verbose_mode_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the vSAN verbose mode is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_verbose_mode_enabled")

    @vsan_verbose_mode_enabled.setter
    def vsan_verbose_mode_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vsan_verbose_mode_enabled", value)


class ComputeCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 datacenter_id: Optional[pulumi.Input[str]] = None,
                 dpm_automation_level: Optional[pulumi.Input[str]] = None,
                 dpm_enabled: Optional[pulumi.Input[bool]] = None,
                 dpm_threshold: Optional[pulumi.Input[int]] = None,
                 drs_advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 drs_automation_level: Optional[pulumi.Input[str]] = None,
                 drs_enable_predictive_drs: Optional[pulumi.Input[bool]] = None,
                 drs_enable_vm_overrides: Optional[pulumi.Input[bool]] = None,
                 drs_enabled: Optional[pulumi.Input[bool]] = None,
                 drs_migration_threshold: Optional[pulumi.Input[int]] = None,
                 drs_scale_descendants_shares: Optional[pulumi.Input[str]] = None,
                 folder: Optional[pulumi.Input[str]] = None,
                 force_evacuate_on_destroy: Optional[pulumi.Input[bool]] = None,
                 ha_admission_control_failover_host_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ha_admission_control_host_failure_tolerance: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_performance_tolerance: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_policy: Optional[pulumi.Input[str]] = None,
                 ha_admission_control_resource_percentage_auto_compute: Optional[pulumi.Input[bool]] = None,
                 ha_admission_control_resource_percentage_cpu: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_resource_percentage_memory: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_slot_policy_explicit_cpu: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_slot_policy_explicit_memory: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_slot_policy_use_explicit_size: Optional[pulumi.Input[bool]] = None,
                 ha_advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ha_datastore_apd_recovery_action: Optional[pulumi.Input[str]] = None,
                 ha_datastore_apd_response: Optional[pulumi.Input[str]] = None,
                 ha_datastore_apd_response_delay: Optional[pulumi.Input[int]] = None,
                 ha_datastore_pdl_response: Optional[pulumi.Input[str]] = None,
                 ha_enabled: Optional[pulumi.Input[bool]] = None,
                 ha_heartbeat_datastore_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ha_heartbeat_datastore_policy: Optional[pulumi.Input[str]] = None,
                 ha_host_isolation_response: Optional[pulumi.Input[str]] = None,
                 ha_host_monitoring: Optional[pulumi.Input[str]] = None,
                 ha_vm_component_protection: Optional[pulumi.Input[str]] = None,
                 ha_vm_dependency_restart_condition: Optional[pulumi.Input[str]] = None,
                 ha_vm_failure_interval: Optional[pulumi.Input[int]] = None,
                 ha_vm_maximum_failure_window: Optional[pulumi.Input[int]] = None,
                 ha_vm_maximum_resets: Optional[pulumi.Input[int]] = None,
                 ha_vm_minimum_uptime: Optional[pulumi.Input[int]] = None,
                 ha_vm_monitoring: Optional[pulumi.Input[str]] = None,
                 ha_vm_restart_additional_delay: Optional[pulumi.Input[int]] = None,
                 ha_vm_restart_priority: Optional[pulumi.Input[str]] = None,
                 ha_vm_restart_timeout: Optional[pulumi.Input[int]] = None,
                 host_cluster_exit_timeout: Optional[pulumi.Input[int]] = None,
                 host_image: Optional[pulumi.Input[pulumi.InputType['ComputeClusterHostImageArgs']]] = None,
                 host_managed: Optional[pulumi.Input[bool]] = None,
                 host_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 proactive_ha_automation_level: Optional[pulumi.Input[str]] = None,
                 proactive_ha_enabled: Optional[pulumi.Input[bool]] = None,
                 proactive_ha_moderate_remediation: Optional[pulumi.Input[str]] = None,
                 proactive_ha_provider_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 proactive_ha_severe_remediation: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vsan_compression_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_dedup_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_disk_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComputeClusterVsanDiskGroupArgs']]]]] = None,
                 vsan_dit_encryption_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_dit_rekey_interval: Optional[pulumi.Input[int]] = None,
                 vsan_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_esa_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComputeClusterVsanFaultDomainArgs']]]]] = None,
                 vsan_network_diagnostic_mode_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_performance_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_remote_datastore_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vsan_stretched_cluster: Optional[pulumi.Input[pulumi.InputType['ComputeClusterVsanStretchedClusterArgs']]] = None,
                 vsan_unmap_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_verbose_mode_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Create a ComputeCluster resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_attributes: A map of custom attribute ids to attribute
               value strings to set for the datastore cluster.
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter Server.
        :param pulumi.Input[str] datacenter_id: The managed object ID of
               the datacenter to create the cluster in. Forces a new resource if changed.
        :param pulumi.Input[str] dpm_automation_level: The automation level for host power operations in this cluster. Can be one of manual or automated.
        :param pulumi.Input[bool] dpm_enabled: Enable DPM support for DRS. This allows you to dynamically control the power of hosts depending on the needs of virtual
               machines in the cluster. Requires that DRS be enabled.
        :param pulumi.Input[int] dpm_threshold: A value between 1 and 5 indicating the threshold of load within the cluster that influences host power operations. This
               affects both power on and power off operations - a lower setting will tolerate more of a surplus/deficit than a higher
               setting.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] drs_advanced_options: Advanced configuration options for DRS and DPM.
        :param pulumi.Input[str] drs_automation_level: The default automation level for all virtual machines in this cluster. Can be one of manual, partiallyAutomated, or
               fullyAutomated.
        :param pulumi.Input[bool] drs_enable_predictive_drs: When true, enables DRS to use data from vRealize Operations Manager to make proactive DRS recommendations.
        :param pulumi.Input[bool] drs_enable_vm_overrides: When true, allows individual VM overrides within this cluster to be set.
        :param pulumi.Input[bool] drs_enabled: Enable DRS for this cluster.
        :param pulumi.Input[int] drs_migration_threshold: A value between 1 and 5 indicating the threshold of imbalance tolerated between hosts. A lower setting will tolerate
               more imbalance while a higher setting will tolerate less.
        :param pulumi.Input[str] drs_scale_descendants_shares: Enable scalable shares for all descendants of this cluster.
        :param pulumi.Input[str] folder: The relative path to a folder to put this cluster in.
               This is a path relative to the datacenter you are deploying the cluster to.
               Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
               The provider will place a cluster named `compute-cluster-test` in a
               host folder located at `/dc1/host/foo/bar`, with the final inventory path
               being `/dc1/host/foo/bar/datastore-cluster-test`.
        :param pulumi.Input[bool] force_evacuate_on_destroy: Force removal of all hosts in the cluster during destroy and make them standalone hosts. Use of this flag mainly exists
               for testing and is not recommended in normal use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ha_admission_control_failover_host_system_ids: When ha_admission_control_policy is failoverHosts, this defines the managed object IDs of hosts to use as dedicated
               failover hosts. These hosts are kept as available as possible - admission control will block access to the host, and DRS
               will ignore the host when making recommendations.
        :param pulumi.Input[int] ha_admission_control_host_failure_tolerance: The maximum number of failed hosts that admission control tolerates when making decisions on whether to permit virtual
               machine operations. The maximum is one less than the number of hosts in the cluster.
        :param pulumi.Input[int] ha_admission_control_performance_tolerance: The percentage of resource reduction that a cluster of VMs can tolerate in case of a failover. A value of 0 produces
               warnings only, whereas a value of 100 disables the setting.
        :param pulumi.Input[str] ha_admission_control_policy: The type of admission control policy to use with vSphere HA, which controls whether or not specific VM operations are
               permitted in the cluster in order to protect the reliability of the cluster. Can be one of resourcePercentage,
               slotPolicy, failoverHosts, or disabled. Note that disabling admission control is not recommended and can lead to service
               issues.
        :param pulumi.Input[bool] ha_admission_control_resource_percentage_auto_compute: When ha_admission_control_policy is resourcePercentage, automatically determine available resource percentages by
               subtracting the average number of host resources represented by the ha_admission_control_host_failure_tolerance setting
               from the total amount of resources in the cluster. Disable to supply user-defined values.
        :param pulumi.Input[int] ha_admission_control_resource_percentage_cpu: When ha_admission_control_policy is resourcePercentage, this controls the user-defined percentage of CPU resources in
               the cluster to reserve for failover.
        :param pulumi.Input[int] ha_admission_control_resource_percentage_memory: When ha_admission_control_policy is resourcePercentage, this controls the user-defined percentage of memory resources in
               the cluster to reserve for failover.
        :param pulumi.Input[int] ha_admission_control_slot_policy_explicit_cpu: When ha_admission_control_policy is slotPolicy, this controls the user-defined CPU slot size, in MHz.
        :param pulumi.Input[int] ha_admission_control_slot_policy_explicit_memory: When ha_admission_control_policy is slotPolicy, this controls the user-defined memory slot size, in MB.
        :param pulumi.Input[bool] ha_admission_control_slot_policy_use_explicit_size: When ha_admission_control_policy is slotPolicy, this setting controls whether or not you wish to supply explicit values
               to CPU and memory slot sizes. The default is to gather a automatic average based on all powered-on virtual machines
               currently in the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] ha_advanced_options: Advanced configuration options for vSphere HA.
        :param pulumi.Input[str] ha_datastore_apd_recovery_action: When ha_vm_component_protection is enabled, controls the action to take on virtual machines if an APD status on an
               affected datastore clears in the middle of an APD event. Can be one of none or reset.
        :param pulumi.Input[str] ha_datastore_apd_response: When ha_vm_component_protection is enabled, controls the action to take on virtual machines when the cluster has
               detected loss to all paths to a relevant datastore. Can be one of disabled, warning, restartConservative, or
               restartAggressive.
        :param pulumi.Input[int] ha_datastore_apd_response_delay: When ha_vm_component_protection is enabled, controls the delay in seconds to wait after an APD timeout event to execute
               the response action defined in ha_datastore_apd_response.
        :param pulumi.Input[str] ha_datastore_pdl_response: When ha_vm_component_protection is enabled, controls the action to take on virtual machines when the cluster has
               detected a permanent device loss to a relevant datastore. Can be one of disabled, warning, or restartAggressive.
        :param pulumi.Input[bool] ha_enabled: Enable vSphere HA for this cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ha_heartbeat_datastore_ids: The list of managed object IDs for preferred datastores to use for HA heartbeating. This setting is only useful when
               ha_heartbeat_datastore_policy is set to either userSelectedDs or allFeasibleDsWithUserPreference.
        :param pulumi.Input[str] ha_heartbeat_datastore_policy: The selection policy for HA heartbeat datastores. Can be one of allFeasibleDs, userSelectedDs, or
               allFeasibleDsWithUserPreference.
        :param pulumi.Input[str] ha_host_isolation_response: The action to take on virtual machines when a host has detected that it has been isolated from the rest of the cluster.
               Can be one of none, powerOff, or shutdown.
        :param pulumi.Input[str] ha_host_monitoring: Global setting that controls whether vSphere HA remediates VMs on host failure. Can be one of enabled or disabled.
        :param pulumi.Input[str] ha_vm_component_protection: Controls vSphere VM component protection for virtual machines in this cluster. This allows vSphere HA to react to
               failures between hosts and specific virtual machine components, such as datastores. Can be one of enabled or disabled.
        :param pulumi.Input[str] ha_vm_dependency_restart_condition: The condition used to determine whether or not VMs in a certain restart priority class are online, allowing HA to move
               on to restarting VMs on the next priority. Can be one of none, poweredOn, guestHbStatusGreen, or appHbStatusGreen.
        :param pulumi.Input[int] ha_vm_failure_interval: If a heartbeat from a virtual machine is not received within this configured interval, the virtual machine is marked as
               failed. The value is in seconds.
        :param pulumi.Input[int] ha_vm_maximum_failure_window: The length of the reset window in which ha_vm_maximum_resets can operate. When this window expires, no more resets are
               attempted regardless of the setting configured in ha_vm_maximum_resets. -1 means no window, meaning an unlimited reset
               time is allotted.
        :param pulumi.Input[int] ha_vm_maximum_resets: The maximum number of resets that HA will perform to a virtual machine when responding to a failure event.
        :param pulumi.Input[int] ha_vm_minimum_uptime: The time, in seconds, that HA waits after powering on a virtual machine before monitoring for heartbeats.
        :param pulumi.Input[str] ha_vm_monitoring: The type of virtual machine monitoring to use when HA is enabled in the cluster. Can be one of vmMonitoringDisabled,
               vmMonitoringOnly, or vmAndAppMonitoring.
        :param pulumi.Input[int] ha_vm_restart_additional_delay: Additional delay in seconds after ready condition is met. A VM is considered ready at this point.
        :param pulumi.Input[str] ha_vm_restart_priority: The default restart priority for affected VMs when vSphere detects a host failure. Can be one of lowest, low, medium,
               high, or highest.
        :param pulumi.Input[int] ha_vm_restart_timeout: The maximum time, in seconds, that vSphere HA will wait for virtual machines in one priority to be ready before
               proceeding with the next priority.
        :param pulumi.Input[int] host_cluster_exit_timeout: The timeout for each host maintenance mode operation when removing hosts from a cluster.
        :param pulumi.Input[pulumi.InputType['ComputeClusterHostImageArgs']] host_image: Details about the host image which should be applied to the cluster.
        :param pulumi.Input[bool] host_managed: Must be set if cluster enrollment is managed from host resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_system_ids: The managed object IDs of the hosts to put in the cluster.
        :param pulumi.Input[str] name: The name of the cluster.
        :param pulumi.Input[str] proactive_ha_automation_level: The DRS behavior for proactive HA recommendations. Can be one of Automated or Manual.
        :param pulumi.Input[bool] proactive_ha_enabled: Enables proactive HA, allowing for vSphere to get HA data from external providers and use DRS to perform remediation.
        :param pulumi.Input[str] proactive_ha_moderate_remediation: The configured remediation for moderately degraded hosts. Can be one of MaintenanceMode or QuarantineMode. Note that
               this cannot be set to MaintenanceMode when proactive_ha_severe_remediation is set to QuarantineMode.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] proactive_ha_provider_ids: The list of IDs for health update providers configured for this cluster.
        :param pulumi.Input[str] proactive_ha_severe_remediation: The configured remediation for severely degraded hosts. Can be one of MaintenanceMode or QuarantineMode. Note that this
               cannot be set to QuarantineMode when proactive_ha_moderate_remediation is set to MaintenanceMode.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The IDs of any tags to attach to this resource.
        :param pulumi.Input[bool] vsan_compression_enabled: Whether the vSAN compression service is enabled for the cluster.
        :param pulumi.Input[bool] vsan_dedup_enabled: Whether the vSAN deduplication service is enabled for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComputeClusterVsanDiskGroupArgs']]]] vsan_disk_groups: A list of disk UUIDs to add to the vSAN cluster.
        :param pulumi.Input[bool] vsan_dit_encryption_enabled: Whether the vSAN data-in-transit encryption is enabled for the cluster.
        :param pulumi.Input[int] vsan_dit_rekey_interval: When vsan_dit_encryption_enabled is enabled, sets the rekey interval of data-in-transit encryption (in minutes).
        :param pulumi.Input[bool] vsan_enabled: Whether the vSAN service is enabled for the cluster.
        :param pulumi.Input[bool] vsan_esa_enabled: Whether the vSAN ESA service is enabled for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComputeClusterVsanFaultDomainArgs']]]] vsan_fault_domains: The configuration for vSAN fault domains.
        :param pulumi.Input[bool] vsan_network_diagnostic_mode_enabled: Whether the vSAN network diagnostic mode is enabled for the cluster.
        :param pulumi.Input[bool] vsan_performance_enabled: Whether the vSAN performance service is enabled for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vsan_remote_datastore_ids: The managed object IDs of the vSAN datastore to be mounted on the cluster.
        :param pulumi.Input[pulumi.InputType['ComputeClusterVsanStretchedClusterArgs']] vsan_stretched_cluster: The configuration for stretched cluster.
        :param pulumi.Input[bool] vsan_unmap_enabled: Whether the vSAN unmap service is enabled for the cluster.
        :param pulumi.Input[bool] vsan_verbose_mode_enabled: Whether the vSAN verbose mode is enabled for the cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComputeClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ComputeCluster resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ComputeClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 datacenter_id: Optional[pulumi.Input[str]] = None,
                 dpm_automation_level: Optional[pulumi.Input[str]] = None,
                 dpm_enabled: Optional[pulumi.Input[bool]] = None,
                 dpm_threshold: Optional[pulumi.Input[int]] = None,
                 drs_advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 drs_automation_level: Optional[pulumi.Input[str]] = None,
                 drs_enable_predictive_drs: Optional[pulumi.Input[bool]] = None,
                 drs_enable_vm_overrides: Optional[pulumi.Input[bool]] = None,
                 drs_enabled: Optional[pulumi.Input[bool]] = None,
                 drs_migration_threshold: Optional[pulumi.Input[int]] = None,
                 drs_scale_descendants_shares: Optional[pulumi.Input[str]] = None,
                 folder: Optional[pulumi.Input[str]] = None,
                 force_evacuate_on_destroy: Optional[pulumi.Input[bool]] = None,
                 ha_admission_control_failover_host_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ha_admission_control_host_failure_tolerance: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_performance_tolerance: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_policy: Optional[pulumi.Input[str]] = None,
                 ha_admission_control_resource_percentage_auto_compute: Optional[pulumi.Input[bool]] = None,
                 ha_admission_control_resource_percentage_cpu: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_resource_percentage_memory: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_slot_policy_explicit_cpu: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_slot_policy_explicit_memory: Optional[pulumi.Input[int]] = None,
                 ha_admission_control_slot_policy_use_explicit_size: Optional[pulumi.Input[bool]] = None,
                 ha_advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ha_datastore_apd_recovery_action: Optional[pulumi.Input[str]] = None,
                 ha_datastore_apd_response: Optional[pulumi.Input[str]] = None,
                 ha_datastore_apd_response_delay: Optional[pulumi.Input[int]] = None,
                 ha_datastore_pdl_response: Optional[pulumi.Input[str]] = None,
                 ha_enabled: Optional[pulumi.Input[bool]] = None,
                 ha_heartbeat_datastore_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ha_heartbeat_datastore_policy: Optional[pulumi.Input[str]] = None,
                 ha_host_isolation_response: Optional[pulumi.Input[str]] = None,
                 ha_host_monitoring: Optional[pulumi.Input[str]] = None,
                 ha_vm_component_protection: Optional[pulumi.Input[str]] = None,
                 ha_vm_dependency_restart_condition: Optional[pulumi.Input[str]] = None,
                 ha_vm_failure_interval: Optional[pulumi.Input[int]] = None,
                 ha_vm_maximum_failure_window: Optional[pulumi.Input[int]] = None,
                 ha_vm_maximum_resets: Optional[pulumi.Input[int]] = None,
                 ha_vm_minimum_uptime: Optional[pulumi.Input[int]] = None,
                 ha_vm_monitoring: Optional[pulumi.Input[str]] = None,
                 ha_vm_restart_additional_delay: Optional[pulumi.Input[int]] = None,
                 ha_vm_restart_priority: Optional[pulumi.Input[str]] = None,
                 ha_vm_restart_timeout: Optional[pulumi.Input[int]] = None,
                 host_cluster_exit_timeout: Optional[pulumi.Input[int]] = None,
                 host_image: Optional[pulumi.Input[pulumi.InputType['ComputeClusterHostImageArgs']]] = None,
                 host_managed: Optional[pulumi.Input[bool]] = None,
                 host_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 proactive_ha_automation_level: Optional[pulumi.Input[str]] = None,
                 proactive_ha_enabled: Optional[pulumi.Input[bool]] = None,
                 proactive_ha_moderate_remediation: Optional[pulumi.Input[str]] = None,
                 proactive_ha_provider_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 proactive_ha_severe_remediation: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vsan_compression_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_dedup_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_disk_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComputeClusterVsanDiskGroupArgs']]]]] = None,
                 vsan_dit_encryption_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_dit_rekey_interval: Optional[pulumi.Input[int]] = None,
                 vsan_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_esa_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComputeClusterVsanFaultDomainArgs']]]]] = None,
                 vsan_network_diagnostic_mode_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_performance_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_remote_datastore_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vsan_stretched_cluster: Optional[pulumi.Input[pulumi.InputType['ComputeClusterVsanStretchedClusterArgs']]] = None,
                 vsan_unmap_enabled: Optional[pulumi.Input[bool]] = None,
                 vsan_verbose_mode_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeClusterArgs.__new__(ComputeClusterArgs)

            __props__.__dict__["custom_attributes"] = custom_attributes
            if datacenter_id is None and not opts.urn:
                raise TypeError("Missing required property 'datacenter_id'")
            __props__.__dict__["datacenter_id"] = datacenter_id
            __props__.__dict__["dpm_automation_level"] = dpm_automation_level
            __props__.__dict__["dpm_enabled"] = dpm_enabled
            __props__.__dict__["dpm_threshold"] = dpm_threshold
            __props__.__dict__["drs_advanced_options"] = drs_advanced_options
            __props__.__dict__["drs_automation_level"] = drs_automation_level
            __props__.__dict__["drs_enable_predictive_drs"] = drs_enable_predictive_drs
            __props__.__dict__["drs_enable_vm_overrides"] = drs_enable_vm_overrides
            __props__.__dict__["drs_enabled"] = drs_enabled
            __props__.__dict__["drs_migration_threshold"] = drs_migration_threshold
            __props__.__dict__["drs_scale_descendants_shares"] = drs_scale_descendants_shares
            __props__.__dict__["folder"] = folder
            __props__.__dict__["force_evacuate_on_destroy"] = force_evacuate_on_destroy
            __props__.__dict__["ha_admission_control_failover_host_system_ids"] = ha_admission_control_failover_host_system_ids
            __props__.__dict__["ha_admission_control_host_failure_tolerance"] = ha_admission_control_host_failure_tolerance
            __props__.__dict__["ha_admission_control_performance_tolerance"] = ha_admission_control_performance_tolerance
            __props__.__dict__["ha_admission_control_policy"] = ha_admission_control_policy
            __props__.__dict__["ha_admission_control_resource_percentage_auto_compute"] = ha_admission_control_resource_percentage_auto_compute
            __props__.__dict__["ha_admission_control_resource_percentage_cpu"] = ha_admission_control_resource_percentage_cpu
            __props__.__dict__["ha_admission_control_resource_percentage_memory"] = ha_admission_control_resource_percentage_memory
            __props__.__dict__["ha_admission_control_slot_policy_explicit_cpu"] = ha_admission_control_slot_policy_explicit_cpu
            __props__.__dict__["ha_admission_control_slot_policy_explicit_memory"] = ha_admission_control_slot_policy_explicit_memory
            __props__.__dict__["ha_admission_control_slot_policy_use_explicit_size"] = ha_admission_control_slot_policy_use_explicit_size
            __props__.__dict__["ha_advanced_options"] = ha_advanced_options
            __props__.__dict__["ha_datastore_apd_recovery_action"] = ha_datastore_apd_recovery_action
            __props__.__dict__["ha_datastore_apd_response"] = ha_datastore_apd_response
            __props__.__dict__["ha_datastore_apd_response_delay"] = ha_datastore_apd_response_delay
            __props__.__dict__["ha_datastore_pdl_response"] = ha_datastore_pdl_response
            __props__.__dict__["ha_enabled"] = ha_enabled
            __props__.__dict__["ha_heartbeat_datastore_ids"] = ha_heartbeat_datastore_ids
            __props__.__dict__["ha_heartbeat_datastore_policy"] = ha_heartbeat_datastore_policy
            __props__.__dict__["ha_host_isolation_response"] = ha_host_isolation_response
            __props__.__dict__["ha_host_monitoring"] = ha_host_monitoring
            __props__.__dict__["ha_vm_component_protection"] = ha_vm_component_protection
            __props__.__dict__["ha_vm_dependency_restart_condition"] = ha_vm_dependency_restart_condition
            __props__.__dict__["ha_vm_failure_interval"] = ha_vm_failure_interval
            __props__.__dict__["ha_vm_maximum_failure_window"] = ha_vm_maximum_failure_window
            __props__.__dict__["ha_vm_maximum_resets"] = ha_vm_maximum_resets
            __props__.__dict__["ha_vm_minimum_uptime"] = ha_vm_minimum_uptime
            __props__.__dict__["ha_vm_monitoring"] = ha_vm_monitoring
            __props__.__dict__["ha_vm_restart_additional_delay"] = ha_vm_restart_additional_delay
            __props__.__dict__["ha_vm_restart_priority"] = ha_vm_restart_priority
            __props__.__dict__["ha_vm_restart_timeout"] = ha_vm_restart_timeout
            __props__.__dict__["host_cluster_exit_timeout"] = host_cluster_exit_timeout
            __props__.__dict__["host_image"] = host_image
            __props__.__dict__["host_managed"] = host_managed
            __props__.__dict__["host_system_ids"] = host_system_ids
            __props__.__dict__["name"] = name
            __props__.__dict__["proactive_ha_automation_level"] = proactive_ha_automation_level
            __props__.__dict__["proactive_ha_enabled"] = proactive_ha_enabled
            __props__.__dict__["proactive_ha_moderate_remediation"] = proactive_ha_moderate_remediation
            __props__.__dict__["proactive_ha_provider_ids"] = proactive_ha_provider_ids
            __props__.__dict__["proactive_ha_severe_remediation"] = proactive_ha_severe_remediation
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vsan_compression_enabled"] = vsan_compression_enabled
            __props__.__dict__["vsan_dedup_enabled"] = vsan_dedup_enabled
            __props__.__dict__["vsan_disk_groups"] = vsan_disk_groups
            __props__.__dict__["vsan_dit_encryption_enabled"] = vsan_dit_encryption_enabled
            __props__.__dict__["vsan_dit_rekey_interval"] = vsan_dit_rekey_interval
            __props__.__dict__["vsan_enabled"] = vsan_enabled
            __props__.__dict__["vsan_esa_enabled"] = vsan_esa_enabled
            __props__.__dict__["vsan_fault_domains"] = vsan_fault_domains
            __props__.__dict__["vsan_network_diagnostic_mode_enabled"] = vsan_network_diagnostic_mode_enabled
            __props__.__dict__["vsan_performance_enabled"] = vsan_performance_enabled
            __props__.__dict__["vsan_remote_datastore_ids"] = vsan_remote_datastore_ids
            __props__.__dict__["vsan_stretched_cluster"] = vsan_stretched_cluster
            __props__.__dict__["vsan_unmap_enabled"] = vsan_unmap_enabled
            __props__.__dict__["vsan_verbose_mode_enabled"] = vsan_verbose_mode_enabled
            __props__.__dict__["resource_pool_id"] = None
        super(ComputeCluster, __self__).__init__(
            'vsphere:index/computeCluster:ComputeCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            datacenter_id: Optional[pulumi.Input[str]] = None,
            dpm_automation_level: Optional[pulumi.Input[str]] = None,
            dpm_enabled: Optional[pulumi.Input[bool]] = None,
            dpm_threshold: Optional[pulumi.Input[int]] = None,
            drs_advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            drs_automation_level: Optional[pulumi.Input[str]] = None,
            drs_enable_predictive_drs: Optional[pulumi.Input[bool]] = None,
            drs_enable_vm_overrides: Optional[pulumi.Input[bool]] = None,
            drs_enabled: Optional[pulumi.Input[bool]] = None,
            drs_migration_threshold: Optional[pulumi.Input[int]] = None,
            drs_scale_descendants_shares: Optional[pulumi.Input[str]] = None,
            folder: Optional[pulumi.Input[str]] = None,
            force_evacuate_on_destroy: Optional[pulumi.Input[bool]] = None,
            ha_admission_control_failover_host_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ha_admission_control_host_failure_tolerance: Optional[pulumi.Input[int]] = None,
            ha_admission_control_performance_tolerance: Optional[pulumi.Input[int]] = None,
            ha_admission_control_policy: Optional[pulumi.Input[str]] = None,
            ha_admission_control_resource_percentage_auto_compute: Optional[pulumi.Input[bool]] = None,
            ha_admission_control_resource_percentage_cpu: Optional[pulumi.Input[int]] = None,
            ha_admission_control_resource_percentage_memory: Optional[pulumi.Input[int]] = None,
            ha_admission_control_slot_policy_explicit_cpu: Optional[pulumi.Input[int]] = None,
            ha_admission_control_slot_policy_explicit_memory: Optional[pulumi.Input[int]] = None,
            ha_admission_control_slot_policy_use_explicit_size: Optional[pulumi.Input[bool]] = None,
            ha_advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            ha_datastore_apd_recovery_action: Optional[pulumi.Input[str]] = None,
            ha_datastore_apd_response: Optional[pulumi.Input[str]] = None,
            ha_datastore_apd_response_delay: Optional[pulumi.Input[int]] = None,
            ha_datastore_pdl_response: Optional[pulumi.Input[str]] = None,
            ha_enabled: Optional[pulumi.Input[bool]] = None,
            ha_heartbeat_datastore_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ha_heartbeat_datastore_policy: Optional[pulumi.Input[str]] = None,
            ha_host_isolation_response: Optional[pulumi.Input[str]] = None,
            ha_host_monitoring: Optional[pulumi.Input[str]] = None,
            ha_vm_component_protection: Optional[pulumi.Input[str]] = None,
            ha_vm_dependency_restart_condition: Optional[pulumi.Input[str]] = None,
            ha_vm_failure_interval: Optional[pulumi.Input[int]] = None,
            ha_vm_maximum_failure_window: Optional[pulumi.Input[int]] = None,
            ha_vm_maximum_resets: Optional[pulumi.Input[int]] = None,
            ha_vm_minimum_uptime: Optional[pulumi.Input[int]] = None,
            ha_vm_monitoring: Optional[pulumi.Input[str]] = None,
            ha_vm_restart_additional_delay: Optional[pulumi.Input[int]] = None,
            ha_vm_restart_priority: Optional[pulumi.Input[str]] = None,
            ha_vm_restart_timeout: Optional[pulumi.Input[int]] = None,
            host_cluster_exit_timeout: Optional[pulumi.Input[int]] = None,
            host_image: Optional[pulumi.Input[pulumi.InputType['ComputeClusterHostImageArgs']]] = None,
            host_managed: Optional[pulumi.Input[bool]] = None,
            host_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            proactive_ha_automation_level: Optional[pulumi.Input[str]] = None,
            proactive_ha_enabled: Optional[pulumi.Input[bool]] = None,
            proactive_ha_moderate_remediation: Optional[pulumi.Input[str]] = None,
            proactive_ha_provider_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            proactive_ha_severe_remediation: Optional[pulumi.Input[str]] = None,
            resource_pool_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            vsan_compression_enabled: Optional[pulumi.Input[bool]] = None,
            vsan_dedup_enabled: Optional[pulumi.Input[bool]] = None,
            vsan_disk_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComputeClusterVsanDiskGroupArgs']]]]] = None,
            vsan_dit_encryption_enabled: Optional[pulumi.Input[bool]] = None,
            vsan_dit_rekey_interval: Optional[pulumi.Input[int]] = None,
            vsan_enabled: Optional[pulumi.Input[bool]] = None,
            vsan_esa_enabled: Optional[pulumi.Input[bool]] = None,
            vsan_fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComputeClusterVsanFaultDomainArgs']]]]] = None,
            vsan_network_diagnostic_mode_enabled: Optional[pulumi.Input[bool]] = None,
            vsan_performance_enabled: Optional[pulumi.Input[bool]] = None,
            vsan_remote_datastore_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            vsan_stretched_cluster: Optional[pulumi.Input[pulumi.InputType['ComputeClusterVsanStretchedClusterArgs']]] = None,
            vsan_unmap_enabled: Optional[pulumi.Input[bool]] = None,
            vsan_verbose_mode_enabled: Optional[pulumi.Input[bool]] = None) -> 'ComputeCluster':
        """
        Get an existing ComputeCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_attributes: A map of custom attribute ids to attribute
               value strings to set for the datastore cluster.
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter Server.
        :param pulumi.Input[str] datacenter_id: The managed object ID of
               the datacenter to create the cluster in. Forces a new resource if changed.
        :param pulumi.Input[str] dpm_automation_level: The automation level for host power operations in this cluster. Can be one of manual or automated.
        :param pulumi.Input[bool] dpm_enabled: Enable DPM support for DRS. This allows you to dynamically control the power of hosts depending on the needs of virtual
               machines in the cluster. Requires that DRS be enabled.
        :param pulumi.Input[int] dpm_threshold: A value between 1 and 5 indicating the threshold of load within the cluster that influences host power operations. This
               affects both power on and power off operations - a lower setting will tolerate more of a surplus/deficit than a higher
               setting.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] drs_advanced_options: Advanced configuration options for DRS and DPM.
        :param pulumi.Input[str] drs_automation_level: The default automation level for all virtual machines in this cluster. Can be one of manual, partiallyAutomated, or
               fullyAutomated.
        :param pulumi.Input[bool] drs_enable_predictive_drs: When true, enables DRS to use data from vRealize Operations Manager to make proactive DRS recommendations.
        :param pulumi.Input[bool] drs_enable_vm_overrides: When true, allows individual VM overrides within this cluster to be set.
        :param pulumi.Input[bool] drs_enabled: Enable DRS for this cluster.
        :param pulumi.Input[int] drs_migration_threshold: A value between 1 and 5 indicating the threshold of imbalance tolerated between hosts. A lower setting will tolerate
               more imbalance while a higher setting will tolerate less.
        :param pulumi.Input[str] drs_scale_descendants_shares: Enable scalable shares for all descendants of this cluster.
        :param pulumi.Input[str] folder: The relative path to a folder to put this cluster in.
               This is a path relative to the datacenter you are deploying the cluster to.
               Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
               The provider will place a cluster named `compute-cluster-test` in a
               host folder located at `/dc1/host/foo/bar`, with the final inventory path
               being `/dc1/host/foo/bar/datastore-cluster-test`.
        :param pulumi.Input[bool] force_evacuate_on_destroy: Force removal of all hosts in the cluster during destroy and make them standalone hosts. Use of this flag mainly exists
               for testing and is not recommended in normal use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ha_admission_control_failover_host_system_ids: When ha_admission_control_policy is failoverHosts, this defines the managed object IDs of hosts to use as dedicated
               failover hosts. These hosts are kept as available as possible - admission control will block access to the host, and DRS
               will ignore the host when making recommendations.
        :param pulumi.Input[int] ha_admission_control_host_failure_tolerance: The maximum number of failed hosts that admission control tolerates when making decisions on whether to permit virtual
               machine operations. The maximum is one less than the number of hosts in the cluster.
        :param pulumi.Input[int] ha_admission_control_performance_tolerance: The percentage of resource reduction that a cluster of VMs can tolerate in case of a failover. A value of 0 produces
               warnings only, whereas a value of 100 disables the setting.
        :param pulumi.Input[str] ha_admission_control_policy: The type of admission control policy to use with vSphere HA, which controls whether or not specific VM operations are
               permitted in the cluster in order to protect the reliability of the cluster. Can be one of resourcePercentage,
               slotPolicy, failoverHosts, or disabled. Note that disabling admission control is not recommended and can lead to service
               issues.
        :param pulumi.Input[bool] ha_admission_control_resource_percentage_auto_compute: When ha_admission_control_policy is resourcePercentage, automatically determine available resource percentages by
               subtracting the average number of host resources represented by the ha_admission_control_host_failure_tolerance setting
               from the total amount of resources in the cluster. Disable to supply user-defined values.
        :param pulumi.Input[int] ha_admission_control_resource_percentage_cpu: When ha_admission_control_policy is resourcePercentage, this controls the user-defined percentage of CPU resources in
               the cluster to reserve for failover.
        :param pulumi.Input[int] ha_admission_control_resource_percentage_memory: When ha_admission_control_policy is resourcePercentage, this controls the user-defined percentage of memory resources in
               the cluster to reserve for failover.
        :param pulumi.Input[int] ha_admission_control_slot_policy_explicit_cpu: When ha_admission_control_policy is slotPolicy, this controls the user-defined CPU slot size, in MHz.
        :param pulumi.Input[int] ha_admission_control_slot_policy_explicit_memory: When ha_admission_control_policy is slotPolicy, this controls the user-defined memory slot size, in MB.
        :param pulumi.Input[bool] ha_admission_control_slot_policy_use_explicit_size: When ha_admission_control_policy is slotPolicy, this setting controls whether or not you wish to supply explicit values
               to CPU and memory slot sizes. The default is to gather a automatic average based on all powered-on virtual machines
               currently in the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] ha_advanced_options: Advanced configuration options for vSphere HA.
        :param pulumi.Input[str] ha_datastore_apd_recovery_action: When ha_vm_component_protection is enabled, controls the action to take on virtual machines if an APD status on an
               affected datastore clears in the middle of an APD event. Can be one of none or reset.
        :param pulumi.Input[str] ha_datastore_apd_response: When ha_vm_component_protection is enabled, controls the action to take on virtual machines when the cluster has
               detected loss to all paths to a relevant datastore. Can be one of disabled, warning, restartConservative, or
               restartAggressive.
        :param pulumi.Input[int] ha_datastore_apd_response_delay: When ha_vm_component_protection is enabled, controls the delay in seconds to wait after an APD timeout event to execute
               the response action defined in ha_datastore_apd_response.
        :param pulumi.Input[str] ha_datastore_pdl_response: When ha_vm_component_protection is enabled, controls the action to take on virtual machines when the cluster has
               detected a permanent device loss to a relevant datastore. Can be one of disabled, warning, or restartAggressive.
        :param pulumi.Input[bool] ha_enabled: Enable vSphere HA for this cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ha_heartbeat_datastore_ids: The list of managed object IDs for preferred datastores to use for HA heartbeating. This setting is only useful when
               ha_heartbeat_datastore_policy is set to either userSelectedDs or allFeasibleDsWithUserPreference.
        :param pulumi.Input[str] ha_heartbeat_datastore_policy: The selection policy for HA heartbeat datastores. Can be one of allFeasibleDs, userSelectedDs, or
               allFeasibleDsWithUserPreference.
        :param pulumi.Input[str] ha_host_isolation_response: The action to take on virtual machines when a host has detected that it has been isolated from the rest of the cluster.
               Can be one of none, powerOff, or shutdown.
        :param pulumi.Input[str] ha_host_monitoring: Global setting that controls whether vSphere HA remediates VMs on host failure. Can be one of enabled or disabled.
        :param pulumi.Input[str] ha_vm_component_protection: Controls vSphere VM component protection for virtual machines in this cluster. This allows vSphere HA to react to
               failures between hosts and specific virtual machine components, such as datastores. Can be one of enabled or disabled.
        :param pulumi.Input[str] ha_vm_dependency_restart_condition: The condition used to determine whether or not VMs in a certain restart priority class are online, allowing HA to move
               on to restarting VMs on the next priority. Can be one of none, poweredOn, guestHbStatusGreen, or appHbStatusGreen.
        :param pulumi.Input[int] ha_vm_failure_interval: If a heartbeat from a virtual machine is not received within this configured interval, the virtual machine is marked as
               failed. The value is in seconds.
        :param pulumi.Input[int] ha_vm_maximum_failure_window: The length of the reset window in which ha_vm_maximum_resets can operate. When this window expires, no more resets are
               attempted regardless of the setting configured in ha_vm_maximum_resets. -1 means no window, meaning an unlimited reset
               time is allotted.
        :param pulumi.Input[int] ha_vm_maximum_resets: The maximum number of resets that HA will perform to a virtual machine when responding to a failure event.
        :param pulumi.Input[int] ha_vm_minimum_uptime: The time, in seconds, that HA waits after powering on a virtual machine before monitoring for heartbeats.
        :param pulumi.Input[str] ha_vm_monitoring: The type of virtual machine monitoring to use when HA is enabled in the cluster. Can be one of vmMonitoringDisabled,
               vmMonitoringOnly, or vmAndAppMonitoring.
        :param pulumi.Input[int] ha_vm_restart_additional_delay: Additional delay in seconds after ready condition is met. A VM is considered ready at this point.
        :param pulumi.Input[str] ha_vm_restart_priority: The default restart priority for affected VMs when vSphere detects a host failure. Can be one of lowest, low, medium,
               high, or highest.
        :param pulumi.Input[int] ha_vm_restart_timeout: The maximum time, in seconds, that vSphere HA will wait for virtual machines in one priority to be ready before
               proceeding with the next priority.
        :param pulumi.Input[int] host_cluster_exit_timeout: The timeout for each host maintenance mode operation when removing hosts from a cluster.
        :param pulumi.Input[pulumi.InputType['ComputeClusterHostImageArgs']] host_image: Details about the host image which should be applied to the cluster.
        :param pulumi.Input[bool] host_managed: Must be set if cluster enrollment is managed from host resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_system_ids: The managed object IDs of the hosts to put in the cluster.
        :param pulumi.Input[str] name: The name of the cluster.
        :param pulumi.Input[str] proactive_ha_automation_level: The DRS behavior for proactive HA recommendations. Can be one of Automated or Manual.
        :param pulumi.Input[bool] proactive_ha_enabled: Enables proactive HA, allowing for vSphere to get HA data from external providers and use DRS to perform remediation.
        :param pulumi.Input[str] proactive_ha_moderate_remediation: The configured remediation for moderately degraded hosts. Can be one of MaintenanceMode or QuarantineMode. Note that
               this cannot be set to MaintenanceMode when proactive_ha_severe_remediation is set to QuarantineMode.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] proactive_ha_provider_ids: The list of IDs for health update providers configured for this cluster.
        :param pulumi.Input[str] proactive_ha_severe_remediation: The configured remediation for severely degraded hosts. Can be one of MaintenanceMode or QuarantineMode. Note that this
               cannot be set to QuarantineMode when proactive_ha_moderate_remediation is set to MaintenanceMode.
        :param pulumi.Input[str] resource_pool_id: The managed object ID of the primary
               resource pool for this cluster. This can be passed directly to the
               `resource_pool_id`
               attribute of the
               `VirtualMachine` resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The IDs of any tags to attach to this resource.
        :param pulumi.Input[bool] vsan_compression_enabled: Whether the vSAN compression service is enabled for the cluster.
        :param pulumi.Input[bool] vsan_dedup_enabled: Whether the vSAN deduplication service is enabled for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComputeClusterVsanDiskGroupArgs']]]] vsan_disk_groups: A list of disk UUIDs to add to the vSAN cluster.
        :param pulumi.Input[bool] vsan_dit_encryption_enabled: Whether the vSAN data-in-transit encryption is enabled for the cluster.
        :param pulumi.Input[int] vsan_dit_rekey_interval: When vsan_dit_encryption_enabled is enabled, sets the rekey interval of data-in-transit encryption (in minutes).
        :param pulumi.Input[bool] vsan_enabled: Whether the vSAN service is enabled for the cluster.
        :param pulumi.Input[bool] vsan_esa_enabled: Whether the vSAN ESA service is enabled for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ComputeClusterVsanFaultDomainArgs']]]] vsan_fault_domains: The configuration for vSAN fault domains.
        :param pulumi.Input[bool] vsan_network_diagnostic_mode_enabled: Whether the vSAN network diagnostic mode is enabled for the cluster.
        :param pulumi.Input[bool] vsan_performance_enabled: Whether the vSAN performance service is enabled for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vsan_remote_datastore_ids: The managed object IDs of the vSAN datastore to be mounted on the cluster.
        :param pulumi.Input[pulumi.InputType['ComputeClusterVsanStretchedClusterArgs']] vsan_stretched_cluster: The configuration for stretched cluster.
        :param pulumi.Input[bool] vsan_unmap_enabled: Whether the vSAN unmap service is enabled for the cluster.
        :param pulumi.Input[bool] vsan_verbose_mode_enabled: Whether the vSAN verbose mode is enabled for the cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeClusterState.__new__(_ComputeClusterState)

        __props__.__dict__["custom_attributes"] = custom_attributes
        __props__.__dict__["datacenter_id"] = datacenter_id
        __props__.__dict__["dpm_automation_level"] = dpm_automation_level
        __props__.__dict__["dpm_enabled"] = dpm_enabled
        __props__.__dict__["dpm_threshold"] = dpm_threshold
        __props__.__dict__["drs_advanced_options"] = drs_advanced_options
        __props__.__dict__["drs_automation_level"] = drs_automation_level
        __props__.__dict__["drs_enable_predictive_drs"] = drs_enable_predictive_drs
        __props__.__dict__["drs_enable_vm_overrides"] = drs_enable_vm_overrides
        __props__.__dict__["drs_enabled"] = drs_enabled
        __props__.__dict__["drs_migration_threshold"] = drs_migration_threshold
        __props__.__dict__["drs_scale_descendants_shares"] = drs_scale_descendants_shares
        __props__.__dict__["folder"] = folder
        __props__.__dict__["force_evacuate_on_destroy"] = force_evacuate_on_destroy
        __props__.__dict__["ha_admission_control_failover_host_system_ids"] = ha_admission_control_failover_host_system_ids
        __props__.__dict__["ha_admission_control_host_failure_tolerance"] = ha_admission_control_host_failure_tolerance
        __props__.__dict__["ha_admission_control_performance_tolerance"] = ha_admission_control_performance_tolerance
        __props__.__dict__["ha_admission_control_policy"] = ha_admission_control_policy
        __props__.__dict__["ha_admission_control_resource_percentage_auto_compute"] = ha_admission_control_resource_percentage_auto_compute
        __props__.__dict__["ha_admission_control_resource_percentage_cpu"] = ha_admission_control_resource_percentage_cpu
        __props__.__dict__["ha_admission_control_resource_percentage_memory"] = ha_admission_control_resource_percentage_memory
        __props__.__dict__["ha_admission_control_slot_policy_explicit_cpu"] = ha_admission_control_slot_policy_explicit_cpu
        __props__.__dict__["ha_admission_control_slot_policy_explicit_memory"] = ha_admission_control_slot_policy_explicit_memory
        __props__.__dict__["ha_admission_control_slot_policy_use_explicit_size"] = ha_admission_control_slot_policy_use_explicit_size
        __props__.__dict__["ha_advanced_options"] = ha_advanced_options
        __props__.__dict__["ha_datastore_apd_recovery_action"] = ha_datastore_apd_recovery_action
        __props__.__dict__["ha_datastore_apd_response"] = ha_datastore_apd_response
        __props__.__dict__["ha_datastore_apd_response_delay"] = ha_datastore_apd_response_delay
        __props__.__dict__["ha_datastore_pdl_response"] = ha_datastore_pdl_response
        __props__.__dict__["ha_enabled"] = ha_enabled
        __props__.__dict__["ha_heartbeat_datastore_ids"] = ha_heartbeat_datastore_ids
        __props__.__dict__["ha_heartbeat_datastore_policy"] = ha_heartbeat_datastore_policy
        __props__.__dict__["ha_host_isolation_response"] = ha_host_isolation_response
        __props__.__dict__["ha_host_monitoring"] = ha_host_monitoring
        __props__.__dict__["ha_vm_component_protection"] = ha_vm_component_protection
        __props__.__dict__["ha_vm_dependency_restart_condition"] = ha_vm_dependency_restart_condition
        __props__.__dict__["ha_vm_failure_interval"] = ha_vm_failure_interval
        __props__.__dict__["ha_vm_maximum_failure_window"] = ha_vm_maximum_failure_window
        __props__.__dict__["ha_vm_maximum_resets"] = ha_vm_maximum_resets
        __props__.__dict__["ha_vm_minimum_uptime"] = ha_vm_minimum_uptime
        __props__.__dict__["ha_vm_monitoring"] = ha_vm_monitoring
        __props__.__dict__["ha_vm_restart_additional_delay"] = ha_vm_restart_additional_delay
        __props__.__dict__["ha_vm_restart_priority"] = ha_vm_restart_priority
        __props__.__dict__["ha_vm_restart_timeout"] = ha_vm_restart_timeout
        __props__.__dict__["host_cluster_exit_timeout"] = host_cluster_exit_timeout
        __props__.__dict__["host_image"] = host_image
        __props__.__dict__["host_managed"] = host_managed
        __props__.__dict__["host_system_ids"] = host_system_ids
        __props__.__dict__["name"] = name
        __props__.__dict__["proactive_ha_automation_level"] = proactive_ha_automation_level
        __props__.__dict__["proactive_ha_enabled"] = proactive_ha_enabled
        __props__.__dict__["proactive_ha_moderate_remediation"] = proactive_ha_moderate_remediation
        __props__.__dict__["proactive_ha_provider_ids"] = proactive_ha_provider_ids
        __props__.__dict__["proactive_ha_severe_remediation"] = proactive_ha_severe_remediation
        __props__.__dict__["resource_pool_id"] = resource_pool_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vsan_compression_enabled"] = vsan_compression_enabled
        __props__.__dict__["vsan_dedup_enabled"] = vsan_dedup_enabled
        __props__.__dict__["vsan_disk_groups"] = vsan_disk_groups
        __props__.__dict__["vsan_dit_encryption_enabled"] = vsan_dit_encryption_enabled
        __props__.__dict__["vsan_dit_rekey_interval"] = vsan_dit_rekey_interval
        __props__.__dict__["vsan_enabled"] = vsan_enabled
        __props__.__dict__["vsan_esa_enabled"] = vsan_esa_enabled
        __props__.__dict__["vsan_fault_domains"] = vsan_fault_domains
        __props__.__dict__["vsan_network_diagnostic_mode_enabled"] = vsan_network_diagnostic_mode_enabled
        __props__.__dict__["vsan_performance_enabled"] = vsan_performance_enabled
        __props__.__dict__["vsan_remote_datastore_ids"] = vsan_remote_datastore_ids
        __props__.__dict__["vsan_stretched_cluster"] = vsan_stretched_cluster
        __props__.__dict__["vsan_unmap_enabled"] = vsan_unmap_enabled
        __props__.__dict__["vsan_verbose_mode_enabled"] = vsan_verbose_mode_enabled
        return ComputeCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of custom attribute ids to attribute
        value strings to set for the datastore cluster.

        > **NOTE:** Custom attributes are unsupported on direct ESXi connections
        and require vCenter Server.
        """
        return pulumi.get(self, "custom_attributes")

    @property
    @pulumi.getter(name="datacenterId")
    def datacenter_id(self) -> pulumi.Output[str]:
        """
        The managed object ID of
        the datacenter to create the cluster in. Forces a new resource if changed.
        """
        return pulumi.get(self, "datacenter_id")

    @property
    @pulumi.getter(name="dpmAutomationLevel")
    def dpm_automation_level(self) -> pulumi.Output[Optional[str]]:
        """
        The automation level for host power operations in this cluster. Can be one of manual or automated.
        """
        return pulumi.get(self, "dpm_automation_level")

    @property
    @pulumi.getter(name="dpmEnabled")
    def dpm_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable DPM support for DRS. This allows you to dynamically control the power of hosts depending on the needs of virtual
        machines in the cluster. Requires that DRS be enabled.
        """
        return pulumi.get(self, "dpm_enabled")

    @property
    @pulumi.getter(name="dpmThreshold")
    def dpm_threshold(self) -> pulumi.Output[Optional[int]]:
        """
        A value between 1 and 5 indicating the threshold of load within the cluster that influences host power operations. This
        affects both power on and power off operations - a lower setting will tolerate more of a surplus/deficit than a higher
        setting.
        """
        return pulumi.get(self, "dpm_threshold")

    @property
    @pulumi.getter(name="drsAdvancedOptions")
    def drs_advanced_options(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Advanced configuration options for DRS and DPM.
        """
        return pulumi.get(self, "drs_advanced_options")

    @property
    @pulumi.getter(name="drsAutomationLevel")
    def drs_automation_level(self) -> pulumi.Output[Optional[str]]:
        """
        The default automation level for all virtual machines in this cluster. Can be one of manual, partiallyAutomated, or
        fullyAutomated.
        """
        return pulumi.get(self, "drs_automation_level")

    @property
    @pulumi.getter(name="drsEnablePredictiveDrs")
    def drs_enable_predictive_drs(self) -> pulumi.Output[Optional[bool]]:
        """
        When true, enables DRS to use data from vRealize Operations Manager to make proactive DRS recommendations.
        """
        return pulumi.get(self, "drs_enable_predictive_drs")

    @property
    @pulumi.getter(name="drsEnableVmOverrides")
    def drs_enable_vm_overrides(self) -> pulumi.Output[Optional[bool]]:
        """
        When true, allows individual VM overrides within this cluster to be set.
        """
        return pulumi.get(self, "drs_enable_vm_overrides")

    @property
    @pulumi.getter(name="drsEnabled")
    def drs_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable DRS for this cluster.
        """
        return pulumi.get(self, "drs_enabled")

    @property
    @pulumi.getter(name="drsMigrationThreshold")
    def drs_migration_threshold(self) -> pulumi.Output[Optional[int]]:
        """
        A value between 1 and 5 indicating the threshold of imbalance tolerated between hosts. A lower setting will tolerate
        more imbalance while a higher setting will tolerate less.
        """
        return pulumi.get(self, "drs_migration_threshold")

    @property
    @pulumi.getter(name="drsScaleDescendantsShares")
    def drs_scale_descendants_shares(self) -> pulumi.Output[Optional[str]]:
        """
        Enable scalable shares for all descendants of this cluster.
        """
        return pulumi.get(self, "drs_scale_descendants_shares")

    @property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[str]]:
        """
        The relative path to a folder to put this cluster in.
        This is a path relative to the datacenter you are deploying the cluster to.
        Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
        The provider will place a cluster named `compute-cluster-test` in a
        host folder located at `/dc1/host/foo/bar`, with the final inventory path
        being `/dc1/host/foo/bar/datastore-cluster-test`.
        """
        return pulumi.get(self, "folder")

    @property
    @pulumi.getter(name="forceEvacuateOnDestroy")
    def force_evacuate_on_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        Force removal of all hosts in the cluster during destroy and make them standalone hosts. Use of this flag mainly exists
        for testing and is not recommended in normal use.
        """
        return pulumi.get(self, "force_evacuate_on_destroy")

    @property
    @pulumi.getter(name="haAdmissionControlFailoverHostSystemIds")
    def ha_admission_control_failover_host_system_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        When ha_admission_control_policy is failoverHosts, this defines the managed object IDs of hosts to use as dedicated
        failover hosts. These hosts are kept as available as possible - admission control will block access to the host, and DRS
        will ignore the host when making recommendations.
        """
        return pulumi.get(self, "ha_admission_control_failover_host_system_ids")

    @property
    @pulumi.getter(name="haAdmissionControlHostFailureTolerance")
    def ha_admission_control_host_failure_tolerance(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of failed hosts that admission control tolerates when making decisions on whether to permit virtual
        machine operations. The maximum is one less than the number of hosts in the cluster.
        """
        return pulumi.get(self, "ha_admission_control_host_failure_tolerance")

    @property
    @pulumi.getter(name="haAdmissionControlPerformanceTolerance")
    def ha_admission_control_performance_tolerance(self) -> pulumi.Output[Optional[int]]:
        """
        The percentage of resource reduction that a cluster of VMs can tolerate in case of a failover. A value of 0 produces
        warnings only, whereas a value of 100 disables the setting.
        """
        return pulumi.get(self, "ha_admission_control_performance_tolerance")

    @property
    @pulumi.getter(name="haAdmissionControlPolicy")
    def ha_admission_control_policy(self) -> pulumi.Output[Optional[str]]:
        """
        The type of admission control policy to use with vSphere HA, which controls whether or not specific VM operations are
        permitted in the cluster in order to protect the reliability of the cluster. Can be one of resourcePercentage,
        slotPolicy, failoverHosts, or disabled. Note that disabling admission control is not recommended and can lead to service
        issues.
        """
        return pulumi.get(self, "ha_admission_control_policy")

    @property
    @pulumi.getter(name="haAdmissionControlResourcePercentageAutoCompute")
    def ha_admission_control_resource_percentage_auto_compute(self) -> pulumi.Output[Optional[bool]]:
        """
        When ha_admission_control_policy is resourcePercentage, automatically determine available resource percentages by
        subtracting the average number of host resources represented by the ha_admission_control_host_failure_tolerance setting
        from the total amount of resources in the cluster. Disable to supply user-defined values.
        """
        return pulumi.get(self, "ha_admission_control_resource_percentage_auto_compute")

    @property
    @pulumi.getter(name="haAdmissionControlResourcePercentageCpu")
    def ha_admission_control_resource_percentage_cpu(self) -> pulumi.Output[Optional[int]]:
        """
        When ha_admission_control_policy is resourcePercentage, this controls the user-defined percentage of CPU resources in
        the cluster to reserve for failover.
        """
        return pulumi.get(self, "ha_admission_control_resource_percentage_cpu")

    @property
    @pulumi.getter(name="haAdmissionControlResourcePercentageMemory")
    def ha_admission_control_resource_percentage_memory(self) -> pulumi.Output[Optional[int]]:
        """
        When ha_admission_control_policy is resourcePercentage, this controls the user-defined percentage of memory resources in
        the cluster to reserve for failover.
        """
        return pulumi.get(self, "ha_admission_control_resource_percentage_memory")

    @property
    @pulumi.getter(name="haAdmissionControlSlotPolicyExplicitCpu")
    def ha_admission_control_slot_policy_explicit_cpu(self) -> pulumi.Output[Optional[int]]:
        """
        When ha_admission_control_policy is slotPolicy, this controls the user-defined CPU slot size, in MHz.
        """
        return pulumi.get(self, "ha_admission_control_slot_policy_explicit_cpu")

    @property
    @pulumi.getter(name="haAdmissionControlSlotPolicyExplicitMemory")
    def ha_admission_control_slot_policy_explicit_memory(self) -> pulumi.Output[Optional[int]]:
        """
        When ha_admission_control_policy is slotPolicy, this controls the user-defined memory slot size, in MB.
        """
        return pulumi.get(self, "ha_admission_control_slot_policy_explicit_memory")

    @property
    @pulumi.getter(name="haAdmissionControlSlotPolicyUseExplicitSize")
    def ha_admission_control_slot_policy_use_explicit_size(self) -> pulumi.Output[Optional[bool]]:
        """
        When ha_admission_control_policy is slotPolicy, this setting controls whether or not you wish to supply explicit values
        to CPU and memory slot sizes. The default is to gather a automatic average based on all powered-on virtual machines
        currently in the cluster.
        """
        return pulumi.get(self, "ha_admission_control_slot_policy_use_explicit_size")

    @property
    @pulumi.getter(name="haAdvancedOptions")
    def ha_advanced_options(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Advanced configuration options for vSphere HA.
        """
        return pulumi.get(self, "ha_advanced_options")

    @property
    @pulumi.getter(name="haDatastoreApdRecoveryAction")
    def ha_datastore_apd_recovery_action(self) -> pulumi.Output[Optional[str]]:
        """
        When ha_vm_component_protection is enabled, controls the action to take on virtual machines if an APD status on an
        affected datastore clears in the middle of an APD event. Can be one of none or reset.
        """
        return pulumi.get(self, "ha_datastore_apd_recovery_action")

    @property
    @pulumi.getter(name="haDatastoreApdResponse")
    def ha_datastore_apd_response(self) -> pulumi.Output[Optional[str]]:
        """
        When ha_vm_component_protection is enabled, controls the action to take on virtual machines when the cluster has
        detected loss to all paths to a relevant datastore. Can be one of disabled, warning, restartConservative, or
        restartAggressive.
        """
        return pulumi.get(self, "ha_datastore_apd_response")

    @property
    @pulumi.getter(name="haDatastoreApdResponseDelay")
    def ha_datastore_apd_response_delay(self) -> pulumi.Output[Optional[int]]:
        """
        When ha_vm_component_protection is enabled, controls the delay in seconds to wait after an APD timeout event to execute
        the response action defined in ha_datastore_apd_response.
        """
        return pulumi.get(self, "ha_datastore_apd_response_delay")

    @property
    @pulumi.getter(name="haDatastorePdlResponse")
    def ha_datastore_pdl_response(self) -> pulumi.Output[Optional[str]]:
        """
        When ha_vm_component_protection is enabled, controls the action to take on virtual machines when the cluster has
        detected a permanent device loss to a relevant datastore. Can be one of disabled, warning, or restartAggressive.
        """
        return pulumi.get(self, "ha_datastore_pdl_response")

    @property
    @pulumi.getter(name="haEnabled")
    def ha_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable vSphere HA for this cluster.
        """
        return pulumi.get(self, "ha_enabled")

    @property
    @pulumi.getter(name="haHeartbeatDatastoreIds")
    def ha_heartbeat_datastore_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of managed object IDs for preferred datastores to use for HA heartbeating. This setting is only useful when
        ha_heartbeat_datastore_policy is set to either userSelectedDs or allFeasibleDsWithUserPreference.
        """
        return pulumi.get(self, "ha_heartbeat_datastore_ids")

    @property
    @pulumi.getter(name="haHeartbeatDatastorePolicy")
    def ha_heartbeat_datastore_policy(self) -> pulumi.Output[Optional[str]]:
        """
        The selection policy for HA heartbeat datastores. Can be one of allFeasibleDs, userSelectedDs, or
        allFeasibleDsWithUserPreference.
        """
        return pulumi.get(self, "ha_heartbeat_datastore_policy")

    @property
    @pulumi.getter(name="haHostIsolationResponse")
    def ha_host_isolation_response(self) -> pulumi.Output[Optional[str]]:
        """
        The action to take on virtual machines when a host has detected that it has been isolated from the rest of the cluster.
        Can be one of none, powerOff, or shutdown.
        """
        return pulumi.get(self, "ha_host_isolation_response")

    @property
    @pulumi.getter(name="haHostMonitoring")
    def ha_host_monitoring(self) -> pulumi.Output[Optional[str]]:
        """
        Global setting that controls whether vSphere HA remediates VMs on host failure. Can be one of enabled or disabled.
        """
        return pulumi.get(self, "ha_host_monitoring")

    @property
    @pulumi.getter(name="haVmComponentProtection")
    def ha_vm_component_protection(self) -> pulumi.Output[Optional[str]]:
        """
        Controls vSphere VM component protection for virtual machines in this cluster. This allows vSphere HA to react to
        failures between hosts and specific virtual machine components, such as datastores. Can be one of enabled or disabled.
        """
        return pulumi.get(self, "ha_vm_component_protection")

    @property
    @pulumi.getter(name="haVmDependencyRestartCondition")
    def ha_vm_dependency_restart_condition(self) -> pulumi.Output[Optional[str]]:
        """
        The condition used to determine whether or not VMs in a certain restart priority class are online, allowing HA to move
        on to restarting VMs on the next priority. Can be one of none, poweredOn, guestHbStatusGreen, or appHbStatusGreen.
        """
        return pulumi.get(self, "ha_vm_dependency_restart_condition")

    @property
    @pulumi.getter(name="haVmFailureInterval")
    def ha_vm_failure_interval(self) -> pulumi.Output[Optional[int]]:
        """
        If a heartbeat from a virtual machine is not received within this configured interval, the virtual machine is marked as
        failed. The value is in seconds.
        """
        return pulumi.get(self, "ha_vm_failure_interval")

    @property
    @pulumi.getter(name="haVmMaximumFailureWindow")
    def ha_vm_maximum_failure_window(self) -> pulumi.Output[Optional[int]]:
        """
        The length of the reset window in which ha_vm_maximum_resets can operate. When this window expires, no more resets are
        attempted regardless of the setting configured in ha_vm_maximum_resets. -1 means no window, meaning an unlimited reset
        time is allotted.
        """
        return pulumi.get(self, "ha_vm_maximum_failure_window")

    @property
    @pulumi.getter(name="haVmMaximumResets")
    def ha_vm_maximum_resets(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of resets that HA will perform to a virtual machine when responding to a failure event.
        """
        return pulumi.get(self, "ha_vm_maximum_resets")

    @property
    @pulumi.getter(name="haVmMinimumUptime")
    def ha_vm_minimum_uptime(self) -> pulumi.Output[Optional[int]]:
        """
        The time, in seconds, that HA waits after powering on a virtual machine before monitoring for heartbeats.
        """
        return pulumi.get(self, "ha_vm_minimum_uptime")

    @property
    @pulumi.getter(name="haVmMonitoring")
    def ha_vm_monitoring(self) -> pulumi.Output[Optional[str]]:
        """
        The type of virtual machine monitoring to use when HA is enabled in the cluster. Can be one of vmMonitoringDisabled,
        vmMonitoringOnly, or vmAndAppMonitoring.
        """
        return pulumi.get(self, "ha_vm_monitoring")

    @property
    @pulumi.getter(name="haVmRestartAdditionalDelay")
    def ha_vm_restart_additional_delay(self) -> pulumi.Output[Optional[int]]:
        """
        Additional delay in seconds after ready condition is met. A VM is considered ready at this point.
        """
        return pulumi.get(self, "ha_vm_restart_additional_delay")

    @property
    @pulumi.getter(name="haVmRestartPriority")
    def ha_vm_restart_priority(self) -> pulumi.Output[Optional[str]]:
        """
        The default restart priority for affected VMs when vSphere detects a host failure. Can be one of lowest, low, medium,
        high, or highest.
        """
        return pulumi.get(self, "ha_vm_restart_priority")

    @property
    @pulumi.getter(name="haVmRestartTimeout")
    def ha_vm_restart_timeout(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum time, in seconds, that vSphere HA will wait for virtual machines in one priority to be ready before
        proceeding with the next priority.
        """
        return pulumi.get(self, "ha_vm_restart_timeout")

    @property
    @pulumi.getter(name="hostClusterExitTimeout")
    def host_cluster_exit_timeout(self) -> pulumi.Output[Optional[int]]:
        """
        The timeout for each host maintenance mode operation when removing hosts from a cluster.
        """
        return pulumi.get(self, "host_cluster_exit_timeout")

    @property
    @pulumi.getter(name="hostImage")
    def host_image(self) -> pulumi.Output[Optional['outputs.ComputeClusterHostImage']]:
        """
        Details about the host image which should be applied to the cluster.
        """
        return pulumi.get(self, "host_image")

    @property
    @pulumi.getter(name="hostManaged")
    def host_managed(self) -> pulumi.Output[Optional[bool]]:
        """
        Must be set if cluster enrollment is managed from host resource.
        """
        return pulumi.get(self, "host_managed")

    @property
    @pulumi.getter(name="hostSystemIds")
    def host_system_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The managed object IDs of the hosts to put in the cluster.
        """
        return pulumi.get(self, "host_system_ids")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="proactiveHaAutomationLevel")
    def proactive_ha_automation_level(self) -> pulumi.Output[Optional[str]]:
        """
        The DRS behavior for proactive HA recommendations. Can be one of Automated or Manual.
        """
        return pulumi.get(self, "proactive_ha_automation_level")

    @property
    @pulumi.getter(name="proactiveHaEnabled")
    def proactive_ha_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables proactive HA, allowing for vSphere to get HA data from external providers and use DRS to perform remediation.
        """
        return pulumi.get(self, "proactive_ha_enabled")

    @property
    @pulumi.getter(name="proactiveHaModerateRemediation")
    def proactive_ha_moderate_remediation(self) -> pulumi.Output[Optional[str]]:
        """
        The configured remediation for moderately degraded hosts. Can be one of MaintenanceMode or QuarantineMode. Note that
        this cannot be set to MaintenanceMode when proactive_ha_severe_remediation is set to QuarantineMode.
        """
        return pulumi.get(self, "proactive_ha_moderate_remediation")

    @property
    @pulumi.getter(name="proactiveHaProviderIds")
    def proactive_ha_provider_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of IDs for health update providers configured for this cluster.
        """
        return pulumi.get(self, "proactive_ha_provider_ids")

    @property
    @pulumi.getter(name="proactiveHaSevereRemediation")
    def proactive_ha_severe_remediation(self) -> pulumi.Output[Optional[str]]:
        """
        The configured remediation for severely degraded hosts. Can be one of MaintenanceMode or QuarantineMode. Note that this
        cannot be set to QuarantineMode when proactive_ha_moderate_remediation is set to MaintenanceMode.
        """
        return pulumi.get(self, "proactive_ha_severe_remediation")

    @property
    @pulumi.getter(name="resourcePoolId")
    def resource_pool_id(self) -> pulumi.Output[str]:
        """
        The managed object ID of the primary
        resource pool for this cluster. This can be passed directly to the
        `resource_pool_id`
        attribute of the
        `VirtualMachine` resource.
        """
        return pulumi.get(self, "resource_pool_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The IDs of any tags to attach to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vsanCompressionEnabled")
    def vsan_compression_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the vSAN compression service is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_compression_enabled")

    @property
    @pulumi.getter(name="vsanDedupEnabled")
    def vsan_dedup_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the vSAN deduplication service is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_dedup_enabled")

    @property
    @pulumi.getter(name="vsanDiskGroups")
    def vsan_disk_groups(self) -> pulumi.Output[Sequence['outputs.ComputeClusterVsanDiskGroup']]:
        """
        A list of disk UUIDs to add to the vSAN cluster.
        """
        return pulumi.get(self, "vsan_disk_groups")

    @property
    @pulumi.getter(name="vsanDitEncryptionEnabled")
    def vsan_dit_encryption_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the vSAN data-in-transit encryption is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_dit_encryption_enabled")

    @property
    @pulumi.getter(name="vsanDitRekeyInterval")
    def vsan_dit_rekey_interval(self) -> pulumi.Output[int]:
        """
        When vsan_dit_encryption_enabled is enabled, sets the rekey interval of data-in-transit encryption (in minutes).
        """
        return pulumi.get(self, "vsan_dit_rekey_interval")

    @property
    @pulumi.getter(name="vsanEnabled")
    def vsan_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the vSAN service is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_enabled")

    @property
    @pulumi.getter(name="vsanEsaEnabled")
    def vsan_esa_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the vSAN ESA service is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_esa_enabled")

    @property
    @pulumi.getter(name="vsanFaultDomains")
    def vsan_fault_domains(self) -> pulumi.Output[Optional[Sequence['outputs.ComputeClusterVsanFaultDomain']]]:
        """
        The configuration for vSAN fault domains.
        """
        return pulumi.get(self, "vsan_fault_domains")

    @property
    @pulumi.getter(name="vsanNetworkDiagnosticModeEnabled")
    def vsan_network_diagnostic_mode_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the vSAN network diagnostic mode is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_network_diagnostic_mode_enabled")

    @property
    @pulumi.getter(name="vsanPerformanceEnabled")
    def vsan_performance_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the vSAN performance service is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_performance_enabled")

    @property
    @pulumi.getter(name="vsanRemoteDatastoreIds")
    def vsan_remote_datastore_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The managed object IDs of the vSAN datastore to be mounted on the cluster.
        """
        return pulumi.get(self, "vsan_remote_datastore_ids")

    @property
    @pulumi.getter(name="vsanStretchedCluster")
    def vsan_stretched_cluster(self) -> pulumi.Output[Optional['outputs.ComputeClusterVsanStretchedCluster']]:
        """
        The configuration for stretched cluster.
        """
        return pulumi.get(self, "vsan_stretched_cluster")

    @property
    @pulumi.getter(name="vsanUnmapEnabled")
    def vsan_unmap_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the vSAN unmap service is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_unmap_enabled")

    @property
    @pulumi.getter(name="vsanVerboseModeEnabled")
    def vsan_verbose_mode_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the vSAN verbose mode is enabled for the cluster.
        """
        return pulumi.get(self, "vsan_verbose_mode_enabled")

