# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ComputeClusterVmAffinityRuleArgs', 'ComputeClusterVmAffinityRule']

@pulumi.input_type
class ComputeClusterVmAffinityRuleArgs:
    def __init__(__self__, *,
                 compute_cluster_id: pulumi.Input[str],
                 virtual_machine_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 enabled: Optional[pulumi.Input[bool]] = None,
                 mandatory: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ComputeClusterVmAffinityRule resource.
        :param pulumi.Input[str] compute_cluster_id: The managed object reference
               ID of the cluster to put the group in.  Forces a new
               resource if changed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] virtual_machine_ids: The UUIDs of the virtual machines to run
               on the same host together.
        :param pulumi.Input[bool] enabled: Enable this rule in the cluster. Default: `true`.
        :param pulumi.Input[bool] mandatory: When this value is `true`, prevents any virtual
               machine operations that may violate this rule. Default: `false`.
               
               > **NOTE:** The namespace for rule names on this resource (defined by the
               `name` argument) is shared with all rules in the cluster - consider
               this when naming your rules.
        :param pulumi.Input[str] name: The name of the rule. This must be unique in the cluster.
        """
        pulumi.set(__self__, "compute_cluster_id", compute_cluster_id)
        pulumi.set(__self__, "virtual_machine_ids", virtual_machine_ids)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if mandatory is not None:
            pulumi.set(__self__, "mandatory", mandatory)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> pulumi.Input[str]:
        """
        The managed object reference
        ID of the cluster to put the group in.  Forces a new
        resource if changed.
        """
        return pulumi.get(self, "compute_cluster_id")

    @compute_cluster_id.setter
    def compute_cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_cluster_id", value)

    @property
    @pulumi.getter(name="virtualMachineIds")
    def virtual_machine_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The UUIDs of the virtual machines to run
        on the same host together.
        """
        return pulumi.get(self, "virtual_machine_ids")

    @virtual_machine_ids.setter
    def virtual_machine_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "virtual_machine_ids", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable this rule in the cluster. Default: `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def mandatory(self) -> Optional[pulumi.Input[bool]]:
        """
        When this value is `true`, prevents any virtual
        machine operations that may violate this rule. Default: `false`.

        > **NOTE:** The namespace for rule names on this resource (defined by the
        `name` argument) is shared with all rules in the cluster - consider
        this when naming your rules.
        """
        return pulumi.get(self, "mandatory")

    @mandatory.setter
    def mandatory(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mandatory", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the rule. This must be unique in the cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ComputeClusterVmAffinityRuleState:
    def __init__(__self__, *,
                 compute_cluster_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 mandatory: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 virtual_machine_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering ComputeClusterVmAffinityRule resources.
        :param pulumi.Input[str] compute_cluster_id: The managed object reference
               ID of the cluster to put the group in.  Forces a new
               resource if changed.
        :param pulumi.Input[bool] enabled: Enable this rule in the cluster. Default: `true`.
        :param pulumi.Input[bool] mandatory: When this value is `true`, prevents any virtual
               machine operations that may violate this rule. Default: `false`.
               
               > **NOTE:** The namespace for rule names on this resource (defined by the
               `name` argument) is shared with all rules in the cluster - consider
               this when naming your rules.
        :param pulumi.Input[str] name: The name of the rule. This must be unique in the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] virtual_machine_ids: The UUIDs of the virtual machines to run
               on the same host together.
        """
        if compute_cluster_id is not None:
            pulumi.set(__self__, "compute_cluster_id", compute_cluster_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if mandatory is not None:
            pulumi.set(__self__, "mandatory", mandatory)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if virtual_machine_ids is not None:
            pulumi.set(__self__, "virtual_machine_ids", virtual_machine_ids)

    @property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The managed object reference
        ID of the cluster to put the group in.  Forces a new
        resource if changed.
        """
        return pulumi.get(self, "compute_cluster_id")

    @compute_cluster_id.setter
    def compute_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_cluster_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable this rule in the cluster. Default: `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def mandatory(self) -> Optional[pulumi.Input[bool]]:
        """
        When this value is `true`, prevents any virtual
        machine operations that may violate this rule. Default: `false`.

        > **NOTE:** The namespace for rule names on this resource (defined by the
        `name` argument) is shared with all rules in the cluster - consider
        this when naming your rules.
        """
        return pulumi.get(self, "mandatory")

    @mandatory.setter
    def mandatory(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mandatory", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the rule. This must be unique in the cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="virtualMachineIds")
    def virtual_machine_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The UUIDs of the virtual machines to run
        on the same host together.
        """
        return pulumi.get(self, "virtual_machine_ids")

    @virtual_machine_ids.setter
    def virtual_machine_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "virtual_machine_ids", value)


class ComputeClusterVmAffinityRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_cluster_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 mandatory: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 virtual_machine_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        The `ComputeClusterVmAffinityRule` resource can be used to
        manage virtual machine affinity rules in a cluster, either created by the
        `ComputeCluster` resource or looked up
        by the `ComputeCluster` data source.

        This rule can be used to tell a set of virtual machines to run together on the
        same host within a cluster. When configured, DRS will make a best effort to
        ensure that the virtual machines run on the same host, or prevent any operation
        that would keep that from happening, depending on the value of the
        `mandatory` flag.

        > An affinity rule can only be used to place virtual machines on the same
        _non-specific_ hosts. It cannot be used to pin virtual machines to a host.
        To enable this capability, use the
        `ComputeClusterVmHostRule`
        resource.

        > **NOTE:** This resource requires vCenter Server and is not available on
        direct ESXi host connections.

        > **NOTE:** vSphere DRS requires a vSphere Enterprise Plus license.

        ## Example Usage

        The following example creates two virtual machines in a cluster using the
        `VirtualMachine` resource, creating the
        virtual machines in the cluster looked up by the
        `ComputeCluster` data source. It
        then creates an affinity rule for these two virtual machines, ensuring they
        will run on the same host whenever possible.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        datastore = vsphere.get_datastore(name="datastore-01",
            datacenter_id=datacenter.id)
        cluster = vsphere.get_compute_cluster(name="cluster-01",
            datacenter_id=datacenter.id)
        network = vsphere.get_network(name="VM Network",
            datacenter_id=datacenter.id)
        vm = []
        for range in [{"value": i} for i in range(0, 2)]:
            vm.append(vsphere.VirtualMachine(f"vm-{range['value']}",
                name=f"foo-{range['value']}",
                resource_pool_id=cluster.resource_pool_id,
                datastore_id=datastore.id,
                num_cpus=1,
                memory=1024,
                guest_id="otherLinux64Guest",
                network_interfaces=[vsphere.VirtualMachineNetworkInterfaceArgs(
                    network_id=network.id,
                )],
                disks=[vsphere.VirtualMachineDiskArgs(
                    label="disk0",
                    size=20,
                )]))
        vm_affinity_rule = vsphere.ComputeClusterVmAffinityRule("vm_affinity_rule",
            name="vm-affinity-rule",
            compute_cluster_id=cluster.id,
            virtual_machine_ids=[v.id for k, v in vm])
        ```

        The following example creates an affinity rule for a set of virtual machines
        in the cluster by looking up the virtual machine UUIDs from the
        `VirtualMachine` data source.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        vms = [
            "foo-0",
            "foo-1",
        ]
        datacenter = vsphere.get_datacenter(name="dc-01")
        cluster = vsphere.get_compute_cluster(name="cluster-01",
            datacenter_id=datacenter.id)
        vms_get_virtual_machine = [vsphere.get_virtual_machine(name=vms[__index],
            datacenter_id=datacenter.id) for __index in range(len(vms))]
        vm_affinity_rule = vsphere.ComputeClusterVmAffinityRule("vm_affinity_rule",
            name="vm-affinity-rule",
            enabled=True,
            compute_cluster_id=cluster.id,
            virtual_machine_ids=[__item.id for __item in vms_get_virtual_machine])
        ```

        ## Importing

        An existing rule can be imported into this resource by supplying
        both the path to the cluster, and the name the rule. If the name or cluster is
        not found, or if the rule is of a different type, an error will be returned. An
        example is below:

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compute_cluster_id: The managed object reference
               ID of the cluster to put the group in.  Forces a new
               resource if changed.
        :param pulumi.Input[bool] enabled: Enable this rule in the cluster. Default: `true`.
        :param pulumi.Input[bool] mandatory: When this value is `true`, prevents any virtual
               machine operations that may violate this rule. Default: `false`.
               
               > **NOTE:** The namespace for rule names on this resource (defined by the
               `name` argument) is shared with all rules in the cluster - consider
               this when naming your rules.
        :param pulumi.Input[str] name: The name of the rule. This must be unique in the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] virtual_machine_ids: The UUIDs of the virtual machines to run
               on the same host together.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComputeClusterVmAffinityRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ComputeClusterVmAffinityRule` resource can be used to
        manage virtual machine affinity rules in a cluster, either created by the
        `ComputeCluster` resource or looked up
        by the `ComputeCluster` data source.

        This rule can be used to tell a set of virtual machines to run together on the
        same host within a cluster. When configured, DRS will make a best effort to
        ensure that the virtual machines run on the same host, or prevent any operation
        that would keep that from happening, depending on the value of the
        `mandatory` flag.

        > An affinity rule can only be used to place virtual machines on the same
        _non-specific_ hosts. It cannot be used to pin virtual machines to a host.
        To enable this capability, use the
        `ComputeClusterVmHostRule`
        resource.

        > **NOTE:** This resource requires vCenter Server and is not available on
        direct ESXi host connections.

        > **NOTE:** vSphere DRS requires a vSphere Enterprise Plus license.

        ## Example Usage

        The following example creates two virtual machines in a cluster using the
        `VirtualMachine` resource, creating the
        virtual machines in the cluster looked up by the
        `ComputeCluster` data source. It
        then creates an affinity rule for these two virtual machines, ensuring they
        will run on the same host whenever possible.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        datastore = vsphere.get_datastore(name="datastore-01",
            datacenter_id=datacenter.id)
        cluster = vsphere.get_compute_cluster(name="cluster-01",
            datacenter_id=datacenter.id)
        network = vsphere.get_network(name="VM Network",
            datacenter_id=datacenter.id)
        vm = []
        for range in [{"value": i} for i in range(0, 2)]:
            vm.append(vsphere.VirtualMachine(f"vm-{range['value']}",
                name=f"foo-{range['value']}",
                resource_pool_id=cluster.resource_pool_id,
                datastore_id=datastore.id,
                num_cpus=1,
                memory=1024,
                guest_id="otherLinux64Guest",
                network_interfaces=[vsphere.VirtualMachineNetworkInterfaceArgs(
                    network_id=network.id,
                )],
                disks=[vsphere.VirtualMachineDiskArgs(
                    label="disk0",
                    size=20,
                )]))
        vm_affinity_rule = vsphere.ComputeClusterVmAffinityRule("vm_affinity_rule",
            name="vm-affinity-rule",
            compute_cluster_id=cluster.id,
            virtual_machine_ids=[v.id for k, v in vm])
        ```

        The following example creates an affinity rule for a set of virtual machines
        in the cluster by looking up the virtual machine UUIDs from the
        `VirtualMachine` data source.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        vms = [
            "foo-0",
            "foo-1",
        ]
        datacenter = vsphere.get_datacenter(name="dc-01")
        cluster = vsphere.get_compute_cluster(name="cluster-01",
            datacenter_id=datacenter.id)
        vms_get_virtual_machine = [vsphere.get_virtual_machine(name=vms[__index],
            datacenter_id=datacenter.id) for __index in range(len(vms))]
        vm_affinity_rule = vsphere.ComputeClusterVmAffinityRule("vm_affinity_rule",
            name="vm-affinity-rule",
            enabled=True,
            compute_cluster_id=cluster.id,
            virtual_machine_ids=[__item.id for __item in vms_get_virtual_machine])
        ```

        ## Importing

        An existing rule can be imported into this resource by supplying
        both the path to the cluster, and the name the rule. If the name or cluster is
        not found, or if the rule is of a different type, an error will be returned. An
        example is below:

        :param str resource_name: The name of the resource.
        :param ComputeClusterVmAffinityRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeClusterVmAffinityRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_cluster_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 mandatory: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 virtual_machine_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeClusterVmAffinityRuleArgs.__new__(ComputeClusterVmAffinityRuleArgs)

            if compute_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'compute_cluster_id'")
            __props__.__dict__["compute_cluster_id"] = compute_cluster_id
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["mandatory"] = mandatory
            __props__.__dict__["name"] = name
            if virtual_machine_ids is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_machine_ids'")
            __props__.__dict__["virtual_machine_ids"] = virtual_machine_ids
        super(ComputeClusterVmAffinityRule, __self__).__init__(
            'vsphere:index/computeClusterVmAffinityRule:ComputeClusterVmAffinityRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compute_cluster_id: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            mandatory: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            virtual_machine_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'ComputeClusterVmAffinityRule':
        """
        Get an existing ComputeClusterVmAffinityRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compute_cluster_id: The managed object reference
               ID of the cluster to put the group in.  Forces a new
               resource if changed.
        :param pulumi.Input[bool] enabled: Enable this rule in the cluster. Default: `true`.
        :param pulumi.Input[bool] mandatory: When this value is `true`, prevents any virtual
               machine operations that may violate this rule. Default: `false`.
               
               > **NOTE:** The namespace for rule names on this resource (defined by the
               `name` argument) is shared with all rules in the cluster - consider
               this when naming your rules.
        :param pulumi.Input[str] name: The name of the rule. This must be unique in the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] virtual_machine_ids: The UUIDs of the virtual machines to run
               on the same host together.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeClusterVmAffinityRuleState.__new__(_ComputeClusterVmAffinityRuleState)

        __props__.__dict__["compute_cluster_id"] = compute_cluster_id
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["mandatory"] = mandatory
        __props__.__dict__["name"] = name
        __props__.__dict__["virtual_machine_ids"] = virtual_machine_ids
        return ComputeClusterVmAffinityRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> pulumi.Output[str]:
        """
        The managed object reference
        ID of the cluster to put the group in.  Forces a new
        resource if changed.
        """
        return pulumi.get(self, "compute_cluster_id")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable this rule in the cluster. Default: `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def mandatory(self) -> pulumi.Output[Optional[bool]]:
        """
        When this value is `true`, prevents any virtual
        machine operations that may violate this rule. Default: `false`.

        > **NOTE:** The namespace for rule names on this resource (defined by the
        `name` argument) is shared with all rules in the cluster - consider
        this when naming your rules.
        """
        return pulumi.get(self, "mandatory")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the rule. This must be unique in the cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="virtualMachineIds")
    def virtual_machine_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The UUIDs of the virtual machines to run
        on the same host together.
        """
        return pulumi.get(self, "virtual_machine_ids")

