# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ContentLibraryArgs', 'ContentLibrary']

@pulumi.input_type
class ContentLibraryArgs:
    def __init__(__self__, *,
                 storage_backings: pulumi.Input[Sequence[pulumi.Input[str]]],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 publication: Optional[pulumi.Input['ContentLibraryPublicationArgs']] = None,
                 subscription: Optional[pulumi.Input['ContentLibrarySubscriptionArgs']] = None):
        """
        The set of arguments for constructing a ContentLibrary resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] storage_backings: The managed object reference ID of the datastore on which to store the content library items.
        :param pulumi.Input[str] description: A description for the content library.
        :param pulumi.Input[str] name: The name of the content library.
        :param pulumi.Input['ContentLibraryPublicationArgs'] publication: Options to publish a local content library.
        :param pulumi.Input['ContentLibrarySubscriptionArgs'] subscription: Options subscribe to a published content library.
        """
        pulumi.set(__self__, "storage_backings", storage_backings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if publication is not None:
            pulumi.set(__self__, "publication", publication)
        if subscription is not None:
            pulumi.set(__self__, "subscription", subscription)

    @property
    @pulumi.getter(name="storageBackings")
    def storage_backings(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The managed object reference ID of the datastore on which to store the content library items.
        """
        return pulumi.get(self, "storage_backings")

    @storage_backings.setter
    def storage_backings(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "storage_backings", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the content library.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the content library.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def publication(self) -> Optional[pulumi.Input['ContentLibraryPublicationArgs']]:
        """
        Options to publish a local content library.
        """
        return pulumi.get(self, "publication")

    @publication.setter
    def publication(self, value: Optional[pulumi.Input['ContentLibraryPublicationArgs']]):
        pulumi.set(self, "publication", value)

    @property
    @pulumi.getter
    def subscription(self) -> Optional[pulumi.Input['ContentLibrarySubscriptionArgs']]:
        """
        Options subscribe to a published content library.
        """
        return pulumi.get(self, "subscription")

    @subscription.setter
    def subscription(self, value: Optional[pulumi.Input['ContentLibrarySubscriptionArgs']]):
        pulumi.set(self, "subscription", value)


@pulumi.input_type
class _ContentLibraryState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 publication: Optional[pulumi.Input['ContentLibraryPublicationArgs']] = None,
                 storage_backings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subscription: Optional[pulumi.Input['ContentLibrarySubscriptionArgs']] = None):
        """
        Input properties used for looking up and filtering ContentLibrary resources.
        :param pulumi.Input[str] description: A description for the content library.
        :param pulumi.Input[str] name: The name of the content library.
        :param pulumi.Input['ContentLibraryPublicationArgs'] publication: Options to publish a local content library.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] storage_backings: The managed object reference ID of the datastore on which to store the content library items.
        :param pulumi.Input['ContentLibrarySubscriptionArgs'] subscription: Options subscribe to a published content library.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if publication is not None:
            pulumi.set(__self__, "publication", publication)
        if storage_backings is not None:
            pulumi.set(__self__, "storage_backings", storage_backings)
        if subscription is not None:
            pulumi.set(__self__, "subscription", subscription)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the content library.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the content library.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def publication(self) -> Optional[pulumi.Input['ContentLibraryPublicationArgs']]:
        """
        Options to publish a local content library.
        """
        return pulumi.get(self, "publication")

    @publication.setter
    def publication(self, value: Optional[pulumi.Input['ContentLibraryPublicationArgs']]):
        pulumi.set(self, "publication", value)

    @property
    @pulumi.getter(name="storageBackings")
    def storage_backings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The managed object reference ID of the datastore on which to store the content library items.
        """
        return pulumi.get(self, "storage_backings")

    @storage_backings.setter
    def storage_backings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "storage_backings", value)

    @property
    @pulumi.getter
    def subscription(self) -> Optional[pulumi.Input['ContentLibrarySubscriptionArgs']]:
        """
        Options subscribe to a published content library.
        """
        return pulumi.get(self, "subscription")

    @subscription.setter
    def subscription(self, value: Optional[pulumi.Input['ContentLibrarySubscriptionArgs']]):
        pulumi.set(self, "subscription", value)


class ContentLibrary(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 publication: Optional[pulumi.Input[pulumi.InputType['ContentLibraryPublicationArgs']]] = None,
                 storage_backings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subscription: Optional[pulumi.Input[pulumi.InputType['ContentLibrarySubscriptionArgs']]] = None,
                 __props__=None):
        """
        Create a ContentLibrary resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description for the content library.
        :param pulumi.Input[str] name: The name of the content library.
        :param pulumi.Input[pulumi.InputType['ContentLibraryPublicationArgs']] publication: Options to publish a local content library.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] storage_backings: The managed object reference ID of the datastore on which to store the content library items.
        :param pulumi.Input[pulumi.InputType['ContentLibrarySubscriptionArgs']] subscription: Options subscribe to a published content library.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContentLibraryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ContentLibrary resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ContentLibraryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContentLibraryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 publication: Optional[pulumi.Input[pulumi.InputType['ContentLibraryPublicationArgs']]] = None,
                 storage_backings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subscription: Optional[pulumi.Input[pulumi.InputType['ContentLibrarySubscriptionArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContentLibraryArgs.__new__(ContentLibraryArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["publication"] = publication
            if storage_backings is None and not opts.urn:
                raise TypeError("Missing required property 'storage_backings'")
            __props__.__dict__["storage_backings"] = storage_backings
            __props__.__dict__["subscription"] = subscription
        super(ContentLibrary, __self__).__init__(
            'vsphere:index/contentLibrary:ContentLibrary',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            publication: Optional[pulumi.Input[pulumi.InputType['ContentLibraryPublicationArgs']]] = None,
            storage_backings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            subscription: Optional[pulumi.Input[pulumi.InputType['ContentLibrarySubscriptionArgs']]] = None) -> 'ContentLibrary':
        """
        Get an existing ContentLibrary resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description for the content library.
        :param pulumi.Input[str] name: The name of the content library.
        :param pulumi.Input[pulumi.InputType['ContentLibraryPublicationArgs']] publication: Options to publish a local content library.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] storage_backings: The managed object reference ID of the datastore on which to store the content library items.
        :param pulumi.Input[pulumi.InputType['ContentLibrarySubscriptionArgs']] subscription: Options subscribe to a published content library.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContentLibraryState.__new__(_ContentLibraryState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["publication"] = publication
        __props__.__dict__["storage_backings"] = storage_backings
        __props__.__dict__["subscription"] = subscription
        return ContentLibrary(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description for the content library.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the content library.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def publication(self) -> pulumi.Output['outputs.ContentLibraryPublication']:
        """
        Options to publish a local content library.
        """
        return pulumi.get(self, "publication")

    @property
    @pulumi.getter(name="storageBackings")
    def storage_backings(self) -> pulumi.Output[Sequence[str]]:
        """
        The managed object reference ID of the datastore on which to store the content library items.
        """
        return pulumi.get(self, "storage_backings")

    @property
    @pulumi.getter
    def subscription(self) -> pulumi.Output[Optional['outputs.ContentLibrarySubscription']]:
        """
        Options subscribe to a published content library.
        """
        return pulumi.get(self, "subscription")

