# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GuestOsCustomizationArgs', 'GuestOsCustomization']

@pulumi.input_type
class GuestOsCustomizationArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['GuestOsCustomizationSpecArgs'],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a GuestOsCustomization resource.
        :param pulumi.Input['GuestOsCustomizationSpecArgs'] spec: Container object for the Guest OS properties about to be customized . See virtual machine customizations
        :param pulumi.Input[str] type: The type of customization specification: One among: Windows, Linux.
        :param pulumi.Input[str] description: The description for the customization specification.
        :param pulumi.Input[str] name: The name of the customization specification is the unique identifier per vCenter Server instance.
        """
        pulumi.set(__self__, "spec", spec)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['GuestOsCustomizationSpecArgs']:
        """
        Container object for the Guest OS properties about to be customized . See virtual machine customizations
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['GuestOsCustomizationSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of customization specification: One among: Windows, Linux.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description for the customization specification.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the customization specification is the unique identifier per vCenter Server instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _GuestOsCustomizationState:
    def __init__(__self__, *,
                 change_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 last_update_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input['GuestOsCustomizationSpecArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GuestOsCustomization resources.
        :param pulumi.Input[str] change_version: The number of last changed version to the customization specification.
        :param pulumi.Input[str] description: The description for the customization specification.
        :param pulumi.Input[str] last_update_time: The time of last modification to the customization specification.
        :param pulumi.Input[str] name: The name of the customization specification is the unique identifier per vCenter Server instance.
        :param pulumi.Input['GuestOsCustomizationSpecArgs'] spec: Container object for the Guest OS properties about to be customized . See virtual machine customizations
        :param pulumi.Input[str] type: The type of customization specification: One among: Windows, Linux.
        """
        if change_version is not None:
            pulumi.set(__self__, "change_version", change_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="changeVersion")
    def change_version(self) -> Optional[pulumi.Input[str]]:
        """
        The number of last changed version to the customization specification.
        """
        return pulumi.get(self, "change_version")

    @change_version.setter
    def change_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "change_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description for the customization specification.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time of last modification to the customization specification.
        """
        return pulumi.get(self, "last_update_time")

    @last_update_time.setter
    def last_update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_update_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the customization specification is the unique identifier per vCenter Server instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['GuestOsCustomizationSpecArgs']]:
        """
        Container object for the Guest OS properties about to be customized . See virtual machine customizations
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['GuestOsCustomizationSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of customization specification: One among: Windows, Linux.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class GuestOsCustomization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[pulumi.InputType['GuestOsCustomizationSpecArgs']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The `GuestOsCustomization` resource can be used to a customization specification for a guest operating system.

        > **NOTE:** The name attribute is unique identifier for the guest OS spec per VC.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        windows_customization = vsphere.GuestOsCustomization("windows_customization",
            name="windows-spec",
            type="Windows",
            spec=vsphere.GuestOsCustomizationSpecArgs(
                windows_options=vsphere.GuestOsCustomizationSpecWindowsOptionsArgs(
                    run_once_command_lists=[
                        "command-1",
                        "command-2",
                    ],
                    computer_name="windows",
                    auto_logon=False,
                    auto_logon_count=0,
                    admin_password="VMware1!",
                    time_zone=4,
                    workgroup="workgroup",
                ),
            ))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description for the customization specification.
        :param pulumi.Input[str] name: The name of the customization specification is the unique identifier per vCenter Server instance.
        :param pulumi.Input[pulumi.InputType['GuestOsCustomizationSpecArgs']] spec: Container object for the Guest OS properties about to be customized . See virtual machine customizations
        :param pulumi.Input[str] type: The type of customization specification: One among: Windows, Linux.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GuestOsCustomizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `GuestOsCustomization` resource can be used to a customization specification for a guest operating system.

        > **NOTE:** The name attribute is unique identifier for the guest OS spec per VC.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        windows_customization = vsphere.GuestOsCustomization("windows_customization",
            name="windows-spec",
            type="Windows",
            spec=vsphere.GuestOsCustomizationSpecArgs(
                windows_options=vsphere.GuestOsCustomizationSpecWindowsOptionsArgs(
                    run_once_command_lists=[
                        "command-1",
                        "command-2",
                    ],
                    computer_name="windows",
                    auto_logon=False,
                    auto_logon_count=0,
                    admin_password="VMware1!",
                    time_zone=4,
                    workgroup="workgroup",
                ),
            ))
        ```

        :param str resource_name: The name of the resource.
        :param GuestOsCustomizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GuestOsCustomizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[pulumi.InputType['GuestOsCustomizationSpecArgs']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GuestOsCustomizationArgs.__new__(GuestOsCustomizationArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if spec is None and not opts.urn:
                raise TypeError("Missing required property 'spec'")
            __props__.__dict__["spec"] = spec
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["change_version"] = None
            __props__.__dict__["last_update_time"] = None
        super(GuestOsCustomization, __self__).__init__(
            'vsphere:index/guestOsCustomization:GuestOsCustomization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            change_version: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            last_update_time: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            spec: Optional[pulumi.Input[pulumi.InputType['GuestOsCustomizationSpecArgs']]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'GuestOsCustomization':
        """
        Get an existing GuestOsCustomization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] change_version: The number of last changed version to the customization specification.
        :param pulumi.Input[str] description: The description for the customization specification.
        :param pulumi.Input[str] last_update_time: The time of last modification to the customization specification.
        :param pulumi.Input[str] name: The name of the customization specification is the unique identifier per vCenter Server instance.
        :param pulumi.Input[pulumi.InputType['GuestOsCustomizationSpecArgs']] spec: Container object for the Guest OS properties about to be customized . See virtual machine customizations
        :param pulumi.Input[str] type: The type of customization specification: One among: Windows, Linux.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GuestOsCustomizationState.__new__(_GuestOsCustomizationState)

        __props__.__dict__["change_version"] = change_version
        __props__.__dict__["description"] = description
        __props__.__dict__["last_update_time"] = last_update_time
        __props__.__dict__["name"] = name
        __props__.__dict__["spec"] = spec
        __props__.__dict__["type"] = type
        return GuestOsCustomization(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="changeVersion")
    def change_version(self) -> pulumi.Output[str]:
        """
        The number of last changed version to the customization specification.
        """
        return pulumi.get(self, "change_version")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description for the customization specification.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> pulumi.Output[str]:
        """
        The time of last modification to the customization specification.
        """
        return pulumi.get(self, "last_update_time")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the customization specification is the unique identifier per vCenter Server instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Output['outputs.GuestOsCustomizationSpec']:
        """
        Container object for the Guest OS properties about to be customized . See virtual machine customizations
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of customization specification: One among: Windows, Linux.
        """
        return pulumi.get(self, "type")

