# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['NasDatastoreArgs', 'NasDatastore']

@pulumi.input_type
class NasDatastoreArgs:
    def __init__(__self__, *,
                 host_system_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 remote_hosts: pulumi.Input[Sequence[pulumi.Input[str]]],
                 remote_path: pulumi.Input[str],
                 access_mode: Optional[pulumi.Input[str]] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 datastore_cluster_id: Optional[pulumi.Input[str]] = None,
                 folder: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 security_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NasDatastore resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_system_ids: The managed object IDs of
               the hosts to mount the datastore on.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_hosts: The hostnames or IP addresses of the remote
               server or servers. Only one element should be present for NFS v3 but multiple
               can be present for NFS v4.1. Forces a new resource if changed.
        :param pulumi.Input[str] remote_path: The remote path of the mount point. Forces a new
               resource if changed.
        :param pulumi.Input[str] access_mode: Access mode for the mount point. Can be one of
               `readOnly` or `readWrite`. Note that `readWrite` does not necessarily mean
               that the datastore will be read-write depending on the permissions of the
               actual share. Default: `readWrite`. Forces a new resource if changed.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_attributes: Map of custom attribute ids to attribute 
               value strings to set on datasource resource.
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter.
        :param pulumi.Input[str] datastore_cluster_id: The managed object
               ID of a datastore cluster to put this datastore in.
               Conflicts with `folder`.
        :param pulumi.Input[str] folder: The relative path to a folder to put this datastore in.
               This is a path relative to the datacenter you are deploying the datastore to.
               Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
               The provider will place a datastore named `test` in a datastore folder
               located at `/dc1/datastore/foo/bar`, with the final inventory path being
               `/dc1/datastore/foo/bar/test`. Conflicts with
               `datastore_cluster_id`.
        :param pulumi.Input[str] name: The name of the datastore. Forces a new resource if
               changed.
        :param pulumi.Input[str] security_type: The security type to use when using NFS v4.1.
               Can be one of `AUTH_SYS`, `SEC_KRB5`, or `SEC_KRB5I`. Forces a new resource
               if changed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The IDs of any tags to attach to this resource. 
               
               > **NOTE:** Tagging support is unsupported on direct ESXi connections and
               requires vCenter 6.0 or higher.
        :param pulumi.Input[str] type: The type of NAS volume. Can be one of `NFS` (to denote
               v3) or `NFS41` (to denote NFS v4.1). Default: `NFS`. Forces a new resource if
               changed.
        """
        pulumi.set(__self__, "host_system_ids", host_system_ids)
        pulumi.set(__self__, "remote_hosts", remote_hosts)
        pulumi.set(__self__, "remote_path", remote_path)
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if datastore_cluster_id is not None:
            pulumi.set(__self__, "datastore_cluster_id", datastore_cluster_id)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if security_type is not None:
            pulumi.set(__self__, "security_type", security_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="hostSystemIds")
    def host_system_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The managed object IDs of
        the hosts to mount the datastore on.
        """
        return pulumi.get(self, "host_system_ids")

    @host_system_ids.setter
    def host_system_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "host_system_ids", value)

    @property
    @pulumi.getter(name="remoteHosts")
    def remote_hosts(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The hostnames or IP addresses of the remote
        server or servers. Only one element should be present for NFS v3 but multiple
        can be present for NFS v4.1. Forces a new resource if changed.
        """
        return pulumi.get(self, "remote_hosts")

    @remote_hosts.setter
    def remote_hosts(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "remote_hosts", value)

    @property
    @pulumi.getter(name="remotePath")
    def remote_path(self) -> pulumi.Input[str]:
        """
        The remote path of the mount point. Forces a new
        resource if changed.
        """
        return pulumi.get(self, "remote_path")

    @remote_path.setter
    def remote_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "remote_path", value)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Access mode for the mount point. Can be one of
        `readOnly` or `readWrite`. Note that `readWrite` does not necessarily mean
        that the datastore will be read-write depending on the permissions of the
        actual share. Default: `readWrite`. Forces a new resource if changed.
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_mode", value)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of custom attribute ids to attribute 
        value strings to set on datasource resource.

        > **NOTE:** Custom attributes are unsupported on direct ESXi connections
        and require vCenter.
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "custom_attributes", value)

    @property
    @pulumi.getter(name="datastoreClusterId")
    def datastore_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The managed object
        ID of a datastore cluster to put this datastore in.
        Conflicts with `folder`.
        """
        return pulumi.get(self, "datastore_cluster_id")

    @datastore_cluster_id.setter
    def datastore_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datastore_cluster_id", value)

    @property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[str]]:
        """
        The relative path to a folder to put this datastore in.
        This is a path relative to the datacenter you are deploying the datastore to.
        Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
        The provider will place a datastore named `test` in a datastore folder
        located at `/dc1/datastore/foo/bar`, with the final inventory path being
        `/dc1/datastore/foo/bar/test`. Conflicts with
        `datastore_cluster_id`.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the datastore. Forces a new resource if
        changed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="securityType")
    def security_type(self) -> Optional[pulumi.Input[str]]:
        """
        The security type to use when using NFS v4.1.
        Can be one of `AUTH_SYS`, `SEC_KRB5`, or `SEC_KRB5I`. Forces a new resource
        if changed.
        """
        return pulumi.get(self, "security_type")

    @security_type.setter
    def security_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IDs of any tags to attach to this resource. 

        > **NOTE:** Tagging support is unsupported on direct ESXi connections and
        requires vCenter 6.0 or higher.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of NAS volume. Can be one of `NFS` (to denote
        v3) or `NFS41` (to denote NFS v4.1). Default: `NFS`. Forces a new resource if
        changed.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _NasDatastoreState:
    def __init__(__self__, *,
                 access_mode: Optional[pulumi.Input[str]] = None,
                 accessible: Optional[pulumi.Input[bool]] = None,
                 capacity: Optional[pulumi.Input[int]] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 datastore_cluster_id: Optional[pulumi.Input[str]] = None,
                 folder: Optional[pulumi.Input[str]] = None,
                 free_space: Optional[pulumi.Input[int]] = None,
                 host_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 maintenance_mode: Optional[pulumi.Input[str]] = None,
                 multiple_host_access: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol_endpoint: Optional[pulumi.Input[bool]] = None,
                 remote_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_path: Optional[pulumi.Input[str]] = None,
                 security_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 uncommitted_space: Optional[pulumi.Input[int]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NasDatastore resources.
        :param pulumi.Input[str] access_mode: Access mode for the mount point. Can be one of
               `readOnly` or `readWrite`. Note that `readWrite` does not necessarily mean
               that the datastore will be read-write depending on the permissions of the
               actual share. Default: `readWrite`. Forces a new resource if changed.
        :param pulumi.Input[bool] accessible: The connectivity status of the datastore. If this is `false`,
               some other computed attributes may be out of date.
        :param pulumi.Input[int] capacity: Maximum capacity of the datastore, in megabytes.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_attributes: Map of custom attribute ids to attribute 
               value strings to set on datasource resource.
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter.
        :param pulumi.Input[str] datastore_cluster_id: The managed object
               ID of a datastore cluster to put this datastore in.
               Conflicts with `folder`.
        :param pulumi.Input[str] folder: The relative path to a folder to put this datastore in.
               This is a path relative to the datacenter you are deploying the datastore to.
               Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
               The provider will place a datastore named `test` in a datastore folder
               located at `/dc1/datastore/foo/bar`, with the final inventory path being
               `/dc1/datastore/foo/bar/test`. Conflicts with
               `datastore_cluster_id`.
        :param pulumi.Input[int] free_space: Available space of this datastore, in megabytes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_system_ids: The managed object IDs of
               the hosts to mount the datastore on.
        :param pulumi.Input[str] maintenance_mode: The current maintenance mode state of the datastore.
        :param pulumi.Input[bool] multiple_host_access: If `true`, more than one host in the datacenter has
               been configured with access to the datastore.
        :param pulumi.Input[str] name: The name of the datastore. Forces a new resource if
               changed.
        :param pulumi.Input[bool] protocol_endpoint: Indicates that this NAS volume is a protocol endpoint.
               This field is only populated if the host supports virtual datastores.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_hosts: The hostnames or IP addresses of the remote
               server or servers. Only one element should be present for NFS v3 but multiple
               can be present for NFS v4.1. Forces a new resource if changed.
        :param pulumi.Input[str] remote_path: The remote path of the mount point. Forces a new
               resource if changed.
        :param pulumi.Input[str] security_type: The security type to use when using NFS v4.1.
               Can be one of `AUTH_SYS`, `SEC_KRB5`, or `SEC_KRB5I`. Forces a new resource
               if changed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The IDs of any tags to attach to this resource. 
               
               > **NOTE:** Tagging support is unsupported on direct ESXi connections and
               requires vCenter 6.0 or higher.
        :param pulumi.Input[str] type: The type of NAS volume. Can be one of `NFS` (to denote
               v3) or `NFS41` (to denote NFS v4.1). Default: `NFS`. Forces a new resource if
               changed.
        :param pulumi.Input[int] uncommitted_space: Total additional storage space, in megabytes,
               potentially used by all virtual machines on this datastore.
        :param pulumi.Input[str] url: The unique locator for the datastore.
        """
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if accessible is not None:
            pulumi.set(__self__, "accessible", accessible)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if datastore_cluster_id is not None:
            pulumi.set(__self__, "datastore_cluster_id", datastore_cluster_id)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if free_space is not None:
            pulumi.set(__self__, "free_space", free_space)
        if host_system_ids is not None:
            pulumi.set(__self__, "host_system_ids", host_system_ids)
        if maintenance_mode is not None:
            pulumi.set(__self__, "maintenance_mode", maintenance_mode)
        if multiple_host_access is not None:
            pulumi.set(__self__, "multiple_host_access", multiple_host_access)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol_endpoint is not None:
            pulumi.set(__self__, "protocol_endpoint", protocol_endpoint)
        if remote_hosts is not None:
            pulumi.set(__self__, "remote_hosts", remote_hosts)
        if remote_path is not None:
            pulumi.set(__self__, "remote_path", remote_path)
        if security_type is not None:
            pulumi.set(__self__, "security_type", security_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uncommitted_space is not None:
            pulumi.set(__self__, "uncommitted_space", uncommitted_space)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Access mode for the mount point. Can be one of
        `readOnly` or `readWrite`. Note that `readWrite` does not necessarily mean
        that the datastore will be read-write depending on the permissions of the
        actual share. Default: `readWrite`. Forces a new resource if changed.
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_mode", value)

    @property
    @pulumi.getter
    def accessible(self) -> Optional[pulumi.Input[bool]]:
        """
        The connectivity status of the datastore. If this is `false`,
        some other computed attributes may be out of date.
        """
        return pulumi.get(self, "accessible")

    @accessible.setter
    def accessible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "accessible", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum capacity of the datastore, in megabytes.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of custom attribute ids to attribute 
        value strings to set on datasource resource.

        > **NOTE:** Custom attributes are unsupported on direct ESXi connections
        and require vCenter.
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "custom_attributes", value)

    @property
    @pulumi.getter(name="datastoreClusterId")
    def datastore_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The managed object
        ID of a datastore cluster to put this datastore in.
        Conflicts with `folder`.
        """
        return pulumi.get(self, "datastore_cluster_id")

    @datastore_cluster_id.setter
    def datastore_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datastore_cluster_id", value)

    @property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[str]]:
        """
        The relative path to a folder to put this datastore in.
        This is a path relative to the datacenter you are deploying the datastore to.
        Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
        The provider will place a datastore named `test` in a datastore folder
        located at `/dc1/datastore/foo/bar`, with the final inventory path being
        `/dc1/datastore/foo/bar/test`. Conflicts with
        `datastore_cluster_id`.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter(name="freeSpace")
    def free_space(self) -> Optional[pulumi.Input[int]]:
        """
        Available space of this datastore, in megabytes.
        """
        return pulumi.get(self, "free_space")

    @free_space.setter
    def free_space(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "free_space", value)

    @property
    @pulumi.getter(name="hostSystemIds")
    def host_system_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The managed object IDs of
        the hosts to mount the datastore on.
        """
        return pulumi.get(self, "host_system_ids")

    @host_system_ids.setter
    def host_system_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "host_system_ids", value)

    @property
    @pulumi.getter(name="maintenanceMode")
    def maintenance_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The current maintenance mode state of the datastore.
        """
        return pulumi.get(self, "maintenance_mode")

    @maintenance_mode.setter
    def maintenance_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_mode", value)

    @property
    @pulumi.getter(name="multipleHostAccess")
    def multiple_host_access(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, more than one host in the datacenter has
        been configured with access to the datastore.
        """
        return pulumi.get(self, "multiple_host_access")

    @multiple_host_access.setter
    def multiple_host_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multiple_host_access", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the datastore. Forces a new resource if
        changed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="protocolEndpoint")
    def protocol_endpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that this NAS volume is a protocol endpoint.
        This field is only populated if the host supports virtual datastores.
        """
        return pulumi.get(self, "protocol_endpoint")

    @protocol_endpoint.setter
    def protocol_endpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "protocol_endpoint", value)

    @property
    @pulumi.getter(name="remoteHosts")
    def remote_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The hostnames or IP addresses of the remote
        server or servers. Only one element should be present for NFS v3 but multiple
        can be present for NFS v4.1. Forces a new resource if changed.
        """
        return pulumi.get(self, "remote_hosts")

    @remote_hosts.setter
    def remote_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "remote_hosts", value)

    @property
    @pulumi.getter(name="remotePath")
    def remote_path(self) -> Optional[pulumi.Input[str]]:
        """
        The remote path of the mount point. Forces a new
        resource if changed.
        """
        return pulumi.get(self, "remote_path")

    @remote_path.setter
    def remote_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_path", value)

    @property
    @pulumi.getter(name="securityType")
    def security_type(self) -> Optional[pulumi.Input[str]]:
        """
        The security type to use when using NFS v4.1.
        Can be one of `AUTH_SYS`, `SEC_KRB5`, or `SEC_KRB5I`. Forces a new resource
        if changed.
        """
        return pulumi.get(self, "security_type")

    @security_type.setter
    def security_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IDs of any tags to attach to this resource. 

        > **NOTE:** Tagging support is unsupported on direct ESXi connections and
        requires vCenter 6.0 or higher.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of NAS volume. Can be one of `NFS` (to denote
        v3) or `NFS41` (to denote NFS v4.1). Default: `NFS`. Forces a new resource if
        changed.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="uncommittedSpace")
    def uncommitted_space(self) -> Optional[pulumi.Input[int]]:
        """
        Total additional storage space, in megabytes,
        potentially used by all virtual machines on this datastore.
        """
        return pulumi.get(self, "uncommitted_space")

    @uncommitted_space.setter
    def uncommitted_space(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "uncommitted_space", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The unique locator for the datastore.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


class NasDatastore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_mode: Optional[pulumi.Input[str]] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 datastore_cluster_id: Optional[pulumi.Input[str]] = None,
                 folder: Optional[pulumi.Input[str]] = None,
                 host_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 remote_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_path: Optional[pulumi.Input[str]] = None,
                 security_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a NasDatastore resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_mode: Access mode for the mount point. Can be one of
               `readOnly` or `readWrite`. Note that `readWrite` does not necessarily mean
               that the datastore will be read-write depending on the permissions of the
               actual share. Default: `readWrite`. Forces a new resource if changed.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_attributes: Map of custom attribute ids to attribute 
               value strings to set on datasource resource.
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter.
        :param pulumi.Input[str] datastore_cluster_id: The managed object
               ID of a datastore cluster to put this datastore in.
               Conflicts with `folder`.
        :param pulumi.Input[str] folder: The relative path to a folder to put this datastore in.
               This is a path relative to the datacenter you are deploying the datastore to.
               Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
               The provider will place a datastore named `test` in a datastore folder
               located at `/dc1/datastore/foo/bar`, with the final inventory path being
               `/dc1/datastore/foo/bar/test`. Conflicts with
               `datastore_cluster_id`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_system_ids: The managed object IDs of
               the hosts to mount the datastore on.
        :param pulumi.Input[str] name: The name of the datastore. Forces a new resource if
               changed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_hosts: The hostnames or IP addresses of the remote
               server or servers. Only one element should be present for NFS v3 but multiple
               can be present for NFS v4.1. Forces a new resource if changed.
        :param pulumi.Input[str] remote_path: The remote path of the mount point. Forces a new
               resource if changed.
        :param pulumi.Input[str] security_type: The security type to use when using NFS v4.1.
               Can be one of `AUTH_SYS`, `SEC_KRB5`, or `SEC_KRB5I`. Forces a new resource
               if changed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The IDs of any tags to attach to this resource. 
               
               > **NOTE:** Tagging support is unsupported on direct ESXi connections and
               requires vCenter 6.0 or higher.
        :param pulumi.Input[str] type: The type of NAS volume. Can be one of `NFS` (to denote
               v3) or `NFS41` (to denote NFS v4.1). Default: `NFS`. Forces a new resource if
               changed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NasDatastoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a NasDatastore resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param NasDatastoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NasDatastoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_mode: Optional[pulumi.Input[str]] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 datastore_cluster_id: Optional[pulumi.Input[str]] = None,
                 folder: Optional[pulumi.Input[str]] = None,
                 host_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 remote_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_path: Optional[pulumi.Input[str]] = None,
                 security_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NasDatastoreArgs.__new__(NasDatastoreArgs)

            __props__.__dict__["access_mode"] = access_mode
            __props__.__dict__["custom_attributes"] = custom_attributes
            __props__.__dict__["datastore_cluster_id"] = datastore_cluster_id
            __props__.__dict__["folder"] = folder
            if host_system_ids is None and not opts.urn:
                raise TypeError("Missing required property 'host_system_ids'")
            __props__.__dict__["host_system_ids"] = host_system_ids
            __props__.__dict__["name"] = name
            if remote_hosts is None and not opts.urn:
                raise TypeError("Missing required property 'remote_hosts'")
            __props__.__dict__["remote_hosts"] = remote_hosts
            if remote_path is None and not opts.urn:
                raise TypeError("Missing required property 'remote_path'")
            __props__.__dict__["remote_path"] = remote_path
            __props__.__dict__["security_type"] = security_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["accessible"] = None
            __props__.__dict__["capacity"] = None
            __props__.__dict__["free_space"] = None
            __props__.__dict__["maintenance_mode"] = None
            __props__.__dict__["multiple_host_access"] = None
            __props__.__dict__["protocol_endpoint"] = None
            __props__.__dict__["uncommitted_space"] = None
            __props__.__dict__["url"] = None
        super(NasDatastore, __self__).__init__(
            'vsphere:index/nasDatastore:NasDatastore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_mode: Optional[pulumi.Input[str]] = None,
            accessible: Optional[pulumi.Input[bool]] = None,
            capacity: Optional[pulumi.Input[int]] = None,
            custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            datastore_cluster_id: Optional[pulumi.Input[str]] = None,
            folder: Optional[pulumi.Input[str]] = None,
            free_space: Optional[pulumi.Input[int]] = None,
            host_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            maintenance_mode: Optional[pulumi.Input[str]] = None,
            multiple_host_access: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            protocol_endpoint: Optional[pulumi.Input[bool]] = None,
            remote_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            remote_path: Optional[pulumi.Input[str]] = None,
            security_type: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            uncommitted_space: Optional[pulumi.Input[int]] = None,
            url: Optional[pulumi.Input[str]] = None) -> 'NasDatastore':
        """
        Get an existing NasDatastore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_mode: Access mode for the mount point. Can be one of
               `readOnly` or `readWrite`. Note that `readWrite` does not necessarily mean
               that the datastore will be read-write depending on the permissions of the
               actual share. Default: `readWrite`. Forces a new resource if changed.
        :param pulumi.Input[bool] accessible: The connectivity status of the datastore. If this is `false`,
               some other computed attributes may be out of date.
        :param pulumi.Input[int] capacity: Maximum capacity of the datastore, in megabytes.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_attributes: Map of custom attribute ids to attribute 
               value strings to set on datasource resource.
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter.
        :param pulumi.Input[str] datastore_cluster_id: The managed object
               ID of a datastore cluster to put this datastore in.
               Conflicts with `folder`.
        :param pulumi.Input[str] folder: The relative path to a folder to put this datastore in.
               This is a path relative to the datacenter you are deploying the datastore to.
               Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
               The provider will place a datastore named `test` in a datastore folder
               located at `/dc1/datastore/foo/bar`, with the final inventory path being
               `/dc1/datastore/foo/bar/test`. Conflicts with
               `datastore_cluster_id`.
        :param pulumi.Input[int] free_space: Available space of this datastore, in megabytes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_system_ids: The managed object IDs of
               the hosts to mount the datastore on.
        :param pulumi.Input[str] maintenance_mode: The current maintenance mode state of the datastore.
        :param pulumi.Input[bool] multiple_host_access: If `true`, more than one host in the datacenter has
               been configured with access to the datastore.
        :param pulumi.Input[str] name: The name of the datastore. Forces a new resource if
               changed.
        :param pulumi.Input[bool] protocol_endpoint: Indicates that this NAS volume is a protocol endpoint.
               This field is only populated if the host supports virtual datastores.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_hosts: The hostnames or IP addresses of the remote
               server or servers. Only one element should be present for NFS v3 but multiple
               can be present for NFS v4.1. Forces a new resource if changed.
        :param pulumi.Input[str] remote_path: The remote path of the mount point. Forces a new
               resource if changed.
        :param pulumi.Input[str] security_type: The security type to use when using NFS v4.1.
               Can be one of `AUTH_SYS`, `SEC_KRB5`, or `SEC_KRB5I`. Forces a new resource
               if changed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The IDs of any tags to attach to this resource. 
               
               > **NOTE:** Tagging support is unsupported on direct ESXi connections and
               requires vCenter 6.0 or higher.
        :param pulumi.Input[str] type: The type of NAS volume. Can be one of `NFS` (to denote
               v3) or `NFS41` (to denote NFS v4.1). Default: `NFS`. Forces a new resource if
               changed.
        :param pulumi.Input[int] uncommitted_space: Total additional storage space, in megabytes,
               potentially used by all virtual machines on this datastore.
        :param pulumi.Input[str] url: The unique locator for the datastore.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NasDatastoreState.__new__(_NasDatastoreState)

        __props__.__dict__["access_mode"] = access_mode
        __props__.__dict__["accessible"] = accessible
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["custom_attributes"] = custom_attributes
        __props__.__dict__["datastore_cluster_id"] = datastore_cluster_id
        __props__.__dict__["folder"] = folder
        __props__.__dict__["free_space"] = free_space
        __props__.__dict__["host_system_ids"] = host_system_ids
        __props__.__dict__["maintenance_mode"] = maintenance_mode
        __props__.__dict__["multiple_host_access"] = multiple_host_access
        __props__.__dict__["name"] = name
        __props__.__dict__["protocol_endpoint"] = protocol_endpoint
        __props__.__dict__["remote_hosts"] = remote_hosts
        __props__.__dict__["remote_path"] = remote_path
        __props__.__dict__["security_type"] = security_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["uncommitted_space"] = uncommitted_space
        __props__.__dict__["url"] = url
        return NasDatastore(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Access mode for the mount point. Can be one of
        `readOnly` or `readWrite`. Note that `readWrite` does not necessarily mean
        that the datastore will be read-write depending on the permissions of the
        actual share. Default: `readWrite`. Forces a new resource if changed.
        """
        return pulumi.get(self, "access_mode")

    @property
    @pulumi.getter
    def accessible(self) -> pulumi.Output[bool]:
        """
        The connectivity status of the datastore. If this is `false`,
        some other computed attributes may be out of date.
        """
        return pulumi.get(self, "accessible")

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[int]:
        """
        Maximum capacity of the datastore, in megabytes.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of custom attribute ids to attribute 
        value strings to set on datasource resource.

        > **NOTE:** Custom attributes are unsupported on direct ESXi connections
        and require vCenter.
        """
        return pulumi.get(self, "custom_attributes")

    @property
    @pulumi.getter(name="datastoreClusterId")
    def datastore_cluster_id(self) -> pulumi.Output[Optional[str]]:
        """
        The managed object
        ID of a datastore cluster to put this datastore in.
        Conflicts with `folder`.
        """
        return pulumi.get(self, "datastore_cluster_id")

    @property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[str]]:
        """
        The relative path to a folder to put this datastore in.
        This is a path relative to the datacenter you are deploying the datastore to.
        Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
        The provider will place a datastore named `test` in a datastore folder
        located at `/dc1/datastore/foo/bar`, with the final inventory path being
        `/dc1/datastore/foo/bar/test`. Conflicts with
        `datastore_cluster_id`.
        """
        return pulumi.get(self, "folder")

    @property
    @pulumi.getter(name="freeSpace")
    def free_space(self) -> pulumi.Output[int]:
        """
        Available space of this datastore, in megabytes.
        """
        return pulumi.get(self, "free_space")

    @property
    @pulumi.getter(name="hostSystemIds")
    def host_system_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The managed object IDs of
        the hosts to mount the datastore on.
        """
        return pulumi.get(self, "host_system_ids")

    @property
    @pulumi.getter(name="maintenanceMode")
    def maintenance_mode(self) -> pulumi.Output[str]:
        """
        The current maintenance mode state of the datastore.
        """
        return pulumi.get(self, "maintenance_mode")

    @property
    @pulumi.getter(name="multipleHostAccess")
    def multiple_host_access(self) -> pulumi.Output[bool]:
        """
        If `true`, more than one host in the datacenter has
        been configured with access to the datastore.
        """
        return pulumi.get(self, "multiple_host_access")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the datastore. Forces a new resource if
        changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="protocolEndpoint")
    def protocol_endpoint(self) -> pulumi.Output[bool]:
        """
        Indicates that this NAS volume is a protocol endpoint.
        This field is only populated if the host supports virtual datastores.
        """
        return pulumi.get(self, "protocol_endpoint")

    @property
    @pulumi.getter(name="remoteHosts")
    def remote_hosts(self) -> pulumi.Output[Sequence[str]]:
        """
        The hostnames or IP addresses of the remote
        server or servers. Only one element should be present for NFS v3 but multiple
        can be present for NFS v4.1. Forces a new resource if changed.
        """
        return pulumi.get(self, "remote_hosts")

    @property
    @pulumi.getter(name="remotePath")
    def remote_path(self) -> pulumi.Output[str]:
        """
        The remote path of the mount point. Forces a new
        resource if changed.
        """
        return pulumi.get(self, "remote_path")

    @property
    @pulumi.getter(name="securityType")
    def security_type(self) -> pulumi.Output[Optional[str]]:
        """
        The security type to use when using NFS v4.1.
        Can be one of `AUTH_SYS`, `SEC_KRB5`, or `SEC_KRB5I`. Forces a new resource
        if changed.
        """
        return pulumi.get(self, "security_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The IDs of any tags to attach to this resource. 

        > **NOTE:** Tagging support is unsupported on direct ESXi connections and
        requires vCenter 6.0 or higher.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of NAS volume. Can be one of `NFS` (to denote
        v3) or `NFS41` (to denote NFS v4.1). Default: `NFS`. Forces a new resource if
        changed.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="uncommittedSpace")
    def uncommitted_space(self) -> pulumi.Output[int]:
        """
        Total additional storage space, in megabytes,
        potentially used by all virtual machines on this datastore.
        """
        return pulumi.get(self, "uncommitted_space")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The unique locator for the datastore.
        """
        return pulumi.get(self, "url")

