# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'ComputeClusterHostImage',
    'ComputeClusterHostImageComponent',
    'ComputeClusterVsanDiskGroup',
    'ComputeClusterVsanFaultDomain',
    'ComputeClusterVsanFaultDomainFaultDomain',
    'ComputeClusterVsanStretchedCluster',
    'ContentLibraryPublication',
    'ContentLibrarySubscription',
    'DistributedPortGroupVlanRange',
    'DistributedVirtualSwitchHost',
    'DistributedVirtualSwitchPvlanMapping',
    'DistributedVirtualSwitchVlanRange',
    'EntityPermissionsPermission',
    'GuestOsCustomizationSpec',
    'GuestOsCustomizationSpecLinuxOptions',
    'GuestOsCustomizationSpecNetworkInterface',
    'GuestOsCustomizationSpecWindowsOptions',
    'HostPortGroupPort',
    'OfflineSoftwareDepotComponent',
    'SupervisorEgressCidr',
    'SupervisorIngressCidr',
    'SupervisorManagementNetwork',
    'SupervisorNamespace',
    'SupervisorPodCidr',
    'SupervisorServiceCidr',
    'VirtualMachineCdrom',
    'VirtualMachineClone',
    'VirtualMachineCloneCustomizationSpec',
    'VirtualMachineCloneCustomize',
    'VirtualMachineCloneCustomizeLinuxOptions',
    'VirtualMachineCloneCustomizeNetworkInterface',
    'VirtualMachineCloneCustomizeWindowsOptions',
    'VirtualMachineDisk',
    'VirtualMachineNetworkInterface',
    'VirtualMachineOvfDeploy',
    'VirtualMachineVapp',
    'VmStoragePolicyTagRule',
    'VnicIpv4',
    'VnicIpv6',
    'GetGuestOsCustomizationSpecResult',
    'GetGuestOsCustomizationSpecLinuxOptionResult',
    'GetGuestOsCustomizationSpecNetworkInterfaceResult',
    'GetGuestOsCustomizationSpecWindowsOptionResult',
    'GetHostVgpuProfileVgpuProfileResult',
    'GetVirtualMachineDiskResult',
    'GetVirtualMachineNetworkInterfaceResult',
    'GetVirtualMachineVappResult',
]

@pulumi.output_type
class ComputeClusterHostImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "esxVersion":
            suggest = "esx_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeClusterHostImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeClusterHostImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeClusterHostImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 components: Optional[Sequence['outputs.ComputeClusterHostImageComponent']] = None,
                 esx_version: Optional[str] = None):
        """
        :param Sequence['ComputeClusterHostImageComponentArgs'] components: List of custom components.
        :param str esx_version: The ESXi version which the image is based on.
        """
        if components is not None:
            pulumi.set(__self__, "components", components)
        if esx_version is not None:
            pulumi.set(__self__, "esx_version", esx_version)

    @property
    @pulumi.getter
    def components(self) -> Optional[Sequence['outputs.ComputeClusterHostImageComponent']]:
        """
        List of custom components.
        """
        return pulumi.get(self, "components")

    @property
    @pulumi.getter(name="esxVersion")
    def esx_version(self) -> Optional[str]:
        """
        The ESXi version which the image is based on.
        """
        return pulumi.get(self, "esx_version")


@pulumi.output_type
class ComputeClusterHostImageComponent(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str key: The identifier for the component.
        :param str version: The version to use.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The identifier for the component.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version to use.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ComputeClusterVsanDiskGroup(dict):
    def __init__(__self__, *,
                 cache: Optional[str] = None,
                 storages: Optional[Sequence[str]] = None):
        """
        :param str cache: Cache disk.
        :param Sequence[str] storages: List of storage disks.
        """
        if cache is not None:
            pulumi.set(__self__, "cache", cache)
        if storages is not None:
            pulumi.set(__self__, "storages", storages)

    @property
    @pulumi.getter
    def cache(self) -> Optional[str]:
        """
        Cache disk.
        """
        return pulumi.get(self, "cache")

    @property
    @pulumi.getter
    def storages(self) -> Optional[Sequence[str]]:
        """
        List of storage disks.
        """
        return pulumi.get(self, "storages")


@pulumi.output_type
class ComputeClusterVsanFaultDomain(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "faultDomains":
            suggest = "fault_domains"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeClusterVsanFaultDomain. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeClusterVsanFaultDomain.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeClusterVsanFaultDomain.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fault_domains: Optional[Sequence['outputs.ComputeClusterVsanFaultDomainFaultDomain']] = None):
        """
        :param Sequence['ComputeClusterVsanFaultDomainFaultDomainArgs'] fault_domains: The configuration for single fault domain.
        """
        if fault_domains is not None:
            pulumi.set(__self__, "fault_domains", fault_domains)

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Optional[Sequence['outputs.ComputeClusterVsanFaultDomainFaultDomain']]:
        """
        The configuration for single fault domain.
        """
        return pulumi.get(self, "fault_domains")


@pulumi.output_type
class ComputeClusterVsanFaultDomainFaultDomain(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostIds":
            suggest = "host_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeClusterVsanFaultDomainFaultDomain. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeClusterVsanFaultDomainFaultDomain.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeClusterVsanFaultDomainFaultDomain.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_ids: Sequence[str],
                 name: str):
        """
        :param Sequence[str] host_ids: The managed object IDs of the hosts to put in the fault domain.
        :param str name: The name of the cluster.
        """
        pulumi.set(__self__, "host_ids", host_ids)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="hostIds")
    def host_ids(self) -> Sequence[str]:
        """
        The managed object IDs of the hosts to put in the fault domain.
        """
        return pulumi.get(self, "host_ids")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the cluster.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ComputeClusterVsanStretchedCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preferredFaultDomainHostIds":
            suggest = "preferred_fault_domain_host_ids"
        elif key == "secondaryFaultDomainHostIds":
            suggest = "secondary_fault_domain_host_ids"
        elif key == "witnessNode":
            suggest = "witness_node"
        elif key == "preferredFaultDomainName":
            suggest = "preferred_fault_domain_name"
        elif key == "secondaryFaultDomainName":
            suggest = "secondary_fault_domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeClusterVsanStretchedCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeClusterVsanStretchedCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeClusterVsanStretchedCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preferred_fault_domain_host_ids: Sequence[str],
                 secondary_fault_domain_host_ids: Sequence[str],
                 witness_node: str,
                 preferred_fault_domain_name: Optional[str] = None,
                 secondary_fault_domain_name: Optional[str] = None):
        """
        :param Sequence[str] preferred_fault_domain_host_ids: The managed object IDs of the hosts to put in the first fault domain.
        :param Sequence[str] secondary_fault_domain_host_ids: The managed object IDs of the hosts to put in the second fault domain.
        :param str witness_node: The managed object IDs of the host selected as witness node when enable stretched cluster.
        :param str preferred_fault_domain_name: The name of prepferred fault domain.
        :param str secondary_fault_domain_name: The name of secondary fault domain.
        """
        pulumi.set(__self__, "preferred_fault_domain_host_ids", preferred_fault_domain_host_ids)
        pulumi.set(__self__, "secondary_fault_domain_host_ids", secondary_fault_domain_host_ids)
        pulumi.set(__self__, "witness_node", witness_node)
        if preferred_fault_domain_name is not None:
            pulumi.set(__self__, "preferred_fault_domain_name", preferred_fault_domain_name)
        if secondary_fault_domain_name is not None:
            pulumi.set(__self__, "secondary_fault_domain_name", secondary_fault_domain_name)

    @property
    @pulumi.getter(name="preferredFaultDomainHostIds")
    def preferred_fault_domain_host_ids(self) -> Sequence[str]:
        """
        The managed object IDs of the hosts to put in the first fault domain.
        """
        return pulumi.get(self, "preferred_fault_domain_host_ids")

    @property
    @pulumi.getter(name="secondaryFaultDomainHostIds")
    def secondary_fault_domain_host_ids(self) -> Sequence[str]:
        """
        The managed object IDs of the hosts to put in the second fault domain.
        """
        return pulumi.get(self, "secondary_fault_domain_host_ids")

    @property
    @pulumi.getter(name="witnessNode")
    def witness_node(self) -> str:
        """
        The managed object IDs of the host selected as witness node when enable stretched cluster.
        """
        return pulumi.get(self, "witness_node")

    @property
    @pulumi.getter(name="preferredFaultDomainName")
    def preferred_fault_domain_name(self) -> Optional[str]:
        """
        The name of prepferred fault domain.
        """
        return pulumi.get(self, "preferred_fault_domain_name")

    @property
    @pulumi.getter(name="secondaryFaultDomainName")
    def secondary_fault_domain_name(self) -> Optional[str]:
        """
        The name of secondary fault domain.
        """
        return pulumi.get(self, "secondary_fault_domain_name")


@pulumi.output_type
class ContentLibraryPublication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationMethod":
            suggest = "authentication_method"
        elif key == "publishUrl":
            suggest = "publish_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentLibraryPublication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentLibraryPublication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentLibraryPublication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_method: Optional[str] = None,
                 password: Optional[str] = None,
                 publish_url: Optional[str] = None,
                 published: Optional[bool] = None,
                 username: Optional[str] = None):
        """
        :param str authentication_method: Method to authenticate users. Must be `NONE` or `BASIC`.
        :param str password: Password used by subscribers to authenticate.
        :param str publish_url: The URL of the published content library.
        :param bool published: Publish the content library. Default `false`.
        :param str username: Username used by subscribers to authenticate. Currently can only be `vcsp`.
        """
        if authentication_method is not None:
            pulumi.set(__self__, "authentication_method", authentication_method)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if publish_url is not None:
            pulumi.set(__self__, "publish_url", publish_url)
        if published is not None:
            pulumi.set(__self__, "published", published)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> Optional[str]:
        """
        Method to authenticate users. Must be `NONE` or `BASIC`.
        """
        return pulumi.get(self, "authentication_method")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password used by subscribers to authenticate.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="publishUrl")
    def publish_url(self) -> Optional[str]:
        """
        The URL of the published content library.
        """
        return pulumi.get(self, "publish_url")

    @property
    @pulumi.getter
    def published(self) -> Optional[bool]:
        """
        Publish the content library. Default `false`.
        """
        return pulumi.get(self, "published")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username used by subscribers to authenticate. Currently can only be `vcsp`.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ContentLibrarySubscription(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationMethod":
            suggest = "authentication_method"
        elif key == "automaticSync":
            suggest = "automatic_sync"
        elif key == "onDemand":
            suggest = "on_demand"
        elif key == "subscriptionUrl":
            suggest = "subscription_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentLibrarySubscription. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentLibrarySubscription.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentLibrarySubscription.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_method: Optional[str] = None,
                 automatic_sync: Optional[bool] = None,
                 on_demand: Optional[bool] = None,
                 password: Optional[str] = None,
                 subscription_url: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str authentication_method: Authentication method to connect ro a published content library. Must be `NONE` or `BASIC`.
        :param bool automatic_sync: Enable automatic synchronization with the published library. Default `false`.
        :param bool on_demand: Download the library from a content only when needed. Default `true`.
        :param str password: Password used for authentication.
        :param str subscription_url: URL of the published content library.
        :param str username: Username used for authentication.
        """
        if authentication_method is not None:
            pulumi.set(__self__, "authentication_method", authentication_method)
        if automatic_sync is not None:
            pulumi.set(__self__, "automatic_sync", automatic_sync)
        if on_demand is not None:
            pulumi.set(__self__, "on_demand", on_demand)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if subscription_url is not None:
            pulumi.set(__self__, "subscription_url", subscription_url)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> Optional[str]:
        """
        Authentication method to connect ro a published content library. Must be `NONE` or `BASIC`.
        """
        return pulumi.get(self, "authentication_method")

    @property
    @pulumi.getter(name="automaticSync")
    def automatic_sync(self) -> Optional[bool]:
        """
        Enable automatic synchronization with the published library. Default `false`.
        """
        return pulumi.get(self, "automatic_sync")

    @property
    @pulumi.getter(name="onDemand")
    def on_demand(self) -> Optional[bool]:
        """
        Download the library from a content only when needed. Default `true`.
        """
        return pulumi.get(self, "on_demand")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password used for authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="subscriptionUrl")
    def subscription_url(self) -> Optional[str]:
        """
        URL of the published content library.
        """
        return pulumi.get(self, "subscription_url")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username used for authentication.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class DistributedPortGroupVlanRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxVlan":
            suggest = "max_vlan"
        elif key == "minVlan":
            suggest = "min_vlan"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributedPortGroupVlanRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributedPortGroupVlanRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributedPortGroupVlanRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_vlan: int,
                 min_vlan: int):
        """
        :param int max_vlan: The minimum VLAN to use in the range.
        :param int min_vlan: The minimum VLAN to use in the range.
        """
        pulumi.set(__self__, "max_vlan", max_vlan)
        pulumi.set(__self__, "min_vlan", min_vlan)

    @property
    @pulumi.getter(name="maxVlan")
    def max_vlan(self) -> int:
        """
        The minimum VLAN to use in the range.
        """
        return pulumi.get(self, "max_vlan")

    @property
    @pulumi.getter(name="minVlan")
    def min_vlan(self) -> int:
        """
        The minimum VLAN to use in the range.
        """
        return pulumi.get(self, "min_vlan")


@pulumi.output_type
class DistributedVirtualSwitchHost(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostSystemId":
            suggest = "host_system_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributedVirtualSwitchHost. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributedVirtualSwitchHost.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributedVirtualSwitchHost.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_system_id: str,
                 devices: Optional[Sequence[str]] = None):
        """
        :param str host_system_id: The managed object ID of the host this specification applies to.
        :param Sequence[str] devices: Name of the physical NIC to be added to the proxy switch.
        """
        pulumi.set(__self__, "host_system_id", host_system_id)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)

    @property
    @pulumi.getter(name="hostSystemId")
    def host_system_id(self) -> str:
        """
        The managed object ID of the host this specification applies to.
        """
        return pulumi.get(self, "host_system_id")

    @property
    @pulumi.getter
    def devices(self) -> Optional[Sequence[str]]:
        """
        Name of the physical NIC to be added to the proxy switch.
        """
        return pulumi.get(self, "devices")


@pulumi.output_type
class DistributedVirtualSwitchPvlanMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryVlanId":
            suggest = "primary_vlan_id"
        elif key == "pvlanType":
            suggest = "pvlan_type"
        elif key == "secondaryVlanId":
            suggest = "secondary_vlan_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributedVirtualSwitchPvlanMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributedVirtualSwitchPvlanMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributedVirtualSwitchPvlanMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primary_vlan_id: int,
                 pvlan_type: str,
                 secondary_vlan_id: int):
        """
        :param int primary_vlan_id: The primary VLAN ID. The VLAN IDs of 0 and 4095 are reserved and cannot be used in this property.
        :param str pvlan_type: The private VLAN type. Valid values are promiscuous, community and isolated.
        :param int secondary_vlan_id: The secondary VLAN ID. The VLAN IDs of 0 and 4095 are reserved and cannot be used in this property.
        """
        pulumi.set(__self__, "primary_vlan_id", primary_vlan_id)
        pulumi.set(__self__, "pvlan_type", pvlan_type)
        pulumi.set(__self__, "secondary_vlan_id", secondary_vlan_id)

    @property
    @pulumi.getter(name="primaryVlanId")
    def primary_vlan_id(self) -> int:
        """
        The primary VLAN ID. The VLAN IDs of 0 and 4095 are reserved and cannot be used in this property.
        """
        return pulumi.get(self, "primary_vlan_id")

    @property
    @pulumi.getter(name="pvlanType")
    def pvlan_type(self) -> str:
        """
        The private VLAN type. Valid values are promiscuous, community and isolated.
        """
        return pulumi.get(self, "pvlan_type")

    @property
    @pulumi.getter(name="secondaryVlanId")
    def secondary_vlan_id(self) -> int:
        """
        The secondary VLAN ID. The VLAN IDs of 0 and 4095 are reserved and cannot be used in this property.
        """
        return pulumi.get(self, "secondary_vlan_id")


@pulumi.output_type
class DistributedVirtualSwitchVlanRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxVlan":
            suggest = "max_vlan"
        elif key == "minVlan":
            suggest = "min_vlan"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributedVirtualSwitchVlanRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributedVirtualSwitchVlanRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributedVirtualSwitchVlanRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_vlan: int,
                 min_vlan: int):
        """
        :param int max_vlan: The minimum VLAN to use in the range.
        :param int min_vlan: The minimum VLAN to use in the range.
        """
        pulumi.set(__self__, "max_vlan", max_vlan)
        pulumi.set(__self__, "min_vlan", min_vlan)

    @property
    @pulumi.getter(name="maxVlan")
    def max_vlan(self) -> int:
        """
        The minimum VLAN to use in the range.
        """
        return pulumi.get(self, "max_vlan")

    @property
    @pulumi.getter(name="minVlan")
    def min_vlan(self) -> int:
        """
        The minimum VLAN to use in the range.
        """
        return pulumi.get(self, "min_vlan")


@pulumi.output_type
class EntityPermissionsPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isGroup":
            suggest = "is_group"
        elif key == "roleId":
            suggest = "role_id"
        elif key == "userOrGroup":
            suggest = "user_or_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntityPermissionsPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntityPermissionsPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntityPermissionsPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_group: bool,
                 propagate: bool,
                 role_id: str,
                 user_or_group: str):
        """
        :param bool is_group: Whether user_or_group field refers to a user or a group. True for a group and false for a user.
        :param bool propagate: Whether or not this permission propagates down the hierarchy to sub-entities.
        :param str role_id: The role id of the role to be given to the user on the specified entity.
        :param str user_or_group: The user/group getting the permission.
        """
        pulumi.set(__self__, "is_group", is_group)
        pulumi.set(__self__, "propagate", propagate)
        pulumi.set(__self__, "role_id", role_id)
        pulumi.set(__self__, "user_or_group", user_or_group)

    @property
    @pulumi.getter(name="isGroup")
    def is_group(self) -> bool:
        """
        Whether user_or_group field refers to a user or a group. True for a group and false for a user.
        """
        return pulumi.get(self, "is_group")

    @property
    @pulumi.getter
    def propagate(self) -> bool:
        """
        Whether or not this permission propagates down the hierarchy to sub-entities.
        """
        return pulumi.get(self, "propagate")

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> str:
        """
        The role id of the role to be given to the user on the specified entity.
        """
        return pulumi.get(self, "role_id")

    @property
    @pulumi.getter(name="userOrGroup")
    def user_or_group(self) -> str:
        """
        The user/group getting the permission.
        """
        return pulumi.get(self, "user_or_group")


@pulumi.output_type
class GuestOsCustomizationSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsServerLists":
            suggest = "dns_server_lists"
        elif key == "dnsSuffixLists":
            suggest = "dns_suffix_lists"
        elif key == "ipv4Gateway":
            suggest = "ipv4_gateway"
        elif key == "ipv6Gateway":
            suggest = "ipv6_gateway"
        elif key == "linuxOptions":
            suggest = "linux_options"
        elif key == "networkInterfaces":
            suggest = "network_interfaces"
        elif key == "windowsOptions":
            suggest = "windows_options"
        elif key == "windowsSysprepText":
            suggest = "windows_sysprep_text"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestOsCustomizationSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestOsCustomizationSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestOsCustomizationSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_server_lists: Optional[Sequence[str]] = None,
                 dns_suffix_lists: Optional[Sequence[str]] = None,
                 ipv4_gateway: Optional[str] = None,
                 ipv6_gateway: Optional[str] = None,
                 linux_options: Optional['outputs.GuestOsCustomizationSpecLinuxOptions'] = None,
                 network_interfaces: Optional[Sequence['outputs.GuestOsCustomizationSpecNetworkInterface']] = None,
                 windows_options: Optional['outputs.GuestOsCustomizationSpecWindowsOptions'] = None,
                 windows_sysprep_text: Optional[str] = None):
        """
        :param Sequence[str] dns_server_lists: The list of DNS servers for a virtual network adapter with a static IP address.
        :param Sequence[str] dns_suffix_lists: A list of DNS search domains to add to the DNS configuration on the virtual machine.
        :param str ipv4_gateway: The IPv4 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
        :param str ipv6_gateway: The IPv6 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
        :param 'GuestOsCustomizationSpecLinuxOptionsArgs' linux_options: A list of configuration options specific to Linux virtual machines.
        :param Sequence['GuestOsCustomizationSpecNetworkInterfaceArgs'] network_interfaces: A specification of network interface configuration options.
        :param 'GuestOsCustomizationSpecWindowsOptionsArgs' windows_options: A list of configuration options specific to Windows virtual machines.
        :param str windows_sysprep_text: Use this option to specify a windows sysprep file directly.
        """
        if dns_server_lists is not None:
            pulumi.set(__self__, "dns_server_lists", dns_server_lists)
        if dns_suffix_lists is not None:
            pulumi.set(__self__, "dns_suffix_lists", dns_suffix_lists)
        if ipv4_gateway is not None:
            pulumi.set(__self__, "ipv4_gateway", ipv4_gateway)
        if ipv6_gateway is not None:
            pulumi.set(__self__, "ipv6_gateway", ipv6_gateway)
        if linux_options is not None:
            pulumi.set(__self__, "linux_options", linux_options)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if windows_options is not None:
            pulumi.set(__self__, "windows_options", windows_options)
        if windows_sysprep_text is not None:
            pulumi.set(__self__, "windows_sysprep_text", windows_sysprep_text)

    @property
    @pulumi.getter(name="dnsServerLists")
    def dns_server_lists(self) -> Optional[Sequence[str]]:
        """
        The list of DNS servers for a virtual network adapter with a static IP address.
        """
        return pulumi.get(self, "dns_server_lists")

    @property
    @pulumi.getter(name="dnsSuffixLists")
    def dns_suffix_lists(self) -> Optional[Sequence[str]]:
        """
        A list of DNS search domains to add to the DNS configuration on the virtual machine.
        """
        return pulumi.get(self, "dns_suffix_lists")

    @property
    @pulumi.getter(name="ipv4Gateway")
    def ipv4_gateway(self) -> Optional[str]:
        """
        The IPv4 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
        """
        return pulumi.get(self, "ipv4_gateway")

    @property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> Optional[str]:
        """
        The IPv6 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
        """
        return pulumi.get(self, "ipv6_gateway")

    @property
    @pulumi.getter(name="linuxOptions")
    def linux_options(self) -> Optional['outputs.GuestOsCustomizationSpecLinuxOptions']:
        """
        A list of configuration options specific to Linux virtual machines.
        """
        return pulumi.get(self, "linux_options")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[Sequence['outputs.GuestOsCustomizationSpecNetworkInterface']]:
        """
        A specification of network interface configuration options.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="windowsOptions")
    def windows_options(self) -> Optional['outputs.GuestOsCustomizationSpecWindowsOptions']:
        """
        A list of configuration options specific to Windows virtual machines.
        """
        return pulumi.get(self, "windows_options")

    @property
    @pulumi.getter(name="windowsSysprepText")
    def windows_sysprep_text(self) -> Optional[str]:
        """
        Use this option to specify a windows sysprep file directly.
        """
        return pulumi.get(self, "windows_sysprep_text")


@pulumi.output_type
class GuestOsCustomizationSpecLinuxOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "hwClockUtc":
            suggest = "hw_clock_utc"
        elif key == "scriptText":
            suggest = "script_text"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestOsCustomizationSpecLinuxOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestOsCustomizationSpecLinuxOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestOsCustomizationSpecLinuxOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain: str,
                 host_name: str,
                 hw_clock_utc: Optional[bool] = None,
                 script_text: Optional[str] = None,
                 time_zone: Optional[str] = None):
        """
        :param str domain: The domain name for this virtual machine.
        :param str host_name: The hostname for this virtual machine.
        :param bool hw_clock_utc: Specifies whether or not the hardware clock should be in UTC or not.
        :param str script_text: The customization script to run before and or after guest customization
        :param str time_zone: Customize the time zone on the VM. This should be a time zone-style entry, like America/Los_Angeles.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "host_name", host_name)
        if hw_clock_utc is not None:
            pulumi.set(__self__, "hw_clock_utc", hw_clock_utc)
        if script_text is not None:
            pulumi.set(__self__, "script_text", script_text)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The domain name for this virtual machine.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        """
        The hostname for this virtual machine.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="hwClockUtc")
    def hw_clock_utc(self) -> Optional[bool]:
        """
        Specifies whether or not the hardware clock should be in UTC or not.
        """
        return pulumi.get(self, "hw_clock_utc")

    @property
    @pulumi.getter(name="scriptText")
    def script_text(self) -> Optional[str]:
        """
        The customization script to run before and or after guest customization
        """
        return pulumi.get(self, "script_text")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        Customize the time zone on the VM. This should be a time zone-style entry, like America/Los_Angeles.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class GuestOsCustomizationSpecNetworkInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsDomain":
            suggest = "dns_domain"
        elif key == "dnsServerLists":
            suggest = "dns_server_lists"
        elif key == "ipv4Address":
            suggest = "ipv4_address"
        elif key == "ipv4Netmask":
            suggest = "ipv4_netmask"
        elif key == "ipv6Address":
            suggest = "ipv6_address"
        elif key == "ipv6Netmask":
            suggest = "ipv6_netmask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestOsCustomizationSpecNetworkInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestOsCustomizationSpecNetworkInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestOsCustomizationSpecNetworkInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_domain: Optional[str] = None,
                 dns_server_lists: Optional[Sequence[str]] = None,
                 ipv4_address: Optional[str] = None,
                 ipv4_netmask: Optional[int] = None,
                 ipv6_address: Optional[str] = None,
                 ipv6_netmask: Optional[int] = None):
        """
        :param str dns_domain: A DNS search domain to add to the DNS configuration on the virtual machine.
        :param Sequence[str] dns_server_lists: Network-interface specific DNS settings for Windows operating systems. Ignored on Linux.
        :param str ipv4_address: The IPv4 address assigned to this network adapter. If left blank, DHCP is used.
        :param int ipv4_netmask: The IPv4 CIDR netmask for the supplied IP address. Ignored if DHCP is selected.
        :param str ipv6_address: The IPv6 address assigned to this network adapter. If left blank, default auto-configuration is used.
        :param int ipv6_netmask: The IPv6 CIDR netmask for the supplied IP address. Ignored if auto-configuration is selected.
        """
        if dns_domain is not None:
            pulumi.set(__self__, "dns_domain", dns_domain)
        if dns_server_lists is not None:
            pulumi.set(__self__, "dns_server_lists", dns_server_lists)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_netmask is not None:
            pulumi.set(__self__, "ipv4_netmask", ipv4_netmask)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if ipv6_netmask is not None:
            pulumi.set(__self__, "ipv6_netmask", ipv6_netmask)

    @property
    @pulumi.getter(name="dnsDomain")
    def dns_domain(self) -> Optional[str]:
        """
        A DNS search domain to add to the DNS configuration on the virtual machine.
        """
        return pulumi.get(self, "dns_domain")

    @property
    @pulumi.getter(name="dnsServerLists")
    def dns_server_lists(self) -> Optional[Sequence[str]]:
        """
        Network-interface specific DNS settings for Windows operating systems. Ignored on Linux.
        """
        return pulumi.get(self, "dns_server_lists")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[str]:
        """
        The IPv4 address assigned to this network adapter. If left blank, DHCP is used.
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv4Netmask")
    def ipv4_netmask(self) -> Optional[int]:
        """
        The IPv4 CIDR netmask for the supplied IP address. Ignored if DHCP is selected.
        """
        return pulumi.get(self, "ipv4_netmask")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[str]:
        """
        The IPv6 address assigned to this network adapter. If left blank, default auto-configuration is used.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="ipv6Netmask")
    def ipv6_netmask(self) -> Optional[int]:
        """
        The IPv6 CIDR netmask for the supplied IP address. Ignored if auto-configuration is selected.
        """
        return pulumi.get(self, "ipv6_netmask")


@pulumi.output_type
class GuestOsCustomizationSpecWindowsOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computerName":
            suggest = "computer_name"
        elif key == "adminPassword":
            suggest = "admin_password"
        elif key == "autoLogon":
            suggest = "auto_logon"
        elif key == "autoLogonCount":
            suggest = "auto_logon_count"
        elif key == "domainAdminPassword":
            suggest = "domain_admin_password"
        elif key == "domainAdminUser":
            suggest = "domain_admin_user"
        elif key == "domainOu":
            suggest = "domain_ou"
        elif key == "fullName":
            suggest = "full_name"
        elif key == "joinDomain":
            suggest = "join_domain"
        elif key == "organizationName":
            suggest = "organization_name"
        elif key == "productKey":
            suggest = "product_key"
        elif key == "runOnceCommandLists":
            suggest = "run_once_command_lists"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestOsCustomizationSpecWindowsOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestOsCustomizationSpecWindowsOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestOsCustomizationSpecWindowsOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 computer_name: str,
                 admin_password: Optional[str] = None,
                 auto_logon: Optional[bool] = None,
                 auto_logon_count: Optional[int] = None,
                 domain_admin_password: Optional[str] = None,
                 domain_admin_user: Optional[str] = None,
                 domain_ou: Optional[str] = None,
                 full_name: Optional[str] = None,
                 join_domain: Optional[str] = None,
                 organization_name: Optional[str] = None,
                 product_key: Optional[str] = None,
                 run_once_command_lists: Optional[Sequence[str]] = None,
                 time_zone: Optional[int] = None,
                 workgroup: Optional[str] = None):
        """
        :param str computer_name: The host name for this virtual machine.
        :param str admin_password: The new administrator password for this virtual machine.
        :param bool auto_logon: Specifies whether or not the VM automatically logs on as Administrator.
        :param int auto_logon_count: Specifies how many times the VM should auto-logon the Administrator account when auto_logon is true.
        :param str domain_admin_password: The password of the domain administrator used to join this virtual machine to the domain.
        :param str domain_admin_user: The user account of the domain administrator used to join this virtual machine to the domain.
        :param str domain_ou: The MachineObjectOU which specifies the full LDAP path name of the OU to which the virtual machine belongs.
        :param str full_name: The full name of the user of this virtual machine.
        :param str join_domain: The domain that the virtual machine should join.
        :param str organization_name: The organization name this virtual machine is being installed for.
        :param str product_key: The product key for this virtual machine.
        :param Sequence[str] run_once_command_lists: A list of commands to run at first user logon, after guest customization.
        :param int time_zone: The new time zone for the virtual machine. This is a sysprep-dictated timezone code.
        :param str workgroup: The workgroup for this virtual machine if not joining a domain.
        """
        pulumi.set(__self__, "computer_name", computer_name)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if auto_logon is not None:
            pulumi.set(__self__, "auto_logon", auto_logon)
        if auto_logon_count is not None:
            pulumi.set(__self__, "auto_logon_count", auto_logon_count)
        if domain_admin_password is not None:
            pulumi.set(__self__, "domain_admin_password", domain_admin_password)
        if domain_admin_user is not None:
            pulumi.set(__self__, "domain_admin_user", domain_admin_user)
        if domain_ou is not None:
            pulumi.set(__self__, "domain_ou", domain_ou)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if join_domain is not None:
            pulumi.set(__self__, "join_domain", join_domain)
        if organization_name is not None:
            pulumi.set(__self__, "organization_name", organization_name)
        if product_key is not None:
            pulumi.set(__self__, "product_key", product_key)
        if run_once_command_lists is not None:
            pulumi.set(__self__, "run_once_command_lists", run_once_command_lists)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if workgroup is not None:
            pulumi.set(__self__, "workgroup", workgroup)

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> str:
        """
        The host name for this virtual machine.
        """
        return pulumi.get(self, "computer_name")

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[str]:
        """
        The new administrator password for this virtual machine.
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="autoLogon")
    def auto_logon(self) -> Optional[bool]:
        """
        Specifies whether or not the VM automatically logs on as Administrator.
        """
        return pulumi.get(self, "auto_logon")

    @property
    @pulumi.getter(name="autoLogonCount")
    def auto_logon_count(self) -> Optional[int]:
        """
        Specifies how many times the VM should auto-logon the Administrator account when auto_logon is true.
        """
        return pulumi.get(self, "auto_logon_count")

    @property
    @pulumi.getter(name="domainAdminPassword")
    def domain_admin_password(self) -> Optional[str]:
        """
        The password of the domain administrator used to join this virtual machine to the domain.
        """
        return pulumi.get(self, "domain_admin_password")

    @property
    @pulumi.getter(name="domainAdminUser")
    def domain_admin_user(self) -> Optional[str]:
        """
        The user account of the domain administrator used to join this virtual machine to the domain.
        """
        return pulumi.get(self, "domain_admin_user")

    @property
    @pulumi.getter(name="domainOu")
    def domain_ou(self) -> Optional[str]:
        """
        The MachineObjectOU which specifies the full LDAP path name of the OU to which the virtual machine belongs.
        """
        return pulumi.get(self, "domain_ou")

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[str]:
        """
        The full name of the user of this virtual machine.
        """
        return pulumi.get(self, "full_name")

    @property
    @pulumi.getter(name="joinDomain")
    def join_domain(self) -> Optional[str]:
        """
        The domain that the virtual machine should join.
        """
        return pulumi.get(self, "join_domain")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[str]:
        """
        The organization name this virtual machine is being installed for.
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="productKey")
    def product_key(self) -> Optional[str]:
        """
        The product key for this virtual machine.
        """
        return pulumi.get(self, "product_key")

    @property
    @pulumi.getter(name="runOnceCommandLists")
    def run_once_command_lists(self) -> Optional[Sequence[str]]:
        """
        A list of commands to run at first user logon, after guest customization.
        """
        return pulumi.get(self, "run_once_command_lists")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[int]:
        """
        The new time zone for the virtual machine. This is a sysprep-dictated timezone code.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def workgroup(self) -> Optional[str]:
        """
        The workgroup for this virtual machine if not joining a domain.
        """
        return pulumi.get(self, "workgroup")


@pulumi.output_type
class HostPortGroupPort(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "macAddresses":
            suggest = "mac_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostPortGroupPort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostPortGroupPort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostPortGroupPort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: Optional[str] = None,
                 mac_addresses: Optional[Sequence[str]] = None,
                 type: Optional[str] = None):
        """
        :param str key: The key for this port group as returned from the vSphere API.
        :param Sequence[str] mac_addresses: The MAC addresses of the network service of the virtual machine connected on this port.
        :param str type: Type type of the entity connected on this port. Possible values are host (VMKkernel), systemManagement (service console), virtualMachine, or unknown.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if mac_addresses is not None:
            pulumi.set(__self__, "mac_addresses", mac_addresses)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The key for this port group as returned from the vSphere API.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="macAddresses")
    def mac_addresses(self) -> Optional[Sequence[str]]:
        """
        The MAC addresses of the network service of the virtual machine connected on this port.
        """
        return pulumi.get(self, "mac_addresses")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type type of the entity connected on this port. Possible values are host (VMKkernel), systemManagement (service console), virtualMachine, or unknown.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class OfflineSoftwareDepotComponent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OfflineSoftwareDepotComponent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OfflineSoftwareDepotComponent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OfflineSoftwareDepotComponent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 key: Optional[str] = None,
                 versions: Optional[Sequence[str]] = None):
        """
        :param str display_name: The name of the component. Useful for easier identification.
        :param str key: The identifier of the component.
        :param Sequence[str] versions: The list of available versions of the component.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The name of the component. Useful for easier identification.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The identifier of the component.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def versions(self) -> Optional[Sequence[str]]:
        """
        The list of available versions of the component.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class SupervisorEgressCidr(dict):
    def __init__(__self__, *,
                 address: str,
                 prefix: int):
        """
        :param str address: Network address.
        :param int prefix: Subnet prefix.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Network address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def prefix(self) -> int:
        """
        Subnet prefix.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class SupervisorIngressCidr(dict):
    def __init__(__self__, *,
                 address: str,
                 prefix: int):
        """
        :param str address: Network address.
        :param int prefix: Subnet prefix.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Network address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def prefix(self) -> int:
        """
        Subnet prefix.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class SupervisorManagementNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressCount":
            suggest = "address_count"
        elif key == "startingAddress":
            suggest = "starting_address"
        elif key == "subnetMask":
            suggest = "subnet_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SupervisorManagementNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SupervisorManagementNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SupervisorManagementNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_count: int,
                 gateway: str,
                 network: str,
                 starting_address: str,
                 subnet_mask: str):
        """
        :param int address_count: Number of addresses to allocate. Starts from 'starting_address'
        :param str gateway: Gateway IP address.
        :param str network: ID of the network. (e.g. a distributed port group).
        :param str starting_address: Starting address of the management network range.
        :param str subnet_mask: Subnet mask.
        """
        pulumi.set(__self__, "address_count", address_count)
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "starting_address", starting_address)
        pulumi.set(__self__, "subnet_mask", subnet_mask)

    @property
    @pulumi.getter(name="addressCount")
    def address_count(self) -> int:
        """
        Number of addresses to allocate. Starts from 'starting_address'
        """
        return pulumi.get(self, "address_count")

    @property
    @pulumi.getter
    def gateway(self) -> str:
        """
        Gateway IP address.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        ID of the network. (e.g. a distributed port group).
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="startingAddress")
    def starting_address(self) -> str:
        """
        Starting address of the management network range.
        """
        return pulumi.get(self, "starting_address")

    @property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> str:
        """
        Subnet mask.
        """
        return pulumi.get(self, "subnet_mask")


@pulumi.output_type
class SupervisorNamespace(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentLibraries":
            suggest = "content_libraries"
        elif key == "vmClasses":
            suggest = "vm_classes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SupervisorNamespace. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SupervisorNamespace.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SupervisorNamespace.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 content_libraries: Optional[Sequence[str]] = None,
                 vm_classes: Optional[Sequence[str]] = None):
        """
        :param str name: The name of the namespace.
        :param Sequence[str] content_libraries: A list of content libraries.
        :param Sequence[str] vm_classes: A list of virtual machine classes.
        """
        pulumi.set(__self__, "name", name)
        if content_libraries is not None:
            pulumi.set(__self__, "content_libraries", content_libraries)
        if vm_classes is not None:
            pulumi.set(__self__, "vm_classes", vm_classes)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the namespace.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="contentLibraries")
    def content_libraries(self) -> Optional[Sequence[str]]:
        """
        A list of content libraries.
        """
        return pulumi.get(self, "content_libraries")

    @property
    @pulumi.getter(name="vmClasses")
    def vm_classes(self) -> Optional[Sequence[str]]:
        """
        A list of virtual machine classes.
        """
        return pulumi.get(self, "vm_classes")


@pulumi.output_type
class SupervisorPodCidr(dict):
    def __init__(__self__, *,
                 address: str,
                 prefix: int):
        """
        :param str address: Network address.
        :param int prefix: Subnet prefix.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Network address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def prefix(self) -> int:
        """
        Subnet prefix.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class SupervisorServiceCidr(dict):
    def __init__(__self__, *,
                 address: str,
                 prefix: int):
        """
        :param str address: Network address.
        :param int prefix: Subnet prefix.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Network address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def prefix(self) -> int:
        """
        Subnet prefix.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class VirtualMachineCdrom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientDevice":
            suggest = "client_device"
        elif key == "datastoreId":
            suggest = "datastore_id"
        elif key == "deviceAddress":
            suggest = "device_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineCdrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineCdrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineCdrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_device: Optional[bool] = None,
                 datastore_id: Optional[str] = None,
                 device_address: Optional[str] = None,
                 key: Optional[int] = None,
                 path: Optional[str] = None):
        """
        :param bool client_device: Indicates whether the device should be mapped to a remote client device
        :param str datastore_id: The datastore ID the ISO is located on.
        :param str device_address: The internally-computed address of this device, such as scsi:0:1, denoting scsi bus #0 and device unit 1.
        :param int key: The ID of the device within the virtual machine.
        :param str path: The path to the ISO file on the datastore.
        """
        if client_device is not None:
            pulumi.set(__self__, "client_device", client_device)
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if device_address is not None:
            pulumi.set(__self__, "device_address", device_address)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="clientDevice")
    def client_device(self) -> Optional[bool]:
        """
        Indicates whether the device should be mapped to a remote client device
        """
        return pulumi.get(self, "client_device")

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[str]:
        """
        The datastore ID the ISO is located on.
        """
        return pulumi.get(self, "datastore_id")

    @property
    @pulumi.getter(name="deviceAddress")
    def device_address(self) -> Optional[str]:
        """
        The internally-computed address of this device, such as scsi:0:1, denoting scsi bus #0 and device unit 1.
        """
        return pulumi.get(self, "device_address")

    @property
    @pulumi.getter
    def key(self) -> Optional[int]:
        """
        The ID of the device within the virtual machine.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to the ISO file on the datastore.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class VirtualMachineClone(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "templateUuid":
            suggest = "template_uuid"
        elif key == "customizationSpec":
            suggest = "customization_spec"
        elif key == "linkedClone":
            suggest = "linked_clone"
        elif key == "ovfNetworkMap":
            suggest = "ovf_network_map"
        elif key == "ovfStorageMap":
            suggest = "ovf_storage_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineClone. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineClone.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineClone.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 template_uuid: str,
                 customization_spec: Optional['outputs.VirtualMachineCloneCustomizationSpec'] = None,
                 customize: Optional['outputs.VirtualMachineCloneCustomize'] = None,
                 linked_clone: Optional[bool] = None,
                 ovf_network_map: Optional[Mapping[str, str]] = None,
                 ovf_storage_map: Optional[Mapping[str, str]] = None,
                 timeout: Optional[int] = None):
        """
        :param str template_uuid: The UUID of the source virtual machine or template.
        :param 'VirtualMachineCloneCustomizationSpecArgs' customization_spec: The customization specification for the virtual machine post-clone.
        :param 'VirtualMachineCloneCustomizeArgs' customize: The customization specification for the virtual machine post-clone.
        :param bool linked_clone: Whether or not to create a linked clone when cloning. When this option is used, the source VM must have a single snapshot associated with it.
        :param Mapping[str, str] ovf_network_map: Mapping of ovf networks to the networks to use in vSphere.
        :param Mapping[str, str] ovf_storage_map: Mapping of ovf storage to the datastores to use in vSphere.
        :param int timeout: The timeout, in minutes, to wait for the virtual machine clone to complete.
        """
        pulumi.set(__self__, "template_uuid", template_uuid)
        if customization_spec is not None:
            pulumi.set(__self__, "customization_spec", customization_spec)
        if customize is not None:
            pulumi.set(__self__, "customize", customize)
        if linked_clone is not None:
            pulumi.set(__self__, "linked_clone", linked_clone)
        if ovf_network_map is not None:
            pulumi.set(__self__, "ovf_network_map", ovf_network_map)
        if ovf_storage_map is not None:
            pulumi.set(__self__, "ovf_storage_map", ovf_storage_map)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="templateUuid")
    def template_uuid(self) -> str:
        """
        The UUID of the source virtual machine or template.
        """
        return pulumi.get(self, "template_uuid")

    @property
    @pulumi.getter(name="customizationSpec")
    def customization_spec(self) -> Optional['outputs.VirtualMachineCloneCustomizationSpec']:
        """
        The customization specification for the virtual machine post-clone.
        """
        return pulumi.get(self, "customization_spec")

    @property
    @pulumi.getter
    def customize(self) -> Optional['outputs.VirtualMachineCloneCustomize']:
        """
        The customization specification for the virtual machine post-clone.
        """
        return pulumi.get(self, "customize")

    @property
    @pulumi.getter(name="linkedClone")
    def linked_clone(self) -> Optional[bool]:
        """
        Whether or not to create a linked clone when cloning. When this option is used, the source VM must have a single snapshot associated with it.
        """
        return pulumi.get(self, "linked_clone")

    @property
    @pulumi.getter(name="ovfNetworkMap")
    def ovf_network_map(self) -> Optional[Mapping[str, str]]:
        """
        Mapping of ovf networks to the networks to use in vSphere.
        """
        return pulumi.get(self, "ovf_network_map")

    @property
    @pulumi.getter(name="ovfStorageMap")
    def ovf_storage_map(self) -> Optional[Mapping[str, str]]:
        """
        Mapping of ovf storage to the datastores to use in vSphere.
        """
        return pulumi.get(self, "ovf_storage_map")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        The timeout, in minutes, to wait for the virtual machine clone to complete.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class VirtualMachineCloneCustomizationSpec(dict):
    def __init__(__self__, *,
                 id: str,
                 timeout: Optional[int] = None):
        """
        :param str id: The UUID of the virtual machine.
        :param int timeout: The amount of time, in minutes, to wait for guest OS customization to complete before returning with an error. Setting this value to 0 or a negative value skips the waiter. Default: 10.
        """
        pulumi.set(__self__, "id", id)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The UUID of the virtual machine.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        The amount of time, in minutes, to wait for guest OS customization to complete before returning with an error. Setting this value to 0 or a negative value skips the waiter. Default: 10.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class VirtualMachineCloneCustomize(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsServerLists":
            suggest = "dns_server_lists"
        elif key == "dnsSuffixLists":
            suggest = "dns_suffix_lists"
        elif key == "ipv4Gateway":
            suggest = "ipv4_gateway"
        elif key == "ipv6Gateway":
            suggest = "ipv6_gateway"
        elif key == "linuxOptions":
            suggest = "linux_options"
        elif key == "networkInterfaces":
            suggest = "network_interfaces"
        elif key == "windowsOptions":
            suggest = "windows_options"
        elif key == "windowsSysprepText":
            suggest = "windows_sysprep_text"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineCloneCustomize. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineCloneCustomize.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineCloneCustomize.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_server_lists: Optional[Sequence[str]] = None,
                 dns_suffix_lists: Optional[Sequence[str]] = None,
                 ipv4_gateway: Optional[str] = None,
                 ipv6_gateway: Optional[str] = None,
                 linux_options: Optional['outputs.VirtualMachineCloneCustomizeLinuxOptions'] = None,
                 network_interfaces: Optional[Sequence['outputs.VirtualMachineCloneCustomizeNetworkInterface']] = None,
                 timeout: Optional[int] = None,
                 windows_options: Optional['outputs.VirtualMachineCloneCustomizeWindowsOptions'] = None,
                 windows_sysprep_text: Optional[str] = None):
        """
        :param Sequence[str] dns_server_lists: The list of DNS servers for a virtual network adapter with a static IP address.
        :param Sequence[str] dns_suffix_lists: A list of DNS search domains to add to the DNS configuration on the virtual machine.
        :param str ipv4_gateway: The IPv4 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
        :param str ipv6_gateway: The IPv6 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
        :param 'VirtualMachineCloneCustomizeLinuxOptionsArgs' linux_options: A list of configuration options specific to Linux virtual machines.
        :param Sequence['VirtualMachineCloneCustomizeNetworkInterfaceArgs'] network_interfaces: A specification of network interface configuration options.
        :param int timeout: The amount of time, in minutes, to wait for guest OS customization to complete before returning with an error. Setting this value to 0 or a negative value skips the waiter. Default: 10.
        :param 'VirtualMachineCloneCustomizeWindowsOptionsArgs' windows_options: A list of configuration options specific to Windows virtual machines.
        :param str windows_sysprep_text: Use this option to specify a windows sysprep file directly.
        """
        if dns_server_lists is not None:
            pulumi.set(__self__, "dns_server_lists", dns_server_lists)
        if dns_suffix_lists is not None:
            pulumi.set(__self__, "dns_suffix_lists", dns_suffix_lists)
        if ipv4_gateway is not None:
            pulumi.set(__self__, "ipv4_gateway", ipv4_gateway)
        if ipv6_gateway is not None:
            pulumi.set(__self__, "ipv6_gateway", ipv6_gateway)
        if linux_options is not None:
            pulumi.set(__self__, "linux_options", linux_options)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if windows_options is not None:
            pulumi.set(__self__, "windows_options", windows_options)
        if windows_sysprep_text is not None:
            pulumi.set(__self__, "windows_sysprep_text", windows_sysprep_text)

    @property
    @pulumi.getter(name="dnsServerLists")
    def dns_server_lists(self) -> Optional[Sequence[str]]:
        """
        The list of DNS servers for a virtual network adapter with a static IP address.
        """
        return pulumi.get(self, "dns_server_lists")

    @property
    @pulumi.getter(name="dnsSuffixLists")
    def dns_suffix_lists(self) -> Optional[Sequence[str]]:
        """
        A list of DNS search domains to add to the DNS configuration on the virtual machine.
        """
        return pulumi.get(self, "dns_suffix_lists")

    @property
    @pulumi.getter(name="ipv4Gateway")
    def ipv4_gateway(self) -> Optional[str]:
        """
        The IPv4 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
        """
        return pulumi.get(self, "ipv4_gateway")

    @property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> Optional[str]:
        """
        The IPv6 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
        """
        return pulumi.get(self, "ipv6_gateway")

    @property
    @pulumi.getter(name="linuxOptions")
    def linux_options(self) -> Optional['outputs.VirtualMachineCloneCustomizeLinuxOptions']:
        """
        A list of configuration options specific to Linux virtual machines.
        """
        return pulumi.get(self, "linux_options")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[Sequence['outputs.VirtualMachineCloneCustomizeNetworkInterface']]:
        """
        A specification of network interface configuration options.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        The amount of time, in minutes, to wait for guest OS customization to complete before returning with an error. Setting this value to 0 or a negative value skips the waiter. Default: 10.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="windowsOptions")
    def windows_options(self) -> Optional['outputs.VirtualMachineCloneCustomizeWindowsOptions']:
        """
        A list of configuration options specific to Windows virtual machines.
        """
        return pulumi.get(self, "windows_options")

    @property
    @pulumi.getter(name="windowsSysprepText")
    def windows_sysprep_text(self) -> Optional[str]:
        """
        Use this option to specify a windows sysprep file directly.
        """
        return pulumi.get(self, "windows_sysprep_text")


@pulumi.output_type
class VirtualMachineCloneCustomizeLinuxOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "hwClockUtc":
            suggest = "hw_clock_utc"
        elif key == "scriptText":
            suggest = "script_text"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineCloneCustomizeLinuxOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineCloneCustomizeLinuxOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineCloneCustomizeLinuxOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain: str,
                 host_name: str,
                 hw_clock_utc: Optional[bool] = None,
                 script_text: Optional[str] = None,
                 time_zone: Optional[str] = None):
        """
        :param str domain: The domain name for this virtual machine.
        :param str host_name: The hostname for this virtual machine.
        :param bool hw_clock_utc: Specifies whether or not the hardware clock should be in UTC or not.
        :param str script_text: The customization script to run before and or after guest customization
        :param str time_zone: Customize the time zone on the VM. This should be a time zone-style entry, like America/Los_Angeles.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "host_name", host_name)
        if hw_clock_utc is not None:
            pulumi.set(__self__, "hw_clock_utc", hw_clock_utc)
        if script_text is not None:
            pulumi.set(__self__, "script_text", script_text)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The domain name for this virtual machine.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        """
        The hostname for this virtual machine.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="hwClockUtc")
    def hw_clock_utc(self) -> Optional[bool]:
        """
        Specifies whether or not the hardware clock should be in UTC or not.
        """
        return pulumi.get(self, "hw_clock_utc")

    @property
    @pulumi.getter(name="scriptText")
    def script_text(self) -> Optional[str]:
        """
        The customization script to run before and or after guest customization
        """
        return pulumi.get(self, "script_text")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        Customize the time zone on the VM. This should be a time zone-style entry, like America/Los_Angeles.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class VirtualMachineCloneCustomizeNetworkInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsDomain":
            suggest = "dns_domain"
        elif key == "dnsServerLists":
            suggest = "dns_server_lists"
        elif key == "ipv4Address":
            suggest = "ipv4_address"
        elif key == "ipv4Netmask":
            suggest = "ipv4_netmask"
        elif key == "ipv6Address":
            suggest = "ipv6_address"
        elif key == "ipv6Netmask":
            suggest = "ipv6_netmask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineCloneCustomizeNetworkInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineCloneCustomizeNetworkInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineCloneCustomizeNetworkInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_domain: Optional[str] = None,
                 dns_server_lists: Optional[Sequence[str]] = None,
                 ipv4_address: Optional[str] = None,
                 ipv4_netmask: Optional[int] = None,
                 ipv6_address: Optional[str] = None,
                 ipv6_netmask: Optional[int] = None):
        """
        :param str dns_domain: A DNS search domain to add to the DNS configuration on the virtual machine.
        :param Sequence[str] dns_server_lists: Network-interface specific DNS settings for Windows operating systems. Ignored on Linux.
        :param str ipv4_address: The IPv4 address assigned to this network adapter. If left blank, DHCP is used.
        :param int ipv4_netmask: The IPv4 CIDR netmask for the supplied IP address. Ignored if DHCP is selected.
        :param str ipv6_address: The IPv6 address assigned to this network adapter. If left blank, default auto-configuration is used.
        :param int ipv6_netmask: The IPv6 CIDR netmask for the supplied IP address. Ignored if auto-configuration is selected.
        """
        if dns_domain is not None:
            pulumi.set(__self__, "dns_domain", dns_domain)
        if dns_server_lists is not None:
            pulumi.set(__self__, "dns_server_lists", dns_server_lists)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_netmask is not None:
            pulumi.set(__self__, "ipv4_netmask", ipv4_netmask)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if ipv6_netmask is not None:
            pulumi.set(__self__, "ipv6_netmask", ipv6_netmask)

    @property
    @pulumi.getter(name="dnsDomain")
    def dns_domain(self) -> Optional[str]:
        """
        A DNS search domain to add to the DNS configuration on the virtual machine.
        """
        return pulumi.get(self, "dns_domain")

    @property
    @pulumi.getter(name="dnsServerLists")
    def dns_server_lists(self) -> Optional[Sequence[str]]:
        """
        Network-interface specific DNS settings for Windows operating systems. Ignored on Linux.
        """
        return pulumi.get(self, "dns_server_lists")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[str]:
        """
        The IPv4 address assigned to this network adapter. If left blank, DHCP is used.
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv4Netmask")
    def ipv4_netmask(self) -> Optional[int]:
        """
        The IPv4 CIDR netmask for the supplied IP address. Ignored if DHCP is selected.
        """
        return pulumi.get(self, "ipv4_netmask")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[str]:
        """
        The IPv6 address assigned to this network adapter. If left blank, default auto-configuration is used.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="ipv6Netmask")
    def ipv6_netmask(self) -> Optional[int]:
        """
        The IPv6 CIDR netmask for the supplied IP address. Ignored if auto-configuration is selected.
        """
        return pulumi.get(self, "ipv6_netmask")


@pulumi.output_type
class VirtualMachineCloneCustomizeWindowsOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computerName":
            suggest = "computer_name"
        elif key == "adminPassword":
            suggest = "admin_password"
        elif key == "autoLogon":
            suggest = "auto_logon"
        elif key == "autoLogonCount":
            suggest = "auto_logon_count"
        elif key == "domainAdminPassword":
            suggest = "domain_admin_password"
        elif key == "domainAdminUser":
            suggest = "domain_admin_user"
        elif key == "domainOu":
            suggest = "domain_ou"
        elif key == "fullName":
            suggest = "full_name"
        elif key == "joinDomain":
            suggest = "join_domain"
        elif key == "organizationName":
            suggest = "organization_name"
        elif key == "productKey":
            suggest = "product_key"
        elif key == "runOnceCommandLists":
            suggest = "run_once_command_lists"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineCloneCustomizeWindowsOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineCloneCustomizeWindowsOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineCloneCustomizeWindowsOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 computer_name: str,
                 admin_password: Optional[str] = None,
                 auto_logon: Optional[bool] = None,
                 auto_logon_count: Optional[int] = None,
                 domain_admin_password: Optional[str] = None,
                 domain_admin_user: Optional[str] = None,
                 domain_ou: Optional[str] = None,
                 full_name: Optional[str] = None,
                 join_domain: Optional[str] = None,
                 organization_name: Optional[str] = None,
                 product_key: Optional[str] = None,
                 run_once_command_lists: Optional[Sequence[str]] = None,
                 time_zone: Optional[int] = None,
                 workgroup: Optional[str] = None):
        """
        :param str computer_name: The host name for this virtual machine.
        :param str admin_password: The new administrator password for this virtual machine.
        :param bool auto_logon: Specifies whether or not the VM automatically logs on as Administrator.
        :param int auto_logon_count: Specifies how many times the VM should auto-logon the Administrator account when auto_logon is true.
        :param str domain_admin_password: The password of the domain administrator used to join this virtual machine to the domain.
        :param str domain_admin_user: The user account of the domain administrator used to join this virtual machine to the domain.
        :param str domain_ou: The MachineObjectOU which specifies the full LDAP path name of the OU to which the virtual machine belongs.
        :param str full_name: The full name of the user of this virtual machine.
        :param str join_domain: The domain that the virtual machine should join.
        :param str organization_name: The organization name this virtual machine is being installed for.
        :param str product_key: The product key for this virtual machine.
        :param Sequence[str] run_once_command_lists: A list of commands to run at first user logon, after guest customization.
        :param int time_zone: The new time zone for the virtual machine. This is a sysprep-dictated timezone code.
        :param str workgroup: The workgroup for this virtual machine if not joining a domain.
        """
        pulumi.set(__self__, "computer_name", computer_name)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if auto_logon is not None:
            pulumi.set(__self__, "auto_logon", auto_logon)
        if auto_logon_count is not None:
            pulumi.set(__self__, "auto_logon_count", auto_logon_count)
        if domain_admin_password is not None:
            pulumi.set(__self__, "domain_admin_password", domain_admin_password)
        if domain_admin_user is not None:
            pulumi.set(__self__, "domain_admin_user", domain_admin_user)
        if domain_ou is not None:
            pulumi.set(__self__, "domain_ou", domain_ou)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if join_domain is not None:
            pulumi.set(__self__, "join_domain", join_domain)
        if organization_name is not None:
            pulumi.set(__self__, "organization_name", organization_name)
        if product_key is not None:
            pulumi.set(__self__, "product_key", product_key)
        if run_once_command_lists is not None:
            pulumi.set(__self__, "run_once_command_lists", run_once_command_lists)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if workgroup is not None:
            pulumi.set(__self__, "workgroup", workgroup)

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> str:
        """
        The host name for this virtual machine.
        """
        return pulumi.get(self, "computer_name")

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[str]:
        """
        The new administrator password for this virtual machine.
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="autoLogon")
    def auto_logon(self) -> Optional[bool]:
        """
        Specifies whether or not the VM automatically logs on as Administrator.
        """
        return pulumi.get(self, "auto_logon")

    @property
    @pulumi.getter(name="autoLogonCount")
    def auto_logon_count(self) -> Optional[int]:
        """
        Specifies how many times the VM should auto-logon the Administrator account when auto_logon is true.
        """
        return pulumi.get(self, "auto_logon_count")

    @property
    @pulumi.getter(name="domainAdminPassword")
    def domain_admin_password(self) -> Optional[str]:
        """
        The password of the domain administrator used to join this virtual machine to the domain.
        """
        return pulumi.get(self, "domain_admin_password")

    @property
    @pulumi.getter(name="domainAdminUser")
    def domain_admin_user(self) -> Optional[str]:
        """
        The user account of the domain administrator used to join this virtual machine to the domain.
        """
        return pulumi.get(self, "domain_admin_user")

    @property
    @pulumi.getter(name="domainOu")
    def domain_ou(self) -> Optional[str]:
        """
        The MachineObjectOU which specifies the full LDAP path name of the OU to which the virtual machine belongs.
        """
        return pulumi.get(self, "domain_ou")

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[str]:
        """
        The full name of the user of this virtual machine.
        """
        return pulumi.get(self, "full_name")

    @property
    @pulumi.getter(name="joinDomain")
    def join_domain(self) -> Optional[str]:
        """
        The domain that the virtual machine should join.
        """
        return pulumi.get(self, "join_domain")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[str]:
        """
        The organization name this virtual machine is being installed for.
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="productKey")
    def product_key(self) -> Optional[str]:
        """
        The product key for this virtual machine.
        """
        return pulumi.get(self, "product_key")

    @property
    @pulumi.getter(name="runOnceCommandLists")
    def run_once_command_lists(self) -> Optional[Sequence[str]]:
        """
        A list of commands to run at first user logon, after guest customization.
        """
        return pulumi.get(self, "run_once_command_lists")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[int]:
        """
        The new time zone for the virtual machine. This is a sysprep-dictated timezone code.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def workgroup(self) -> Optional[str]:
        """
        The workgroup for this virtual machine if not joining a domain.
        """
        return pulumi.get(self, "workgroup")


@pulumi.output_type
class VirtualMachineDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "controllerType":
            suggest = "controller_type"
        elif key == "datastoreId":
            suggest = "datastore_id"
        elif key == "deviceAddress":
            suggest = "device_address"
        elif key == "diskMode":
            suggest = "disk_mode"
        elif key == "diskSharing":
            suggest = "disk_sharing"
        elif key == "eagerlyScrub":
            suggest = "eagerly_scrub"
        elif key == "ioLimit":
            suggest = "io_limit"
        elif key == "ioReservation":
            suggest = "io_reservation"
        elif key == "ioShareCount":
            suggest = "io_share_count"
        elif key == "ioShareLevel":
            suggest = "io_share_level"
        elif key == "keepOnRemove":
            suggest = "keep_on_remove"
        elif key == "storagePolicyId":
            suggest = "storage_policy_id"
        elif key == "thinProvisioned":
            suggest = "thin_provisioned"
        elif key == "unitNumber":
            suggest = "unit_number"
        elif key == "writeThrough":
            suggest = "write_through"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label: str,
                 attach: Optional[bool] = None,
                 controller_type: Optional[str] = None,
                 datastore_id: Optional[str] = None,
                 device_address: Optional[str] = None,
                 disk_mode: Optional[str] = None,
                 disk_sharing: Optional[str] = None,
                 eagerly_scrub: Optional[bool] = None,
                 io_limit: Optional[int] = None,
                 io_reservation: Optional[int] = None,
                 io_share_count: Optional[int] = None,
                 io_share_level: Optional[str] = None,
                 keep_on_remove: Optional[bool] = None,
                 key: Optional[int] = None,
                 path: Optional[str] = None,
                 size: Optional[int] = None,
                 storage_policy_id: Optional[str] = None,
                 thin_provisioned: Optional[bool] = None,
                 unit_number: Optional[int] = None,
                 uuid: Optional[str] = None,
                 write_through: Optional[bool] = None):
        """
        :param str label: A unique label for this disk.
        :param bool attach: If this is true, the disk is attached instead of created. Implies keep_on_remove.
        :param str controller_type: The type of controller the disk should be connected to. Must be 'scsi', 'sata', or 'ide'.
        :param str datastore_id: The datastore ID for this virtual disk, if different than the virtual machine.
        :param str device_address: The internally-computed address of this device, such as scsi:0:1, denoting scsi bus #0 and device unit 1.
        :param str disk_mode: The mode of this this virtual disk for purposes of writes and snapshotting. Can be one of append, independent_nonpersistent, independent_persistent, nonpersistent, persistent, or undoable.
        :param str disk_sharing: The sharing mode of this virtual disk. Can be one of sharingMultiWriter or sharingNone.
        :param bool eagerly_scrub: The virtual disk file zeroing policy when thin_provision is not true. The default is false, which lazily-zeros the disk, speeding up thick-provisioned disk creation time.
        :param int io_limit: The upper limit of IOPS that this disk can use.
        :param int io_reservation: The I/O guarantee that this disk has, in IOPS.
        :param int io_share_count: The share count for this disk when the share level is custom.
        :param str io_share_level: The share allocation level for this disk. Can be one of low, normal, high, or custom.
        :param bool keep_on_remove: Set to true to keep the underlying VMDK file when removing this virtual disk from configuration.
        :param int key: The ID of the device within the virtual machine.
        :param str path: The full path of the virtual disk. This can only be provided if attach is set to true, otherwise it is a read-only value.
        :param int size: The size of the disk, in GB.
        :param str storage_policy_id: The ID of the storage policy to assign to the virtual disk in VM.
        :param bool thin_provisioned: If true, this disk is thin provisioned, with space for the file being allocated on an as-needed basis.
        :param int unit_number: The unique device number for this disk. This number determines where on the SCSI bus this device will be attached.
        :param str uuid: The UUID of the virtual machine. Also exposed as the `id` of the resource.
        :param bool write_through: If true, writes for this disk are sent directly to the filesystem immediately instead of being buffered.
        """
        pulumi.set(__self__, "label", label)
        if attach is not None:
            pulumi.set(__self__, "attach", attach)
        if controller_type is not None:
            pulumi.set(__self__, "controller_type", controller_type)
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if device_address is not None:
            pulumi.set(__self__, "device_address", device_address)
        if disk_mode is not None:
            pulumi.set(__self__, "disk_mode", disk_mode)
        if disk_sharing is not None:
            pulumi.set(__self__, "disk_sharing", disk_sharing)
        if eagerly_scrub is not None:
            pulumi.set(__self__, "eagerly_scrub", eagerly_scrub)
        if io_limit is not None:
            pulumi.set(__self__, "io_limit", io_limit)
        if io_reservation is not None:
            pulumi.set(__self__, "io_reservation", io_reservation)
        if io_share_count is not None:
            pulumi.set(__self__, "io_share_count", io_share_count)
        if io_share_level is not None:
            pulumi.set(__self__, "io_share_level", io_share_level)
        if keep_on_remove is not None:
            pulumi.set(__self__, "keep_on_remove", keep_on_remove)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if storage_policy_id is not None:
            pulumi.set(__self__, "storage_policy_id", storage_policy_id)
        if thin_provisioned is not None:
            pulumi.set(__self__, "thin_provisioned", thin_provisioned)
        if unit_number is not None:
            pulumi.set(__self__, "unit_number", unit_number)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if write_through is not None:
            pulumi.set(__self__, "write_through", write_through)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        A unique label for this disk.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def attach(self) -> Optional[bool]:
        """
        If this is true, the disk is attached instead of created. Implies keep_on_remove.
        """
        return pulumi.get(self, "attach")

    @property
    @pulumi.getter(name="controllerType")
    def controller_type(self) -> Optional[str]:
        """
        The type of controller the disk should be connected to. Must be 'scsi', 'sata', or 'ide'.
        """
        return pulumi.get(self, "controller_type")

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[str]:
        """
        The datastore ID for this virtual disk, if different than the virtual machine.
        """
        return pulumi.get(self, "datastore_id")

    @property
    @pulumi.getter(name="deviceAddress")
    def device_address(self) -> Optional[str]:
        """
        The internally-computed address of this device, such as scsi:0:1, denoting scsi bus #0 and device unit 1.
        """
        return pulumi.get(self, "device_address")

    @property
    @pulumi.getter(name="diskMode")
    def disk_mode(self) -> Optional[str]:
        """
        The mode of this this virtual disk for purposes of writes and snapshotting. Can be one of append, independent_nonpersistent, independent_persistent, nonpersistent, persistent, or undoable.
        """
        return pulumi.get(self, "disk_mode")

    @property
    @pulumi.getter(name="diskSharing")
    def disk_sharing(self) -> Optional[str]:
        """
        The sharing mode of this virtual disk. Can be one of sharingMultiWriter or sharingNone.
        """
        return pulumi.get(self, "disk_sharing")

    @property
    @pulumi.getter(name="eagerlyScrub")
    def eagerly_scrub(self) -> Optional[bool]:
        """
        The virtual disk file zeroing policy when thin_provision is not true. The default is false, which lazily-zeros the disk, speeding up thick-provisioned disk creation time.
        """
        return pulumi.get(self, "eagerly_scrub")

    @property
    @pulumi.getter(name="ioLimit")
    def io_limit(self) -> Optional[int]:
        """
        The upper limit of IOPS that this disk can use.
        """
        return pulumi.get(self, "io_limit")

    @property
    @pulumi.getter(name="ioReservation")
    def io_reservation(self) -> Optional[int]:
        """
        The I/O guarantee that this disk has, in IOPS.
        """
        return pulumi.get(self, "io_reservation")

    @property
    @pulumi.getter(name="ioShareCount")
    def io_share_count(self) -> Optional[int]:
        """
        The share count for this disk when the share level is custom.
        """
        return pulumi.get(self, "io_share_count")

    @property
    @pulumi.getter(name="ioShareLevel")
    def io_share_level(self) -> Optional[str]:
        """
        The share allocation level for this disk. Can be one of low, normal, high, or custom.
        """
        return pulumi.get(self, "io_share_level")

    @property
    @pulumi.getter(name="keepOnRemove")
    def keep_on_remove(self) -> Optional[bool]:
        """
        Set to true to keep the underlying VMDK file when removing this virtual disk from configuration.
        """
        return pulumi.get(self, "keep_on_remove")

    @property
    @pulumi.getter
    def key(self) -> Optional[int]:
        """
        The ID of the device within the virtual machine.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The full path of the virtual disk. This can only be provided if attach is set to true, otherwise it is a read-only value.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        """
        The size of the disk, in GB.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="storagePolicyId")
    def storage_policy_id(self) -> Optional[str]:
        """
        The ID of the storage policy to assign to the virtual disk in VM.
        """
        return pulumi.get(self, "storage_policy_id")

    @property
    @pulumi.getter(name="thinProvisioned")
    def thin_provisioned(self) -> Optional[bool]:
        """
        If true, this disk is thin provisioned, with space for the file being allocated on an as-needed basis.
        """
        return pulumi.get(self, "thin_provisioned")

    @property
    @pulumi.getter(name="unitNumber")
    def unit_number(self) -> Optional[int]:
        """
        The unique device number for this disk. This number determines where on the SCSI bus this device will be attached.
        """
        return pulumi.get(self, "unit_number")

    @property
    @pulumi.getter
    def uuid(self) -> Optional[str]:
        """
        The UUID of the virtual machine. Also exposed as the `id` of the resource.
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter(name="writeThrough")
    def write_through(self) -> Optional[bool]:
        """
        If true, writes for this disk are sent directly to the filesystem immediately instead of being buffered.
        """
        return pulumi.get(self, "write_through")


@pulumi.output_type
class VirtualMachineNetworkInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkId":
            suggest = "network_id"
        elif key == "adapterType":
            suggest = "adapter_type"
        elif key == "bandwidthLimit":
            suggest = "bandwidth_limit"
        elif key == "bandwidthReservation":
            suggest = "bandwidth_reservation"
        elif key == "bandwidthShareCount":
            suggest = "bandwidth_share_count"
        elif key == "bandwidthShareLevel":
            suggest = "bandwidth_share_level"
        elif key == "deviceAddress":
            suggest = "device_address"
        elif key == "macAddress":
            suggest = "mac_address"
        elif key == "ovfMapping":
            suggest = "ovf_mapping"
        elif key == "physicalFunction":
            suggest = "physical_function"
        elif key == "useStaticMac":
            suggest = "use_static_mac"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineNetworkInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineNetworkInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineNetworkInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_id: str,
                 adapter_type: Optional[str] = None,
                 bandwidth_limit: Optional[int] = None,
                 bandwidth_reservation: Optional[int] = None,
                 bandwidth_share_count: Optional[int] = None,
                 bandwidth_share_level: Optional[str] = None,
                 device_address: Optional[str] = None,
                 key: Optional[int] = None,
                 mac_address: Optional[str] = None,
                 ovf_mapping: Optional[str] = None,
                 physical_function: Optional[str] = None,
                 use_static_mac: Optional[bool] = None):
        """
        :param str network_id: The ID of the network to connect this network interface to.
        :param str adapter_type: The controller type. Can be one of e1000, e1000e, sriov, vmxnet3, or vrdma.
        :param int bandwidth_limit: The upper bandwidth limit of this network interface, in Mbits/sec.
        :param int bandwidth_reservation: The bandwidth reservation of this network interface, in Mbits/sec.
        :param int bandwidth_share_count: The share count for this network interface when the share level is custom.
        :param str bandwidth_share_level: The bandwidth share allocation level for this interface. Can be one of low, normal, high, or custom.
        :param str device_address: The internally-computed address of this device, such as scsi:0:1, denoting scsi bus #0 and device unit 1.
        :param int key: The ID of the device within the virtual machine.
        :param str mac_address: The MAC address of this network interface. Can only be manually set if use_static_mac is true.
        :param str ovf_mapping: Mapping of network interface to OVF network.
        :param str physical_function: The ID of the Physical SR-IOV NIC to attach to, e.g. '0000:d8:00.0'
        :param bool use_static_mac: If true, the mac_address field is treated as a static MAC address and set accordingly.
        """
        pulumi.set(__self__, "network_id", network_id)
        if adapter_type is not None:
            pulumi.set(__self__, "adapter_type", adapter_type)
        if bandwidth_limit is not None:
            pulumi.set(__self__, "bandwidth_limit", bandwidth_limit)
        if bandwidth_reservation is not None:
            pulumi.set(__self__, "bandwidth_reservation", bandwidth_reservation)
        if bandwidth_share_count is not None:
            pulumi.set(__self__, "bandwidth_share_count", bandwidth_share_count)
        if bandwidth_share_level is not None:
            pulumi.set(__self__, "bandwidth_share_level", bandwidth_share_level)
        if device_address is not None:
            pulumi.set(__self__, "device_address", device_address)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if ovf_mapping is not None:
            pulumi.set(__self__, "ovf_mapping", ovf_mapping)
        if physical_function is not None:
            pulumi.set(__self__, "physical_function", physical_function)
        if use_static_mac is not None:
            pulumi.set(__self__, "use_static_mac", use_static_mac)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> str:
        """
        The ID of the network to connect this network interface to.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="adapterType")
    def adapter_type(self) -> Optional[str]:
        """
        The controller type. Can be one of e1000, e1000e, sriov, vmxnet3, or vrdma.
        """
        return pulumi.get(self, "adapter_type")

    @property
    @pulumi.getter(name="bandwidthLimit")
    def bandwidth_limit(self) -> Optional[int]:
        """
        The upper bandwidth limit of this network interface, in Mbits/sec.
        """
        return pulumi.get(self, "bandwidth_limit")

    @property
    @pulumi.getter(name="bandwidthReservation")
    def bandwidth_reservation(self) -> Optional[int]:
        """
        The bandwidth reservation of this network interface, in Mbits/sec.
        """
        return pulumi.get(self, "bandwidth_reservation")

    @property
    @pulumi.getter(name="bandwidthShareCount")
    def bandwidth_share_count(self) -> Optional[int]:
        """
        The share count for this network interface when the share level is custom.
        """
        return pulumi.get(self, "bandwidth_share_count")

    @property
    @pulumi.getter(name="bandwidthShareLevel")
    def bandwidth_share_level(self) -> Optional[str]:
        """
        The bandwidth share allocation level for this interface. Can be one of low, normal, high, or custom.
        """
        return pulumi.get(self, "bandwidth_share_level")

    @property
    @pulumi.getter(name="deviceAddress")
    def device_address(self) -> Optional[str]:
        """
        The internally-computed address of this device, such as scsi:0:1, denoting scsi bus #0 and device unit 1.
        """
        return pulumi.get(self, "device_address")

    @property
    @pulumi.getter
    def key(self) -> Optional[int]:
        """
        The ID of the device within the virtual machine.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[str]:
        """
        The MAC address of this network interface. Can only be manually set if use_static_mac is true.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="ovfMapping")
    def ovf_mapping(self) -> Optional[str]:
        """
        Mapping of network interface to OVF network.
        """
        return pulumi.get(self, "ovf_mapping")

    @property
    @pulumi.getter(name="physicalFunction")
    def physical_function(self) -> Optional[str]:
        """
        The ID of the Physical SR-IOV NIC to attach to, e.g. '0000:d8:00.0'
        """
        return pulumi.get(self, "physical_function")

    @property
    @pulumi.getter(name="useStaticMac")
    def use_static_mac(self) -> Optional[bool]:
        """
        If true, the mac_address field is treated as a static MAC address and set accordingly.
        """
        return pulumi.get(self, "use_static_mac")


@pulumi.output_type
class VirtualMachineOvfDeploy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowUnverifiedSslCert":
            suggest = "allow_unverified_ssl_cert"
        elif key == "deploymentOption":
            suggest = "deployment_option"
        elif key == "diskProvisioning":
            suggest = "disk_provisioning"
        elif key == "enableHiddenProperties":
            suggest = "enable_hidden_properties"
        elif key == "ipAllocationPolicy":
            suggest = "ip_allocation_policy"
        elif key == "ipProtocol":
            suggest = "ip_protocol"
        elif key == "localOvfPath":
            suggest = "local_ovf_path"
        elif key == "ovfNetworkMap":
            suggest = "ovf_network_map"
        elif key == "remoteOvfUrl":
            suggest = "remote_ovf_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineOvfDeploy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineOvfDeploy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineOvfDeploy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_unverified_ssl_cert: Optional[bool] = None,
                 deployment_option: Optional[str] = None,
                 disk_provisioning: Optional[str] = None,
                 enable_hidden_properties: Optional[bool] = None,
                 ip_allocation_policy: Optional[str] = None,
                 ip_protocol: Optional[str] = None,
                 local_ovf_path: Optional[str] = None,
                 ovf_network_map: Optional[Mapping[str, str]] = None,
                 remote_ovf_url: Optional[str] = None):
        """
        :param bool allow_unverified_ssl_cert: Allow unverified ssl certificates while deploying ovf/ova from url.
        :param str deployment_option: The Deployment option to be chosen. If empty, the default option is used.
        :param str disk_provisioning: An optional disk provisioning. If set, all the disks in the deployed ovf will have the same specified disk type (e.g., thin provisioned).
        :param bool enable_hidden_properties: Allow properties with ovf:userConfigurable=false to be set.
        :param str ip_allocation_policy: The IP allocation policy.
        :param str ip_protocol: The IP protocol.
        :param str local_ovf_path: The absolute path to the ovf/ova file in the local system.
        :param Mapping[str, str] ovf_network_map: The mapping of name of network identifiers from the ovf descriptor to network UUID in the VI infrastructure.
        :param str remote_ovf_url: URL to the remote ovf/ova file to be deployed.
        """
        if allow_unverified_ssl_cert is not None:
            pulumi.set(__self__, "allow_unverified_ssl_cert", allow_unverified_ssl_cert)
        if deployment_option is not None:
            pulumi.set(__self__, "deployment_option", deployment_option)
        if disk_provisioning is not None:
            pulumi.set(__self__, "disk_provisioning", disk_provisioning)
        if enable_hidden_properties is not None:
            pulumi.set(__self__, "enable_hidden_properties", enable_hidden_properties)
        if ip_allocation_policy is not None:
            pulumi.set(__self__, "ip_allocation_policy", ip_allocation_policy)
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if local_ovf_path is not None:
            pulumi.set(__self__, "local_ovf_path", local_ovf_path)
        if ovf_network_map is not None:
            pulumi.set(__self__, "ovf_network_map", ovf_network_map)
        if remote_ovf_url is not None:
            pulumi.set(__self__, "remote_ovf_url", remote_ovf_url)

    @property
    @pulumi.getter(name="allowUnverifiedSslCert")
    def allow_unverified_ssl_cert(self) -> Optional[bool]:
        """
        Allow unverified ssl certificates while deploying ovf/ova from url.
        """
        return pulumi.get(self, "allow_unverified_ssl_cert")

    @property
    @pulumi.getter(name="deploymentOption")
    def deployment_option(self) -> Optional[str]:
        """
        The Deployment option to be chosen. If empty, the default option is used.
        """
        return pulumi.get(self, "deployment_option")

    @property
    @pulumi.getter(name="diskProvisioning")
    def disk_provisioning(self) -> Optional[str]:
        """
        An optional disk provisioning. If set, all the disks in the deployed ovf will have the same specified disk type (e.g., thin provisioned).
        """
        return pulumi.get(self, "disk_provisioning")

    @property
    @pulumi.getter(name="enableHiddenProperties")
    def enable_hidden_properties(self) -> Optional[bool]:
        """
        Allow properties with ovf:userConfigurable=false to be set.
        """
        return pulumi.get(self, "enable_hidden_properties")

    @property
    @pulumi.getter(name="ipAllocationPolicy")
    def ip_allocation_policy(self) -> Optional[str]:
        """
        The IP allocation policy.
        """
        return pulumi.get(self, "ip_allocation_policy")

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[str]:
        """
        The IP protocol.
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter(name="localOvfPath")
    def local_ovf_path(self) -> Optional[str]:
        """
        The absolute path to the ovf/ova file in the local system.
        """
        return pulumi.get(self, "local_ovf_path")

    @property
    @pulumi.getter(name="ovfNetworkMap")
    def ovf_network_map(self) -> Optional[Mapping[str, str]]:
        """
        The mapping of name of network identifiers from the ovf descriptor to network UUID in the VI infrastructure.
        """
        return pulumi.get(self, "ovf_network_map")

    @property
    @pulumi.getter(name="remoteOvfUrl")
    def remote_ovf_url(self) -> Optional[str]:
        """
        URL to the remote ovf/ova file to be deployed.
        """
        return pulumi.get(self, "remote_ovf_url")


@pulumi.output_type
class VirtualMachineVapp(dict):
    def __init__(__self__, *,
                 properties: Optional[Mapping[str, str]] = None):
        """
        :param Mapping[str, str] properties: A map of customizable vApp properties and their values. Allows customization of VMs cloned from OVF templates which have customizable vApp properties.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        A map of customizable vApp properties and their values. Allows customization of VMs cloned from OVF templates which have customizable vApp properties.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class VmStoragePolicyTagRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagCategory":
            suggest = "tag_category"
        elif key == "includeDatastoresWithTags":
            suggest = "include_datastores_with_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VmStoragePolicyTagRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VmStoragePolicyTagRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VmStoragePolicyTagRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tag_category: str,
                 tags: Sequence[str],
                 include_datastores_with_tags: Optional[bool] = None):
        """
        :param str tag_category: Name of the tag category.
        :param Sequence[str] tags: List of Name of tags to select from the given category.
        :param bool include_datastores_with_tags: Include datastores with the given tags or exclude. Default `true`.
        """
        pulumi.set(__self__, "tag_category", tag_category)
        pulumi.set(__self__, "tags", tags)
        if include_datastores_with_tags is not None:
            pulumi.set(__self__, "include_datastores_with_tags", include_datastores_with_tags)

    @property
    @pulumi.getter(name="tagCategory")
    def tag_category(self) -> str:
        """
        Name of the tag category.
        """
        return pulumi.get(self, "tag_category")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        List of Name of tags to select from the given category.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="includeDatastoresWithTags")
    def include_datastores_with_tags(self) -> Optional[bool]:
        """
        Include datastores with the given tags or exclude. Default `true`.
        """
        return pulumi.get(self, "include_datastores_with_tags")


@pulumi.output_type
class VnicIpv4(dict):
    def __init__(__self__, *,
                 dhcp: Optional[bool] = None,
                 gw: Optional[str] = None,
                 ip: Optional[str] = None,
                 netmask: Optional[str] = None):
        """
        :param bool dhcp: Use DHCP to configure the interface's IPv4 stack.
        :param str gw: IP address of the default gateway, if DHCP is not set.
        :param str ip: address of the interface, if DHCP is not set.
        :param str netmask: netmask of the interface, if DHCP is not set.
        """
        if dhcp is not None:
            pulumi.set(__self__, "dhcp", dhcp)
        if gw is not None:
            pulumi.set(__self__, "gw", gw)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if netmask is not None:
            pulumi.set(__self__, "netmask", netmask)

    @property
    @pulumi.getter
    def dhcp(self) -> Optional[bool]:
        """
        Use DHCP to configure the interface's IPv4 stack.
        """
        return pulumi.get(self, "dhcp")

    @property
    @pulumi.getter
    def gw(self) -> Optional[str]:
        """
        IP address of the default gateway, if DHCP is not set.
        """
        return pulumi.get(self, "gw")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        address of the interface, if DHCP is not set.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def netmask(self) -> Optional[str]:
        """
        netmask of the interface, if DHCP is not set.
        """
        return pulumi.get(self, "netmask")


@pulumi.output_type
class VnicIpv6(dict):
    def __init__(__self__, *,
                 addresses: Optional[Sequence[str]] = None,
                 autoconfig: Optional[bool] = None,
                 dhcp: Optional[bool] = None,
                 gw: Optional[str] = None):
        """
        :param Sequence[str] addresses: List of IPv6 addresses
        :param bool autoconfig: Use IPv6 Autoconfiguration (RFC2462).
        :param bool dhcp: Use DHCP to configure the interface's IPv4 stack.
        :param str gw: IP address of the default gateway, if DHCP or autoconfig is not set.
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if autoconfig is not None:
            pulumi.set(__self__, "autoconfig", autoconfig)
        if dhcp is not None:
            pulumi.set(__self__, "dhcp", dhcp)
        if gw is not None:
            pulumi.set(__self__, "gw", gw)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[Sequence[str]]:
        """
        List of IPv6 addresses
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter
    def autoconfig(self) -> Optional[bool]:
        """
        Use IPv6 Autoconfiguration (RFC2462).
        """
        return pulumi.get(self, "autoconfig")

    @property
    @pulumi.getter
    def dhcp(self) -> Optional[bool]:
        """
        Use DHCP to configure the interface's IPv4 stack.
        """
        return pulumi.get(self, "dhcp")

    @property
    @pulumi.getter
    def gw(self) -> Optional[str]:
        """
        IP address of the default gateway, if DHCP or autoconfig is not set.
        """
        return pulumi.get(self, "gw")


@pulumi.output_type
class GetGuestOsCustomizationSpecResult(dict):
    def __init__(__self__, *,
                 dns_server_lists: Sequence[str],
                 dns_suffix_lists: Sequence[str],
                 linux_options: Sequence['outputs.GetGuestOsCustomizationSpecLinuxOptionResult'],
                 network_interfaces: Sequence['outputs.GetGuestOsCustomizationSpecNetworkInterfaceResult'],
                 windows_options: Sequence['outputs.GetGuestOsCustomizationSpecWindowsOptionResult'],
                 windows_sysprep_text: str):
        """
        :param Sequence[str] dns_server_lists: A list of DNS servers for a virtual network adapter with a static IP address.
        :param Sequence[str] dns_suffix_lists: A list of DNS search domains to add to the DNS configuration on the virtual machine.
        :param Sequence['GetGuestOsCustomizationSpecLinuxOptionArgs'] linux_options: A list of configuration options specific to Linux.
        :param Sequence['GetGuestOsCustomizationSpecNetworkInterfaceArgs'] network_interfaces: A specification of network interface configuration options.
        :param Sequence['GetGuestOsCustomizationSpecWindowsOptionArgs'] windows_options: A list of configuration options specific to Windows.
        :param str windows_sysprep_text: Use this option to specify use of a Windows Sysprep file.
        """
        pulumi.set(__self__, "dns_server_lists", dns_server_lists)
        pulumi.set(__self__, "dns_suffix_lists", dns_suffix_lists)
        pulumi.set(__self__, "linux_options", linux_options)
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        pulumi.set(__self__, "windows_options", windows_options)
        pulumi.set(__self__, "windows_sysprep_text", windows_sysprep_text)

    @property
    @pulumi.getter(name="dnsServerLists")
    def dns_server_lists(self) -> Sequence[str]:
        """
        A list of DNS servers for a virtual network adapter with a static IP address.
        """
        return pulumi.get(self, "dns_server_lists")

    @property
    @pulumi.getter(name="dnsSuffixLists")
    def dns_suffix_lists(self) -> Sequence[str]:
        """
        A list of DNS search domains to add to the DNS configuration on the virtual machine.
        """
        return pulumi.get(self, "dns_suffix_lists")

    @property
    @pulumi.getter(name="linuxOptions")
    def linux_options(self) -> Sequence['outputs.GetGuestOsCustomizationSpecLinuxOptionResult']:
        """
        A list of configuration options specific to Linux.
        """
        return pulumi.get(self, "linux_options")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.GetGuestOsCustomizationSpecNetworkInterfaceResult']:
        """
        A specification of network interface configuration options.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="windowsOptions")
    def windows_options(self) -> Sequence['outputs.GetGuestOsCustomizationSpecWindowsOptionResult']:
        """
        A list of configuration options specific to Windows.
        """
        return pulumi.get(self, "windows_options")

    @property
    @pulumi.getter(name="windowsSysprepText")
    def windows_sysprep_text(self) -> str:
        """
        Use this option to specify use of a Windows Sysprep file.
        """
        return pulumi.get(self, "windows_sysprep_text")


@pulumi.output_type
class GetGuestOsCustomizationSpecLinuxOptionResult(dict):
    def __init__(__self__, *,
                 domain: str,
                 host_name: str,
                 hw_clock_utc: bool,
                 script_text: str,
                 time_zone: str):
        """
        :param str domain: The domain name for this virtual machine.
        :param str host_name: The hostname for this virtual machine.
        :param bool hw_clock_utc: Specifies whether or not the hardware clock should be in UTC or not.
        :param str script_text: The customization script to run before and or after guest customization.
        :param str time_zone: Set the time zone on the guest operating system. For a list of the acceptable values for Linux customization specifications, see [List of Time Zone Database Zones](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones) on Wikipedia.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "hw_clock_utc", hw_clock_utc)
        pulumi.set(__self__, "script_text", script_text)
        pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The domain name for this virtual machine.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        """
        The hostname for this virtual machine.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="hwClockUtc")
    def hw_clock_utc(self) -> bool:
        """
        Specifies whether or not the hardware clock should be in UTC or not.
        """
        return pulumi.get(self, "hw_clock_utc")

    @property
    @pulumi.getter(name="scriptText")
    def script_text(self) -> str:
        """
        The customization script to run before and or after guest customization.
        """
        return pulumi.get(self, "script_text")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        """
        Set the time zone on the guest operating system. For a list of the acceptable values for Linux customization specifications, see [List of Time Zone Database Zones](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones) on Wikipedia.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class GetGuestOsCustomizationSpecNetworkInterfaceResult(dict):
    def __init__(__self__, *,
                 dns_domain: str,
                 dns_server_lists: Sequence[str],
                 ipv4_address: str,
                 ipv4_netmask: int,
                 ipv6_address: str,
                 ipv6_netmask: int):
        """
        :param str dns_domain: A DNS search domain to add to the DNS configuration on the virtual machine.
        :param Sequence[str] dns_server_lists: Network-interface specific DNS settings for Windows operating systems. Ignored on Linux.
        :param str ipv4_address: The IPv4 address assigned to this network adapter. If left blank, DHCP is used.
        :param int ipv4_netmask: The IPv4 CIDR netmask for the supplied IP address. Ignored if DHCP is selected.
        :param str ipv6_address: The IPv6 address assigned to this network adapter. If left blank, default auto-configuration is used.
        :param int ipv6_netmask: The IPv6 CIDR netmask for the supplied IP address. Ignored if auto-configuration is selected.
        """
        pulumi.set(__self__, "dns_domain", dns_domain)
        pulumi.set(__self__, "dns_server_lists", dns_server_lists)
        pulumi.set(__self__, "ipv4_address", ipv4_address)
        pulumi.set(__self__, "ipv4_netmask", ipv4_netmask)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        pulumi.set(__self__, "ipv6_netmask", ipv6_netmask)

    @property
    @pulumi.getter(name="dnsDomain")
    def dns_domain(self) -> str:
        """
        A DNS search domain to add to the DNS configuration on the virtual machine.
        """
        return pulumi.get(self, "dns_domain")

    @property
    @pulumi.getter(name="dnsServerLists")
    def dns_server_lists(self) -> Sequence[str]:
        """
        Network-interface specific DNS settings for Windows operating systems. Ignored on Linux.
        """
        return pulumi.get(self, "dns_server_lists")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> str:
        """
        The IPv4 address assigned to this network adapter. If left blank, DHCP is used.
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv4Netmask")
    def ipv4_netmask(self) -> int:
        """
        The IPv4 CIDR netmask for the supplied IP address. Ignored if DHCP is selected.
        """
        return pulumi.get(self, "ipv4_netmask")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> str:
        """
        The IPv6 address assigned to this network adapter. If left blank, default auto-configuration is used.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="ipv6Netmask")
    def ipv6_netmask(self) -> int:
        """
        The IPv6 CIDR netmask for the supplied IP address. Ignored if auto-configuration is selected.
        """
        return pulumi.get(self, "ipv6_netmask")


@pulumi.output_type
class GetGuestOsCustomizationSpecWindowsOptionResult(dict):
    def __init__(__self__, *,
                 admin_password: str,
                 auto_logon: bool,
                 auto_logon_count: int,
                 computer_name: str,
                 domain_admin_user: str,
                 domain_ou: str,
                 join_domain: str,
                 run_once_command_lists: Sequence[str],
                 time_zone: int,
                 workgroup: str,
                 domain_admin_password: Optional[str] = None):
        """
        :param str admin_password: The new administrator password for this virtual machine.
        :param bool auto_logon: Specifies whether or not the guest operating system automatically logs on as Administrator.
        :param int auto_logon_count: Specifies how many times the guest operating system should auto-logon the Administrator account when `auto_logon` is `true`.
        :param str computer_name: The hostname for this virtual machine.
        :param str domain_admin_user: The user account of the domain administrator used to join this virtual machine to the domain.
        :param str domain_ou: The MachineObjectOU which specifies the full LDAP path name of the OU to which the virtual machine belongs.
        :param str join_domain: The Active Directory domain for the virtual machine to join.
        :param Sequence[str] run_once_command_lists: A list of commands to run at first user logon, after guest customization.
        :param int time_zone: The new time zone for the virtual machine. This is a sysprep-dictated timezone code.
        :param str workgroup: The workgroup for this virtual machine if not joining an Active Directory domain.
        :param str domain_admin_password: The user account used to join this virtual machine to the Active Directory domain.
        """
        pulumi.set(__self__, "admin_password", admin_password)
        pulumi.set(__self__, "auto_logon", auto_logon)
        pulumi.set(__self__, "auto_logon_count", auto_logon_count)
        pulumi.set(__self__, "computer_name", computer_name)
        pulumi.set(__self__, "domain_admin_user", domain_admin_user)
        pulumi.set(__self__, "domain_ou", domain_ou)
        pulumi.set(__self__, "join_domain", join_domain)
        pulumi.set(__self__, "run_once_command_lists", run_once_command_lists)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "workgroup", workgroup)
        if domain_admin_password is not None:
            pulumi.set(__self__, "domain_admin_password", domain_admin_password)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> str:
        """
        The new administrator password for this virtual machine.
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="autoLogon")
    def auto_logon(self) -> bool:
        """
        Specifies whether or not the guest operating system automatically logs on as Administrator.
        """
        return pulumi.get(self, "auto_logon")

    @property
    @pulumi.getter(name="autoLogonCount")
    def auto_logon_count(self) -> int:
        """
        Specifies how many times the guest operating system should auto-logon the Administrator account when `auto_logon` is `true`.
        """
        return pulumi.get(self, "auto_logon_count")

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> str:
        """
        The hostname for this virtual machine.
        """
        return pulumi.get(self, "computer_name")

    @property
    @pulumi.getter(name="domainAdminUser")
    def domain_admin_user(self) -> str:
        """
        The user account of the domain administrator used to join this virtual machine to the domain.
        """
        return pulumi.get(self, "domain_admin_user")

    @property
    @pulumi.getter(name="domainOu")
    def domain_ou(self) -> str:
        """
        The MachineObjectOU which specifies the full LDAP path name of the OU to which the virtual machine belongs.
        """
        return pulumi.get(self, "domain_ou")

    @property
    @pulumi.getter(name="joinDomain")
    def join_domain(self) -> str:
        """
        The Active Directory domain for the virtual machine to join.
        """
        return pulumi.get(self, "join_domain")

    @property
    @pulumi.getter(name="runOnceCommandLists")
    def run_once_command_lists(self) -> Sequence[str]:
        """
        A list of commands to run at first user logon, after guest customization.
        """
        return pulumi.get(self, "run_once_command_lists")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> int:
        """
        The new time zone for the virtual machine. This is a sysprep-dictated timezone code.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def workgroup(self) -> str:
        """
        The workgroup for this virtual machine if not joining an Active Directory domain.
        """
        return pulumi.get(self, "workgroup")

    @property
    @pulumi.getter(name="domainAdminPassword")
    def domain_admin_password(self) -> Optional[str]:
        """
        The user account used to join this virtual machine to the Active Directory domain.
        """
        return pulumi.get(self, "domain_admin_password")


@pulumi.output_type
class GetHostVgpuProfileVgpuProfileResult(dict):
    def __init__(__self__, *,
                 disk_snapshot_supported: bool,
                 memory_snapshot_supported: bool,
                 migrate_supported: bool,
                 suspend_supported: bool,
                 vgpu: str):
        """
        :param bool disk_snapshot_supported: Indicates whether the GPU plugin on this host is
               capable of disk-only snapshots when VM is not powered off.
        :param bool memory_snapshot_supported: Indicates whether the GPU plugin on this host is
               capable of memory snapshots.
        :param bool migrate_supported: Indicates whether the GPU plugin on this host is capable
               of migration.
        :param bool suspend_supported: Indicates whether the GPU plugin on this host is capable
               of suspend-resume.
        :param str vgpu: Name of a particular vGPU available as a shared GPU device (vGPU profile).
        """
        pulumi.set(__self__, "disk_snapshot_supported", disk_snapshot_supported)
        pulumi.set(__self__, "memory_snapshot_supported", memory_snapshot_supported)
        pulumi.set(__self__, "migrate_supported", migrate_supported)
        pulumi.set(__self__, "suspend_supported", suspend_supported)
        pulumi.set(__self__, "vgpu", vgpu)

    @property
    @pulumi.getter(name="diskSnapshotSupported")
    def disk_snapshot_supported(self) -> bool:
        """
        Indicates whether the GPU plugin on this host is
        capable of disk-only snapshots when VM is not powered off.
        """
        return pulumi.get(self, "disk_snapshot_supported")

    @property
    @pulumi.getter(name="memorySnapshotSupported")
    def memory_snapshot_supported(self) -> bool:
        """
        Indicates whether the GPU plugin on this host is
        capable of memory snapshots.
        """
        return pulumi.get(self, "memory_snapshot_supported")

    @property
    @pulumi.getter(name="migrateSupported")
    def migrate_supported(self) -> bool:
        """
        Indicates whether the GPU plugin on this host is capable
        of migration.
        """
        return pulumi.get(self, "migrate_supported")

    @property
    @pulumi.getter(name="suspendSupported")
    def suspend_supported(self) -> bool:
        """
        Indicates whether the GPU plugin on this host is capable
        of suspend-resume.
        """
        return pulumi.get(self, "suspend_supported")

    @property
    @pulumi.getter
    def vgpu(self) -> str:
        """
        Name of a particular vGPU available as a shared GPU device (vGPU profile).
        """
        return pulumi.get(self, "vgpu")


@pulumi.output_type
class GetVirtualMachineDiskResult(dict):
    def __init__(__self__, *,
                 eagerly_scrub: bool,
                 label: str,
                 size: int,
                 thin_provisioned: bool,
                 unit_number: int):
        """
        :param bool eagerly_scrub: Set to `true` if the disk has been eager zeroed.
        :param str label: The label for the disk.
        :param int size: The size of the disk, in GIB.
        :param bool thin_provisioned: Set to `true` if the disk has been thin provisioned.
        :param int unit_number: The disk number on the storage bus.
        """
        pulumi.set(__self__, "eagerly_scrub", eagerly_scrub)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "thin_provisioned", thin_provisioned)
        pulumi.set(__self__, "unit_number", unit_number)

    @property
    @pulumi.getter(name="eagerlyScrub")
    def eagerly_scrub(self) -> bool:
        """
        Set to `true` if the disk has been eager zeroed.
        """
        return pulumi.get(self, "eagerly_scrub")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        The label for the disk.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the disk, in GIB.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="thinProvisioned")
    def thin_provisioned(self) -> bool:
        """
        Set to `true` if the disk has been thin provisioned.
        """
        return pulumi.get(self, "thin_provisioned")

    @property
    @pulumi.getter(name="unitNumber")
    def unit_number(self) -> int:
        """
        The disk number on the storage bus.
        """
        return pulumi.get(self, "unit_number")


@pulumi.output_type
class GetVirtualMachineNetworkInterfaceResult(dict):
    def __init__(__self__, *,
                 adapter_type: str,
                 bandwidth_share_count: int,
                 mac_address: str,
                 network_id: str,
                 physical_function: str,
                 bandwidth_limit: Optional[int] = None,
                 bandwidth_reservation: Optional[int] = None,
                 bandwidth_share_level: Optional[str] = None):
        """
        :param str adapter_type: The network interface types for each network interface found 
               on the virtual machine, in device bus order. Will be one of `e1000`, `e1000e`,
               `vmxnet3vrdma`, or `vmxnet3`.
        :param int bandwidth_share_count: The share count for this network interface when the
               share level is custom.
        :param str mac_address: The MAC address of this network interface.
        :param str network_id: The managed object reference ID of the network this interface is
               connected to.
        :param str physical_function: The ID of the Physical SR-IOV NIC to attach to, e.g. '0000:d8:00.0'
        :param int bandwidth_limit: The upper bandwidth limit of this network interface, 
               in Mbits/sec.
        :param int bandwidth_reservation: The bandwidth reservation of this network interface,
               in Mbits/sec.
        :param str bandwidth_share_level: The bandwidth share allocation level for this interface.
               Can be one of `low`, `normal`, `high`, or `custom`.
        """
        pulumi.set(__self__, "adapter_type", adapter_type)
        pulumi.set(__self__, "bandwidth_share_count", bandwidth_share_count)
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "physical_function", physical_function)
        if bandwidth_limit is not None:
            pulumi.set(__self__, "bandwidth_limit", bandwidth_limit)
        if bandwidth_reservation is not None:
            pulumi.set(__self__, "bandwidth_reservation", bandwidth_reservation)
        if bandwidth_share_level is not None:
            pulumi.set(__self__, "bandwidth_share_level", bandwidth_share_level)

    @property
    @pulumi.getter(name="adapterType")
    def adapter_type(self) -> str:
        """
        The network interface types for each network interface found 
        on the virtual machine, in device bus order. Will be one of `e1000`, `e1000e`,
        `vmxnet3vrdma`, or `vmxnet3`.
        """
        return pulumi.get(self, "adapter_type")

    @property
    @pulumi.getter(name="bandwidthShareCount")
    def bandwidth_share_count(self) -> int:
        """
        The share count for this network interface when the
        share level is custom.
        """
        return pulumi.get(self, "bandwidth_share_count")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> str:
        """
        The MAC address of this network interface.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> str:
        """
        The managed object reference ID of the network this interface is
        connected to.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="physicalFunction")
    def physical_function(self) -> str:
        """
        The ID of the Physical SR-IOV NIC to attach to, e.g. '0000:d8:00.0'
        """
        return pulumi.get(self, "physical_function")

    @property
    @pulumi.getter(name="bandwidthLimit")
    def bandwidth_limit(self) -> Optional[int]:
        """
        The upper bandwidth limit of this network interface, 
        in Mbits/sec.
        """
        return pulumi.get(self, "bandwidth_limit")

    @property
    @pulumi.getter(name="bandwidthReservation")
    def bandwidth_reservation(self) -> Optional[int]:
        """
        The bandwidth reservation of this network interface,
        in Mbits/sec.
        """
        return pulumi.get(self, "bandwidth_reservation")

    @property
    @pulumi.getter(name="bandwidthShareLevel")
    def bandwidth_share_level(self) -> Optional[str]:
        """
        The bandwidth share allocation level for this interface.
        Can be one of `low`, `normal`, `high`, or `custom`.
        """
        return pulumi.get(self, "bandwidth_share_level")


@pulumi.output_type
class GetVirtualMachineVappResult(dict):
    def __init__(__self__, *,
                 properties: Optional[Mapping[str, str]] = None):
        """
        :param Mapping[str, str] properties: A map of customizable vApp properties and their values. Allows customization of VMs cloned from OVF templates which have customizable vApp properties.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        A map of customizable vApp properties and their values. Allows customization of VMs cloned from OVF templates which have customizable vApp properties.
        """
        return pulumi.get(self, "properties")


