import pytest


class TestConfig:
    def test_cleanup_task(self, load_config):
        conf = load_config("config", "config")

        try:
            from airflow_config import DAG
        except ImportError:
            return pytest.skip("Airflow DAG not available in this environment")

        d = DAG(dag_id="test_cleanup", config=conf)
        assert len(d.tasks) == 1

    def test_cleanup_render(self, load_config):
        conf = load_config("config", "config")
        assert (
            conf.dags["test_cleanup"].render()
            == """# Generated by airflow-config
from datetime import datetime

from airflow.models import DAG
from airflow.models.param import Param

from airflow_pydantic.extras.common.clean import create_cleanup_dag_runs_operator

with DAG(
    schedule="0 0 * * *",
    start_date=datetime.fromisoformat("2025-01-01T00:00:00-04:56"),
    max_active_tasks=1,
    max_active_runs=1,
    catchup=False,
    params={
        "delete_successful": Param(True, title="Delete Successful", description=None, type="boolean"),
        "delete_failed": Param(True, title="Delete Failed", description=None, type="boolean"),
        "mark_failed_as_successful": Param(False, title="Mark Failed As Successful", description=None, type="boolean"),
        "max_dagruns": Param(10, title="Max Dagruns", description=None, type="integer"),
        "days_to_keep": Param(10, title="Days To Keep", description=None, type="integer"),
    },
    dag_id="test_cleanup",
    default_args={},
) as dag:
    cleanup_task = create_cleanup_dag_runs_operator(task_id="cleanup_task", dag=dag)
"""
        )
