# type: ignore
"""Remove Column class entirely

Revision ID: 8fd96526b04f
Revises: 86fd6ecaae8a
Create Date: 2025-04-29 13:23:48.513452

"""

import sqlalchemy as sa
from alembic import op

# Revision identifiers, used by Alembic.
revision = "8fd96526b04f"
down_revision = "86fd6ecaae8a"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "optimization_equationindexsetassociation",
        sa.Column("equation__id", sa.Integer(), nullable=False),
        sa.Column("indexset__id", sa.Integer(), nullable=False),
        sa.Column("column_name", sa.String(length=255), nullable=True),
        sa.Column(
            "id",
            sa.Integer(),
            sa.Identity(always=False, on_null=True, start=1, increment=1),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["equation__id"],
            ["optimization_equation.id"],
            name=op.f("fk_optimization_equationindexsetassociation_equation__i_be8b"),
        ),
        sa.ForeignKeyConstraint(
            ["indexset__id"],
            ["optimization_indexset.id"],
            name=op.f("fk_optimization_equationindexsetassociation_indexset__i_82d0"),
        ),
        sa.PrimaryKeyConstraint(
            "id", name=op.f("pk_optimization_equationindexsetassociation")
        ),
    )
    with op.batch_alter_table(
        "optimization_equationindexsetassociation", schema=None
    ) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_optimization_equationindexsetassociation_equation__id"),
            ["equation__id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_optimization_equationindexsetassociation_indexset__id"),
            ["indexset__id"],
            unique=False,
        )

    op.create_table(
        "optimization_tableindexsetassociation",
        sa.Column("table__id", sa.Integer(), nullable=False),
        sa.Column("indexset__id", sa.Integer(), nullable=False),
        sa.Column("column_name", sa.String(length=255), nullable=True),
        sa.Column(
            "id",
            sa.Integer(),
            sa.Identity(always=False, on_null=True, start=1, increment=1),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["indexset__id"],
            ["optimization_indexset.id"],
            name=op.f("fk_optimization_tableindexsetassociation_indexset__id_o_868a"),
        ),
        sa.ForeignKeyConstraint(
            ["table__id"],
            ["optimization_table.id"],
            name=op.f("fk_optimization_tableindexsetassociation_table__id_opti_5cfe"),
        ),
        sa.PrimaryKeyConstraint(
            "id", name=op.f("pk_optimization_tableindexsetassociation")
        ),
    )
    with op.batch_alter_table(
        "optimization_tableindexsetassociation", schema=None
    ) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_optimization_tableindexsetassociation_indexset__id"),
            ["indexset__id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_optimization_tableindexsetassociation_table__id"),
            ["table__id"],
            unique=False,
        )

    op.create_table(
        "optimization_variableindexsetassociation",
        sa.Column("variable__id", sa.Integer(), nullable=False),
        sa.Column("indexset__id", sa.Integer(), nullable=False),
        sa.Column("column_name", sa.String(length=255), nullable=True),
        sa.Column(
            "id",
            sa.Integer(),
            sa.Identity(always=False, on_null=True, start=1, increment=1),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["indexset__id"],
            ["optimization_indexset.id"],
            name=op.f("fk_optimization_variableindexsetassociation_indexset__i_044c"),
        ),
        sa.ForeignKeyConstraint(
            ["variable__id"],
            ["optimization_optimizationvariable.id"],
            name=op.f("fk_optimization_variableindexsetassociation_variable__i_02a8"),
        ),
        sa.PrimaryKeyConstraint(
            "id", name=op.f("pk_optimization_variableindexsetassociation")
        ),
    )
    with op.batch_alter_table(
        "optimization_variableindexsetassociation", schema=None
    ) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_optimization_variableindexsetassociation_indexset__id"),
            ["indexset__id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_optimization_variableindexsetassociation_variable__id"),
            ["variable__id"],
            unique=False,
        )

    op.drop_table("optimization_column_docs")
    with op.batch_alter_table("optimization_column", schema=None) as batch_op:
        batch_op.drop_index("ix_optimization_column_constrained_to_indexset")

    op.drop_table("optimization_column")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "optimization_column",
        sa.Column("name", sa.VARCHAR(length=255), nullable=False),
        sa.Column("dtype", sa.VARCHAR(length=255), nullable=False),
        sa.Column("table__id", sa.INTEGER(), nullable=True),
        sa.Column("constrained_to_indexset", sa.INTEGER(), nullable=False),
        sa.Column("unique", sa.BOOLEAN(), nullable=False),
        sa.Column("id", sa.INTEGER(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("created_by", sa.VARCHAR(length=255), nullable=True),
        sa.Column("equation__id", sa.INTEGER(), nullable=True),
        sa.Column("parameter__id", sa.INTEGER(), nullable=True),
        sa.Column("variable__id", sa.INTEGER(), nullable=True),
        sa.ForeignKeyConstraint(
            ["constrained_to_indexset"],
            ["optimization_indexset.id"],
            name="fk_optimization_column_constrained_to_indexset_optimiza_8432",
        ),
        sa.ForeignKeyConstraint(
            ["equation__id"],
            ["optimization_equation.id"],
            name="fk_optimization_column_equation__id_optimization_equation",
        ),
        sa.ForeignKeyConstraint(
            ["parameter__id"],
            ["optimization_parameter.id"],
            name="fk_optimization_column_parameter__id_optimization_parameter",
        ),
        sa.ForeignKeyConstraint(
            ["table__id"],
            ["optimization_table.id"],
            name="fk_optimization_column_table__id_optimization_table",
        ),
        sa.ForeignKeyConstraint(
            ["variable__id"],
            ["optimization_optimizationvariable.id"],
            name="fk_optimization_column_variable__id_optimization_optimi_2f05",
        ),
        sa.PrimaryKeyConstraint("id", name="pk_optimization_column"),
        sa.UniqueConstraint(
            "name", "table__id", name="uq_optimization_column_name_table__id"
        ),
    )
    with op.batch_alter_table("optimization_column", schema=None) as batch_op:
        batch_op.create_index(
            "ix_optimization_column_constrained_to_indexset",
            ["constrained_to_indexset"],
            unique=False,
        )

    op.create_table(
        "optimization_column_docs",
        sa.Column("description", sa.TEXT(), nullable=False),
        sa.Column("dimension__id", sa.INTEGER(), nullable=True),
        sa.Column("id", sa.INTEGER(), nullable=False),
        sa.ForeignKeyConstraint(
            ["dimension__id"],
            ["optimization_column.id"],
            name="fk_optimization_column_docs_dimension__id_optimization_column",
        ),
        sa.PrimaryKeyConstraint("id", name="pk_optimization_column_docs"),
        sa.UniqueConstraint(
            "dimension__id", name="uq_optimization_column_docs_dimension__id"
        ),
    )
    with op.batch_alter_table(
        "optimization_variableindexsetassociation", schema=None
    ) as batch_op:
        batch_op.drop_index(
            batch_op.f("ix_optimization_variableindexsetassociation_variable__id")
        )
        batch_op.drop_index(
            batch_op.f("ix_optimization_variableindexsetassociation_indexset__id")
        )

    op.drop_table("optimization_variableindexsetassociation")
    with op.batch_alter_table(
        "optimization_tableindexsetassociation", schema=None
    ) as batch_op:
        batch_op.drop_index(
            batch_op.f("ix_optimization_tableindexsetassociation_table__id")
        )
        batch_op.drop_index(
            batch_op.f("ix_optimization_tableindexsetassociation_indexset__id")
        )

    op.drop_table("optimization_tableindexsetassociation")
    with op.batch_alter_table(
        "optimization_equationindexsetassociation", schema=None
    ) as batch_op:
        batch_op.drop_index(
            batch_op.f("ix_optimization_equationindexsetassociation_indexset__id")
        )
        batch_op.drop_index(
            batch_op.f("ix_optimization_equationindexsetassociation_equation__id")
        )

    op.drop_table("optimization_equationindexsetassociation")
    # ### end Alembic commands ###
