# type: ignore
"""Create optimization_scalar table

Revision ID: 97ba231770e2
Revises: da1fba23f206
Create Date: 2023-11-14 15:59:19.314252

"""

import sqlalchemy as sa
from alembic import op

# Revision identifiers, used by Alembic.
revision = "97ba231770e2"
down_revision = "da1fba23f206"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "optimization_scalar",
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.Column("value", sa.Float(), nullable=True),
        sa.Column("unit__id", sa.Integer(), nullable=True),
        sa.Column("run__id", sa.Integer(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("created_by", sa.String(length=255), nullable=True),
        sa.Column(
            "id",
            sa.Integer(),
            sa.Identity(always=False, on_null=True, start=1, increment=1),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["run__id"],
            ["run.id"],
            name=op.f("fk_optimization_scalar_run__id_run"),
        ),
        sa.ForeignKeyConstraint(
            ["unit__id"],
            ["unit.id"],
            name=op.f("fk_optimization_scalar_unit__id_unit"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_optimization_scalar")),
        sa.UniqueConstraint(
            "name", "run__id", name=op.f("uq_optimization_scalar_name_run__id")
        ),
    )
    with op.batch_alter_table("optimization_scalar", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_optimization_scalar_run__id"),
            ["run__id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_optimization_scalar_unit__id"),
            ["unit__id"],
            unique=False,
        )

    op.create_table(
        "optimization_scalar_docs",
        sa.Column("description", sa.Text(), nullable=False),
        sa.Column("dimension__id", sa.Integer(), nullable=True),
        sa.Column(
            "id",
            sa.Integer(),
            sa.Identity(always=False, on_null=True, start=1, increment=1),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["dimension__id"],
            ["optimization_scalar.id"],
            name=op.f("fk_optimization_scalar_docs_dimension__id_optimization_scalar"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_optimization_scalar_docs")),
        sa.UniqueConstraint(
            "dimension__id",
            name=op.f("uq_optimization_scalar_docs_dimension__id"),
        ),
    )
    with op.batch_alter_table("optimization_indexset", schema=None) as batch_op:
        batch_op.drop_constraint("uq_optimization_indexset_name", type_="unique")
        batch_op.create_unique_constraint(
            batch_op.f("uq_optimization_indexset_name_run__id"),
            ["name", "run__id"],
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("optimization_indexset", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("uq_optimization_indexset_name_run__id"), type_="unique"
        )
        batch_op.create_unique_constraint("uq_optimization_indexset_name", ["name"])

    op.drop_table("optimization_scalar_docs")
    with op.batch_alter_table("optimization_scalar", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_optimization_scalar_unit__id"))
        batch_op.drop_index(batch_op.f("ix_optimization_scalar_run__id"))

    op.drop_table("optimization_scalar")
    # ### end Alembic commands ###
