# type: ignore
"""add audit info

Revision ID: c29289ced488
Revises: 081bbda6bb7b
Create Date: 2024-07-31 11:13:39.889253

"""

import sqlalchemy as sa
from alembic import op

from ixmp4.db.migrations import utils

# Revision identifiers, used by Alembic.
revision = "c29289ced488"
down_revision = "081bbda6bb7b"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("optimization_column", schema=None) as batch_op:
        batch_op.add_column(sa.Column("created_at", sa.DateTime(), nullable=True))
        batch_op.add_column(
            sa.Column("created_by", sa.String(length=255), nullable=True)
        )

    with utils.pause_foreign_key_checks():
        with op.batch_alter_table("region", schema=None) as batch_op:
            batch_op.alter_column(
                "name",
                existing_type=sa.VARCHAR(length=1023),
                type_=sa.String(length=255),
                existing_nullable=False,
            )

    with op.batch_alter_table("run", schema=None) as batch_op:
        batch_op.add_column(sa.Column("updated_at", sa.DateTime(), nullable=True))
        batch_op.add_column(
            sa.Column("updated_by", sa.String(length=255), nullable=True)
        )
        batch_op.add_column(sa.Column("created_at", sa.DateTime(), nullable=True))
        batch_op.add_column(
            sa.Column("created_by", sa.String(length=255), nullable=True)
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("run", schema=None) as batch_op:
        batch_op.drop_column("created_by")
        batch_op.drop_column("created_at")
        batch_op.drop_column("updated_by")
        batch_op.drop_column("updated_at")

    with utils.pause_foreign_key_checks():
        with op.batch_alter_table("region", schema=None) as batch_op:
            batch_op.alter_column(
                "name",
                existing_type=sa.String(length=255),
                type_=sa.VARCHAR(length=1023),
                existing_nullable=False,
            )

    with op.batch_alter_table("optimization_column", schema=None) as batch_op:
        batch_op.drop_column("created_by")
        batch_op.drop_column("created_at")

    # ### end Alembic commands ###
