100 DIM TOD(5),DOY(5)
120 PRINT "BASIC CLOCK SUBROUTINE DEMONSTRATION PROGRAM"
130 GOSUB 10000
140 PRINT "The time is ";TIME$;" on ";WDAY$;" ";DATE1$
150 PRINT "The time is ";TIME$;" on ";WDAY$;" ";DATE2$
160 PRINT
170 END
10000 '******************************************************************
10010 '*								*
10020 '*	SYSTEM SUPPORT 1 BOARD CLOCK SUBROUTINES		*
10030 '*	BY BILL BOLTON, Software Tools, Australia		*
10040 '*	VERSION 1.0	JAN 17,1982	INITIAL RELEASE		*
10050 '*								*
10060 '*		VARIABLES USED IN THESE ROUTINES		*
10070 '*		IN APPROXIMATE ORDER OF APPEARANCE		*
10080 '*								*
10090 '*TOD		STORAGE ARRAY FOR TIME OF DAY (TOD) DIGITS	*
10100 '*DOY		STORAGE ARRAY FOR DAY OF YEAR (DOY) DIGITS	*
10110 '*BASEPORT	SYSTEM SUPPORT 1 BOARD BASE PORT ADDRESS	*
10120 '*CMDPORT		SS1 CLOCK COMMAND PORT ADDRESS			*
10130 '*DATAPORT	SS1 CLOCK DATA PORT ADDRESS			*
10140 '*HOURS10		TENS OF HOURS DIGIT				*
10150 '*HOURS1		UNIT HOURS DIGIT				*
10160 '*MINUTES10	TENS OF MINUTES DIGIT				*
10170 '*MINUTES1	UNIT MINUTES DIGIT				*
10180 '*SECONDS10	TENS OF SECONDS DIGIT				*
10190 '*SECONDS1	UNIT SECONDS DIGIT				*
10200 '*TIME$		TIME OF DAY STRING IN HH:MM:SS FORMAT		*
10210 '*WEEKDAY		DAY OF WEEK DIGIT				*
10220 '*WDAY$		DAY OF WEEK NAME STRING				*
10230 '*YEAR		YEAR INTEGER					*
10240 '*MONTH10		TENS OF MONTHS DIGIT				*
10250 '*MONTH1		UNIT MONTHS DIGIT				*
10260 '*DAY10		TENS OF DAYS DIGIT				*
10270 '*DAY1		UNIT DAYS DIGIT					*
10280 '*DATE1$		DATE STRING IN DD/MM/YY FORMAT			*
10290 '*MONTH		MONTH INTEGER					*
10300 '*DATE2$		DATE STRING IN MONTH DD,19YY FORMAT		*
10310 '*TDAY$		TEMPORARY DAY STRING				*
10320 '*								*
10330 '*		###### NOTE ######				*
10340 '*								*
10350 '* THE FOLLOWING ARRAYS MUST BE DIMENSIONED IN THE MAIN BODY	*
10360 '* THE PROGRAM CALLING THESE SUBROUTINES				*
10370 '*								*
10380 '* DIM TOD(5)							*
10390 '* DIM DOY(5)							*
10400 '*								*
10410 '******************************************************************
10420 BASEPORT = &H50
10430 CMDPORT = BASEPORT + 10
10440 DATAPORT = CMDPORT + 1
10450 '**********************************************************
10460 '*		READ THE TIME DIGITS			*
10470 '**********************************************************
10480 FOR DIGIT = 5 TO 0 STEP -1
10490	OUT CMDPORT,(&H10 + DIGIT)
10500	TOD(DIGIT) = INP(DATAPORT)
10510	IF DIGIT = 5 THEN TOD(DIGIT) = TOD(DIGIT) AND 3
10520 NEXT DIGIT
10530 HOURS10 = TOD(5)
10540 HOURS1  = TOD(4)
10550 MINUTES10 = TOD(3)
10560 MINUTES1  = TOD(2)
10570 SECONDS10 = TOD(1)
10580 SECONDS1  = TOD(0)
10590 '**********************************************************
10600 '*		FORMAT THE TIME STRING			*
10610 '**********************************************************
10620 TIME$="        "
10630 MID$(TIME$,1,1) = RIGHT$(STR$(HOURS10),1)
10640 MID$(TIME$,2,1) = RIGHT$(STR$(HOURS1),1)
10650 MID$(TIME$,3,1) = ":"
10660 MID$(TIME$,4,1) = RIGHT$(STR$(MINUTES10),1)
10670 MID$(TIME$,5,1) = RIGHT$(STR$(MINUTES1),1)
10680 MID$(TIME$,6,1) = ":"
10690 MID$(TIME$,7,1) = RIGHT$(STR$(SECONDS10),1)
10700 MID$(TIME$,8,1) = RIGHT$(STR$(SECONDS1),1)
10710 '**********************************************************
10720 '*	READ THE WEEKDAY DIGIT AND CONVERT IT TO A	*
10730 '*               DAY NAME STRING				*
10740 '**********************************************************
10750 OUT CMDPORT,(&H10 + 6)
10760 WEEKDAY = INP(DATAPORT)
10770 IF WEEKDAY = 0 THEN WDAY$ = "Sunday"
10780 IF WEEKDAY = 1 THEN WDAY$ = "Monday"
10790 IF WEEKDAY = 2 THEN WDAY$ = "Tuesday"
10800 IF WEEKDAY = 3 THEN WDAY$ = "Wednesday"
10810 IF WEEKDAY = 4 THEN WDAY$ = "Thursday"
10820 IF WEEKDAY = 5 THEN WDAY$ = "Friday"
10830 IF WEEKDAY = 6 THEN WDAY$ = "Saturday"
10840 '**********************************************************
10850 '*		READ THE DATE DIGITS			*
10860 '**********************************************************
10870 FOR DIGIT = 12 TO 7 STEP -1
10880	OUT CMDPORT,(&H10 + DIGIT)
10890	DOY(DIGIT - 7) = INP(DATAPORT)
10900 NEXT DIGIT
10910 YEAR= (DOY(5) * 10) + DOY(4)
10920 MONTH10 = DOY(3)
10930 MONTH1  = DOY(2)
10940 DAY10 = DOY(1)
10950 DAY1  = DOY(0)
10960 '**********************************************************
10970 '*		FORMAT THE FIRST DATE STRING		*
10980 '**********************************************************
10990 DATE1$="        "
11000 MID$(DATE1$,1,1) = RIGHT$(STR$(DAY10),1)
11010 MID$(DATE1$,2,1) = RIGHT$(STR$(DAY1),1)
11020 MID$(DATE1$,3,1) = "/"
11030 MID$(DATE1$,4,1) = RIGHT$(STR$(MONTH10),1)
11040 MID$(DATE1$,5,1) = RIGHT$(STR$(MONTH1),1)
11050 MID$(DATE1$,6,1) = "/"
11060 MID$(DATE1$,7,2) = RIGHT$(STR$(YEAR),2)
11070 MONTH = (MONTH10 * 10) + MONTH1
11080 '**********************************************************
11090 '*		FORMAT THE SECOND DATE STRING		*
11100 '**********************************************************
11110 IF MONTH = 1 THEN MONTH$ = "January"
11120 IF MONTH = 2 THEN MONTH$ = "February"
11130 IF MONTH = 3 THEN MONTH$ = "March"
11140 IF MONTH = 4 THEN MONTH$ = "April"
11150 IF MONTH = 5 THEN MONTH$ = "May"
11160 IF MONTH = 6 THEN MONTH$ = "June"
11170 IF MONTH = 7 THEN MONTH$ = "July"
11180 IF MONTH = 8 THEN MONTH$ = "August"
11190 IF MONTH = 9 THEN MONTH$ = "September"
11200 IF MONTH = 10 THEN MONTH$ = "October"
11210 IF MONTH = 11 THEN MONTH$ = "November"
11220 IF MONTH = 12 THEN MONTH$ = "December"
11230 DATE2$ = "                               "
11240 TDAY$ = STR$((DAY10 * 10) + DAY1)
11250 TDAY$ = RIGHT$(TDAY$,LEN(TDAY$)-1)
11260 MID$(DATE2$,1) = MONTH$
11270 MID$(DATE2$,LEN(MONTH$)+1,1) = " "
11280 MID$(DATE2$,LEN(MONTH$)+2,LEN(TDAY$)) = TDAY$
11290 MID$(DATE2$,LEN(MONTH$) + LEN(TDAY$) + 2,4) = ", 19"
11300 MID$(DATE2$,LEN(MONTH$)+8,2) = RIGHT$(DATE1$,2)
11310 '**********************************************************
11320 '*	EXAMPLES OF DISPLAYING TIME AND DATE IN		*
11330 '*		TWO DIFFERENT FORMATS			*
11340 '*							*
11350 '* PRINT "The time is ";TIME$;" on ";WDAY$;" ";DATE1$	*
11360 '* PRINT "The time is ";TIME$;" on ";WDAY$;" ";DATE2$	*
11370 '**********************************************************
11380 RETURN
