10 REM "INDUCT" consolidates "STRP-IND", "STRP-LNG",,"WIRE-IND", "WIRE-LNG",
20 REM  and "TPI" into one program, and adds several inductance calculations
30 REM  v1.0 by Bob Stein, W6NBI, 12/31/86.
40 REM  v2.0 by Bob Stein, W6NBI, 4/17/87.  Error trapping changed to to cover
50 REM  all menu selections.  New inductance calculations added.
60 REM ************************************************************************
70 PRINT CHR$(26) : CLEAR : ON ERROR GOTO 3610
80 PI=3.14159
90 PRINT "THIS PROGRAM WILL CALCULATE THE FOLLOWING FOR ROUND COPPER WIRE OR COPPER STRAP:
100 PRINT "   1 - Inductance of a single-layer coil
110 PRINT "   2 - No. of turns in a single-layer coil for a specified inductance
120 PRINT "   3 - No. of turns, from coil stock of known turns per inch or turns per cm,
130 PRINT "       for a specified inductance
140 PRINT "   4 - Inductance of a straight strap 
150 PRINT "   5 - Required length of a straight strap for a specified inductance
160 PRINT "   6 - Inductance of a transmission-line section
170 PRINT "   7 - Required length of transmission line for a specified inductance
180 PRINT "   8 - Inductance of a wire parallel to a ground plane
190 PRINT "   9 - Required length of wire above ground plane for a specified inductance
200 PRINT "  10 - Inductance of a straight wire
210 PRINT "  11 - Required length of a straight wire for a specified inductance
220 PRINT "  12 - Inductance of a multi-layer rectangular coil
230 PRINT "  13 - Inductance of a multi-layer circular coil 
240 PRINT "  14 - No. of turns in a multi-layer bobbin-wound coil for a specified
250 PRINT "       inductance
260 PRINT 
270 INPUT "ENTER YOUR CHOICE (1-14)  ",C%
280 IF C%<1 OR C%>14 THEN PRINT "Please enter a number between 1 and 14   " : GOTO 270
290 PRINT CHR$(26)
300 IF C%=11 THEN 3460 ELSE ON C% GOSUB 320,1870,440,570,690,1990,2370,1390,1610,2570,3460,860,1250,2670
310 GOTO 3620
320 REM **********************************************************************
330 PRINT TAB(26);"SINGLE-LAYER COIL INDUCTANCE
340 PRINT TAB(26);STRING$(28,"=")
350 GOSUB 3660
360 INPUT "NO. OF TURNS ";N
370 INPUT "COIL LENGTH ";LG
380 INPUT "COIL RADIUS ";R
390 IF A%=2 THEN LG=LG/25.4 : R=R/25.4
400 L=R*R*N*N/(9*R+10*LG)
410 PRINT 
420 PRINT "INDUCTANCE (uH) =";L
430 RETURN
440 REM **********************************************************************
450 PRINT TAB(8);"COIL TURNS REQUIRED USING FIXED NUMBER OF TURNS PER UNIT LENGTH
460 PRINT TAB(8);STRING$(63,"=")
470 GOSUB 3660
480 INPUT "INDUCTANCE (uH) ";L
490 IF A%=1 THEN PRINT "TURNS PER INCH "; ELSE PRINT "TURNS PER CM ";
500 INPUT T
510 INPUT "COIL RADIUS ";R
520 IF A%=2 THEN T=T*2.54 : R=R/2.54
530 N=(5*L+SQR(25*L*L+9*L*T*T*R^3))/(T*R*R)
540 PRINT
550 PRINT USING "NO. OF TURNS = ###.#";N
560 RETURN
570 REM **********************************************************************
580 PRINT TAB(27);"STRAIGHT STRAP INDUCTANCE
590 PRINT TAB(27);STRING$(25,"=")
600 GOSUB 3660
610 INPUT "STRAP LENGTH ";LG
620 INPUT "STRAP WIDTH ";B
630 INPUT "STRAP THICKNESS ";C
640 IF A%=2 THEN LG=LG/25.4  : B=B/25.4 : C=C/25.4
650 L=.0051*LG*(LOG(2*LG/(B+C))+(.224*(B+C)/LG)+.5)*1000
660 PRINT 
670 PRINT "INDUCTANCE (nH) =";L
680 RETURN
690 REM **********************************************************************
700 PRINT TAB(27);"STRAIGHT STRAP LENGTH
710 PRINT TAB(27);STRING$(21,"=")
720 GOSUB 3660
730 INPUT "INDUCTANCE (nH) ";L
740 INPUT "STRAP WIDTH ";B
750 INPUT "STRAP THICKNESS ";C
760 IF A%=2 THEN B=B/25.4 : C=C/25.4
770 X=1
780 LG=(.196*L)/(LOG((2*X)/(B+C))+(.224*(B+C)/X)+.5)
790 IF LG<.999*X OR LG>1.001*X THEN X=LG ELSE 810
800 GOTO 780
810 PRINT
820 IF A%=2 THEN LG=LG*25.4
830 PRINT "STRAP LENGTH =";LG;
840 IF A%=1 THEN PRINT "IN." ELSE PRINT "mm"
850 RETURN
860 REM **********************************************************************
870 PRINT TAB(20);"MULTI-LAYER RECTANGULAR COIL INDUCTANCE
880 PRINT TAB(20);STRING$(39,"=")
890 PRINT 
900 PRINT TAB(27);"!----------LG----------!
910 PRINT TAB(25);"->! T !<-                !
920 PRINT TAB(25);"- ";STRING$(24,"-");"\"
930 PRINT TAB(25);"! |                      | \
940 PRINT TAB(25);"! |   ----------------   |  |
950 PRINT TAB(25);"! |   |              |   |  |
960 PRINT TAB(25);"W |   |              |   |  |
970 PRINT TAB(25);"! |   |              |   |  |
980 PRINT TAB(25);"! |   ----------------   |  |
990 PRINT TAB(25);"! |                      |  |
1000 PRINT TAB(25);"- ";STRING$(24,"-");"\ |
1010 PRINT TAB(25);"   \ H                      \ 
1020 PRINT TAB(29);STRING$(25,"-")
1030 GOSUB 3660
1040 INPUT "OVERALL LENGTH (LG) ";LG
1050 INPUT "OVERALL WIDTH (W)   ";W
1060 INPUT "OVERALL HEIGHT (H)  ";H
1070 INPUT "COIL THICKNESS (T)  ";T
1080 PRINT "DO YOU WANT TO ENTER: 
1090 PRINT "   1 - TOTAL NO. OF TURNS
1100 PRINT "   2 - NO. OF TURNS/LAYER AND NO. OF LAYERS
1110 INPUT "     ENTER YOUR CHOICE ",Y%
1120 IF Y%<1 OR Y%>2 THEN PRINT "Please enter 1 or 2" : GOTO 1110
1130 IF Y%=2 THEN INPUT "NO. OF TURNS PER LAYER ";N ELSE 1170
1140 INPUT "NO. OF LAYERS IN COIL ";M
1150 N=N*M
1160 GOTO 1200
1170 INPUT "TOTAL NO. OF TURNS ";N
1180 IF A%=2 THEN LG=LG/25.4 : W=W/25.4 : H=H/25.4 : T=T/25.4
1190 REM  Formula from EDN; Aug 4, 1982; p164 (RSS Document #M905)
1200 C=LG+W-2*T
1210 L=.07*C*C*N*N/(1.908*C+9*H+10*T)
1220 PRINT 
1230 PRINT USING "INDUCTANCE (uH) = ####.#";L; : PRINT " (+/- 10%)
1240 RETURN
1250 REM **********************************************************************
1260 PRINT TAB(22);"MULTI-LAYER CIRCULAR COIL INDUCTANCE
1270 PRINT TAB(22);STRING$(36,"=")
1280 GOSUB 3660
1290 INPUT "INSIDE DIAMETER OF COIL ";ID
1300 INPUT "OUTSIDE DIAMETER OF COIL ";OD
1310 INPUT "HEIGHT OF COIL ";W
1320 INPUT "NO. OF TURNS ";N
1330 IF A%=2 THEN W=W/25.4 : ID=ID/25.4 : OD=OD/25.4
1340 R=(OD+ID)/4
1350 L=.8*R*R*N*N/(6*R+9*W+5*(OD-ID))
1360 PRINT 
1370 PRINT USING "INDUCTANCE (uH) = ####.#";L
1380 RETURN
1390 REM **********************************************************************
1400 PRINT TAB(25);"WIRE PARALLEL TO GROUND PLANE
1410 PRINT TAB(25);STRING$(29,"=")
1420 PRINT 
1430 PRINT TAB(28);"|---------LG---------|
1440 PRINT TAB(28);STRING$(22,"*");" -"
1450 PRINT TAB(49);"* |
1460 PRINT TAB(49);"* H
1470 PRINT TAB(49);"* |
1480 PRINT TAB(26);STRING$(23,"-");"*--
1490 PRINT TAB(26);STRING$(26,"/")
1500 GOSUB 3660 : GOSUB 3740
1510 INPUT "LENGTH (LG) ";LG
1520 INPUT "HEIGHT (H) ABOVE GROUND PLANE ";W
1530 IF A%=2 THEN R=D/2 ELSE LG=25.4*LG : R=12.7*D : W=25.4*W
1540 REM Equation from 1986 ARRL Handbook
1550 K1=SQR(LG*LG+R*R)
1560 K2=SQR(LG*LG+4*W*W)
1570 L=.2*LG*LOG((2*W/R)*((LG+K1)/(LG+K2)))+.2*(K2-K1+(LG/4)-(2*W)+R)
1580 PRINT 
1590 PRINT "INDUCTANCE (nH) =";L;"(INCLUDING DIMENSION 'H')
1600 RETURN
1610 REM **********************************************************************
1620 PRINT TAB(22);"WIRE LENGTH PARALLEL TO GROUND PLANE
1630 PRINT TAB(22);STRING$(36,"=")
1640 PRINT 
1650 PRINT TAB(28);"|---------LG---------|
1660 PRINT TAB(28);STRING$(22,"*");" -"
1670 PRINT TAB(49);"* |
1680 PRINT TAB(49);"* H
1690 PRINT TAB(49);"* |
1700 PRINT TAB(26);STRING$(23,"-");"*--
1710 PRINT TAB(26);STRING$(26,"/")
1720 GOSUB 3660 : GOSUB 3740
1730 INPUT "INDUCTANCE (nH) ";L
1740 INPUT "HEIGHT (H) ABOVE GROUND PLANE ";W
1750 IF A%=2 THEN R=D/2 ELSE R=12.7*D : W=25.4*W
1760 X=25
1770 K1=SQR(X*X+R*R)
1780 K2=SQR(X*X+4*W*W)
1790 LG=L/(.2*LOG((2*W/R)*((X+K1)/(X+K2)))+(.2*(K2-K1+(X/4)-(2*W)+R))/X)
1800 IF LG>.999*X AND LG<1.001*X THEN 1820 ELSE X=LG
1810 GOTO 1770
1820 IF A%=1 THEN LG=LG/25.4
1830 PRINT 
1840 IF LG>0 THEN PRINT "LENGTH (LG) =";LG; ELSE 3610
1850 IF A%=1 THEN PRINT "IN." ELSE PRINT "mm"
1860 GOTO 3620
1870 REM **********************************************************************
1880 PRINT TAB(28);"SINGLE-LAYER COIL TURNS
1890 PRINT TAB(28);STRING$(23,"=")
1900 GOSUB 3660
1910 INPUT "INDUCTANCE (uH) ";L
1920 INPUT "COIL LENGTH ";LG
1930 INPUT "COIL RADIUS ";R
1940 IF A%=2 THEN LG=LG/25.4 : R=R/25.4
1950 N=SQR(L*(9*R+10*LG)/(R*R))
1960 PRINT 
1970 PRINT "NO. OF TURNS = ";USING "###.#";N
1980 RETURN
1990 REM **********************************************************************
2000 PRINT TAB(24);"TRANSMISSION LINE INDUCTANCE
2010 PRINT TAB(24);STRING$(28,"=")
2020 PRINT : PRINT 
2030 PRINT "DO YOU WANT TO ENTER LINE LENGTH IN:
2040 PRINT "   1 - INCHES
2050 PRINT "   2 - CENTIMETERS
2060 PRINT "   3 - ELECTRICAL DEGREES
2070 PRINT "   4 - WAVELENGTH  
2080 INPUT "ENTER YOUR CHOICE ",Y%
2090 IF Y%<1 OR Y%>4 THEN PRINT "   Please enter a number between 1 and 4" : GOTO 2080
2100 INPUT "LINE LENGTH ";LG
2110 INPUT "OPEN (O) OR SHORTED (S) LINE ";T$
2120 IF T$<>"O" AND T$<>"o" AND T$<>"S" AND T$<>"s" THEN PRINT "Please enter 'O' or 'S'" : GOTO 2110
2130 INPUT "CHARACTERISTIC IMPEDANCE ";ZO
2140 IF Y%=<2 THEN INPUT "VELOCITY FACTOR (DECIMAL) ";V
2150 IF V>1 THEN PRINT "Please enter a value of 1 or less" : GOTO 2140
2160 INPUT "FREQUENCY (MHz) ";F
2170 IF Y%=1 THEN LG=LG*F/(11802.9*V)
2180 IF Y%=2 THEN LG=LG*F/(29979.3*V)
2190 IF Y%=3 THEN LG=LG/360
2200 WHILE LG>.5
2210   LG=LG-.5
2220 WEND
2230 PRINT 
2240 IF LG>.249 AND LG<.251 THEN PRINT "LINE IS A QUARTER-WAVE OPEN OR SHORT CIRCUIT" : RETURN
2250 IF LG>=.495 AND LG=<.5 THEN PRINT "LINE IS A HALF-WAVE TRANSFORMER" : RETURN
2260 LG=LG*2*PI
2270 IF T$="S" OR T$="s" THEN XL=ZO*TAN(LG) ELSE XL=-ZO*TAN(LG)
2280 IF XL<0 THEN PRINT "LINE IS CAPACITIVE" ELSE 2330
2290 C=ABS(1/(2*PI*F*XL))
2300 PRINT "   CAPACITANCE (pF) =";C*1E+06
2310 PRINT "   REACTANCE (OHMS) = ";XL
2320 RETURN
2330 L=XL/(2*PI*F)
2340 PRINT "INDUCTANCE (nH)  =";L*1000
2350 PRINT "REACTANCE (OHMS) =";XL
2360 RETURN
2370 REM **********************************************************************
2380 PRINT TAB(28);"TRANSMISSION LINE LENGTH
2390 PRINT TAB(28);STRING$(24,"=")
2400 PRINT : PRINT 
2410 INPUT "INDUCTANCE (nH) ";L
2420 INPUT "CHARACTERISTIC IMPEDANCE ";ZO
2430 INPUT "VELOCITY FACTOR (DECIMAL) ";V
2440 IF V>1 THEN PRINT "Please enter a value of 1 or less" : GOTO 2430
2450 INPUT "FREQUENCY (MHz) ";F
2460 INPUT "OPEN (O) OR SHORTED (S) LINE ";T$
2470 IF T$<>"O" AND T$<>"o" AND T$<>"S" AND T$<>"s" THEN PRINT "Please enter 'O' or 'S'" : GOTO 2460
2480 XL=2*PI*F*L*.001
2490 LG=ATN(XL/ZO)
2500 IF T$="O" OR T$="o" THEN LG=PI-LG
2510 LG=LG/(2*PI)	'wavelength
2520 LGD=LG*360		'degrees
2530 LGI=LG*V*11802.9/F	'inches
2540 PRINT 
2550 PRINT "LENGTH: ";LG;"WAVELENGTH =";LGD;"DEGREES =";LGI;"IN. =";LGI*2.54;"CM
2560 RETURN
2570 REM **********************************************************************
2580 PRINT TAB(26);"STRAIGHT WIRE INDUCTANCE
2590 PRINT TAB(26);STRING$(24,"=")
2600 GOSUB 3660 : GOSUB 3740
2610 INPUT "WIRE LENGTH ";LG
2620 IF A%=2 THEN LG=LG/25.4 : D=D/25.4
2630 L=.0051*LG*(LOG((4*LG)/D)-1)*1000
2640 PRINT
2650 PRINT "INDUCTANCE (nH) =";L
2660 RETURN
2670 REM **********************************************************************
2680 REM  This routine adapted from program written by Thomas N. Lockyer and
2690 REM  published in March 17, 1983 issue of "EDN"
2700 PRINT TAB(22);"MULTI-LAYER BOBBIN-WOUND COIL DESIGN
2710 PRINT TAB(22);STRING$(36,"=")
2720 PRINT : PRINT "DIMENSIONS MUST BE ENTERED IN INCHES" : PRINT 
2730 PRINT "IS BOBBIN:
2740 PRINT "  1 - CIRCULAR
2750 PRINT "  2 - RECTANGULAR
2760 INPUT "ENTER YOUR CHOICE ",J%
2770 IF J%<1 OR J%>2 THEN PRINT "Please enter 1 or 2" : GOTO 2760
2780 PRINT 
2790 INPUT "DESIRED INDUCTANCE (uH) ";H1
2800 IF J%=1 THEN PRINT "COIL AXIAL HEIGHT "; ELSE PRINT "COIL HEIGHT ";
2810 INPUT L
2820 IF J%=1 THEN PRINT "ESTIMATED COIL BUILD-UP (RADIAL THICKNESS) "; ELSE PRINT "ESTIMATED COIL BUILD-UP (THICKNESS) ";
2830 INPUT B
2840 IF B<.003 THEN PRINT "Estimated coil build-up is too small - reestimate!" : GOTO 2830
2850 INPUT "MUST INDUCTOR CARRY A SPECIFIED CURRENT? (Y/N) ";Z$
2860 IF Z$="N" OR Z$="n" THEN 2890
2870 INPUT "REQUIRED CURRENT (AMP) ";A2
2880 IF A2<.019 OR A2>21 THEN PRINT "Current must be between .019 and 21 amp - respecify!" : GOTO 2870
2890 IF J%=1 THEN 2950
2900 INPUT "LENGTH OF RECTANGULAR BOBBIN ";Y
2910 INPUT "WIDTH OF RECTANGULAR BOBBIN  ";D
2920 C=D+Y+2*B
2930 Z=1.908*C
2940 GOTO 2970
2950 INPUT "DIAMETER OF CIRCULAR BOBBIN ";D
2960 C=(D/2)+(B/2)
2970 K=9*L
2980 M=10*B
2990 IF J%=1 THEN 3040
3000 T=H1*(Z+K+M)
3010 P=T/.07
3020 N=SQR(P)/C
3030 GOTO 3080
3040 V=6*C
3050 T=H1*(V+K+M)
3060 P=T/.8
3070 N=SQR(P)/C
3080 A=SQR((B*L)/N)*800
3090 C1=A*A
3100 A1=C1/500
3110 REM  Calc wire size (10 to 40 AWG) and circular mils
3120 E=10
3130 FOR E=10 TO 40
3140   D1=10380
3150   F=E-9
3160   FOR G=1 TO F
3170     D1=D1-.207*D1
3180   NEXT G
3190   IF D1<C1 THEN 3210
3200 NEXT E
3210 IF Z$="N" OR Z$="n" THEN 3340 ELSE PFLAG%=PFLAG%+1
3220 IF PFLAG%=1 THEN PRINT " . . . calculating - please wait!
3230 REM  Determines wire size for specified current
3240 IF A1/A2<1.01 THEN 3290
3250 IF A1>A2 THEN 3270
3260 GOTO 3290
3270 B=B-.05*B
3280 IF J%=1 THEN 2960 ELSE 2920
3290 IF A2/A1<1.01 THEN 3340
3300 IF A1<A2 THEN 3320
3310 GOTO 3340
3320 B=B+.05*B
3330 IF J%=1 THEN 2960 ELSE 2920
3340 S=A*N/(L*800)
3350 IF A1>21 THEN PRINT "Estimated coil build-up is too large - redesign!" : RETURN
3360 IF A1<.019 THEN PRINT "Estimated coil build-up is too small - redesign!" : RETURN
3370 IF S<.9 THEN PRINT "Less than one coil layer - respecify coil length!" : RETURN
3380 PRINT 
3390 PRINT "NO. OF TURNS ";TAB(40);N
3400 PRINT "REQUIRED COIL BUILD-UP";TAB(40);B;"IN."
3410 PRINT "CIRCULAR MILS PER TURN AVAILABLE";TAB(40);C1
3420 PRINT "MAX. CURRENT AT 500 CM/AMP";TAB(40);A1;"AMP"
3430 PRINT "WIRE SIZE";TAB(40);E;"AWG"
3440 PRINT "NO. OF LAYERS";TAB(40);S
3450 RETURN
3460 REM *********************************************************************
3470 PRINT TAB(29);"STRAIGHT WIRE LENGTH
3480 PRINT TAB(29);STRING$(20,"=")
3490 GOSUB 3660 : GOSUB 3740
3500 INPUT "INDUCTANCE (nH) ";L
3510 IF A%=2 THEN D=D/25.4
3520 X=1
3530 LG=.196*L/(LOG(4*X/D)-1)
3540 IF LG>.999*X AND LG<1.001*X THEN 3560 ELSE X=LG
3550 GOTO 3530
3560 IF A%=2 THEN LG=LG*25.4
3570 PRINT 
3580 IF LG>0 THEN PRINT "WIRE LENGTH =";LG; ELSE 3610
3590 IF A%=1 THEN PRINT "IN." ELSE PRINT "mm"
3600 GOTO 3620
3610 PRINT : PRINT "NO SOLUTION FOR THE DATA ENTERED" : FLAG%=1
3620 PRINT : PRINT
3630 INPUT "RUN AGAIN? (Y/N)? ",R$
3640 IF R$="Y" OR R$="y" THEN RESTORE ELSE END
3650 IF FLAG%=1 THEN RESUME 70 ELSE 70
3660 REM **********************************************************************
3670 PRINT 
3680 PRINT "DO YOU WANT TO ENTER DIMENSIONS IN:
3690 PRINT "   1 - INCHES
3700 PRINT "   2 - MILLIMETERS
3710 INPUT "     ENTER YOUR CHOICE ",A%
3720 IF A%<1 OR A%>2 THEN PRINT "Please enter 1 or 2" : GOTO 3710
3730 RETURN
3740 REM **********************************************************************
3750 IF A%=1 THEN PRINT "DO YOU WANT TO ENTER WIRE DIAMETER IN:" ELSE 3810
3760 PRINT "   1 - INCHES
3770 PRINT "   2 - AWG SIZE
3780 INPUT "     ENTER YOUR CHOICE ",S%
3790 IF S%<1 OR S%>2 THEN PRINT "Please enter 1 or 2" : GOTO 3780
3800 IF S%=2 THEN INPUT "WIRE SIZE (EVEN NO. FROM 10 TO 40) ";Z% : GOTO 3820
3810 INPUT "WIRE DIAMETER ";D : RETURN
3820 IF Z%<10 OR Z%>40 THEN PRINT "Invalid size --->  "; : GOTO 3800
3830 FOR J=10 TO Z% STEP 2
3840   READ D
3850 NEXT J
3860 RETURN
3870 REM *********************************************************************
3880 REM Follows wire dia in inches from #10 to #40 AWG
3890 DATA .1019,.08081,.06408,.05082,.0403,.03196,.02535,.0201,.01594,.01264
3900 DATA .01003,.00795,.006305,.005,.003965,.003145
