10	REM	STARVAL.BAS	JULY 15.1, 1981
20	REM
30	REM			READS SEQUENTIAL RECORDS, CHECKS
40	REM			THEM (SIMPLE CHECK), AND REPORTS
50	REM			ALL ERRORS FOUND
60	REM
70	REM	OPEN FILE, INITIALIZE CONSTANTS
80	REM
90	PRINT TAB(20);"STAR DATABASE VALIDATION"
100	PRINT
110	PRINT "This program performs several cursory checks on the various"
120	PRINT "STARx.DAT data files.  While it can detect some errors, it"
130	PRINT "is NOT capable of finding ALL POSSIBLE ERRORS in the data"
140	PRINT "base."
150	PRINT
160	PRINT "     HAPPY STAR GAZING"
170	PRINT
180	PRINT "FILE NAME   FIRST   LAST   COMMENTS"
190	PRINT
200	PRINT "STAR1.BAD       1     50   File with sample errors to demonstrate"
210	PRINT "                           STARVALs error detection capabilities."
220	PRINT "STAR1.DAT       1    884   First datafile"
230	PRINT "STAR2.DAT     885   2059   2ND datafile"
240	PRINT "STAR3.DAT    2060   3234   3RD datafile"
250     PRINT "STAR4.DAT    3235   4409   4TH datafile"
260     PRINT "STAR5.DAT    4410   5584   5TH datafile"
270     PRINT "STAR6.DAT    5585   6759   6TH datafile
280	PRINT "STAR7.DAT    6760   7934   7TH datafile"
290	PRINT "STAR8.DAT    7935   9110   Last datafile"
300	PRINT
310	INPUT "File name, first line #, last line #? ",A$,S,F
320	INPUT "Do you want just the line #s with errors displayed  (Y/N)? ",B$
330	IF B$="y" THEN B$="Y"
340	OPEN "I",#1,A$
350	E=0
360	E1=0
370	S$="    "
380	REM
390	REM	CHECK EACH STAR
400	REM
410	FOR I=S TO F STEP 1
420	REM
430	REM	CALCULATE STAR NUMBER IN ASCII
440	REM
450	N$=RIGHT$(STR$(I),LEN(STR$(I))-1)
460	IF LEN(N$)>=4 THEN 510
470	N$="0"+N$
480	GOTO 460
490	REM	INPUT DATA RECORD ON ONE STAR
500	REM
510	LINE INPUT #1,C$
520	REM
530	REM	CHECK TO SEE THAT REDUNDANT CATALOG NUMBERS ARE EQUAL
540	REM
550	IF B$<>"Y" THEN GOSUB 1220
560	IF LEFT$(C$,4)=MID$(C$,85,4) THEN 630
570	IF B$="Y" THEN GOSUB 1220
580	PRINT LEFT$(C$,4);" NOT = ";MID$(C$,85,4);
590	E=E+1
600	REM
610	REM	CHECK TO SEE THAT CATALOG NUMBERS ARE SEQUENTIAL
620	REM
630	IF LEFT$(C$,4)=N$ THEN 730
640	IF B$="Y" THEN GOSUB 1220
650	PRINT "CAT # OUT OF SEQUENCE ";
660	E=E+1
670	REM
680	REM	CHECK TO SEE THAT THE DECIMAL POINTS ASSOCIATED WITH
690	REM	THE FIXED POINT DATA IN RADIANS ARE IN THE CORRECT
700	REM	PLACE.  (THESE FOUR DECIMAL POINTS ARE THE ONLY
710	REM	"DATA" THAT CAN BE VERIFIED.)
720	REM
730	IF MID$(C$,174,1)="." THEN 770
740	IF B$="Y" THEN GOSUB 1220
750	PRINT MID$(C$,174,1);" ,174 <> '.'";
760	E=E+1
770	IF MID$(C$,182,1)="." THEN 810
780	IF B$="Y" THEN GOSUB 1220
790	PRINT MID$(C$,182,1);" ,182 <> '.'";
800	E=E+1
810	IF MID$(C$,190,1)="." THEN 850
820	IF B$="Y" THEN GOSUB 1220
830	PRINT MID$(C$,190,1);" ,190 <> '.'";
840	E=E+1
850	IF MID$(C$,198,1)="." THEN 920
860	IF B$="Y" THEN GOSUB 1220
870	PRINT MID$(C$,198,1);" ,198 <> '.'";
880	E=E+1
890	REM
900	REM	CHECK TO SEE THAT LENGTH IS CORRECT
910	REM
920	IF LEN(C$)=202 THEN 990
930	IF B$="Y" THEN GOSUB 1220
940	PRINT "LEN NOT 202, = ";LEN(C$);
950	E=E+1
960	REM
970	REM	CHECK TO SEE THAT ALL CHARACTERS ARE ASCII
980	REM
990	FOR J=1 TO LEN(C$)
1000	IF MID$(C$,J,1)<" "THEN 1020
1010	IF MID$(C$,J,1)<"~" THEN 1050
1020	IF B$="Y" THEN GOSUB 1220
1030	PRINT "CHAR #";J;" NOT VALID ASCII CHAR"
1040	E=E+1
1050	NEXT J
1060	IF B$<>"Y" THEN PRINT:GOTO 1090
1070	IF E<>E1 THEN PRINT
1080	E1=E
1090	NEXT I
1100	REM
1110	REM	PRINT THE GOOD (HOPEFULLY) NEWS
1120	REM
1130	PRINT
1140	PRINT "    Total number of errors DETECTED = ";E
1150	CLOSE #1
1160	GOTO 170
1170	END
1180	ON ERROR GOTO 1190
1190	PRINT "UNEXPECTED END OF FILE ENCOUNTERED"
1200	E=E+1
1210	GOTO 1130
1220	PRINT "Line # = ";I;" (";LEFT$(C$,4);") ";
1230	RETURN
