10 REM HOLT-WINTERS FORECASTING PROGRAM BY C. VAN DER KAAY (2024)
20 CLEAR
30 PRINT  " WELCOME TO THE HOLT-WINTERS FORECASTING PROGRAM"
40 PRINT  "------------------------------------------------------------"
50 PRINT  " THIS PROGRAM UTILIZES THE ADVANCED HOLT-WINTERS METHOD FOR"
60 PRINT  " TIME SERIES FORECASTING. IT EFFECTIVELY ESTIMATES LEVEL, TREND,"
70 PRINT  " AND SEASONAL COMPONENTS USING OPTIMIZED SMOOTHING FACTORS:"
80 PRINT  " ALPHA, BETA, AND GAMMA. IDEAL FOR DATA WITH TRENDS AND SEASONALITY,"
90 PRINT  " THIS PROGRAM PROVIDES ACCURATE FUTURE VALUES AND COMPUTES KEY"
100 PRINT  " ERROR METRICS SUCH AS MPE, MAPE, RMSE, MAE, DURBIN-WATSON"
110 PRINT  " STATISTIC, AND THE LJUNG-BOX Q TEST."
120 PRINT  "------------------------------------------------------------"
130 PRINT  " PROGRAM AUTOMATICALLY CALCULATES THE SEASONAL PERIOD BY"
140 PRINT  " ANALYZING THE PERIODICITY IN THE HISTORICAL DATA SERIES USING"
150 PRINT  " THE AUTOCORRELATION FUNCTION (ACF)."
160 PRINT  "------------------------------------------------------------"
170 PAUSED = 0
180 PRINT 
190 PRINT "PRESS ENTER TO START OR TYPE 'INFO' FOR DETAILS"
200 PRINT "OR TYPE 'DEBUG' TO ENABLE DEBUG MODE FOR AUTOMATIC TESTING"
210 INPUT BEGIN$
220 IF BEGIN$ = "INFO" THEN GOSUB 4640 : PRINT : PRINT "RETURNING FROM INFO MENU..." : GOTO 190
230 IF BEGIN$ = "DEBUG" THEN DEBUGMODE = 1 : GOTO 260
240 IF BEGIN$ = "" THEN GOTO 260
250 PRINT "INVALID INPUT. PLEASE PRESS ENTER, OR TYPE 'INFO' OR 'DEBUG'." : GOTO 190
260 IF DEBUGMODE = 1 THEN GOSUB 5660 : GOTO 530
270 PRINT "IS YOUR DATA SEASONALITY ADDITIVE OR MULTIPLICATIVE? (A/M)"
280 INPUT SEASONALITY$
290 IF SEASONALITY$ = "A" THEN MODELTYPE = 1 : GOTO 320
300 IF SEASONALITY$ = "M" THEN MODELTYPE = 2 : GOTO 320
310 PRINT "INVALID INPUT. ENTER 'A' FOR ADDITIVE OR 'M' FOR MULTIPLICATIVE." : GOTO 270
320 DIM Y(400), F(400), S(400), T(400), C(400), U(400), L(400), E(400), ACFY(200), ACFRES(200)
330 INPUT "ENTER NUMBER OF HISTORICAL DATA POINTS: "; N$
340 N = VAL(N$)
350 IF N <= 0 OR N <> INT(N) THEN PRINT "INVALID INPUT. PLEASE ENTER A POSITIVE INTEGER." : GOTO 330
360 FOR I = 1 TO N
370 INPUT "ENTER DATA POINT "; Y$
380 IF Y$ = "" THEN PRINT "INPUT CANNOT BE EMPTY." : I = I - 1 : GOTO 370
390 FOR J = 1 TO LEN(Y$)
400 C$ = MID$(Y$, J, 1)
410 IF (C$ < "0" OR C$ > "9") AND C$ <> "." AND C$ <> "-" THEN PRINT "INVALID INPUT. PLEASE ENTER A VALID NUMBER." : I = I - 1 : GOTO 370
420 NEXT J
430 Y(I) = VAL(Y$)
440 PRINT "YOU ENTERED: "; Y(I)
450 INPUT "IS THIS CORRECT? (Y/N): "; CORRECT$
460 IF CORRECT$ = "N" THEN PRINT "PLEASE RE-ENTER THE CORRECT VALUE." : I = I - 1
470 NEXT I
480 INPUT "ENTER FORECAST HORIZON (1-100): "; H$
490 H = VAL(H$)
500 IF H <= 0 OR H > 100 OR H <> INT(H) THEN PRINT "INVALID INPUT. PLEASE ENTER A NUMBER BETWEEN 1 AND 100." : GOTO 480
510 TRAINSIZE = N - H
520 IF TRAINSIZE < 2 THEN PRINT "ERROR: NOT ENOUGH DATA FOR TRAINING. REDUCE FORECAST HORIZON." : END
530 REM CALCULATE SEASONAL PERIOD AUTOMATICALLY
540 GOSUB 3720 ' CALCULATE ACF AND DETERMINE P
550 IF P <= 0 OR P <> INT(P) THEN PRINT "WARNING: SEASONAL PERIOD NOT DETECTED. USING DEFAULT P = 12" : P = 12
560 IF 2 * P > 200 THEN PRINT "ERROR: SEASONAL PERIOD TOO LARGE.": END
570 PRINT:PRINT "----------------------------------"
580 PRINT "DETECTED SEASONAL PERIOD: "; P
590 IF TRAINSIZE < 2 * P THEN PRINT "WARNING: TOO FEW FULL SEASONS FOR RELIABLE SEASONALITY" : REM CONTINUE ANYWAY
600 PRINT "----------------------------------"
610 PRINT:PRINT "YOU HAVE SUCCESSFULLY ENTERED THE REQUIRED DATA."
620 PRINT "THE PROGRAM WILL NOW BEGIN TESTING SMOOTHING FACTORS."
630 PRINT "DO YOU WANT FAST MODE (80 COMBINATIONS) OR FULL MODE (810 COMBINATIONS)?"
640 PRINT "TYPE 'F' FOR FAST OR 'FULL' FOR COMPLETE SEARCH:"
650 INPUT MODE$
660 IF MODE$ = "F" THEN FASTMODE = 1 : GOTO 690
670 IF MODE$ = "FULL" THEN FASTMODE = 0 : GOTO 690
680 PRINT "INVALID INPUT. TYPE 'F' FOR FAST OR 'FULL' FOR COMPLETE SEARCH." : GOTO 650
690 REM OPTIMIZE SMOOTHING FACTORS
700 BESTMSE = 1E+30
710 REM -- PROGRESS TRACKING VARIABLES --
720 COMBOCOUNT = 0
730 IF FASTMODE = 1 THEN TOTALCOMBOS = 80 ELSE TOTALCOMBOS = 810
740 IF FASTMODE = 1 THEN AISTART = 2 : AISTEP = 2 : AIEND = 8 ELSE AISTART = 1 : AISTEP = 1 : AIEND = 9
750 FOR AI = AISTART TO AIEND STEP AISTEP
760 ALPHA = AI / 10
770 IF FASTMODE = 1 THEN BISTART = 2 : BISTEP = 2 : BIEND = 8 ELSE BISTART = 1 : BISTEP = 1 : BIEND = 9
780 FOR BI = BISTART TO BIEND STEP BISTEP
790 BETA = BI / 10
800 IF FASTMODE = 1 THEN GISTART = 2 : GISTEP = 2 : GIEND = 10 ELSE GISTART = 1 : GISTEP = 1 : GIEND = 10
810 FOR GI = GISTART TO GIEND STEP GISTEP
820 GAMMA = GI / 10
830 COMBOCOUNT = COMBOCOUNT + 1
840 PERCENTDONE = INT((COMBOCOUNT / TOTALCOMBOS) * 100)
850 FOR RST = 1 TO N
860 S(RST) = 0 : T(RST) = 0 : C(RST) = 0
870 NEXT RST
880 FOR RST = 1 TO N + H
890 F(RST) = 0 : E(RST) = 0
900 NEXT RST
910 MSE = 0
920 PRINT:PRINT "TESTING COMBINATION "; COMBOCOUNT; " OF "; TOTALCOMBOS; ""
930 PRINT "ALPHA = "; ALPHA; " BETA = "; BETA; " GAMMA = "; GAMMA 
940 PRINT PERCENTDONE; "% COMPLETE"
950 S(1) = Y(1)
960 REM === TREND INITIALIZATION ===
970 SUMT = 0
980 COUNT = 0
990 FOR J = 1 TO TRAINSIZE - 1
1000 SUMT = SUMT + (Y(J + 1) - Y(J))
1010 COUNT = COUNT + 1
1020 NEXT J
1030 IF COUNT > 0 THEN T(1) = SUMT / COUNT ELSE T(1) = 0
1040 REM TREND T(1) INITIALIZED AS AVERAGE SLOPE OVER TRAINING DATA
1050 YMEAN = 0
1060 FOR I = 1 TO TRAINSIZE
1070 YMEAN = YMEAN + Y(I)
1080 NEXT I
1090 YMEAN = YMEAN / TRAINSIZE
1100 IF MODELTYPE = 1 THEN GOTO 1130
1110 IF MODELTYPE = 2 THEN GOTO 1420
1120 GOTO 1260
1130 FOR I = 1 TO P
1140 SUMC = 0
1150 COUNT = 0
1160 FOR J = 0 TO INT((TRAINSIZE - I) / P)
1170 IDX = I + J * P
1180 IF IDX <= TRAINSIZE THEN SUMC = SUMC + (Y(IDX) - YMEAN) : COUNT = COUNT + 1
1190 NEXT J
1200 IF COUNT > 0 THEN C(I) = SUMC / COUNT ELSE C(I) = 0
1210 NEXT I
1220 REM --- EXTEND SEASONAL COMPONENT TO COVER TRAINING RANGE
1230 FOR I = P + 1 TO TRAINSIZE
1240 C(I) = C(I - P)
1250 NEXT I
1260 FOR I = P + 1 TO TRAINSIZE
1270 IF MODELTYPE = 1 THEN GOTO 1300
1280 IF MODELTYPE = 2 THEN GOTO 1350
1290 GOTO 1520
1300 REM --- ADDITIVE UPDATE ---
1310 S(I) = ALPHA * (Y(I) - C(I-P)) + (1 - ALPHA) * (S(I-1) + T(I-1))
1320 T(I) = BETA * (S(I) - S(I-1)) + (1 - BETA) * T(I-1)
1330 C(I) = GAMMA * (Y(I) - S(I)) + (1 - GAMMA) * C(I-P)
1340 GOTO 1520
1350 PRINT "*** WARNING: ZERO VALUE IN MULTIPLICATIVE UPDATE AT STEP "; I
1360 IF C(I-P) = 0 THEN C(I-P) = .0001
1370 S(I) = ALPHA * (Y(I) / C(I-P)) + (1 - ALPHA) * (S(I-1) + T(I-1))
1380 T(I) = BETA * (S(I) - S(I-1)) + (1 - BETA) * T(I-1)
1390 IF S(I) = 0 THEN S(I) = .0001
1400 C(I) = GAMMA * (Y(I) / S(I)) + (1 - GAMMA) * C(I-P)
1410 GOTO 1520
1420 FOR J = 1 TO P
1430 SUMC = 0
1440 COUNT = 0
1450 FOR K = 0 TO INT((TRAINSIZE - J) / P)
1460 IDX = J + K * P
1470 IF IDX <= TRAINSIZE AND YMEAN <> 0 THEN SUMC = SUMC + (Y(IDX) / YMEAN) : COUNT = COUNT + 1
1480 NEXT K
1490 IF COUNT > 0 THEN C(J) = SUMC / COUNT ELSE C(J) = 1
1500 NEXT J
1510 GOTO 1260
1520 NEXT I
1530 FOR K = P + 1 TO TRAINSIZE
1540 IF ABS(S(K)) > 1E+10 OR ABS(C(K)) > 1E+10 THEN PRINT "UNSTABLE FOR ALPHA="; ALPHA; " BETA="; BETA; " GAMMA="; GAMMA : GOTO 1780
1550 NEXT K
1560 REM CALCULATE FORECAST AND MSE
1570 FOR I = 1 TO H
1580 TEMP = ((TRAINSIZE + I - 1) MOD P) + 1
1590 IF MODELTYPE = 1 THEN F(TRAINSIZE+I) = S(TRAINSIZE) + I * T(TRAINSIZE) + C(TEMP)
1600 IF MODELTYPE = 2 THEN F(TRAINSIZE+I) = (S(TRAINSIZE) + I * T(TRAINSIZE)) * C(TEMP)
1610 NEXT I
1620 FOR I = 1 TO H
1630 E(I) = 0
1640 E(I) = Y(TRAINSIZE + I) - F(TRAINSIZE + I)
1650 MSE = MSE + E(I) * E(I)
1660 NEXT I
1670 MSE = MSE / H
1680 IF MSE = 0 THEN PRINT "*** WARNING: MSE=0 b  CHECK FOR POSSIBLE MODEL DEGENERACY! ***"
1690 PRINT "MSE FOR ALPHA="; ALPHA; " BETA="; BETA; " GAMMA="; GAMMA; ": "; MSE
1700 IF MSE < BESTMSE THEN GOTO 1720
1710 GOTO 1780
1720 BESTMSE = MSE
1730 BESTALPHA = ALPHA
1740 BESTBETA = BETA
1750 BESTGAMMA = GAMMA
1760 REM END OF BEST VALUE ASSIGNMENT
1770 REM CONTINUES TO NEXT GAMMA
1780 NEXT GI
1790 NEXT BI
1800 PRINT "------------------------------------------------------------"
1810 NEXT AI
1820 PRINT "OPTIMAL ALPHA: "; BESTALPHA
1830 PRINT "OPTIMAL BETA: "; BESTBETA
1840 PRINT "OPTIMAL GAMMA: "; BESTGAMMA
1850 PRINT "BEST MEAN SQUARED ERROR: "; BESTMSE
1860 PRINT "------------------------------------------------------------"
1870 PRINT "OPTIMAL SMOOTHING FACTORS FOUND."
1880 PRINT "THE PROGRAM WILL NOW USE THESE FACTORS TO COMPUTE FORECASTS"
1890 PRINT "AND CALCULATE ERROR METRICS."
1900 PRINT:PRINT "PRESS ENTER TO CONTINUE."
1910 INPUT CONTINUE$
1920 IF CONTINUE$ = "" THEN GOTO 1930
1930 REM USE OPTIMAL SMOOTHING FACTORS
1940 ALPHA = BESTALPHA
1950 BETA = BESTBETA
1960 GAMMA = BESTGAMMA
1970 S(1) = Y(1)
1980 T(1) = 0
1990 FOR I = 1 TO P
2000 C(I) = Y(I) - S(1)
2010 NEXT I
2020 FOR I = P + 1 TO TRAINSIZE
2030 S(I) = ALPHA * (Y(I) - C(I-P)) + (1 - ALPHA) * (S(I-1) + T(I-1))
2040 T(I) = BETA * (S(I) - S(I-1)) + (1 - BETA) * T(I-1)
2050 C(I) = GAMMA * (Y(I) - S(I)) + (1 - GAMMA) * C(I-P)
2060 NEXT I
2070 FOR I = P + 1 TO TRAINSIZE
2080 TEMP = ((I - 1) MOD P) + 1
2090 IF MODELTYPE = 1 THEN F(I) = S(I - 1) + T(I - 1) + C(TEMP)
2100 IF MODELTYPE = 2 THEN F(I) = (S(I - 1) + T(I - 1)) * C(TEMP)
2110 E(I) = Y(I) - F(I)
2120 NEXT I
2130 REM FORECAST DATA
2140 FOR I = 1 TO H
2150 TEMP = ((TRAINSIZE + I - 1) MOD P) + 1
2160 IF MODELTYPE = 1 THEN F(TRAINSIZE + I) = S(TRAINSIZE) + I * T(TRAINSIZE) + C(TEMP)
2170 IF MODELTYPE = 2 THEN F(TRAINSIZE + I) = (S(TRAINSIZE) + I * T(TRAINSIZE)) * C(TEMP)
2180 NEXT I
2190 SUME2 = 0
2200 MSE = 0
2210 FOR I = 1 TO H
2220 MSE = MSE + (Y(TRAINSIZE + I) - F(TRAINSIZE + I)) ^ 2
2230 NEXT I
2240 MSE = MSE / H
2250 SE = SQR(MSE)
2260 PRINT "STANDARD ERROR USED FOR INTERVALS: "; SE
2270 REM === CALCULATE MEAN OF TRAINING DATA ===
2280 YAVG = 0
2290 FOR I = 1 TO TRAINSIZE
2300 YAVG = YAVG + Y(I)
2310 NEXT I
2320 YAVG = YAVG / TRAINSIZE
2330 REM === CALCULATE STANDARD DEVIATION OF TRAINING DATA ===
2340 SUMSQR = 0
2350 FOR I = 1 TO TRAINSIZE
2360 SUMSQR = SUMSQR + (Y(I) - YAVG) ^ 2
2370 NEXT I
2380 YSTD = SQR(SUMSQR / (TRAINSIZE - 1))
2390 REM === RELATIVE STANDARD ERROR CHECK ===
2400 IF SE / YAVG > .25 THEN PRINT "*** WARNING: FORECAST ERROR > 25% OF DATA MEAN b  POSSIBLY UNSTABLE MODEL ***"
2410 REM === SE COMPARED TO IN-SAMPLE VOLATILITY ===
2420 IF SE > YSTD THEN PRINT "*** WARNING: FORECAST ERROR > DATA VOLATILITY b  CHECK MODEL FIT OR P ***"
2430 REM PRINT FORECASTS WITH PREDICTION INTERVALS
2440 PRINT CHR$(7): PRINT "***********************************"
2450 PRINT "FORECASTS WITH PREDICTION INTERVALS:"
2460 FOR I = 1 TO H
2470 TEMP = ((TRAINSIZE + I - 1) MOD P) + 1
2480 IF MODELTYPE = 1 THEN F(TRAINSIZE + I) = S(TRAINSIZE) + I * T(TRAINSIZE) + C(TEMP)
2490 IF MODELTYPE = 2 THEN F(TRAINSIZE + I) = (S(TRAINSIZE) + I * T(TRAINSIZE)) * C(TEMP)
2500 U(TRAINSIZE + I) = F(TRAINSIZE + I) + 1.96 * SE * SQR(I)
2510 L(TRAINSIZE + I) = F(TRAINSIZE + I) - 1.96 * SE * SQR(I)
2520 IF L(TRAINSIZE + I) < 0 THEN L(TRAINSIZE + I) = 0
2530 PRINT "STEP"; I; " | FORECAST:"; F(TRAINSIZE + I); " | UPPER:"; U(TRAINSIZE + I); " | LOWER:"; L(TRAINSIZE + I)
2540 IF I MOD 20 = 0 THEN GOSUB 3660
2550 NEXT I
2560 PRINT "***********************************"
2570 REM PRINT FORECASTS AND ERRORS
2580 MPE = 0
2590 MAPE = 0
2600 MAE = 0
2610 RMSE = 0
2620 PAUSED = 0
2630 VALIDH = 0
2640 SUME2 = 0
2650 FOR I = 1 TO H
2660 IF Y(TRAINSIZE + I) = 0 THEN PRINT "DIVISION BY ZERO AT STEP "; I : GOTO 2740
2670 VALIDH = VALIDH + 1
2680 E(I) = (Y(TRAINSIZE + I) - F(TRAINSIZE + I)) / Y(TRAINSIZE + I)
2690 SUME2 = SUME2 + E(I) * E(I)
2700 MPE = MPE + E(I)
2710 MAPE = MAPE + ABS(E(I))
2720 MAE = MAE + ABS(Y(TRAINSIZE + I) - F(TRAINSIZE + I))
2730 RMSE = RMSE + (Y(TRAINSIZE + I) - F(TRAINSIZE + I)) ^ 2
2740 IF I MOD 20 = 0 THEN GOSUB 3660
2750 NEXT I
2760 MPE = MPE / VALIDH * 100
2770 MAPE = MAPE / VALIDH * 100
2780 PRINT "NOTE: ANY FORECAST STEPS WITH DIVISION BY ZERO WERE SKIPPED."
2790 MAE = MAE / VALIDH
2800 RMSE = SQR(RMSE / VALIDH)
2810 PRINT "MEAN PERCENTAGE ERROR: "; MPE; "%"
2820 PRINT "MEAN ABSOLUTE PERCENTAGE ERROR: "; MAPE; "%"
2830 PRINT "MEAN ABSOLUTE ERROR: "; MAE
2840 PRINT "ROOT MEAN SQUARED ERROR: "; RMSE
2850 REM DURBIN-WATSON STATISTIC
2860 DWNUMERATOR = 0
2870 DWDENOMINATOR = 0
2880 PAUSED = 0
2890 FOR I = P + 2 TO TRAINSIZE
2900 DWNUMERATOR = DWNUMERATOR + (E(I) - E(I-1)) ^ 2
2910 DWDENOMINATOR = DWDENOMINATOR + E(I) ^ 2
2920 IF I MOD 20 = 0 THEN GOSUB 3660
2930 NEXT I
2940 DURBINWATSON = DWNUMERATOR / DWDENOMINATOR
2950 PRINT "DURBIN-WATSON STATISTIC: "; DURBINWATSON
2960 REM LJUNG-BOX Q TEST
2970 Q = 0
2980 EMEAN = 0
2990 FOR I = P + 1 TO TRAINSIZE
3000 EMEAN = EMEAN + E(I)
3010 NEXT I
3020 EMEAN = EMEAN / (TRAINSIZE - P)
3030 FOR K = 1 TO 10
3040 SUMRK = 0
3050 FOR T = P + K + 1 TO TRAINSIZE
3060 SUMRK = SUMRK + (E(T) - EMEAN) * (E(T - K) - EMEAN)
3070 NEXT T
3080 RK = SUMRK / SUME2
3090 Q = Q + (RK * RK) / (TRAINSIZE - P - K)
3100 IF K MOD 10 = 0 THEN GOSUB 3660
3110 NEXT K
3120 Q = Q * (TRAINSIZE - P) * ((TRAINSIZE - P) + 2)
3130 PRINT "LJUNG-BOX Q STATISTIC: "; Q
3140 PRINT "***********************************"
3150 REM CALCULATE AUTOCORRELATION FUNCTION (ACF) FOR THE HISTORICAL DATA SERIES Y
3160 REM AUTOCORRELATION FUNCTION (ACF) CALCULATION
3170 YMEAN = 0
3180 FOR I = 1 TO N
3190 YMEAN = YMEAN + Y(I)
3200 NEXT I
3210 YMEAN = YMEAN / N
3220 FOR LAG = 1 TO 2 * P
3230 NUMERATOR = 0
3240 DENOMINATOR = 0
3250 FOR I = 1 TO N - LAG
3260 NUMERATOR = NUMERATOR + (Y(I) - YMEAN) * (Y(I + LAG) - YMEAN)
3270 NEXT I
3280 FOR I = 1 TO N
3290 DENOMINATOR = DENOMINATOR + (Y(I) - YMEAN) * (Y(I) - YMEAN)
3300 NEXT I
3310 ACFY(LAG) = NUMERATOR / DENOMINATOR
3320 PRINT "ACF FOR HISTORICAL DATA AT LAG "; LAG; ": "; ACFY(LAG)
3330 IF LAG MOD 20 = 0 THEN GOSUB 3660
3340 NEXT LAG
3350 PRINT "***********************************"
3360 REM CALCULATE AUTOCORRELATION FUNCTION (ACF) FOR RESIDUALS
3370 PRINT "CALCULATING ACF FOR RESIDUALS..."
3380 EMEAN = 0
3390 FOR I = P + 1 TO TRAINSIZE
3400 EMEAN = EMEAN + E(I)
3410 NEXT I
3420 EMEAN = EMEAN / (TRAINSIZE - P)
3430 FOR LAG = 1 TO 2 * P
3440 NUMERATOR = 0
3450 DENOMINATOR = 0
3460 FOR I = P + 1 TO TRAINSIZE - LAG
3470 NUMERATOR = NUMERATOR + (E(I) - EMEAN) * (E(I + LAG) - EMEAN)
3480 NEXT I
3490 FOR J = P + 1 TO TRAINSIZE
3500 DENOMINATOR = DENOMINATOR + (E(J) - EMEAN) * (E(J) - EMEAN)
3510 NEXT J
3520 IF DENOMINATOR = 0 THEN ACFRES(LAG) = 0 ELSE ACFRES(LAG) = NUMERATOR / DENOMINATOR
3530 PRINT "ACF FOR RESIDUALS AT LAG "; LAG; ": "; ACFRES(LAG)
3540 IF LAG MOD 20 = 0 THEN GOSUB 3660
3550 NEXT LAG
3560 REM END OF RESIDUAL ACF LOOP
3570 REM PROMPT USER TO PRINT REPORT OR EXIT
3580 PRINT "WOULD YOU LIKE TO PRINT THE REPORT OR EXIT OR RESTART?"
3590 PRINT "ENTER 'P' TO PRINT, 'E' TO EXIT, 'R' TO RESTART"
3600 INPUT CHOICE$
3610 IF CHOICE$ = "P" THEN GOSUB 4030 : GOTO 3580
3620 IF CHOICE$ = "E" THEN GOTO 4510
3630 IF CHOICE$ = "R" THEN GOTO 10
3640 PRINT "INVALID CHOICE. PLEASE ENTER 'P', 'E', OR 'R'."
3650 GOTO 3580
3660 REM SUBROUTINE FOR PAGINATION
3670 IF PAUSED = 1 THEN RETURN
3680 PRINT : PRINT "PRESS ENTER TO CONTINUE..."
3690 INPUT PAUSE$
3700 PAUSED = 1
3710 RETURN
3720 REM SUBROUTINE TO CALCULATE ACF AND DETERMINE P
3730 P = 0
3740 DIM TEMPACF(100)
3750 YMEAN = 0
3760 DIM CANDP(3), CANDVAL(3)
3770 FOR I = 1 TO N
3780 YMEAN = YMEAN + Y(I)
3790 NEXT I
3800 YMEAN = YMEAN / N
3810 FOR LAG = 1 TO 100
3820 SUMNUM = 0
3830 SUMDEN = 0
3840 FOR I = LAG + 1 TO N
3850 SUMNUM = SUMNUM + (Y(I) - YMEAN) * (Y(INT(I - LAG)) - YMEAN)
3860 NEXT I
3870 FOR I = 1 TO N
3880 SUMDEN = SUMDEN + (Y(I) - YMEAN) ^ 2
3890 NEXT I
3900 TEMPACF(LAG) = SUMNUM / SUMDEN
3910 THRESHOLD = 1.96 / SQR(N)
3920 IF TEMPACF(LAG) > CANDVAL(1) THEN CANDP(3) = CANDP(2) : CANDVAL(3) = CANDVAL(2) : CANDP(2) = CANDP(1) : CANDVAL(2) = CANDVAL(1) : CANDP(1) = LAG : CANDVAL(1) = TEMPACF(LAG)
3930 MAXACF = 0
3940 FOR LAG2 = 4 TO 99
3950 IF TEMPACF(LAG2) > THRESHOLD THEN GOTO 3970
3960 GOTO 3980
3970 IF TEMPACF(LAG2) > TEMPACF(LAG2 - 1) AND TEMPACF(LAG2) > TEMPACF(LAG2 + 1) THEN P = LAG2 : GOTO 4020
3980 NEXT LAG2
3990 IF CANDP(1) > 0 THEN P = CANDP(1)
4000 IF N < 2 * P THEN PRINT "WARNING: SEASONAL PERIOD P MAY BE TOO LARGE FOR DATA LENGTH." : REM CONTINUE ANYWAY
4010 NEXT LAG
4020 RETURN
4030 REM PRINT REPORT SUBROUTINE
4040 SE = SQR(BESTMSE)  ' USE THE FORECAST ERROR-BASED MSE
4050 REM === CALCULATE YAVG AND YSTD FOR WARNINGS ===
4060 YAVG = 0
4070 FOR I = 1 TO TRAINSIZE
4080 YAVG = YAVG + Y(I)
4090 NEXT I
4100 YAVG = YAVG / TRAINSIZE
4110 SUMSQR = 0
4120 FOR I = 1 TO TRAINSIZE
4130 SUMSQR = SUMSQR + (Y(I) - YAVG) ^ 2
4140 NEXT I
4150 YSTD = SQR(SUMSQR / (TRAINSIZE - 1))
4160 LPRINT "********** HOLT-WINTERS FORECASTING REPORT **********"
4170 IF MODELTYPE = 1 THEN LPRINT "MODEL TYPE: ADDITIVE"
4180 IF MODELTYPE = 2 THEN LPRINT "MODEL TYPE: MULTIPLICATIVE"
4190 LPRINT "SEASONAL PERIOD: "; P
4200 LPRINT "OPTIMAL ALPHA: "; BESTALPHA
4210 LPRINT "OPTIMAL BETA: "; BESTBETA
4220 LPRINT "OPTIMAL GAMMA: "; BESTGAMMA
4230 LPRINT "BEST MEAN SQUARED ERROR: "; BESTMSE
4240 LPRINT "MEAN PERCENTAGE ERROR: "; MPE; "%"
4250 LPRINT "NOTE: ERROR METRICS BASED ON HELD-OUT FORECASTS."
4260 LPRINT "      RESIDUALS USED FOR DIAGNOSTIC TESTING ONLY."
4270 LPRINT "MEAN ABSOLUTE PERCENTAGE ERROR: "; MAPE; "%"
4280 LPRINT "MEAN ABSOLUTE ERROR: "; MAE
4290 LPRINT "ROOT MEAN SQUARED ERROR: "; RMSE
4300 LPRINT "STANDARD ERROR USED FOR PREDICTION INTERVALS: "; SE
4310 IF SE / YAVG > .25 THEN LPRINT "*** WARNING: FORECAST ERROR > 25% OF DATA MEAN b  MODEL MAY BE UNSTABLE ***"
4320 IF SE > YSTD THEN LPRINT "*** WARNING: FORECAST ERROR > DATA VOLATILITY b  CHECK MODEL FIT OR SEASONALITY ***"
4330 LPRINT "DURBIN-WATSON STATISTIC: "; DURBINWATSON
4340 LPRINT "LJUNG-BOX Q STATISTIC: "; Q
4350 LPRINT "--------------------------------------"
4360 LPRINT "FORECASTS WITH PREDICTION INTERVALS:"
4370 FOR I = 1 TO H
4380 LPRINT "STEP "; I; " | FORECAST: "; F(TRAINSIZE + I); " | UPPER: "; U(TRAINSIZE + I); " | LOWER: "; L(TRAINSIZE + I)
4390 NEXT I
4400 LPRINT "--------------------------------------"
4410 LPRINT "AUTOCORRELATION FUNCTION (ACF) VALUES FOR HISTORICAL DATA:"
4420 FOR LAG = 1 TO 2 * P
4430 LPRINT "ACF FOR LAG "; LAG; ": "; ACFY(LAG)
4440 NEXT LAG
4450 LPRINT "AUTOCORRELATION FUNCTION (ACF) VALUES FOR RESIDUALS:"
4460 FOR LAG = 1 TO 2 * P
4470 LPRINT "ACF FOR LAG "; LAG; ": "; ACFRES(LAG)
4480 NEXT LAG
4490 LPRINT "********** END OF REPORT **********"
4500 RETURN
4510 REM END CREDITS 
4520 PRINT "******************************************************"
4530 PRINT "*                                                    *"
4540 PRINT "*          HOLT-WINTERS FORECASTING PROGRAM          *"
4550 PRINT "*                        V1.2                        *"
4560 PRINT "******************************************************"
4570 PRINT "*                                                    *"
4580 PRINT "*    WRITTEN BY CHRISTOPHER D. VAN DER KAAY, PH.D.   *"
4590 PRINT "*                                                    *"
4600 PRINT "*                        2024                        *"
4610 PRINT "*                                                    *"
4620 PRINT "******************************************************"
4630 END
4640 REM === INFORMATION MENU SUBROUTINE ===
4650 PRINT "INFORMATION MENU"
4660 PRINT "--------------------------------------------"
4670 PRINT "1. ABOUT THIS PROGRAM"
4680 PRINT "2. WHEN TO USE HOLT-WINTERS"
4690 PRINT "3. STATISTICS DETAILS"
4700 PRINT "4. RETURN TO MAIN MENU"
4710 PRINT "--------------------------------------------"
4720 PRINT
4730 INPUT "SELECT AN OPTION (1-4): "; INFO$
4740 IF INFO$ = "1" THEN GOSUB 4810 : GOTO 4640
4750 IF INFO$ = "2" THEN GOSUB 5090 : GOTO 4640
4760 IF INFO$ = "3" THEN GOSUB 5250 : GOTO 4640
4770 IF INFO$ = "4" THEN GOTO 4800
4780 PRINT "INVALID OPTION. PLEASE ENTER 1-4."
4790 GOTO 4640
4800 RETURN
4810 PRINT "ABOUT THIS PROGRAM"
4820 PRINT "--------------------------------------------"
4830 PRINT "THE HOLT-WINTERS METHOD FOR TIME SERIES"
4840 PRINT "FORECASTING IS A COMPREHENSIVE APPROACH"
4850 PRINT "TO ESTIMATING LEVEL, TREND, AND SEASONAL"
4860 PRINT "COMPONENTS. THIS PROGRAM USES OPTIMIZED"
4870 PRINT "SMOOTHING FACTORS: ALPHA (LEVEL), BETA"
4880 PRINT "(TREND), AND GAMMA (SEASONALITY) TO PROVIDE"
4890 PRINT "ACCURATE FORECASTS AND ERROR METRICS."
4900 PRINT "SUITABLE FOR DATA WITH BOTH TREND AND"
4910 PRINT "SEASONAL VARIATIONS, IT HELPS IN MAKING"
4920 PRINT "RELIABLE FUTURE PREDICTIONS."
4930 PRINT
4940 PRINT "PRESS ENTER TO RETURN."
4950 INPUT PAUSE$
4960 PRINT "ADDITIVE AND MULTIPLICATIVE SEASONALITY"
4970 PRINT "--------------------------------------------"
4980 PRINT "THIS PROGRAM SUPPORTS TWO TYPES OF SEASONALITY:"
4990 PRINT "  - ADDITIVE: SEASONAL EFFECT IS CONSTANT OVER TIME"
5000 PRINT "  - MULTIPLICATIVE: SEASONAL EFFECT GROWS OR SHRINKS"
5010 PRINT "IN THE BEGINNING, YOU WILL BE ASKED TO SELECT EITHER"
5020 PRINT "'A' FOR ADDITIVE OR 'M' FOR MULTIPLICATIVE SEASONALITY."
5030 PRINT "THIS CHOICE DETERMINES HOW FORECASTS ARE CALCULATED."
5040 PRINT "--------------------------------------------"
5050 PRINT
5060 PRINT "PRESS ENTER TO RETURN."
5070 INPUT PAUSE$
5080 RETURN
5090 PRINT "WHEN TO USE HOLT-WINTERS"
5100 PRINT "--------------------------------------------"
5110 PRINT "HOLT-WINTERS SHOULD BE USED WHEN YOUR DATA"
5120 PRINT "EXHIBITS BOTH TREND AND SEASONALITY. THIS"
5130 PRINT "METHOD IS IDEAL FOR TIME SERIES DATA WHERE"
5140 PRINT "SEASONAL PATTERNS AND TRENDS ARE EXPECTED"
5150 PRINT "TO CONTINUE. EXAMPLES INCLUDE:"
5160 PRINT " 1. MONTHLY SALES FIGURES"
5170 PRINT " 2. QUARTERLY REVENUE DATA"
5180 PRINT " 3. ANNUAL TEMPERATURE READINGS"
5190 PRINT "IT IS LESS SUITABLE FOR DATA WITHOUT CLEAR"
5200 PRINT "SEASONAL OR TREND COMPONENTS."
5210 PRINT
5220 PRINT "PRESS ENTER TO RETURN."
5230 INPUT PAUSE$
5240 RETURN
5250 PRINT "STATISTICS DETAILS"
5260 PRINT "--------------------------------------------"
5270 PRINT "MPE: MEAN PERCENTAGE ERROR"
5280 PRINT " - MEASURES AVERAGE PERCENTAGE ERROR."
5290 PRINT " - INDICATES WHETHER FORECASTS ARE"
5300 PRINT "   CONSISTENTLY TOO HIGH OR LOW."
5310 PRINT
5320 PRINT "MAPE: MEAN ABSOLUTE PERCENTAGE ERROR"
5330 PRINT " - AVERAGE OF ABSOLUTE PERCENTAGE ERRORS."
5340 PRINT " - USEFUL FOR COMPARING FORECAST ACCURACY"
5350 PRINT "   ACROSS DIFFERENT DATASETS."
5360 PRINT
5370 PRINT "PRESS ENTER FOR MORE DETAILS."
5380 INPUT PAUSE$
5390 PRINT "--------------------------------------------"
5400 PRINT "RMSE: ROOT MEAN SQUARED ERROR"
5410 PRINT " - MEASURES THE SQUARE ROOT OF THE AVERAGE"
5420 PRINT "   OF SQUARED ERRORS."
5430 PRINT " - INDICATES THE SPREAD OF FORECAST ERRORS."
5440 PRINT
5450 PRINT "MAE: MEAN ABSOLUTE ERROR"
5460 PRINT " - AVERAGE OF ABSOLUTE ERRORS."
5470 PRINT " - SHOWS THE AVERAGE MAGNITUDE OF ERRORS"
5480 PRINT "   WITHOUT CONSIDERING THEIR DIRECTION."
5490 PRINT
5500 PRINT "PRESS ENTER FOR MORE DETAILS."
5510 INPUT PAUSE$
5520 PRINT "--------------------------------------------"
5530 PRINT "DURBIN-WATSON: AUTOCORRELATION TEST"
5540 PRINT " - TESTS FOR AUTOCORRELATION IN RESIDUALS"
5550 PRINT "   FROM A REGRESSION ANALYSIS."
5560 PRINT " - VALUES CLOSE TO 2 SUGGEST NO AUTOCORREL."
5570 PRINT
5580 PRINT "LJUNG-BOX Q: AUTOCORRELATION TEST"
5590 PRINT " - TESTS FOR PRESENCE OF AUTOCORRELATION"
5600 PRINT "   IN TIME SERIES DATA."
5610 PRINT " - SIGNIFICANT Q INDICATES NON-RANDOMNESS."
5620 PRINT
5630 PRINT "PRESS ENTER TO RETURN."
5640 INPUT PAUSE$
5650 RETURN
5660 REM === DEBUG MODE SUBROUTINE ===
5670 PRINT : PRINT ">>> DEBUG MODE ENABLED - POPULATING TEST DATA <<<"
5680 MODELTYPE = 1  ' 1 FOR ADDITIVE, 2 FOR MULTIPLICATIVE
5690 N = 24
5700 H = 6
5710 TRAINSIZE = N - H
5720 DIM Y(400), F(400), S(400), T(400), C(400), U(400), L(400), E(400), ACFY(200), ACFRES(200)
5730 FOR I = 1 TO N
5740 Y(I) = 100 + 10 * SIN(2 * 3.14 * I / 12) + .5 * I  ' SIMPLE SEASONAL TREND WITH NOISE
5750 NEXT I
5760 PRINT "MODEL TYPE: ADDITIVE"
5770 PRINT "DATA POINTS LOADED: "; N
5780 PRINT "FORECAST HORIZON: "; H
5790 PRINT "DEBUG DATA LOADED SUCCESSFULLY"
5800 PRINT "NOW JUMPING TO MAIN FORECAST ROUTINE. PLEASE BE PATIENT..."
5810 RETURN
