10 PRINT  "********************************************"
20 PRINT  "*                                          *"
30 PRINT  "*   LUNARCALC ASTRONOMY TOOL (MBASIC-80)   *"
40 PRINT  "*             VERSION 1.0 2025             *"
50 PRINT  "*                                          *"
60 PRINT  "*  PHASE - ILLUMINATION - RISE/SET TIMES   *"
70 PRINT  "*                                          *"
80 PRINT  "*    WRITTEN BY C. VAN DER KAAY, PH.D.     *"
90 PRINT  "*                                          *"
100 PRINT "********************************************"
110 PRINT
120 PRINT "NOTE: SOME CALCULATIONS MAY TAKE TIME DEPENDING"
130 PRINT "      ON SYSTEM SPEED."
140 PRINT
150 PRINT "THIS PROGRAM IS DESIGNED FOR ASTRONOMICAL USE"
160 PRINT "AND REQUIRES ACCURATE DATE, TIME, AND LOCATION."
170 PRINT: PRINT "PRESS RETURN TO CONTINUE"; : INPUT DUMMY$
180 REM *** CONSTANT DEFINITIONS ***
190 REM *** DEFAULT VARIABLES TO DOUBLE PRECISION EXCEPT FOR I ***
200 DEFDBL A-H, J-Z
210 REM *** REM RAD = PI / 180 CONVERTS DEGREES TO RADIANS FOR TRIG FUNCTIONS ***
220 RAD = 1.745329E-02
230 REM *** NEW MOON ON 1/6/2000 18:14 UTC START OF LUNATION 0 ***
240 BASEJD = 2451550.1# 
250 REM *** MEAN SYNODIC MONTH (DAYS) MOST RECENT JPL AVERAGE ***
260 SYN = 29.530588861#   
270 REM *** TIME STEP PER ITERATION = 0.00001 DAYS (APPROX 0.864 SECONDS) ***
280 STEP1 = .00001#
290 REM *** DEFAULT DELTA-T IF PROGRAM CANNOT FIND ESTIMATE ***
300 DTSEC = 68
310 REM *** EPSILON VALUE TO AVOID ROUNDING ERRORS IN FLOATING-POINT PHASE COMPARISONS ***
320 EPS = .001#
330 REM *** FOR EARLY EXIT (0.01B0) LINE 3980 ***
340 EXITTOL = 100
350 REM *** MAX ELONGATION DELTA FOR PHASE MATCH (0.2 DEGREE = 2000 UNITS X10000 SCALE) ***
360 TOL = 1000
370 DIM MONTH$(12)
380 FOR I = 1 TO 12
390 READ MONTH$(I)
400 NEXT I
410 DATA "JAN", "FEB", "MAR", "APR", "MAY", "JUN"
420 DATA "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"
430 REM *** USER INPUT ***
440 PRINT "INPUT YEAR (1583 OR GREATER)"; : INPUT Y
450 IF Y < 1583 THEN PRINT "YEAR MUST BE 1583 OR GREATER": GOTO 440
460 PRINT "ENTER MONTH (1-12):"; : INPUT M
470 IF M < 1 THEN PRINT "INVALID MONTH. TRY AGAIN.": GOTO 460
480 IF M > 12 THEN PRINT "INVALID MONTH. TRY AGAIN.": GOTO 460
490 PRINT "ENTER DAY (1-31):"; : INPUT DY
500 IF DY < 1 THEN PRINT "INVALID DAY. TRY AGAIN.": GOTO 490
510 IF DY > 31 THEN PRINT "INVALID DAY. TRY AGAIN.": GOTO 490
520 GOSUB 2770
530 PRINT "NOTE: USE 24-HOUR FORMAT (E.G., 2:00 PM = 14)"
540 PRINT "ENTER HOUR (UTC, 0 TO 23):"; : INPUT HOUR
550 IF HOUR < 0 THEN PRINT "INVALID HOUR. TRY AGAIN.": GOTO 540
560 IF HOUR > 23 THEN PRINT "INVALID HOUR. TRY AGAIN.": GOTO 540
570 PRINT "ENTER MINUTE (UTC, 0 TO 59):"; : INPUT MN
580 IF MN < 0 THEN PRINT "INVALID MINUTE. TRY AGAIN.": GOTO 570
590 IF MN > 59 THEN PRINT "INVALID MINUTE. TRY AGAIN.": GOTO 570
600 IF Y < 1600 THEN PRINT: PRINT "WARNING: DELTA-T ESTIMATE OUTSIDE SUPPORTED RANGE (1600b 2100)."
610 IF Y > 2100 THEN PRINT "NOTE: HIGH YEAR; DELTA-T MODEL MAY BE INACCURATE."
620 GOSUB 2920
630 PRINT "ESTIMATED DELTA-T: "; INT(DTSEC * 10 + .5) / 10; " SECONDS"
640 DT = DTSEC / 86400!
650 Y0 = Y: M0 = M: D0 = DY
660 REM *** CONVERT DELTA-T TO DAYS ***
670 PRINT "ENTER LATITUDE (DECIMAL DEGREES, NORTH=POSITIVE, SOUTH=NEGATIVE):"; : INPUT LAT
680 IF LAT < -90 THEN PRINT "INVALID LATITUDE. TRY AGAIN.": GOTO 670
690 IF LAT > 90 THEN PRINT "INVALID LATITUDE. TRY AGAIN.": GOTO 670
700 REM *** VALIDATE LATITUDE RANGE ***
710 PRINT "ENTER LONGITUDE (DECIMAL DEGREES, EAST=POSITIVE, WEST=NEGATIVE):"; : INPUT LON
720 IF LON < -180 THEN PRINT "INVALID LONGITUDE. TRY AGAIN.": GOTO 710
730 IF LON > 180 THEN PRINT "INVALID LONGITUDE. TRY AGAIN.": GOTO 710
740 REM *** CALL JULIAN DAY SUBROUTINE ***
750 YR = Y0: MO = M0: HR = HOUR: D1 = D0
760 GOSUB 4420
770 REM *** APPLY DELTA T (APPROX, IN DAYS) ***
780 JD = JD + DT
790 JDT = JD
800 JDINPUT = JD
810 AGE = JD - BASEJD
820 REM *** CALCULATE LUNAR AGE FROM REFERENCE ***
830 X = AGE / SYN
840 IF X >= 0 THEN CYCLE = INT(X): GOTO 870
850 CYCLE = -INT(-X)
860 REM *** MOON ELONGATION AND PHASE USING MEEUS APPROXIMATION ***
870 N = JD - 2451545!
880 G = 357.529# + .98560028# * N
890 G = G - INT(G / 360) * 360
900 IF G < 0 THEN G = G + 360
910 REM *** SUN'S MEAN LONGITUDE ***
920 LS = 280.459# + .98564736# * N
930 LS = LS - INT(LS / 360) * 360
940 IF LS < 0 THEN LS = LS + 360
950 LS = LS + 1.915# * SIN(G * RAD) + .02# * SIN(2# * G * RAD)
960 REM *** MOON'S MEAN ANOMALY ***
970 MM = 134.963# + 13.064993# * N
980 MM = MM - INT(MM / 360) * 360
990 IF MM < 0 THEN MM = MM + 360
1000 GOSUB 3310
1010 REM *** MOON'S MEAN LONGITUDE ***
1020 LM = 218.316# + 13.176396# * N
1030 LM = LM - INT(LM / 360) * 360
1040 IF LM < 0 THEN LM = LM + 360
1050 ELONG = LM - LS
1060 IF ELONG < 0 THEN ELONG = ELONG + 360
1070 REM *** ENSURE ELONGATION STAYS IN 0b 360 RANGE DUE TO FP ROUNDING ***
1080 REM *** NORMALIZE ANGULAR DISTANCE D ***
1090 IF ELONG > 360 THEN ELONG = ELONG - INT(ELONG / 360) * 360
1100 REM *** ILLUMINATION USING ELONGATION D ***
1110 COSI = COS(ELONG * RAD)
1120 K = (1# - COSI) / 2#
1130 REM *** MOON PERCENT ILLUMINATED ***
1140 ILL = K * 100
1150 REM *** DISPLAY RESULTS: MOON PHASE & ILLUMINATION ***
1160 AG = AGE - CYCLE * SYN
1170 IF AG < 0 THEN AG = AG + SYN
1180 IF AG >= SYN THEN AG = AG - SYN
1190 IF AG > -.001# THEN IF AG < 1# + EPS THEN PH$ = "NEW MOON": GOTO 1280
1200 IF AG >= 1 THEN IF AG < 6 + EPS THEN PH$ = "WAXING CRESCENT": GOTO 1280
1210 IF AG >= 6 THEN IF AG < 8 + EPS THEN PH$ = "FIRST QUARTER": GOTO 1280
1220 IF AG >= 8 THEN IF AG < 13 + EPS THEN PH$ = "WAXING GIBBOUS": GOTO 1280
1230 IF AG >= 13 THEN IF AG < 16 + EPS THEN PH$ = "FULL MOON": GOTO 1280
1240 IF AG >= 16 THEN IF AG < 22 + EPS THEN PH$ = "WANING GIBBOUS": GOTO 1280
1250 IF AG >= 22 THEN IF AG < 24 + EPS  THEN PH$ = "LAST QUARTER": GOTO 1280
1260 IF AG >= 24 THEN IF AG < SYN + EPS THEN PH$ = "WANING CRESCENT": GOTO 1280
1270 PH$ = "NEW MOON"
1280 PRINT "******************************************************************"
1290 PRINT "*  THIS ROUTINE ADVANCES TIME IN SMALL INCREMENTS (0.864 SECONDS)*"
1300 PRINT "*  OR 0.00001 DAYS PER STEP, TO LOCATE PRECISE LUNAR PHASES.     *"
1310 PRINT "*                                                                *"
1320 PRINT "*  THE MEAN SYNODIC MONTH IS APPROX. 29.5306 DAYS.               *"
1330 PRINT "*  - NEW MOON:    MOON'S ELONGATION APPROX. 0 DEGREES            *"
1340 PRINT "*  - FULL MOON:   MOON'S ELONGATION APPROX 180 DEGREES           *"
1350 PRINT "*                                                                *"
1360 PRINT "*  THE PROGRAM EVALUATES THE MOON'S ELONGATION IN EACH STEP AND  *"
1370 PRINT "*  IDENTIFIES THE MOMENT THAT MATCHES THE TARGET PHASE ANGLE.    *"
1380 PRINT "*  TOLERANCE IS APPROXIMATELY +/-0.1 DEGREES OR +/-6 ARCMINUTES  *"
1390 PRINT "*                                                                *"
1400 PRINT "*  DURING SEARCH, PROGRESS CHECKPOINTS WILL BE DISPLAYED:        *"
1410 PRINT "*     - JULIAN DATE (ASTRONOMICAL TIME SCALE)                    *"
1420 PRINT "*     - LUNAR AGE IN DAYS SINCE LAST NEW MOON                    *"
1430 PRINT "*     - ANGULAR DISTANCE FROM TARGET ELONGATION (IN DEGREES)     *"
1440 PRINT "*                                                                *"
1450 PRINT "*  WHEN A CLOSE MATCH IS FOUND, THE PROGRAM WILL DISPLAY THE     *"
1460 PRINT "*  EXACT TIME OF THE PHASE TRANSITION IN UTC.                    *"
1470 PRINT "******************************************************************"
1480 PRINT: INPUT "==> PRESS RETURN TO BEGIN SEARCH."; DUMMY$
1490 REM *** NEXT FULL MOON SEARCH ***
1500 DELTA = 0 : EGOAL = 180
1510 REM *** SKIP SEARCH IF ALREADY AT FULL MOON WITHIN B10.05 DEG OR 3 ARCMINUTES ***
1520 IF ABS(ELONG - 180) < .05 THEN JDRESULT = JDINPUT: GOTO 1630
1530 REM *** ROBUST FULL MOON SEARCH START b  CENTERED IN LUNATION ***
1540 IF AG < SYN / 2# THEN JDSTART = JDINPUT + (SYN / 2# - AG) ELSE JDSTART = JDINPUT + (SYN + SYN / 2# - AG)
1550 PRINT: PRINT "SEARCH STARTS AT JD="; JDSTART
1560 PRINT: PRINT "ENTERING FULL MOON SEARCH LOOP (BY ELONGATION)..."; JDSTART
1570 PRINT: PRINT "MATCH TOLERANCE SET TO +/-"; TOL / 10000; " DEGREES"
1580 GOSUB 3740
1590 JDFULL = JDRESULT
1600 JDCONV = JDFULL
1610 IF JDRESULT = -1 THEN PRINT: PRINT "ERROR! FULL MOON NOT FOUND IN SEARCH RANGE.": GOTO 2570
1620 GOSUB 3070
1630 FMY = YOUT: FMM = MOUT: FMD = DOUT: FMH = HOUT: FMMIN = MINOUT
1640 REM *** NEXT NEW MOON SEARCH ***
1650 EGOAL = 0
1660 JDRESULT = -1
1670 PRINT: PRINT "NEXT FULL MOON (UTC): "; MONTH$(FMM); " "; FMD; ", "; FMY; " AT "; FMH; " H : "; INT(FMMIN); " M : "; INT(FMS * 100 + .5) / 100; " S"
1680 PRINT: PRINT "ENTERING NEW MOON SEARCH LOOP (BY ELONGATION)..."
1690 PRINT: PRINT "LUNAR AGE USED TO COMPUTE JDSTART = "; AG
1700 IF ABS(ELONG - 0) < .1 THEN JDSTART = JDINPUT - .05: GOTO 1730
1710 IF AG < 1 THEN JDSTART = JDINPUT + .01: GOTO 1730
1720 JDSTART = JDINPUT + (SYN - AG) - 1
1730 PRINT: PRINT "NEW MOON SEARCH STARTS AT JDSTART = "; JDSTART
1740 JDRESULT = -1
1750 GOSUB 3740
1760 JDNEW = JDRESULT: JDCONV = JDRESULT
1770 JDCONV = JDNEW
1780 IF JDRESULT = -1 THEN PRINT: PRINT "ERROR! NEW MOON NOT FOUND IN SEARCH RANGE.": GOTO 2570
1790 GOSUB 3070
1800 NMY = YOUT: NMM = MOUT: NMD = DOUT: NMH = HOUT: NMMIN = MINOUT
1810 REM *** SOLAR DECLINATION FOR SUNRISE/SUNSET ***
1820 N = JD - 2451545!
1830 GS = 357.529 + .98560028# * N
1840 GS = GS - INT(GS / 360) * 360
1850 E = -7.655# * SIN(GS * RAD) + 9.873# * SIN(2# * GS * RAD + 3.588#)
1860 IF ABS(E) > 20 THEN PRINT "WARNING! EQUATION OF TIME UNUSUALLY LARGE: "; E
1870 L = 280.459# + .98564736# * N
1880 L = L - INT(L / 360) * 360
1890 G = 357.529# + .98560028# * N
1900 G = G - INT(G / 360) * 360
1910 IF G < 0 THEN G = G + 360
1920 LAMBDA = L + 1.915# * SIN(G * RAD) + .02# * SIN(2# * G * RAD)
1930 REM *** DECLINATION FROM LAMBDA
1940 SINDECL = .39779# * SIN(LAMBDA * RAD)
1950 TEMP = SINDECL
1960 IF TEMP < -1 THEN TEMP = -1
1970 IF TEMP > 1 THEN TEMP = 1
1980 REM *** COMPUTE DECLINATION IN DEGREES
1990 DECL = ATN(TEMP / SQR(1# - TEMP * TEMP)) / RAD
2000 REM *** SUNRISE/SUNSET HOUR ANGLE (H0)
2010 NOON = 12 - (LON / 15) - E / 60
2020 COSH0 = (COS(90.833# * RAD) - SIN(LAT * RAD) * SIN(DECL * RAD)) / (COS(LAT * RAD) * COS(DECL * RAD))
2030 REM *** CHECK FOR POLAR DAY/NIGHT CONDITIONS BEFORE CLIPPING ***
2040 IF COSH0 > 1 THEN PRINT: PRINT "SUN NEVER RISES TODAY.": GOTO 2650
2050 IF COSH0 < -1 THEN PRINT: PRINT "SUN NEVER SETS TODAY.": GOTO 2650
2060 TEMP = COSH0
2070 IF TEMP < -1 THEN TEMP = -1
2080 IF TEMP > 1 THEN TEMP = 1
2090 IF TEMP = 0 THEN H0 = 90: GOTO 2120
2100 TEMP1 = TEMP
2110 IF TEMP1 < 0 THEN TEMP1 = -TEMP1
2120 H0 = ATN(SQR(1 - TEMP * TEMP) / TEMP1) / RAD
2130 IF TEMP < 0 THEN H0 = 180 - H0
2140 IF H0 < 0 THEN H0 = 0
2150 IF H0 > 180 THEN H0 = 180
2160 REM *** SUNRISE AND SUNSET (APPROX, UTC) ***
2170 IF NOON < 0 THEN NOON = NOON + 24
2180 RAWRISE = NOON - H0 / 15
2190 RAWSET = NOON + H0 / 15
2200 IF RAWRISE < 0 THEN RAWRISE = RAWRISE + 24
2210 IF RAWSET >= 24 THEN RAWSET = RAWSET - 24
2220 IF RAWSET < RAWRISE THEN SETNEXTDAY = 1: GOTO 2240
2230 SETNEXTDAY = 0
2240 SUNRISE = RAWRISE
2250 SUNSET = RAWSET
2260 TSUNRISE = SUNRISE
2270 IF TSUNRISE < 0 THEN TSUNRISE = TSUNRISE + 24
2280 IF TSUNRISE >= 24 THEN TSUNRISE = TSUNRISE - 24
2290 TSUNSET = SUNSET
2300 REM *** COMPUTE SUNRISE HOUR AND MINUTE ***
2310 H1 = INT(TSUNRISE)
2320 MIN1 = (TSUNRISE - H1) * 60
2330 IF MIN1 = 60 THEN MIN1 = 0: H1 = H1 + 1
2340 IF H1 = 24 THEN H1 = 0
2350 REM *** COMPUTE SUNSET HOUR AND MINUTE ***
2360 H2 = INT(TSUNSET)
2370 MIN2 = (TSUNSET - H2) * 60
2380 IF MIN2 = 60 THEN MIN2 = 0: H2 = H2 + 1
2390 IF H2 = 24 THEN H2 = 0
2400 REM *** DISPLAY RESULTS ***
2410 PRINT: PRINT "********************************************"
2420 PRINT "MOON AGE:             "; INT(AG * 100 + .5) / 100; " DAYS"
2430 PRINT "ILLUMINATION:         "; INT(ILL * 100 + .5) / 100; "%"
2440 PRINT "PHASE:                "; PH$
2450 FMS = (FMMIN - INT(FMMIN)) * 60
2460 NMS = (NMMIN - INT(NMMIN)) * 60
2470 PRINT "NEXT FULL MOON (UTC): "; MONTH$(FMM); " "; FMD; ", "; FMY; " AT "; FMH; " H : "; INT(FMMIN); " M : "; INT(FMS * 100 + .5) / 100; " S"
2480 PRINT "NEXT NEW  MOON (UTC): "; MONTH$(NMM); " "; NMD; ", "; NMY; " AT "; NMH; " H : "; INT(NMMIN); " M : "; INT(NMS * 100 + .5) / 100; " S"
2490 GOSUB 3310
2500 PRINT "MOON DISTANCE:        "; MDIST; " KM"
2510 PRINT "********************************************"
2520 S1 = (MIN1 - INT(MIN1)) * 60
2530 S2 = (MIN2 - INT(MIN2)) * 60
2540 PRINT "SUNRISE (UTC):        "; H1; " H : "; INT(MIN1); " M : "; INT(S1 * 100 + .5) / 100; " S"
2550 PRINT "SUNSET  (UTC):        "; H2; " H : "; INT(MIN2); " M : "; INT(S2 * 100 + .5) / 100; " S"
2560 PRINT "********************************************"
2570 PRINT: INPUT "WOULD YOU LIKE TO PERFORM ANOTHER CALCULATION? (Y/N): ", A$
2580 IF A$ = "Y" THEN GOTO 10
2590 IF A$ = "N" THEN GOTO 2620
2600 PRINT "INVALID RESPONSE. PLEASE ENTER 'Y' OR 'N'."
2610 GOTO 2570
2620 PRINT: PRINT "THANK YOU FOR USING THE MOONCALC ASTRONOMY TOOL!"
2630 PRINT "PROGRAM BY: CHRISTOPHER D. VAN DER KAAY, PH.D."
2640 END
2650 REM *** DISPLAY LIMITED INFO IF SUN NEVER RISES/SETS ***
2660 PRINT: PRINT "********************************************"
2670 PRINT "MOON AGE:             "; INT(AG * 100 + .5) / 100; " DAYS"
2680 PRINT "ILLUMINATION:         "; INT(ILL * 100 + .5) / 100; "%"
2690 PRINT "PHASE:                "; PH$
2700 FMS = (FMMIN - INT(FMMIN)) * 60
2710 NMS = (NMMIN - INT(NMMIN)) * 60
2720 PRINT "NEXT FULL MOON (UTC): "; MONTH$(FMM); " "; FMD; ", "; FMY; " AT "; FMH; " H : "; INT(FMMIN); " M : "; INT(FMS * 100 + .5) / 100; " S"
2730 PRINT "NEXT NEW  MOON (UTC): "; MONTH$(NMM); " "; NMD; ", "; NMY; " AT "; NMH; " H : "; INT(NMMIN); " M : "; INT(NMS * 100 + .5) / 100; " S"
2740 PRINT "MOON DISTANCE:        "; MDIST; " KM"
2750 PRINT "********************************************"
2760 GOTO 2570
2770 REM *** VALIDATE DAY BY MONTH AND LEAP YEAR ***
2780 IF M = 4 THEN IF DY > 30 THEN PRINT "THIS MONTH HAS ONLY 30 DAYS. TRY AGAIN.": GOTO 490
2790 IF M = 6 THEN IF DY > 30 THEN PRINT "THIS MONTH HAS ONLY 30 DAYS. TRY AGAIN.": GOTO 490
2800 IF M = 9 THEN IF DY > 30 THEN PRINT "THIS MONTH HAS ONLY 30 DAYS. TRY AGAIN.": GOTO 490
2810 IF M = 11 THEN IF DY > 30 THEN PRINT "THIS MONTH HAS ONLY 30 DAYS. TRY AGAIN.": GOTO 490
2820 IF M = 2 THEN GOSUB 2840
2830 RETURN
2840 REM *** LEAP YEAR CHECK FOR FEBRUARY ***
2850 LEAP = 0
2860 IF INT(Y / 4) * 4 = Y THEN LEAP = 1
2870 IF Y - INT(Y / 100) * 100 = 0 THEN LEAP = 0
2880 IF Y - INT(Y / 400) * 400 = 0 THEN LEAP = 1
2890 IF LEAP = 1 THEN IF DY > 29 THEN PRINT "FEBRUARY HAS ONLY 29 DAYS IN LEAP YEARS. TRY AGAIN.": GOTO 490
2900 IF LEAP = 0 THEN IF DY > 28 THEN PRINT "FEBRUARY HAS ONLY 28 DAYS. TRY AGAIN.": GOTO 490
2910 RETURN
2920 REM *** DELTA-T ESTIMATION ***
2930 IF Y >= 2000 AND Y <= 2100 THEN T = (Y - 2000) / 100#: DTSEC = 62.92# + .32217# * T * T + .005589# * T * T * T * T: GOTO 3020
2940 IF Y >= 1900 AND Y < 2000 THEN T = Y - 1900: GOTO 2990
2950 IF Y >= 1800 AND Y < 1900 THEN T = Y - 1800: GOTO 3000
2960 IF Y >= 1600 AND Y < 1800 THEN T = Y - 1600: GOTO 3010
2970 PRINT: PRINT "WARNING! DELTA-T ESTIMATE OUTSIDE MODEL RANGE. USING DEFAULT DTSEC = ";DTSEC
2980 GOTO 3020
2990 DTSEC = -2.79# + 1.494119# * T - .0598939# * T * T + .0061966# * T * T * T: GOTO 3020
3000 DTSEC = 13.72# - .332447# * T + .0068612# * T * T + .0041116# * T * T * T: GOTO 3020
3010 DTSEC = 120# - .9808# * T - .01532# * T * T + T * T * T / 7129#
3020 RETURN
3030 REM *** WARNING FOR YEARS OUTSIDE MODEL RANGE ***
3040 IF Y < 1600 THEN PRINT: PRINT "DELTA-T ESTIMATE OUTSIDE MODEL RANGE. USING DEFAULT DTSEC = "; DTSEC: GOTO 3060
3050 IF Y > 2100 THEN PRINT: PRINT "DELTA-T ESTIMATE OUTSIDE MODEL RANGE. USING DEFAULT DTSEC = "; DTSEC: GOTO 3060
3060 RETURN
3070 REM *** CONVERT JULIAN DAY (JDCONV) TO CALENDAR DATE ND$ ***
3080 Z0 = INT(JDCONV)
3090 F0 = JDCONV - Z0
3100 IF Z0 < 2299161! THEN A0 = Z0: GOTO 3130
3110 ALPHA = INT((Z0 - 1867216.25#) / 36524.25#)
3120 A0 = Z0 + 1# + ALPHA - INT(ALPHA / 4#)
3130 B0 = A0 + 1524#
3140 C0 = INT((B0 - 122.1#) / 365.25#)
3150 D0 = INT(365.25# * C0)
3160 E0 = INT((B0 - D0) / 30.6001#)
3170 DAY1 = B0 - D0 - INT(30.6001# * E0) + F0
3180 IF E0 < 14 THEN M1 = E0 - 1: GOTO 3200
3190 M1 = E0 - 13
3200 IF M1 > 2 THEN Y1 = C0 - 4716: GOTO 3220
3210 Y1 = C0 - 4715
3220 DD = INT(DAY1)
3230 FRAC = DAY1 - DD
3240 HOURS = F0 * 24
3250 HH1 = INT(HOURS)
3260 MIN1 = (HOURS - HH1) * 60
3270 IF HH1 = 24 THEN HH1 = 0
3280 YOUT = Y1: MOUT = M1: DOUT = DD
3290 HOUT = HH1: MINOUT = MIN1
3300 RETURN
3310 REM *** COMPUTE MOON RA/DEC APPROXIMATIONS ***
3320 TLOC = JDT - 2451545!
3330 L0 = 218.316# + 13.176396# * TLOC
3340 L0 = L0 - INT(L0 / 360) * 360
3350 IF L0 < 0 THEN L0 = L0 + 360
3360 MMLOC = 134.963# + 13.064993# * TLOC
3370 MMLOC = MMLOC - INT(MMLOC / 360) * 360
3380 IF MMLOC < 0 THEN MMLOC = MMLOC + 360
3390 IF MMLOC >= 360 THEN MMLOC = MMLOC - 360
3400 FLOC = 93.27201# + 13.22935# * TLOC
3410 FLOC = FLOC - INT(FLOC / 360) * 360
3420 IF FLOC < 0 THEN FLOC = FLOC + 360
3430 LAMLCL = L0 + 6.289# * SIN(MMLOC * RAD)
3440 BETA = 5.128# * SIN(FLOC * RAD)
3450 REM *** COMPUTE APPROXIMATE MOON DISTANCE ***
3460 REM *** RECOMPUTE SUN'S APPARENT LONGITUDE (LSLOCAL) FOR CURRENT JDT ***
3470 GLOC = 357.529# + .98560028# * TLOC
3480 GLOC = GLOC - INT(GLOC / 360) * 360
3490 IF GLOC < 0 THEN GLOC = GLOC + 360
3500 LSTMP = 280.459# + .98564736# * TLOC
3510 LSTMP = LSTMP - INT(LSTMP / 360) * 360
3520 IF LSTMP < 0 THEN LSTMP = LSTMP + 360
3530 LSTMP = LSTMP + 1.915# * SIN(GLOC * RAD) + .02# * SIN(2# * GLOC * RAD)
3540 LSLOCAL = LSTMP
3550 DELTA = L0 - LSLOCAL
3560 IF DELTA < 0 THEN DELTA = DELTA + 360
3570 DELTA = DELTA * RAD
3580 T1 = COS(MMLOC * RAD)
3590 T2 = COS(2 * DELTA)
3600 T3 = COS(2 * DELTA - MMLOC * RAD)
3610 T4 = COS(2 * DELTA + MMLOC * RAD)
3620 MRADKM = 385000.56#
3630 MRADKM = MRADKM - 20905.355# * T1
3640 MRADKM = MRADKM - 3699.111# * T2
3650 MRADKM = MRADKM - 2955.968# * T3
3660 MRADKM = MRADKM - 569.925# * T4
3670 MDIST = INT(MRADKM + .5)
3680 REM *** PASS LAMLCL AND BETA TO ALTITUDE CALCULATION ***
3690 LAMBDA = LAMLCL
3700 RETURN
3710 REM *** ANGLE NORMALIZATION BELOW MUST USE INT() TO AVOID FP ROUNDING ERRORS ***
3720 REM *** DO NOT USE (X / 360) * 360 WITH DOUBLE PRECISION VARIABLES             ***
3730 REM *** THIS ENSURES PHASE MATCHES (E.G., FULL MOON AT 180 DEG) FUNCTION PROPERLY ***
3740 REM *** SUBROUTINE TO FIND NEXT LUNAR PHASE BY ELONGATION ***
3750 JDRESULT = -1
3760 DELTAMIN = 9999999!
3770 JDNEAR = -1
3780 FOR I = 0 TO 1800000!
3790 JD1 = JDSTART + I * STEP1
3800 N1 = JD1 - 2451545!
3810 G1 = 357.529# + .98560028# * N1
3820 G1 = G1 - INT(G1 / 360) * 360
3830 IF G1 < 0 THEN G1 = G1 + 360
3840 LS1 = 280.459# + .98564736# * N1
3850 LS1 = LS1 - INT(LS1 / 360) * 360
3860 IF LS1 < 0 THEN LS1 = LS1 + 360
3870 LS1 = LS1 + 1.915# * SIN(G1 * RAD) + .02# * SIN(2# * G1 * RAD)
3880 MM1 = 134.963# + 13.064993# * N1
3890 MM1 = MM1 - INT(MM1 / 360) * 360
3900 IF MM1 < 0 THEN MM1 = MM1 + 360
3910 LM1 = 218.316# + 13.176396# * N1 + 6.289# * SIN(MM1 * RAD)
3920 LM1 = LM1 - INT(LM1 / 360) * 360
3930 IF LM1 < 0 THEN LM1 = LM1 + 360
3940 ELONG = LM1 - LS1
3950 IF ELONG < 0 THEN ELONG = ELONG + 360
3960 IF ELONG < 0 OR ELONG > 360 THEN PRINT "WARNING! ELONG OUT OF BOUNDS = "; ELONG
3970 ELONGI = ELONG
3980 EGOALI = EGOAL
3990 DELTAEI = ABS(ELONGI - EGOALI)
4000 IF DELTAEI > 1800000! THEN DELTAEI = 3600000! - DELTAEI
4010 IF INT(I / 1000) = I / 1000 THEN PRINT "STEP "; I; " JD="; JD1; " ELONG="; ELONG; " DELTA="; DELTAEI
4020 IF DELTAEI < DELTAMIN THEN PRINT "BETTER MATCH FOUND AT JD="; JD1; " ELONG="; ELONG; " DELTAEI="; DELTAEI
4030 IF DELTAEI < DELTAMIN THEN DELTAMIN = DELTAEI: JDNEAR = JD1
4040 REM *** IMMEDIATE EXIT IF ELONGATION DELTA < 0.01 DEGREE ***
4050 IF DELTAEI < EXITTOL THEN JDRESULT = JD1: GOTO 4080
4060 REM *** ALWAYS TRACK BEST MATCH ***
4070 NEXT I
4080 REM *** FINAL DELTA VALIDATION ***
4090 JDRESULT = JDNEAR
4100 N3 = JDRESULT - 2451545!
4110 G3 = 357.529# + .98560028# * N3
4120 G3 = G3 - INT(G3 / 360) * 360
4130 IF G3 < 0 THEN G3 = G3 + 360
4140 LS3 = 280.459# + .98564736# * N3
4150 LS3 = LS3 - INT(LS3 / 360) * 360
4160 IF LS3 < 0 THEN LS3 = LS3 + 360
4170 LS3 = LS3 + 1.915# * SIN(G3 * RAD) + .02# * SIN(2# * G3 * RAD)
4180 MM3 = 134.963# + 13.064993# * N3
4190 MM3 = MM3 - INT(MM3 / 360) * 360
4200 IF MM3 < 0 THEN MM3 = MM3 + 360
4210 LM3 = 218.316# + 13.176396# * N3 + 6.289# * SIN(MM3 * RAD)
4220 LM3 = LM3 - INT(LM3 / 360) * 360
4230 IF LM3 < 0 THEN LM3 = LM3 + 360
4240 ELONG3 = LM3 - LS3
4250 IF ELONG3 < 0 THEN ELONG3 = ELONG3 + 360
4260 IF ELONG3 >= 360 THEN ELONG3 = ELONG3 - 360
4270 ELONGI = INT(ELONG3 * 10000! + .5)
4280 EGOALI = INT(EGOAL * 10000! + .5)
4290 FINALDELTA = ABS(ELONGI - EGOALI)
4300 IF FINALDELTA > 1800000! THEN FINALDELTA = 3600000! - FINALDELTA
4310 PRINT "FINAL ELONGATION MATCH DELTA: "; FINALDELTA / 10000
4320 DELTA = FINALDELTA
4330 PRINT "BEST MATCH FOUND AT JD="; JDNEAR; " BEFORE FINAL VALIDATION"
4340 REM *** NEVER DISCARD RESULT BASED ON FINALDELTA ***
4350 PRINT "FINAL JDRESULT="; JDRESULT; " FOR EGOAL="; EGOAL
4360 IF FINALDELTA > TOL THEN PRINT "WARNING! FINAL DELTA ABOVE "; TOL / 10000; " DEGREE: "; FINALDELTA / 10000
4370 IF FINALDELTA > 10000 AND FINALDELTA <= 18000 THEN IF EGOAL = 180 THEN PRINT "MATCH IS ACCEPTABLE BUT ABOVE 1 DEGREE."
4380 IF FINALDELTA > 10000 AND FINALDELTA <= 18000 THEN IF EGOAL = 0 THEN PRINT "MATCH IS ACCEPTABLE BUT ABOVE 1 DEGREE."
4390 IF FINALDELTA > 18000 THEN IF EGOAL = 180 THEN PRINT "MATCH MAY BE INACCURATE (DELTA > 1.8 DEGREE)."
4400 IF FINALDELTA > 18000 THEN IF EGOAL = 0 THEN PRINT "MATCH MAY BE INACCURATE (DELTA > 1.8 DEGREE)."
4410 RETURN
4420 REM *** JULIAN DAY CALCULATION SUBROUTINE ***
4430 IF MO <= 2 THEN Y1 = YR - 1: M1 = MO + 12: GOTO 4460
4440 IF MO > 2 THEN Y1 = YR: M1 = MO
4450 Y1 = YR: M1 = MO
4460 A = INT(Y1 / 100)
4470 IF YR > 1582 THEN B = 2 - A + INT(A / 4): GOTO 4510
4480 IF YR = 1582 THEN IF MO > 10 THEN B = 2 - A + INT(A / 4): GOTO 4510
4490 IF YR = 1582 THEN IF MO = 10 THEN IF DY >= 15 THEN B = 2 - A + INT(A / 4): GOTO 4510
4500 B = 0
4510 JD = INT(365.25# * (Y1 + 4716#)) + INT(30.6001# * (M1 + 1)) + DY + B - 1524.5# + (HR + MN / 60) / 24
4520 RETURN
