1   REM PROGRAM BY C. VAN DER KAAY (2023)
5   REM ********************************
10  REM * PROGRAM INITIALIZATION PHASE *
15  REM ********************************
20  REM CLEAR THE SCREEN ON START
25  PRINT CHR$(26)
30  REM POSITION AND PRINT THE TITLE IN THE CENTER (APPROXIMATELY)
35  PRINT CHR$(27) + "=" + CHR$(12) + CHR$(40); "PRIME NUMBER GENERATOR";
40  PRINT
45  PRINT CHR$(27) + "=" + CHR$(10) + CHR$(41); "WELCOME TO THE PRIME NUMBER GENERATOR!";
50  PRINT "* THIS PROGRAM IS TAILORED FOR THE KAYPRO II SYSTEM.";
55  PRINT "* USING THIS TOOL, YOU CAN FIND AND LIST PRIME NUMBERS";
60  PRINT "* WITHIN A SPECIFIED RANGE.";
65  PRINT "* BEGIN BY PROVIDING A STARTING AND ENDING VALUE. THE";
70  PRINT "* PROGRAM WILL THEN DISPLAY ALL THE PRIME NUMBERS WITHIN";
75  PRINT "* THAT INTERVAL. AFTER EXECUTION, YOU'LL RECEIVE SOME";
80  PRINT "* STATISTICAL DATA, LIKE THE TOTAL PRIMES FOUND,";
85  PRINT "* AND A COMPARISON TO THE TOTAL NUMBERS CHECKED.";
90  PRINT
95  PRINT "* NOW, PLEASE PROVIDE THE RANGE BELOW.";
100 REM PROMPT USER FOR THE RANGE OF PRIME SEARCH
105 REM POSITIONING CURSOR FOR "START" INPUT
109 PRINT CHR$(7)
110 PRINT CHR$(27) + "=" + CHR$(20) + CHR$(25); "FROM WHAT NUMBER DO YOU WANT TO START"
115 INPUT START
120 REM POSITIONING CURSOR FOR "END" INPUT
124 PRINT CHR$(7)
125 PRINT CHR$(27) + "=" + CHR$(22) + CHR$(25); "UP TO WHAT NUMBER DO YOU WANT TO GENERATE PRIMES"
130 INPUT N
135 REM ENSURE START IS AT LEAST 2, AS 1 IS NOT PRIME
140 IF START < 2 THEN START = 2
145 REM INITIALIZE PRIME COUNTER AND EFFORT COUNTER TO ZERO
150 PRIMECOUNT = 0
155 EFFORTCOUNT = 0
160 REM CLEAR PREVIOUS OUTPUTS BEFORE LISTING PRIMES
165 PRINT CHR$(23)
170 REM LOOP THROUGH EACH NUMBER FROM START TO N TO CHECK FOR PRIMALITY
175 FOR I = START TO N
180     REM ASSUME NUMBER IS PRIME AT START
185     PRIME = 1
190     ' OPTIMIZED PRIME CHECK: GO ONLY UP TO SQUARE ROOT
195     FOR J = 2 TO SQR(I)
200         REM INCREMENT EFFORT COUNTER
205         EFFORTCOUNT = EFFORTCOUNT + 1
210         REM RESET TEMP TO THE VALUE OF I
215         TEMP = I
220         REM SUBTRACT J FROM TEMP UNTIL TEMP < J TO FIND REMAINDER
225         WHILE TEMP >= J
230             TEMP = TEMP - J
235         WEND
240         REM IF REMAINDER IS ZERO, THE NUMBER IS NOT PRIME
245         IF TEMP = 0 THEN PRIME = 0: GOTO 265
250     NEXT J
255     REM IF NUMBER IS PRIME, PRINT IT AND INCREASE THE PRIME COUNTER
260     IF PRIME = 1 THEN PRINT I; " ";: PRIMECOUNT = PRIMECOUNT + 1
265 NEXT I
270 PRINT CHR$(7)
275 REM POSITIONING CURSOR FOR OUTPUT
280 PRINT CHR$(27) + "=" + CHR$(23) + CHR$(25);
285 PRINT "TOTAL NUMBERS CHECKED: "; N - START + 1
290 PRINT "TOTAL PRIMES FOUND: "; PRIMECOUNT
295 REM CALCULATE AND DISPLAY THE PERCENTAGE OF PRIMES IN THE RANGE
300 PRIMEPERCENT = (PRIMECOUNT / (N - START + 1)) * 100
305 PRINT "PERCENTAGE OF PRIME NUMBERS: "; PRIMEPERCENT; "%"
310 PRINT "CPU EFFORT (IN LOOP COUNTS): "; EFFORTCOUNT
315 REM PROMPT THE USER TO RESTART OR EXIT
320 REM POSITIONING CURSOR FOR RESTART QUERY
324 PRINT CHR$(7)
325 PRINT CHR$(27) + "=" + CHR$(25) + CHR$(25); "DO YOU WANT TO RESTART? (Y/N)"
330 INPUT ANSWER$
335 IF ANSWER$ = "Y" OR ANSWER$ = "Y" THEN PRINT CHR$(26): GOTO 25
340 REM END PROGRAM ELEGANTLY
345 PRINT CHR$(26)  ' CLEAR THE SCREEN
350 REM END OF THE PROGRAM
355 END
