5 REM *** PROGRAMMED BY C. VAN DER KAAY 6/2024 ***
10 RANDOMIZE
20 DIM UC$(100), CC$(100)
30 GOSUB 1000 ' DISPLAY INSTRUCTIONS
35 INPUT "CHOOSE DIFFICULTY (1=EASY, 2=MEDIUM, 3=HARD): ", DL
36 IF DL < 1 OR DL > 3 THEN PRINT "INVALID CHOICE! TRY AGAIN.": GOTO 35
40 GOSUB 7000 ' INITIALIZE GAME STATE
50 INPUT "HOW MANY ROUNDS WOULD YOU LIKE TO PLAY? ", TR
60 IF TR <= 0 THEN PRINT "PLEASE ENTER A POSITIVE NUMBER.": GOTO 50
61 IF TR > 100 THEN PRINT "MAXIMUM ROUNDS IS 100.": GOTO 50
70 US = 0
80 CS = 0
90 RC = 1
110 IF RC > TR THEN GOTO 200
120 IF INT(RND * 10) = 0 THEN PRINT "*** BONUS ROUND! POINTS ARE DOUBLED! ***": BR = 1: GOTO 125
121 BR = 0
125 REM CONTINUE
130 GOSUB 2000
140 IF PC$ = "X" THEN GOSUB 8000: GOTO 130
150 GOSUB 3000
160 GOSUB 4000
170 GOSUB 5000
180 RC = RC + 1
185 GOTO 110
200 GOSUB 6000 ' END GAME MESSAGE
210 INPUT "WOULD YOU LIKE TO VIEW THE STATISTICS (Y/N)? ", STATS$
220 IF STATS$ = "Y" OR STATS$ = "Y" THEN GOSUB 8000: GOTO 230
225 IF STATS$ <> "N" AND STATS$ <> "N" THEN PRINT "PLEASE ENTER Y OR N.": GOTO 210
230 INPUT "PLAY AGAIN (Y/N)? ", AGAIN$
240 IF AGAIN$ = "Y" OR AGAIN$ = "Y" THEN GOSUB 7000: GOTO 35
250 PRINT : PRINT "GOOD BYE!"
260 END
1000 REM SUBROUTINE TO DISPLAY INSTRUCTIONS
1010 PRINT "*********************************************"
1020 PRINT "*                                           *"
1030 PRINT "*   WELCOME TO ROCK-PAPER-SCISSORS!         *"
1040 PRINT "*                                           *"
1050 PRINT "*  INSTRUCTIONS:                            *"
1060 PRINT "*  CHOOSE ROCK (R), PAPER (P), OR SCISSORS  *"
1070 PRINT "*  (S). THE GAME FOLLOWS THE STANDARD RULES:*"
1080 PRINT "*  ROCK BEATS SCISSORS, SCISSORS BEAT PAPER,*"
1090 PRINT "*  AND PAPER BEATS ROCK.                    *"
1100 PRINT "*                                           *"
1110 PRINT "*  THE PLAYER WITH THE MOST POINTS AFTER    *"
1120 PRINT "*  THE SPECIFIED ROUNDS WINS.               *"
1130 PRINT "*                                           *"
1140 PRINT "*********************************************"
1150 RETURN
2000 REM SUBROUTINE TO GET PLAYER CHOICE
2010 PRINT
2020 IF RC > 1 THEN GOTO 2025 ELSE GOTO 2080
2025 GOTO 2080
2080 PRINT "CHOOSE ROCK (R), PAPER (P), SCISSORS (S) OR STATS (X)."
2085 PRINT "YOUR CHOICE (R/P/S/X): ";
2090 INPUT PC$
2100 PC$ = LEFT$(PC$, 1)
2110 IF PC$ = "R" THEN PC$ = "R"
2120 IF PC$ = "P" THEN PC$ = "P"
2130 IF PC$ = "S" THEN PC$ = "S"
2140 IF PC$ = "X" THEN PC$ = "X"
2150 IF PC$ <> "R" AND PC$ <> "P" AND PC$ <> "S" AND PC$ <> "X" THEN PRINT "INVALID CHOICE! TRY AGAIN.": GOTO 2090
2160 IF PC$ = "X" THEN RETURN
2170 UC$(RC) = PC$
2180 RETURN
3000 REM SUBROUTINE TO GET COMPUTER CHOICE
3010 IF DL = 1 THEN CP$ = MID$("RPS", INT(RND * 3) + 1, 1): GOTO 3030
3011 IF DL = 2 THEN GOSUB 3100: GOTO 3030
3012 IF DL = 3 THEN GOSUB 3500: GOTO 3030
3030 PRINT "COMPUTER CHOSE: "; CP$
3040 CC$(RC) = CP$
3050 RETURN
3100 REM SUBROUTINE TO USE BASIC PATTERN RECOGNITION FOR MEDIUM LEVEL
3110 IF RC > 5 THEN GOSUB 3200: GOTO 3140
3115 CP$ = MID$("RPS", INT(RND * 3) + 1, 1)
3140 PRINT "COMPUTER CHOSE: "; CP$
3150 CC$(RC) = CP$
3160 RETURN
3200 REM ANALYZE LAST 5 PLAYER CHOICES FOR PATTERN RECOGNITION
3210 REM INITIALIZE COUNTS FOR EACH CHOICE
3220 ROCKCOUNT = 0: PAPERCOUNT = 0: SCISSORSCOUNT = 0
3230 REM LOOP THROUGH THE LAST 5 PLAYER CHOICES AND COUNT EACH TYPE
3240 FOR I = RC - 5 TO RC - 1
3250 IF I > 0 THEN GOTO 3270 ELSE GOTO 3300
3270 IF UC$(I) = "R" THEN ROCKCOUNT = ROCKCOUNT + 1 ELSE GOTO 3290
3280 GOTO 3300
3290 IF UC$(I) = "P" THEN PAPERCOUNT = PAPERCOUNT + 1 ELSE GOTO 3295
3295 IF UC$(I) = "S" THEN SCISSORSCOUNT = SCISSORSCOUNT + 1
3300 NEXT I
3310 REM DETERMINE THE MOST FREQUENT PLAYER CHOICE IN THE LAST 5 ROUNDS
3320 REM SET DEFAULT TO ROCK FOR COMPARISON PURPOSES
3330 MOSTFREQUENTCHOICE$ = "R"
3340 IF PAPERCOUNT > ROCKCOUNT AND PAPERCOUNT > SCISSORSCOUNT THEN MOSTFREQUENTCHOICE$ = "P"
3350 IF SCISSORSCOUNT > ROCKCOUNT AND SCISSORSCOUNT > PAPERCOUNT THEN MOSTFREQUENTCHOICE$ = "S"
3360 REM HANDLE TIES BY RANDOM SELECTION AMONG TIED CHOICES
3370 IF ROCKCOUNT = PAPERCOUNT AND ROCKCOUNT > SCISSORSCOUNT THEN MOSTFREQUENTCHOICE$ = MID$("RP", INT(RND * 2) + 1, 1)
3380 IF ROCKCOUNT = SCISSORSCOUNT AND ROCKCOUNT > PAPERCOUNT THEN MOSTFREQUENTCHOICE$ = MID$("RS", INT(RND * 2) + 1, 1)
3390 IF PAPERCOUNT = SCISSORSCOUNT AND PAPERCOUNT > ROCKCOUNT THEN MOSTFREQUENTCHOICE$ = MID$("PS", INT(RND * 2) + 1, 1)
3400 IF ROCKCOUNT = PAPERCOUNT AND ROCKCOUNT = SCISSORSCOUNT THEN MOSTFREQUENTCHOICE$ = MID$("RPS", INT(RND * 3) + 1, 1)
3410 REM CHOOSE COMPUTER MOVE TO COUNTER THE MOST FREQUENT PLAYER CHOICE
3420 REM INTRODUCE RANDOMNESS TO AVOID PREDICTABILITY
3430 RANDNUM = INT(RND * 10)
3440 IF MOSTFREQUENTCHOICE$ = "R" THEN CP$ = MID$("PSR", RANDNUM MOD 3 + 1, 1)
3450 IF MOSTFREQUENTCHOICE$ = "P" THEN CP$ = MID$("SRP", RANDNUM MOD 3 + 1, 1)
3460 IF MOSTFREQUENTCHOICE$ = "S" THEN CP$ = MID$("RPS", RANDNUM MOD 3 + 1, 1)
3470 RETURN
3500 REM ADVANCED PATTERN RECOGNITION FOR HARD LEVEL
3510 REM INITIALIZE COUNTS FOR EACH CHOICE
3520 ROCKCOUNT = 0: PAPERCOUNT = 0: SCISSORSCOUNT = 0
3530 REM LOOP THROUGH THE LAST 10 PLAYER CHOICES AND COUNT EACH TYPE
3540 FOR I = RC - 10 TO RC - 1
3550 IF I > 0 THEN GOTO 3570 ELSE GOTO 3600
3570 IF UC$(I) = "R" THEN ROCKCOUNT = ROCKCOUNT + 1 ELSE GOTO 3590
3580 GOTO 3600
3590 IF UC$(I) = "P" THEN PAPERCOUNT = PAPERCOUNT + 1 ELSE GOTO 3595
3595 IF UC$(I) = "S" THEN SCISSORSCOUNT = SCISSORSCOUNT + 1
3600 NEXT I
3610 REM DETERMINE THE MOST FREQUENT PLAYER CHOICE IN THE LAST 10 ROUNDS
3620 MOSTFREQUENTCHOICE$ = "R"
3630 IF PAPERCOUNT > ROCKCOUNT AND PAPERCOUNT > SCISSORSCOUNT THEN MOSTFREQUENTCHOICE$ = "P"
3640 IF SCISSORSCOUNT > ROCKCOUNT AND SCISSORSCOUNT > PAPERCOUNT THEN MOSTFREQUENTCHOICE$ = "S"
3650 REM HANDLE TIES BY RANDOM SELECTION AMONG TIED CHOICES
3660 IF ROCKCOUNT = PAPERCOUNT AND ROCKCOUNT > SCISSORSCOUNT THEN MOSTFREQUENTCHOICE$ = MID$("RP", INT(RND * 2) + 1, 1)
3670 IF ROCKCOUNT = SCISSORSCOUNT AND ROCKCOUNT > PAPERCOUNT THEN MOSTFREQUENTCHOICE$ = MID$("RS", INT(RND * 2) + 1, 1)
3680 IF PAPERCOUNT = SCISSORSCOUNT AND PAPERCOUNT > ROCKCOUNT THEN MOSTFREQUENTCHOICE$ = MID$("PS", INT(RND * 2) + 1, 1)
3690 IF ROCKCOUNT = PAPERCOUNT AND ROCKCOUNT = SCISSORSCOUNT THEN MOSTFREQUENTCHOICE$ = MID$("RPS", INT(RND * 3) + 1, 1)
3700 REM CHOOSE COMPUTER MOVE TO COUNTER THE MOST FREQUENT PLAYER CHOICE
3710 REM INTRODUCE RANDOMNESS TO AVOID PREDICTABILITY
3720 RANDNUM = INT(RND * 10)
3730 IF MOSTFREQUENTCHOICE$ = "R" THEN CP$ = MID$("PSR", RANDNUM MOD 3 + 1, 1)
3740 IF MOSTFREQUENTCHOICE$ = "P" THEN CP$ = MID$("SRP", RANDNUM MOD 3 + 1, 1)
3750 IF MOSTFREQUENTCHOICE$ = "S" THEN CP$ = MID$("RPS", RANDNUM MOD 3 + 1, 1)
3760 RETURN
4000 REM SUBROUTINE TO DETERMINE WINNER AND UPDATE SCORE
4010 IF PC$ = CP$ THEN PRINT : PRINT "TIE! SCORES REMAIN THE SAME.": TC = TC + 1: RETURN
4020 IF (PC$ = "R" AND CP$ = "S") OR (PC$ = "P" AND CP$ = "R") OR (PC$ = "S" AND CP$ = "P") THEN GOSUB 4100: RETURN
4030 GOSUB 4200: RETURN
4100 REM PLAYER WINS
4110 PRINT CHR$(7): PRINT : PRINT "*** YOU WIN! ***"
4120 IF BR = 1 THEN US = US + 2: GOTO 4130
4125 US = US + 1
4130 RETURN
4200 REM COMPUTER WINS
4210 PRINT : PRINT "<<< COMPUTER WINS! >>>"
4220 IF BR = 1 THEN CS = CS + 2: GOTO 4230
4225 CS = CS + 1
4230 RETURN
5000 REM SUBROUTINE TO DISPLAY SCORES
5010 PRINT : PRINT "YOUR SCORE: "; US
5020 PRINT "COMPUTER SCORE: "; CS
5030 PRINT "ROUNDS PLAYED: "; RC
5040 RETURN
6000 REM SUBROUTINE TO DISPLAY END GAME MESSAGE
6010 PRINT : PRINT "GAME OVER!"
6020 IF US > CS THEN PRINT "*** CONGRATULATIONS, YOU WON THE GAME! ***"
6030 IF CS > US THEN PRINT "<<< SORRY, THE COMPUTER WON THE GAME. >>>"
6040 IF US = CS THEN PRINT "=== THE GAME IS A TIE. ==="
6050 PRINT : PRINT "FINAL SCORES:"
6060 PRINT "  YOUR SCORE: "; US
6070 PRINT "  COMPUTER SCORE: "; CS
6080 PRINT "  TOTAL TIES: "; TC
6090 PRINT
6100 RETURN
7000 REM SUBROUTINE TO INITIALIZE GAME STATE
7010 US = 0
7020 CS = 0
7030 RC = 1
7040 TC = 0
7050 FOR I = 1 TO 100
7060 UC$(I) = ""
7070 CC$(I) = ""
7080 NEXT I
7090 RETURN
8000 REM SUBROUTINE TO DISPLAY GAME STATISTICS
8010 PRINT:PRINT "*********************************************"
8020 PRINT "*                GAME STATISTICS            *"
8030 PRINT "*********************************************"
8040 PRINT "* TOTAL ROUNDS PLAYED: "; RC - 1
8050 PRINT "* TOTAL TIES: "; TC
8060 PRINT "* TOTAL PLAYER WINS: "; US
8070 PRINT "* TOTAL COMPUTER WINS: "; CS
8080 UR = 0: UP = 0: US2 = 0
8090 CR = 0: CP2 = 0: CS2 = 0
8100 FOR I = 1 TO RC - 1
8110 IF UC$(I) = "R" THEN UR = UR + 1
8120 IF UC$(I) = "P" THEN UP = UP + 1
8130 IF UC$(I) = "S" THEN US2 = US2 + 1
8140 IF CC$(I) = "R" THEN CR = CR + 1
8150 IF CC$(I) = "P" THEN CP2 = CP2 + 1
8160 IF CC$(I) = "S" THEN CS2 = CS2 + 1
8170 NEXT I
8180 PRINT "* PLAYER CHOICES: ROCK = "; UR; ", PAPER = "; UP; ", SCISSORS = "; US2
8190 PRINT "* COMPUTER CHOICES: ROCK = "; CR; ", PAPER = "; CP2; ", SCISSORS = "; CS2
8200 PRINT "*********************************************"
8210 RETURN
