1 ' Clock routines for RBBENT, RBBMIN, and EXITBBS1, using the
2 ' CompuTime clock board (late model, using the OKI-5832 clock
3 ' chip.)
4 '
5 ' The base port address (frequently 80h) should be specified
6 ' with CLKBASE = &H80 (or whatever) somewhere in the initialization
7 ' section of EACH of the programs in which it is used.
8 '
9 '                                    Dave Goodman - 02/15/82
10 '
  
  
20 'The module with line numbers 14000-14999 replaces all code
21 'within those line numbers in RBBENT.
22 '
23 'The module with line numbers 44000-xxxxx replaces all code
24 'within those line numbers in RBBMIN and EXITBBS1.
25 '
26 'Don't forget to put the CLKBASE equate somewhere!
  
  
14000 ' Date getting subroutine
14010 ' For CompuTime with OKI-5832 chip.  DG - 2/15/82
14030 '
14035 INDX = 12 : GOSUB 14092 : DY$ = TEMP$
14040 INDX = 10 : GOSUB 14092 : DM$ = TEMP$
14045 INDX = 8  : GOSUB 14092 : DD$ = TEMP$
14055 DT$=DM$+"/"+DD$
14060 DZ$=DM$+"/"+DD$+"/"+DY$
14090 RETURN
14091  '
14092 OUT CLKBASE + 1, &H10 : TEMP$ = ""
14093   FOR REGISTER = INDX TO INDX - 1 STEP -1
14094	  OUT CLKBASE + 2, REGISTER + &H20
14095     IF REGISTER=8 THEN TEMP$=TEMP$+CHR$((INP(CLKBASE + 2) AND 3) + &H30)
           ELSE TEMP$ = TEMP$ + CHR$(INP(CLKBASE + 2) + &H30)
14096   NEXT
14097 OUT CLKBASE + 1, 0
14098 RETURN
14100 ' 
14200 ' Time-finding subroutine
14205 '
14210 OUT CLKBASE + 1, &H10
14215   FOR REGISTER = 5 TO 0 STEP -1
14220	  OUT CLKBASE + 2, REGISTER + &H20
14225	  IF REGISTER = 5 THEN H(1) = INP(CLKBASE + 2) AND 3
 	  ELSE H(6 - REGISTER) = INP(CLKBASE + 2)
14230   NEXT
14235 OUT CLKBASE + 1, 0
14240 '
14245 TD$ = ""
14250   FOR INDX = 1 TO 6
14255	  TD$ = TD$ + CHR$(H(INDX) + &H30)
14260   NEXT
14265 TD$ = LEFT$(TD$, 2) + ":" + MID$(TD$, 3, 2) + ":" + RIGHT$(TD$, 2)
14270 TI$ = DD$ + "-" + LEFT$(TD$, 5)
14290 RETURN
14999 '
  
  
44000 ' Clock routine for Computime with OKI-5832 chip.  DG - 2/15/81
44010 ' Print present time first
44210 OUT CLKBASE + 1, &H10
44215   FOR REGISTER = 5 TO 0 STEP -1
44220	  OUT CLKBASE + 2, REGISTER + &H20
44225	  IF REGISTER = 5 THEN H(1) = INP(CLKBASE + 2) AND 3
 	  ELSE H(6 - REGISTER) = INP(CLKBASE + 2)
44230   NEXT
44235 OUT CLKBASE + 1, 0
                                                                                                                                