# External Reference Materials

This directory contains external reference documentation imported from other sources.

## Files

### BASIC-80 (MBASIC) Reference Manual

**basic_ref.pdf** (7.5 MB)
- Official BASIC-80 Reference Manual, Version 5.21, 1981
- Microsoft BASIC for CP/M operating system
- Complete language reference for MBASIC 5.21
- Source: Microsoft Corporation

**basic_ref.txt** (182 KB)
- Text extraction from basic_ref.pdf
- Created for easier searching and reference
- May contain OCR errors from PDF conversion

### Microsoft BASIC Compiler Manual

**Microsoft_BASIC_Compiler_1980.pdf** (10 MB)
- Microsoft BASIC Compiler (BASCOM) for CP/M, 1980
- Describes the BASIC compiler (not interpreter)
- Useful for understanding compiler vs interpreter differences
- Source: Microsoft Corporation

**Microsoft_BASIC_Compiler_1980.txt** (229 KB)
- Text extraction from Microsoft_BASIC_Compiler_1980.pdf
- Created for easier searching and reference
- May contain OCR errors from PDF conversion

## Purpose

These reference materials document:
- The MBASIC 5.21 language specification
- Original Microsoft implementations (both interpreter and compiler)
- CP/M era BASIC programming

They are essential references for ensuring the mbasic interpreter accurately implements the MBASIC 5.21 specification.

## License

These documents are copyright Microsoft Corporation. They are included here for reference purposes only to support accurate implementation of the MBASIC 5.21 specification.

## Related Documentation

See also:
- **../COMPILER_DESIGN.md** - Analysis of compiler vs interpreter differences
- **../COMPILER_VS_INTERPRETER_DIFFERENCES.md** - Detailed comparison
- **../LANGUAGE_CHANGES.md** - BASIC language evolution analysis

These files in the main doc/ directory provide our analysis of the reference materials.
