---
search:
  exclude: true
---

# Appendices

Additional reference material for BASIC-80 programming.

## Available Appendices

### [Error Codes and Messages](error-codes.md)
Complete list of all BASIC-80 error codes with descriptions and handling advice.

**Includes:**
- General errors (syntax, type mismatch, overflow, etc.)
- Extended and Disk version errors
- Disk I/O errors (file operations, bad file numbers, etc.)
- Error handling references (see [Error Handling](../statements/index.md#error-handling) for detailed examples)

### [ASCII Character Codes](ascii-codes.md)
Complete ASCII character code reference with decimal and hexadecimal values.

**Includes:**
- Control characters (0-31)
- Printable characters (32-126)
- Usage examples with CHR$ and ASC
- Common ASCII values quick reference

### [Mathematical Functions](math-functions.md)
Derived mathematical functions using BASIC-80's intrinsic functions.

**Includes:**
- Trigonometric functions (secant, cosecant, cotangent)
- Inverse trigonometric functions
- Hyperbolic functions
- Inverse hyperbolic functions
- Mathematical constants and examples

## See Also

- [Functions](../functions/index.md) - Built-in BASIC-80 functions
- [Statements](../statements/index.md) - BASIC-80 statements and commands
- [Error Handling](../statements/index.md#error-handling) - Error handling statements
