---
category: mathematical
description: Return the absolute value of a number (removes negative sign)
keywords: ['abs', 'absolute', 'magnitude', 'positive', 'distance']
syntax: ABS(number)
related: ['sgn', 'int', 'fix']
title: ABS
type: function
---

# ABS

## Syntax

```basic
ABS(X)
```

## Description

Returns the absolute value of the expression X.

## Example

```basic
PRINT ABS(7*(-5»
 35
 Ok
```

## See Also
- [ATN](atn.md) - Returns the arctangent of X in radians
- [COS](cos.md) - Returns the cosine of X in radians
- [EXP](exp.md) - Returns e to the power of X
- [FIX](fix.md) - Returns the truncated integer part of X
- [INT](int.md) - Return the largest integer less than or equal to a number (floor function)
- [LOG](log.md) - Returns the natural logarithm of X
- [RND](rnd.md) - Returns a random number between 0 and 1
- [SGN](sgn.md) - Returns the sign of X (-1, 0, or 1)
- [SIN](sin.md) - Returns the sine of X in radians
- [SQR](sqr.md) - Returns the square root of X
- [TAN](tan.md) - Returns the tangent of X in radians
