---
search:
  exclude: true
---

# BASIC-80 Functions

Intrinsic functions provided by BASIC-80. These functions may be called from any program without further definition.

## By Category

### Mathematical Functions
- [ABS](abs.md) - Absolute value
- [ATN](atn.md) - Arctangent
- [COS](cos.md) - Cosine
- [EXP](exp.md) - Exponential
- [FIX](fix.md) - Truncate
- [INT](int.md) - Integer part
- [LOG](log.md) - Natural logarithm
- [RND](rnd.md) - Random number
- [SGN](sgn.md) - Sign
- [SIN](sin.md) - Sine
- [SQR](sqr.md) - Square root
- [TAN](tan.md) - Tangent

### String Functions
- [ASC](asc.md) - Character to ASCII code
- [CHR$](chr_dollar.md) - ASCII code to character
- [HEX$](hex_dollar.md) - Number to hexadecimal
- [INSTR](instr.md) - Find substring
- [LEFT$](left_dollar.md) - Left substring
- [LEN](len.md) - String length
- [MID$](mid_dollar.md) - Middle substring
- [OCT$](oct_dollar.md) - Number to octal
- [RIGHT$](right_dollar.md) - Right substring
- [SPACE$](space_dollar.md) - Returns a string of spaces
- [STR$](str_dollar.md) - Number to string
- [STRING$](string_dollar.md) - Repeated character
- [VAL](val.md) - String to number

### Output Formatting Functions
- [SPC](spc.md) - Skip spaces in PRINT
- [TAB](tab.md) - Tab to position in PRINT

### Type Conversion Functions
- [CDBL](cdbl.md) - To double precision
- [CINT](cint.md) - To integer
- [CSNG](csng.md) - To single precision
- [CVD, CVI, CVS](cvi-cvs-cvd.md) - String to number
- [MKD$, MKI$, MKS$](mki_dollar-mks_dollar-mkd_dollar.md) - Number to string

### File I/O Functions
- [EOF](eof.md) - End of file
- [INPUT$](input_dollar.md) - Read characters
- [LOC](loc.md) - File position
- [LOF](lof.md) - Length of file
- [LPOS](lpos.md) - Printer position
- [POS](pos.md) - Cursor position

### System Functions
- [FRE](fre.md) - Free memory
- [INKEY$](inkey_dollar.md) - Read keyboard
- [INP](inp.md) - Port input
- [PEEK](peek.md) - Read memory location
- [USR](usr.md) - Machine language call
- [VARPTR](varptr.md) - Variable address

## Alphabetical Quick Reference

[ABS](abs.md) | [ASC](asc.md) | [ATN](atn.md) | [CDBL](cdbl.md) | [CHR$](chr_dollar.md) | [CINT](cint.md) | [COS](cos.md) | [CSNG](csng.md) | [CVD/CVI/CVS](cvi-cvs-cvd.md) | [EOF](eof.md) | [EXP](exp.md) | [FIX](fix.md) | [FRE](fre.md) | [HEX$](hex_dollar.md) | [INKEY$](inkey_dollar.md) | [INP](inp.md) | [INPUT$](input_dollar.md) | [INSTR](instr.md) | [INT](int.md) | [LEFT$](left_dollar.md) | [LEN](len.md) | [LOC](loc.md) | [LOF](lof.md) | [LOG](log.md) | [LPOS](lpos.md) | [MID$](mid_dollar.md) | [MKD$/MKI$/MKS$](mki_dollar-mks_dollar-mkd_dollar.md) | [OCT$](oct_dollar.md) | [PEEK](peek.md) | [POS](pos.md) | [RIGHT$](right_dollar.md) | [RND](rnd.md) | [SGN](sgn.md) | [SIN](sin.md) | [SPACE$](space_dollar.md) | [SPC](spc.md) | [SQR](sqr.md) | [STR$](str_dollar.md) | [STRING$](string_dollar.md) | [TAB](tab.md) | [TAN](tan.md) | [USR](usr.md) | [VAL](val.md) | [VARPTR](varptr.md)

## See Also

- [Statements](../statements/index.md) - BASIC-80 statements and commands
- [Error Codes](../appendices/error-codes.md) - Error messages and codes
- [Examples](../../examples.md) - Example programs
