---
category: mathematical
description: Returns the natural logarithm of X
keywords: ['function', 'log', 'print', 'return']
syntax: LOG (X)
title: LOG
type: function
---

# LOG

## Syntax

```basic
LOG (X)
```

## Description

Returns the natural logarithm of X. X must be greater than zero.

## Example

```basic
PRINT LOG ( 45/7 )
 1.86075
Ok
```

## See Also
- [ABS](abs.md) - Return the absolute value of a number (removes negative sign)
- [ATN](atn.md) - Returns the arctangent of X in radians
- [COS](cos.md) - Returns the cosine of X in radians
- [EXP](exp.md) - Returns e to the power of X
- [FIX](fix.md) - Returns the truncated integer part of X
- [INT](int.md) - Return the largest integer less than or equal to a number (floor function)
- [RND](rnd.md) - Returns a random number between 0 and 1
- [SGN](sgn.md) - Returns the sign of X (-1, 0, or 1)
- [SIN](sin.md) - Returns the sine of X in radians
- [SQR](sqr.md) - Returns the square root of X
- [TAN](tan.md) - Returns the tangent of X in radians
