---
category: mathematical
description: Returns the sine of X in radians
keywords: ['function', 'print', 'return', 'sin']
syntax: SIN(X)
title: SIN
type: function
---

# SIN

## Syntax

```basic
SIN(X)
```

## Description

Returns the sine of X in radians. SIN(X) is calculated in single precision.

**Note**: COS(X) = SIN(X + 3.14159/2)

## Example

```basic
PRINT SIN(1.5)
 .997495
 Ok
```

## See Also
- [ABS](abs.md) - Return the absolute value of a number (removes negative sign)
- [ATN](atn.md) - Returns the arctangent of X in radians
- [COS](cos.md) - Returns the cosine of X in radians
- [EXP](exp.md) - Returns e to the power of X
- [FIX](fix.md) - Returns the truncated integer part of X
- [INT](int.md) - Return the largest integer less than or equal to a number (floor function)
- [LOG](log.md) - Returns the natural logarithm of X
- [RND](rnd.md) - Returns a random number between 0 and 1
- [SGN](sgn.md) - Returns the sign of X (-1, 0, or 1)
- [SQR](sqr.md) - Returns the square root of X
- [TAN](tan.md) - Returns the tangent of X in radians
