---
category: mathematical
description: Returns the square root of X
keywords: ['for', 'function', 'next', 'print', 'return', 'sqr']
syntax: SQR(X)
title: SQR
type: function
---

# SQR

## Syntax

```basic
SQR(X)
```

## Description

Returns the square root of X. X must be >=0.

## Example

```basic
10 FOR X = 10 TO 25 STEP 5
 20 PRINT X, SQR(X)
 30 NEXT
 RUN
 10 3.16228
 15 3.87298
 20 4.47214
 25 5
 Ok
```

## See Also
- [ABS](abs.md) - Return the absolute value of a number (removes negative sign)
- [ATN](atn.md) - Returns the arctangent of X in radians
- [COS](cos.md) - Returns the cosine of X in radians
- [EXP](exp.md) - Returns e to the power of X
- [FIX](fix.md) - Returns the truncated integer part of X
- [INT](int.md) - Return the largest integer less than or equal to a number (floor function)
- [LOG](log.md) - Returns the natural logarithm of X
- [RND](rnd.md) - Returns a random number between 0 and 1
- [SGN](sgn.md) - Returns the sign of X (-1, 0, or 1)
- [SIN](sin.md) - Returns the sine of X in radians
- [TAN](tan.md) - Returns the tangent of X in radians
