---
category: program-control
description: To delete the program currently in memory and clear all variables
keywords: ['command', 'execute', 'for', 'new', 'program', 'return', 'statement', 'variable']
syntax: NEW
title: NEW
type: statement
---

# NEW

## Syntax

```basic
NEW
```

## Purpose

To delete the program currently in memory and clear all variables.

## Remarks

## See Also
- [CHAIN](chain.md) - To call a program and pass variables to it from the current program
- [CLEAR](clear.md) - To set all numeric variables to zero and all string variables to null; and, optionally, 'to set the end of memory and the amount of stack space
- [COMMON](common.md) - To pass variables to a CHAINed program
- [CONT](cont.md) - To continue program execution after a Control-C has been typed, or a STOP or END statement has been executed
- [END](end.md) - To terminate program execution, close all files and return to command level
- [RUN](run.md) - Executes the current program or loads and runs a program from disk
- [STOP](stop.md) - To terminate program execution and return to command level
- [SYSTEM](system.md) - Exits MBASIC and returns to the operating system
