# MBASIC 5.21 Help

Welcome to MBASIC 5.21! This help system is organized into three sections:

## 📕 [Language Reference](common/language/index.md)

Learn the BASIC-80 language - statements, functions, operators, and data types.

**Common topics:**
- [Statements](common/language/statements/index.md) - PRINT, FOR, IF, GOSUB, etc.
- [Functions](common/language/functions/index.md) - ABS, SIN, LEFT$, etc.
- [Data Types](common/language/data-types.md) - Integer, String, Single, Double
- [Operators](common/language/operators.md) - Arithmetic, comparison, logical

**Quick examples:**
- [Hello World](common/examples/hello-world.md)
- [Loops and Control Flow](common/examples/loops.md)

## 📗 [About MBASIC 5.21](mbasic/index.md)

Learn about this implementation of Microsoft BASIC-80 version 5.21.

**Topics:**
- [Getting Started](mbasic/getting-started.md) - Your first program
- [Features](mbasic/features.md) - What's implemented
- [Compatibility](mbasic/compatibility.md) - How it compares to original MBASIC
- [Extensions](mbasic/extensions.md) - Modern enhancements
- [Architecture](mbasic/architecture.md) - How it works

## 📘 UI-Specific Help

Learn how to use the interface you're currently in.

**Select your interface:**
- [Tk (Desktop GUI)](ui/tk/index.md) - Graphical interface with menus
- [Curses (Terminal)](ui/curses/index.md) - Full-screen terminal interface
- [Web Browser](ui/web/index.md) - Browser-based interface
- [CLI (Command Line)](ui/cli/index.md) - Simple command-line interface

---

## Most Commonly Searched

**Language Basics:**
- [PRINT statement](common/language/statements/print.md) - Display output
- [INPUT statement](common/language/statements/input.md) - Get user input
- [FOR...NEXT loops](common/language/statements/for-next.md) - Repeat code
- [IF...THEN...ELSE](common/language/statements/if-then-else-if-goto.md) - Conditional execution
- [GOSUB...RETURN](common/language/statements/gosub-return.md) - Subroutines

**File Operations:**
- [OPEN statement](common/language/statements/open.md) - Open files
- [PRINT # statement](common/language/statements/print.md) - Write to files
- [INPUT # statement](common/language/statements/input_hash.md) - Read from files
- [CLOSE statement](common/language/statements/close.md) - Close files

**Common Functions:**
- [String functions](common/language/functions/index.md#string-functions) - LEFT$, RIGHT$, MID$, LEN
- [Math functions](common/language/functions/index.md#mathematical-functions) - SIN, COS, SQR, ABS
- [Type conversion](common/language/functions/index.md#type-conversion-functions) - CINT, CSNG, CDBL

---

## Tips

- Use the **Search** box above to find specific topics
- Press **{{kbd:find:curses}}** to search within the current page
- Click **⌂ Home** button to return to this page
- Click **← Back** to go to the previous page

## About This Implementation

MBASIC 5.21 is a faithful recreation of Microsoft BASIC-80 version 5.21, originally released in 1981 for CP/M systems. This modern implementation maintains 100% compatibility with original MBASIC programs while adding optional modern conveniences.

For more details, see [About MBASIC](mbasic/index.md).
