---
title: MBASIC Curses UI Help
type: guide
ui: curses
description: Help system for the MBASIC terminal-based IDE
keywords: [help, curses, terminal, ui, interface]
---

# MBASIC Curses UI Help

Welcome to the MBASIC terminal-based IDE. This help system integrates documentation for the Curses UI, the MBASIC interpreter, and the BASIC-80 language.

## 🎮 Games Library

Browse and run classic BASIC games:

- **[Games Library](../../../library/games/index.md)** - 113 classic CP/M era games ready to run!

## 📘 Curses UI Guide

Learn how to use the terminal interface:

- [Getting Started](getting-started.md) - First steps with the curses UI
- [Quick Reference](quick-reference.md) - All keyboard shortcuts in one place
- [Keyboard Shortcuts](../../../user/keyboard-shortcuts.md) - Complete keyboard reference (auto-generated)
- [Editing Programs](editing.md) - How to write and edit programs
- [Running Programs](running.md) - Execute and debug your code
- [File Operations](files.md) - Save and load your programs
- [Help Navigation](help-navigation.md) - How to use this help system

## 📗 MBASIC Interpreter

About this BASIC interpreter:

- [MBASIC Index](../../mbasic/index.md) - Overview and navigation
- [Getting Started](../../mbasic/getting-started.md) - Your first BASIC program
- [Features](../../mbasic/features.md) - What's implemented
- [Compatibility](../../mbasic/compatibility.md) - MBASIC 5.21 differences
- [Architecture](../../mbasic/architecture.md) - Interpreter vs compiler design

## 📙 MBASIC Compiler

Compile BASIC programs to native CP/M executables:

- **[Compiler Guide](../../common/compiler/index.md)** - Generate .COM files for 8080 or Z80 systems (100% complete!)
- [Features](../../common/compiler/features.md) - What the compiler supports
- [Getting Started](../../common/compiler/getting-started.md) - Compile your first program
- [Generated Code](../../common/compiler/generated-code.md) - Understanding compiler output

## 📕 BASIC-80 Language Reference

Complete BASIC-80 language documentation:

- [Language Overview](../../common/language/index.md) - Introduction to BASIC-80
- [Operators](../../common/language/operators.md) - Arithmetic, logical, and relational operators
- **Statements** - All 63 BASIC-80 statements
  - [Statements Index](../../common/language/statements/index.md) - Browse all statements
  - Organized by category: input-output, control-flow, file-io, arrays, etc.
- **Functions** - All 40 BASIC-80 functions
  - [Functions Index](../../common/language/functions/index.md) - Browse all functions
  - Organized by category: mathematical, string, type-conversion, etc.
- **Appendices** - Reference materials
  - [Error Codes](../../common/language/appendices/error-codes.md) - All 68 error codes
  - [ASCII Table](../../common/language/appendices/ascii-codes.md) - Character codes
  - [Math Functions](../../common/language/appendices/math-functions.md) - Derived functions

---

## Help Navigation

Use these keys while viewing help:

| Key | Action |
|-----|--------|
| **↑/↓** | Scroll through current page |
| **Tab** | Move to next link |
| **Enter** | Follow the highlighted link |
| **U** | Go back to previous page |
| **ESC** or **Q** | Close help and return to editor |

You can navigate seamlessly between all three sections using the links above.

## Search

Press **/** to search across all help content. Results are grouped by section (UI, MBASIC, Language).

## Tips

- **Context-sensitive help**: Press {{kbd:home:curses}} with cursor on a BASIC keyword for direct help
- **Quick access**: Bookmark frequently used topics with your browser's history (U key)
- **Cross-references**: Follow "See Also" links to explore related topics
- **Categories**: Browse statements and functions by category in the language reference

---

## Beyond the Interpreter

The Curses UI runs programs in **interpreter mode**. To compile BASIC programs to native CP/M executables:

**[MBASIC Compiler →](../../common/compiler/index.md)** - Generate native .COM files for 8080 or Z80 systems (100% complete!)

---

**Welcome to MBASIC!** Choose a section above to get started, or press `/` to search for a specific topic.
