# MBASIC History

## What is MBASIC?

MBASIC (short for "Microsoft BASIC") was a BASIC interpreter developed by Microsoft in the late 1970s and early 1980s for CP/M and other 8-bit operating systems. It was one of Microsoft's early successful products and helped establish the company as a major software developer.

### Historical Significance

**MBASIC's Role in Microsoft's History:**
- One of Microsoft's first commercial products (late 1970s)
- Helped fund Microsoft's early growth
- Established Microsoft as a serious programming language vendor
- Led to many dialects: GW-BASIC, BASICA, QuickBASIC, etc.

**The Language:**
- Based on Dartmouth BASIC with Microsoft extensions
- Designed for CP/M systems (8080/Z80 processors)
- Version 5.21 (1982) was one of the most stable and widely used
- Featured line-numbered programs, immediate mode, and built-in editor
- Supported floating point math, string handling, arrays, file I/O

### This Implementation

**Important Disclaimers:**

This project (`mbasic`) is:
- ✅ An independent, open-source reimplementation of the MBASIC 5.21 language
- ✅ Written from scratch in Python by Andrew Wohl
- ✅ Created for educational purposes and preservation of computing history
- ✅ Compatible with MBASIC 5.21 programs

This project is **NOT**:
- ❌ Created by Microsoft
- ❌ Endorsed by Microsoft
- ❌ Affiliated with Microsoft
- ❌ Supported by Microsoft
- ❌ Using any Microsoft source code

**Credit Where Due:**
- **Language design credit:** Microsoft (Paul Allen, Bill Gates, Monte Davidoff - original Altair BASIC team)
- **Historical MBASIC versions:** Microsoft Corporation (1977-1986)
- **Any issues with this implementation:** Andrew Wohl and contributors to this project
- **Any praise for the original language:** Microsoft's original team

### Why Preserve MBASIC?

MBASIC represents an important era in computing history:
- Thousands of programs were written in MBASIC
- It was many people's first programming language
- Original CP/M systems are increasingly rare
- Historical software preservation is important

This reimplementation allows:
- Running historical MBASIC programs on modern systems
- Learning about 1980s programming practices
- Understanding the evolution of BASIC dialects
- Preserving cultural and technical heritage

### Further Reading

**Historical Resources:**
- [MBASIC on Wikipedia](https://en.wikipedia.org/wiki/Microsoft_BASIC)
- [CP/M history](https://en.wikipedia.org/wiki/CP/M)
- [Altair BASIC - The Beginning](https://en.wikipedia.org/wiki/Altair_BASIC)

**Original Documentation:**
- See `docs/external/` for preserved historical documentation
- Original MBASIC manuals and references (public domain/historical)

### License Note

The original MBASIC was proprietary Microsoft software. This reimplementation:
- Is original code (not derived from Microsoft sources)
- Implements the published language specification
- Is released under [appropriate open source license]
- Respects Microsoft's historical trademarks while clearly distinguishing this as an independent project

---

**Summary:** MBASIC was important historical software from Microsoft that helped start their company. This project recreates the language for modern systems. Credit for the language goes to Microsoft. Credit for any bugs in this implementation goes to us.
