# MBASIC Program Library

Welcome to the MBASIC Program Library! Browse our collection of classic BASIC programs organized by category.

⚠️ **Important:** These programs have had minimal testing by humans. If you encounter issues, please submit a bug report (link coming soon).

## Categories

### 🎮 [Games](games/index.md)
Card games, arcade games, strategy games, and more classic entertainment from the 1980s.

**Featured programs:** Blackjack, Spacewar, Star Trek, Hangman, Roulette

---

### 🛠️ [Utilities](utilities/index.md)
Calculators, converters, tools, and helpful programs for everyday computing.

**Featured programs:** Calendar, Unit Converter, Sort, Search, Day of Week Calculator

---

### 📚 [Education](education/index.md)
Educational programs for learning math, science, and programming concepts.

**Featured programs:** Math Test, Astronomy, Wind Chill Calculator

---

### 💼 [Business](business/index.md)
Financial calculators, budgeting tools, calendars, and productivity applications.

**Featured programs:** Budget Tracker, Mortgage Calculator, Finance Tools, PERT Charts

---

### 🔌 [Electronics](electronics/index.md)
Circuit design calculators, IC timers, assembly language listers, and electronic engineering tools.

**Featured programs:** 555 Timer Calculator, Attenuator Calculator, 8085 Assembly Lister

---

### 📡 [Ham Radio](ham_radio/index.md)
Amateur radio utilities including QSO loggers, callsign lookups, and radio tools.

**Featured programs:** QSO Logger, QSO Editor, RBS Utilities

---

### 💾 [Data Management](data_management/index.md)
Bibliography systems, database tools, file managers, and data organization programs.

**Featured programs:** Bibliography Builder, Database Editor, File Manager

---

### 📞 [Telecommunications](telecommunications/index.md)
Modem programs, BBS utilities, and communication tools from the dial-up era.

**Featured programs:** Modem Programs, BBS Exit Utilities, Dialog Systems

---

### 🧪 [Demos & Tests](demos/index.md)
Test programs, benchmarks, and demonstration code.

**Featured programs:** Interpreter Benchmark, Curses Tests, Sample Programs

---

## About This Library

These programs are classic BASIC applications from the CP/M and early PC era (1970s-1980s). They demonstrate the creativity and programming skills of early computer enthusiasts who created powerful applications within the constraints of 1980s hardware.

### Historical Sources

The programs in this library have been preserved from historical archives including:
- **Oakland Software Repository (OAK)** - One of the largest CP/M software archives
- **Simtel** - Historic software archive from the 1980s-1990s
- **CP/M CD-ROMs** - Collection CD-ROMs from the CP/M era
- **Walnut Creek CD-ROM collections** - Preserved software from the 1980s-1990s
- **Other historical archives and user group libraries**

These programs represent the collaborative work of countless programmers, hobbyists, and enthusiasts from the early personal computing era. We preserve them here for educational and historical purposes. All programs are provided as-is from their original archived sources.

## How to Use

1. **Browse** by category above
2. **Download** the .bas file you want to use
3. **Load in MBASIC:**
   - **Web UI:** File → Open, then select the downloaded file using browser file picker
   - **Tk UI:** File → Open, select the downloaded file
   - **CLI:** Type `LOAD "filename.bas"`
4. **Run:** Type `RUN` or click the Run button

## Notes

- Some programs may require hardware or features not available in modern systems
- Programs in the "Incompatible" category require CP/M-specific features or graphics hardware
- Original authors are credited in program source code where available

## Contributing

Have a classic BASIC program to add? See our contribution guidelines in the project repository.

---

**Library Statistics:**
- 177 programs from the 1970s-1980s
- Sources: OAK, Simtel, CP/M CD-ROMs, and other historical archives
