# MBASIC Utilities Library

Utility programs for file management, conversion, and system tools

## Available Utilities

### Bigcal2

Extended precision calculator with up to 100-digit precision for arithmetic operations

**Author:** Judson D. McClendon, modified by R.J. Sandel
**Year:** 1980s
**Tags:** calculator, math, precision

**[Download bigcal2.bas](bigcal2.bas)**

---

### Calendar

Month/year calendar generator - prompts for specific month and year (1900-2099), prints formatted calendar (Dr Dobbs, 1982)

**Source:** Dr Dobbs Nov 1981
**Year:** 1982
**Tags:** date, calendar, utility, month-view

**[Download calendar.bas](calendar.bas)**

**Note:** A different calendar program (full-year display) is available in the [Games Library](../games/index.md#calendar)

---

### Calendr5

Gregorian calendar utilities - compute day of week, days between dates, and astronomical Julian dates

**Author:** D. Mc Lanahan
**Year:** 1980s
**Tags:** calendar, date, astronomy, julian

**[Download calendr5.bas](calendr5.bas)**

---

### Charfreq

Character frequency analyzer - counts occurrence of each character in text

**Year:** 1980s
**Tags:** text, analysis, frequency

**[Download charfreq.bas](charfreq.bas)**

---

### Convert

Convert BASICODE2 programs to MBASIC format

**Author:** Henk Wevers, Dutch Hobby Computerclub
**Year:** 1980s
**Tags:** conversion, basicode, translator

**[Download convert.bas](convert.bas)**

---

### Dow

Day of Week calculator - determine what day of the week any date falls on

**Year:** 1980s
**Tags:** date, calendar, dow

**[Download dow.bas](dow.bas)**

---

### Fprime

Prime number generator - finds and prints all prime numbers up to 1000

**Year:** 1980s
**Tags:** math, prime, numbers

**[Download fprime.bas](fprime.bas)**

---

### Hex2Data

Convert Intel Hex Format data files to BASIC DATA statements

**Author:** Ian Cottrell, Ottawa, Ontario
**Year:** 1983
**Tags:** conversion, assembly, hex

**[Download hex2data.bas](hex2data.bas)**

---

### Million

Millionaire life simulation game - make financial decisions to accumulate wealth

**Author:** Craig Gunnett
**Source:** Creative Computing
**Year:** 1980s
**Tags:** simulation, financial, game

**[Download million.bas](million.bas)**

---

### Rotate

Letter rotation puzzle game - order letters A-P by rotating groups clockwise

**Year:** 1980s
**Tags:** puzzle, game, logic

**[Download rotate.bas](rotate.bas)**

---

### Search

Library search system - search computer journals and general files by keywords

**Year:** 1980s
**Tags:** database, search, library

**[Download search.bas](search.bas)**

---

### Sort

BASICODE 2 utility routines collection

**Author:** Henk Wevers
**Year:** 1980s
**Tags:** basicode, utilities, routines

**[Download sort.bas](sort.bas)**

---

### Ucase

Convert lowercase characters to uppercase using bit masking function

**Year:** 1980s
**Tags:** string, conversion, uppercase

**[Download ucase.bas](ucase.bas)**

---

### Un-Prot

Fixup utility for UN.COM unprotect program - modifies UN.COM to work with MBASIC 5.2 protected files (by B. Norris, 1983)

**Author:** B. Norris
**Year:** 1983
**Tags:** utility, unprotect, mbasic, tool

**[Download un-prot.bas](un-prot.bas)**

---

### Unprotct

Self-unprotecting program for MBASIC 5.21 protected files

**Year:** 1980s
**Tags:** utility, unprotect, mbasic

**[Download unprotct.bas](unprotct.bas)**

---

### Uudecode

Decode uuencoded files back to binary format

**Year:** 1980s
**Tags:** decode, uuencode, conversion

**[Download uudecode.bas](uudecode.bas)**

---

### Xextract

Database extract utility - reads database files and extracts selected items (phone/address records) to output file

**Year:** 1980s
**Tags:** database, extract, utility, records

**[Download xextract.bas](xextract.bas)**

---

### Xscan

Database scan and delete utility - reads database files and allows deletion of selected items (phone/address records)

**Year:** 1980s
**Tags:** database, delete, utility, records

**[Download xscan.bas](xscan.bas)**

---

## How to Use

1. **Download** the .bas file you want to use
2. **Open MBASIC** in your preferred UI (Web, Tkinter, Curses, or CLI)
3. **Open the file:**
   - **Web/Tkinter UI:** Click File → Open, select the downloaded file
   - **CLI:** Type `LOAD "filename.bas"`
4. **Run:** Type `RUN` or press the Run button

## About These Utilities

These programs are from the CP/M and early PC era (1970s-1980s), 
preserved from historical archives including OAK, Simtel, and CP/M CD-ROMs.
