# User Documentation

External user-facing documentation and guides.

## Contents

### Getting Started
- **[INSTALL.md](INSTALL.md)** - Installation guide
- **[INSTALLATION.md](INSTALLATION.md)** - Alternative installation instructions
- **[CHOOSING_YOUR_UI.md](CHOOSING_YOUR_UI.md)** - Guide to selecting the right UI

### UI-Specific Guides
- **[TK_UI_QUICK_START.md](TK_UI_QUICK_START.md)** - Tk/Tkinter UI quick start

### Reference Documentation
- **[QUICK_REFERENCE.md](QUICK_REFERENCE.md)** - Quick command reference (Curses UI specific)
- **[keyboard-shortcuts.md](keyboard-shortcuts.md)** - Keyboard shortcuts reference (Curses UI specific; Tk shortcuts in TK_UI_QUICK_START.md)
- **[UI_FEATURE_COMPARISON.md](UI_FEATURE_COMPARISON.md)** - Feature comparison across UIs

### Configuration
- **[SETTINGS_AND_CONFIGURATION.md](SETTINGS_AND_CONFIGURATION.md)** - Settings guide
- **[CASE_HANDLING_GUIDE.md](CASE_HANDLING_GUIDE.md)** - Variable and keyword case handling

### File Operations
- **[FILE_FORMAT_COMPATIBILITY.md](FILE_FORMAT_COMPATIBILITY.md)** - File format, line endings, CP/M compatibility
- **[sequential-files.md](sequential-files.md)** - Sequential file I/O guide

## Purpose

This directory contains documentation intended for end users:
- Installation guides
- Getting started tutorials
- User guides
- FAQs
- Quick references

## In-UI Help vs User Docs

- **In-UI Help** ([../help](../help/)) - Documentation accessible from within MBASIC
- **User Docs** (this directory) - External documentation, README files, guides

The in-UI help system provides context-sensitive help while using MBASIC, while this directory contains external documentation for reading before or alongside using the interpreter.
