# Archived Documentation

This directory contains historical documentation that has been archived as part of the documentation cleanup and consolidation effort.

## Archived Files

### AI Agent Documentation (Consolidated into CLAUDE.md)

- **QWEN.md** - Project overview and development conventions for Qwen AI
- **GEMINI.md** - Similar guidance for Gemini AI
- **Reason for archival**: Redundant with CLAUDE.md, which serves as the comprehensive AI agent guide

### ACB Documentation (Consolidated into ACB_GUIDE.md)

- **ACB_INTEGRATION.md** - ACB integration guide
- **ACB_REFACTORING.md** - ACB refactoring history and notes
- **ACB_PLUGIN_EXAMPLE.md** - Plugin development examples
- **ACB_CONFIGURATION_EXAMPLES.md** - Configuration examples for ACB adapters
- **Reason for archival**: Consolidated into comprehensive docs/ACB_GUIDE.md

### Historical Development Documentation

#### Quality Documentation

- **quality/refurb-modernization.md** - Refurb tool modernization notes
- **quality/type-checking-progress.md** - Type checking progress tracking
- **Reason for archival**: Historical progress tracking, superseded by current codebase state

#### Refactoring Documentation

- **refactoring/complexity-reduction-mission.md** - Complexity reduction initiatives
- **Reason for archival**: Historical refactoring notes, completed work

#### Incident Documentation

- **incidents/pre-commit-resolution-2025-10-09.md** - Pre-commit hook incident resolution
- **Reason for archival**: Historical incident documentation, issue resolved

## Active Documentation

For current documentation, see:

- **[CLAUDE.md](../../CLAUDE.md)** - Main AI agent guide and development guidelines
- **[CONTRIBUTING.md](../../CONTRIBUTING.md)** - Repository contribution guidelines
- **[docs/ACB_GUIDE.md](../ACB_GUIDE.md)** - Comprehensive ACB integration guide
- **[docs/JINJA2_ASYNC_ENVIRONMENT_USAGE.md](../JINJA2_ASYNC_ENVIRONMENT_USAGE.md)** - Technical implementation guide
- **[docs/migrations/](../migrations/)** - Version migration guides
- **[docs/examples/](../examples/)** - Code examples and templates

## Notes

These files are preserved for historical reference and may contain useful insights into past decisions and approaches. However, they should not be considered current guidance for FastBlocks development.

**Archived**: 2025-11-18
