# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Rule(pydantic.BaseModel):
    """
    The Rule object describes characteristics of a rule associated with a policy or an event.
    """

    category: typing.Optional[str] = pydantic.Field(default=None)
    """
    The rule category.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the rule that generated the event.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the rule that generated the event.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The rule type.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the rule that generated the event.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The rule version. For example: <code>1.1</code>.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
