# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.timestamp import Timestamp
from .file import File
from .job_run_state_id import JobRunStateId
from .user import User

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Job(pydantic.BaseModel):
    """
    The Job object provides information about a scheduled job or task, including its name, command line, and state. It encompasses attributes that describe the properties and status of the scheduled job.
    """

    cmd_line: typing.Optional[str] = pydantic.Field(default=None)
    """
    The job command line.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the job was created.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the job was created.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the job.
    """

    file: File = pydantic.Field()
    """
    The file that pertains to the job.
    """

    last_run_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the job was last run.
    """

    last_run_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the job was last run.
    """

    name: str = pydantic.Field()
    """
    The name of the job.
    """

    next_run_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the job will next be run.
    """

    next_run_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the job will next be run.
    """

    run_state: typing.Optional[str] = pydantic.Field(default=None)
    """
    The run state of the job.
    """

    run_state_id: typing.Optional[JobRunStateId] = pydantic.Field(default=None)
    """
    The run state ID of the job.
    """

    user: typing.Optional[User] = pydantic.Field(default=None)
    """
    The user that created the job.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
