# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .defender_credential import DefenderCredential

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CloudSecurityDefender(pydantic.BaseModel):
    """
    Configuration for the Microsoft Defender for Cloud Provider
    """

    credential: DefenderCredential
    subscription_id: str = pydantic.Field()
    """
    The Azure subscription ID that contains the Microsoft Defender for Cloud workspace.
    """

    tenant_id: str = pydantic.Field()
    """
    The Azure Active Directory tenant ID that contains the Microsoft Defender for Cloud workspace.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base URL to your Microsoft Defender for Cloud workspace.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
