# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .sentinel_credential import SentinelCredential

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SiemSentinel(pydantic.BaseModel):
    """
    Configuration for Microsoft Sentinel SIEM Product.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/microsoft-sentinel-siem-setup)
    """

    credential: SentinelCredential
    default_tables: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The default tables to use for queries. Supply this value if you would like to a subset of the default tables or non-ASIM data tables with Sentinel/Log Analytics queries.
    If more than one table is specified, a union operator will join them to query all of the tables at once. Supply a single value with `*` if you would like to query all tables without the normalizing ASIM transformations.
    **Note** that a single `*` entry will map to a `union *` query. Relying heavily on these queries is generally discouraged by Sentinel because they are slower and more resource intensive.
    """

    ingest_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Either the logs ingestion API url for you Data Collection Rule or your Data Collection Endpoint URL. This value must be supplied to ingest data into Microsoft Sentinel. This should look something like https://mydcr-xxx-westus2.logs.z1.ingest.monitor.azure.com
    """

    logs_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base URL for the Microsoft Azure Monitor Logs API. Should only be supplied if using an alternate Microsoft cloud, such as GovCloud.
    """

    management_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base URL for the Microsoft Azure Management API. Should only be supplied if using an alternate Microsoft cloud, such as GovCloud.
    """

    resource_group: str = pydantic.Field()
    """
    Azure resource group name that contains the Microsoft Sentinel workspace.
    """

    rule_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Immutable ID of the Data Collection Rule. This value must be supplied to ingest data into Microsoft Sentinel.
    """

    stream_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the Data Collection Rule stream. This value must be supplied to ingest data into Microsoft Sentinel.
    """

    subscription_id: str = pydantic.Field()
    """
    Azure subscription ID that contains the Microsoft Sentinel workspace.
    """

    tenant_id: str = pydantic.Field()
    """
    Azure Active Directory tenant ID that contains the Microsoft Sentinel workspace.
    """

    workspace_id: str = pydantic.Field()
    """
    ID of the Microsoft Sentinel Log Analytics workspace.
    """

    workspace_name: str = pydantic.Field()
    """
    Name of the Microsoft Sentinel Log Analytics workspace.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
